/*
 * Decompiled with CFR 0.152.
 */
package br;

import br.Logger;
import br.Plugin;
import br.ReadCanvas;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import javax.microedition.rms.RecordStore;

public class BookReader
extends MIDlet
implements CommandListener,
Runnable {
    static BookReader instance = null;
    public static Display display;
    ReadCanvas myView = null;
    List myBookList = null;
    Command myTextEditCommand = null;
    static final Command CMD_OK;
    static final Command CMD_CANCEL;
    static final Command CMD_EXIT;
    static final Command CMD_RENAME;
    static final Command CMD_REMOVE;
    static final Command CMD_TEXTPROPS;
    static final Command CMD_DOWNLOAD;
    static final Command CMD_NEW;
    static String ERROR_OUT_OF_MEM;
    public static int BACKGROUND_COLOR;
    boolean myIsFirstTime = false;
    static RecordStore myRS;
    private static String myState;
    static Plugin myPlatformPlugin;
    static String[] PLATFORM_CLASSES;
    int myJarEntryCount = 0;
    Form myLoadingForm = null;
    private static Object[] backLightParam;
    private static Boolean ON;
    private static Boolean OFF;

    public BookReader() {
        instance = this;
        Logger.init(true);
        int n = PLATFORM_CLASSES.length;
        for (int i = 0; i < n; i += 2) {
            try {
                Class.forName(PLATFORM_CLASSES[i + 1]);
                System.out.println("Found platform-specific class '" + PLATFORM_CLASSES[i + 1] + "', test plugin '" + PLATFORM_CLASSES[i] + "'");
                System.out.println("CFN (" + PLATFORM_CLASSES[i] + ") : " + Class.forName(PLATFORM_CLASSES[i]) + "");
                myPlatformPlugin = (Plugin)Class.forName(PLATFORM_CLASSES[i]).newInstance();
                System.out.println("  Created Platform plugin: '" + PLATFORM_CLASSES[i] + "'");
                break;
            }
            catch (Throwable throwable) {
                System.out.println("Cant instanciate : " + throwable);
                continue;
            }
        }
        try {
            InputStream inputStream = null;
            do {
                String string = this.myJarEntryCount == 0 ? "/textfile.txt" : "/textfile" + this.myJarEntryCount + ".txt";
                inputStream = this.getClass().getResourceAsStream(string);
                if (inputStream == null) continue;
                inputStream.close();
                ++this.myJarEntryCount;
            } while (inputStream != null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void startApp() throws MIDletStateChangeException {
        Object object;
        display = Display.getDisplay((MIDlet)this);
        try {
            myRS = RecordStore.openRecordStore((String)"strprops", (boolean)true);
            if (myRS.getNextRecordID() == 1) {
                myState = "\u0000";
            } else {
                object = myRS.getRecord(1);
                if (object != null) {
                    DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream((byte[])object));
                    myState = dataInputStream.readUTF();
                }
            }
        }
        catch (Exception exception) {
            myRS = null;
            myState = "\u0000";
        }
        BookReader.setBackLight(true);
        this.myView = new ReadCanvas(display);
        this.myBookList = new List("Books", 3);
        this.myBookList.addCommand(CMD_EXIT);
        this.myBookList.addCommand(CMD_RENAME);
        this.myBookList.setCommandListener((CommandListener)this);
        object = BookReader.getProperty("main", "lasttext");
        int n = this.myJarEntryCount;
        for (int i = 0; i < n; ++i) {
            String string = this.getBookId(i);
            String string2 = BookReader.getProperty(string, "label");
            if (string2 == null) {
                string2 = this.getAppProperty("TC-Booklet-Label-" + i);
            }
            if (string2 == null) {
                string2 = "Jar Book " + (i + 1);
            }
            this.myBookList.append(string2, null);
            if (!string.equals(object)) continue;
            this.myBookList.setSelectedIndex(i, true);
        }
        display.setCurrent((Displayable)this.myBookList);
        boolean bl = this.myIsFirstTime = object == null;
        if (object != null) {
            this.waitLoadSelectedText();
        }
    }

    private String getBookId(int n) {
        return n == 0 ? "J/textfile.txt" : "J/textfile" + n + ".txt";
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == List.SELECT_COMMAND) {
            this.waitLoadSelectedText();
        } else if (command == CMD_RENAME) {
            this.renameBook(null);
        } else if (command == CMD_OK && displayable == this.myLoadingForm) {
            display.setCurrent((Displayable)this.myView);
        } else if (command == CMD_OK && this.myTextEditCommand == CMD_RENAME && displayable instanceof TextBox) {
            this.renameBook((TextBox)displayable);
        } else if (command == CMD_CANCEL) {
            display.setCurrent((Displayable)this.myBookList);
        } else if (command == CMD_EXIT) {
            if (displayable != this.myBookList) {
                display.setCurrent((Displayable)this.myBookList);
            } else {
                this.destroyApp(true);
            }
        }
    }

    public static void setProperty(String string, String string2, String string3) {
        String string4 = "\u0000" + string + "\n" + string2 + "=";
        int n = myState.indexOf(string4);
        if (n == -1) {
            myState = myState + string4 + string3;
        } else {
            int n2 = myState.indexOf("\u0000", n += string4.length());
            if (n2 == -1) {
                n2 = myState.length();
            }
            myState = myState.substring(0, n) + string3 + myState.substring(n2);
        }
    }

    public static String getProperty(String string, String string2) {
        String string3 = "\u0000" + string + "\n" + string2 + "=";
        String string4 = null;
        int n = myState.indexOf(string3);
        if (n != -1) {
            int n2 = myState.indexOf("\u0000", n += string3.length());
            if (n2 == -1) {
                n2 = myState.length();
            }
            string4 = myState.substring(n, n2);
        }
        return string4;
    }

    public static void saveProps(boolean bl) {
        try {
            if (myRS != null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream.writeUTF(myState.toString());
                byte[] byArray = byteArrayOutputStream.toByteArray();
                if (myRS.getNextRecordID() == 1) {
                    myRS.addRecord(byArray, 0, byArray.length);
                } else {
                    myRS.setRecord(1, byArray, 0, byArray.length);
                }
                if (bl) {
                    myRS.closeRecordStore();
                    myRS = null;
                }
            }
        }
        catch (Exception exception) {
            System.out.println("error saving/closing props:" + exception);
        }
    }

    public void run() {
        try {
            this.myView.setText(null, null);
            String string = this.getBookId(this.myBookList.getSelectedIndex());
            this.myView.setText(string, BookReader.getProperty(string, "label"));
            if (this.myIsFirstTime) {
                this.myIsFirstTime = false;
                this.myLoadingForm.delete(0);
                this.myLoadingForm.addCommand(CMD_OK);
            } else {
                display.setCurrent((Displayable)this.myView);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.showMessage(ERROR_OUT_OF_MEM, "Error");
        }
        catch (Throwable throwable) {
            display.setCurrent((Displayable)new Alert("cant read text", throwable.getMessage(), null, AlertType.ERROR));
        }
    }

    void waitLoadSelectedText() {
        String string = "Loading...";
        if (this.myLoadingForm == null) {
            this.myLoadingForm = new Form("(c)tequilaCat");
            try {
                this.myLoadingForm.append(string);
                this.myLoadingForm.append(this.myView.HELP_MESSAGE);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.myLoadingForm.setCommandListener((CommandListener)this);
        } else {
            ((StringItem)this.myLoadingForm.get(0)).setText(string);
            this.myLoadingForm.removeCommand(CMD_OK);
        }
        display.setCurrent((Displayable)this.myLoadingForm);
        String string2 = this.getBookId(this.myBookList.getSelectedIndex());
        BookReader.setProperty("main", "lasttext", string2);
        BookReader.saveProps(false);
        new Thread(this).start();
    }

    public void pauseApp() {
        BookReader.setBackLight(false);
        BookReader.saveProps(true);
        display = null;
        this.myView = null;
    }

    public static void setBackLight(boolean bl) {
        if (myPlatformPlugin != null) {
            BookReader.backLightParam[0] = bl ? ON : OFF;
            myPlatformPlugin.call("bglight", backLightParam);
        }
    }

    public void destroyApp(boolean bl) {
        BookReader.saveProps(true);
        this.notifyDestroyed();
    }

    public void showBooksList() {
        this.myView.setText(null, null);
        BookReader.setProperty("main", "lasttext", "");
        BookReader.saveProps(false);
        display.setCurrent((Displayable)this.myBookList);
    }

    private void showMessage(String string, String string2) {
        Form form = new Form(string2 == null ? "Info" : string2);
        form.addCommand(CMD_EXIT);
        form.setCommandListener((CommandListener)this);
        form.append(string);
        display.setCurrent((Displayable)form);
    }

    private void renameBook(TextBox textBox) {
        String string = this.getBookId(this.myBookList.getSelectedIndex());
        if (textBox == null) {
            this.myTextEditCommand = CMD_RENAME;
            String string2 = BookReader.getProperty(string, "label");
            TextBox textBox2 = new TextBox("Rename:", string2, 30, 0);
            textBox2.addCommand(CMD_OK);
            textBox2.addCommand(CMD_CANCEL);
            textBox2.setCommandListener((CommandListener)this);
            display.setCurrent((Displayable)textBox2);
        } else {
            String string3 = textBox.getString();
            BookReader.setProperty(string, "label", string3);
            BookReader.saveProps(false);
            display.setCurrent((Displayable)this.myBookList);
        }
    }

    static {
        CMD_OK = new Command("Ok", 4, 0);
        CMD_CANCEL = new Command("Cancel", 3, 0);
        CMD_EXIT = new Command("Exit", 6, 0);
        CMD_RENAME = new Command("Rename", 8, 1);
        CMD_REMOVE = new Command("Remove", 8, 1);
        CMD_TEXTPROPS = new Command("Properties", 8, 1);
        CMD_DOWNLOAD = new Command("Download", 8, 1);
        CMD_NEW = new Command("New", 8, 1);
        ERROR_OUT_OF_MEM = "Sorry, text is too big. Try splitting it onto smaller parts.\nTEKCT HE B/\\E3, nuXAuTE KyCKAMu.";
        BACKGROUND_COLOR = 0xFFFFFF;
        myRS = null;
        myState = null;
        myPlatformPlugin = null;
        PLATFORM_CLASSES = new String[]{"Nokia", "com.nokia.mid.ui.DeviceControl", "Siemens", "com.siemens.mp.game.Light", "Accompli", "com.mot.tcc.media.BackLight"};
        backLightParam = new Object[1];
        ON = new Boolean(true);
        OFF = new Boolean(false);
    }
}

