/*
 * Decompiled with CFR 0.152.
 */
package br;

import br.BookReader;
import br.Logger;
import br.Text;
import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GlyphRenderer {
    Image myBGRImage = null;
    int myPageWidth;
    int myPageHeight;
    int myCharWidth;
    int myCharHeight;
    Image myFontBitmap = null;
    Image myTransposedFontBitmap = null;
    boolean myIsTransposed = false;
    int myNextLinePos = 0;
    int myNextPagePos = 0;
    char[] myLineBuffer = null;
    int myLinesPerPage = 0;
    Text myText = null;
    int myViewWidth;
    int myViewHeight;
    char[] myMenuItems = null;
    int myMenuSelectedPos = 0;

    public void setMenu(char[] cArray, int n) {
        this.myMenuItems = cArray;
        this.myMenuSelectedPos = 0;
        while (n-- > 0) {
            this.moveMenuSelection(true);
        }
    }

    public void moveMenuSelection(boolean bl) {
        int n = bl ? 1 : -1;
        char[] cArray = this.myMenuItems;
        int n2 = this.myMenuSelectedPos;
        int n3 = this.myMenuItems.length;
        int n4 = 0;
        boolean bl2 = false;
        if (n < 0 && n2 > 0) {
            n2 -= 2;
        }
        while (cArray[n2] != '\n') {
            if ((n2 += n) < 0) {
                if (bl2 || this.myMenuSelectedPos > 0) {
                    n2 = 0;
                    break;
                }
                n2 = n3 + n;
                bl2 = true;
                continue;
            }
            if (n2 < n3) continue;
            n2 = 0;
            break;
        }
        if (cArray[n2] == '\n') {
            ++n2;
        }
        if (n2 >= n3) {
            n2 = n4;
        }
        this.myMenuSelectedPos = n2;
    }

    public void displayMenu(Graphics graphics) {
        int n = graphics.getFont().getHeight();
        graphics.setClip(0, 0, this.myViewWidth, this.myViewHeight);
        graphics.setColor(255);
        graphics.fillRect(0, 0, this.myViewWidth, n);
        graphics.setColor(BookReader.BACKGROUND_COLOR);
        graphics.fillRect(0, n, this.myViewWidth, this.myViewHeight - n);
        graphics.setColor(0xFFFFFF);
        boolean bl = false;
        int n2 = this.myMenuItems.length;
        int n3 = this.myMenuSelectedPos;
        int n4 = this.myMenuSelectedPos;
        int n5 = 0;
        char[] cArray = this.myMenuItems;
        for (int i = 0; i < this.myPageHeight; i += n) {
            int n6;
            for (n6 = n3; n6 < n2 && cArray[n6] != '\n'; ++n6) {
            }
            if (n3 == 0 && i > 0) {
                graphics.drawLine(0, i, this.myPageWidth, i);
            }
            graphics.drawChars(cArray, n3, n6 - n3, n5, i, 0x10 | 4);
            n3 = n6 + 1;
            if (n3 >= n2) {
                n3 = 0;
            }
            if (n3 == n4) break;
            graphics.setColor(0);
        }
    }

    public String getCurrentItem() {
        return null;
    }

    public int getCurrentItemIndex() {
        int n = 0;
        int n2 = this.myMenuSelectedPos;
        char[] cArray = this.myMenuItems;
        for (int i = 0; i < n2; ++i) {
            if (cArray[i] != '\n') continue;
            ++n;
        }
        return n;
    }

    public GlyphRenderer(Canvas canvas, int n, int n2) {
        this.myViewWidth = n;
        this.myViewHeight = n2;
        this.myPageWidth = n;
        this.myPageHeight = n2;
        try {
            this.myFontBitmap = Image.createImage((String)"/font.png");
            try {
                this.myTransposedFontBitmap = Image.createImage((String)"/font-lscp.png");
            }
            catch (IOException iOException) {
                this.myTransposedFontBitmap = null;
            }
            this.myCharWidth = this.myFontBitmap.getWidth() / 16;
            this.myCharHeight = this.myFontBitmap.getHeight() / 14;
        }
        catch (Exception exception) {
            Logger.log("can't create GlyphRenderer: " + exception);
        }
        this.myIsTransposed = false;
        this.myLineBuffer = new char[this.myPageWidth > this.myPageHeight ? this.myPageWidth : this.myPageHeight];
    }

    public void setText(Text text) {
        this.myText = text;
        if (this.myText != null) {
            this.validateDisplayType();
        }
    }

    public boolean nextDisplayType() {
        if (!this.myText.isUnicode()) {
            String string = BookReader.getProperty(this.myText.getId(), "pagedisplay");
            if (string.equals("normal")) {
                string = "clockwise";
            } else if (string.equals("clockwise")) {
                string = "font";
            } else if (string.startsWith("font")) {
                string = "normal";
            }
            BookReader.setProperty(this.myText.getId(), "pagedisplay", string);
            return this.validateDisplayType();
        }
        return false;
    }

    private boolean validateDisplayType() {
        String string;
        String string2 = string = BookReader.getProperty(this.myText.getId(), "pagedisplay");
        if (string == null) {
            string = "normal";
        }
        if (this.myTransposedFontBitmap == null && string.equals("clockwise")) {
            string = "font";
        }
        if (this.myText.isUnicode() && !string.startsWith("font")) {
            string = "font";
        }
        this.myIsTransposed = string.equals("clockwise");
        if (this.myIsTransposed) {
            this.myPageHeight = this.myViewWidth;
            this.myPageWidth = this.myViewHeight;
            this.myCharWidth = this.myTransposedFontBitmap.getHeight() / 16;
            this.myCharHeight = this.myTransposedFontBitmap.getWidth() / 14;
        } else {
            this.myPageWidth = this.myViewWidth;
            this.myPageHeight = this.myViewHeight;
            this.myCharWidth = this.myFontBitmap.getWidth() / 16;
            this.myCharHeight = this.myFontBitmap.getHeight() / 14;
        }
        if (!string.equals(string2)) {
            BookReader.setProperty(this.myText.getId(), "pagedisplay", string);
        }
        return true;
    }

    public String render(Graphics graphics, Text text, int n, boolean bl) {
        String string = "No text";
        Graphics graphics2 = graphics;
        try {
            if (text != null && text.getCharCount() > 0) {
                string = null;
                if (bl) {
                    if (this.myBGRImage == null) {
                        this.myBGRImage = Image.createImage((int)this.myPageWidth, (int)this.myPageHeight);
                    }
                    graphics2 = this.myBGRImage.getGraphics();
                }
                graphics2.setColor(0xFFFFFF);
                graphics2.setClip(0, 0, this.myViewWidth, this.myViewHeight);
                graphics2.fillRect(0, 0, this.myViewWidth, this.myViewHeight);
                long l = System.currentTimeMillis();
                graphics2.setColor(0);
                this.displayFormattedText(graphics2, n);
                Logger.LOG.put("paint", "" + (System.currentTimeMillis() - l));
                graphics2.setClip(0, 0, this.myPageWidth, this.myPageHeight);
                this.paintSB(graphics2, n, text.getCharCount());
                Logger.LOG.put("paint+sb", "" + (System.currentTimeMillis() - l));
                if (this.myBGRImage != null) {
                    graphics.drawImage(this.myBGRImage, 0, 0, 4 | 0x10);
                }
            }
        }
        catch (Exception exception) {
            string = exception.toString();
        }
        return string;
    }

    private void paintSB(Graphics graphics, int n, int n2) {
        int n3;
        int n4 = 0x808080;
        boolean bl = this.myIsTransposed;
        int n5 = this.myPageWidth - 2;
        graphics.setColor(n4);
        int n6 = this.myPageHeight;
        for (n3 = 0; n3 < n6; ++n3) {
            if (bl) {
                graphics.drawLine(n3, n5, n3 + 1, n5 + 1);
            } else {
                graphics.drawLine(n5, n3, n5 + 1, n3 + 1);
            }
            ++n3;
        }
        graphics.setColor(0xFFFFFF);
        n3 = (this.myPageHeight - 3) * n / n2 - 1;
        if (bl) {
            n3 = this.myPageHeight - n3 - 2;
            graphics.drawLine(n3, n5, n3, n5 + 1);
            graphics.setColor(n4);
            graphics.drawLine(--n3, n5, n3, n5 + 1);
            graphics.drawLine(--n3, n5, n3, n5 + 1);
            graphics.drawLine(--n3, n5, n3, n5 + 1);
            graphics.setColor(0xFFFFFF);
            graphics.drawLine(--n3, n5, n3, n5 + 1);
            --n3;
        } else {
            graphics.drawLine(n5, n3, n5 + 1, n3);
            graphics.setColor(n4);
            graphics.drawLine(n5, ++n3, n5 + 1, n3);
            graphics.drawLine(n5, ++n3, n5 + 1, n3);
            graphics.drawLine(n5, ++n3, n5 + 1, n3);
            graphics.setColor(0xFFFFFF);
            graphics.drawLine(n5, ++n3, n5 + 1, n3);
            ++n3;
        }
    }

    void paintGlyph(Graphics graphics, int n, int n2, int n3) {
        if (n <= 32) {
            return;
        }
        int n4 = (n -= 32) & 0xF;
        int n5 = n >> 4;
        if (this.myIsTransposed) {
            int n6 = this.myPageHeight - n3 - this.myCharHeight;
            int n7 = n2;
            graphics.setClip(n6, n7, this.myCharHeight, this.myCharWidth);
            graphics.drawImage(this.myTransposedFontBitmap, n6 - (13 - n5) * this.myCharHeight, n7 - n4 * this.myCharWidth, 0x10 | 4);
        } else {
            graphics.setClip(n2, n3, this.myCharWidth, this.myCharHeight);
            graphics.drawImage(this.myFontBitmap, n2 - n4 * this.myCharWidth, n3 - n5 * this.myCharHeight, 0x10 | 4);
        }
    }

    private void displayFormattedText(Graphics graphics, int n) {
        char[] cArray = this.myLineBuffer;
        int n2 = n;
        long l = 0L;
        boolean bl = this.myText.isUnicode();
        String string = BookReader.getProperty(this.myText.getId(), "pagedisplay");
        Font font = string.startsWith("font") ? Font.getDefaultFont() : null;
        graphics.setColor(0);
        if (bl && (n2 += n2) == 0) {
            n2 = 2;
        }
        boolean bl2 = false;
        this.myNextLinePos = n2;
        this.myNextPagePos = n2;
        Object[] objectArray = new Object[2];
        this.myText.getChunkAt(objectArray, n2);
        byte[] byArray = (byte[])objectArray[1];
        int n3 = byArray == null ? 0 : (Integer)objectArray[0];
        int n4 = n2 - n3;
        int n5 = 0;
        int n6 = font != null ? font.getHeight() : this.myCharHeight;
        int n7 = 0;
        int n8 = -1;
        int n9 = 0;
        this.myLinesPerPage = 0;
        int n10 = this.myText.getCharCount();
        if (bl) {
            n10 += n10;
        }
        int n11 = 0;
        while (byArray != null) {
            int n12;
            int n13;
            boolean bl3 = false;
            while (true) {
                if (n3 >= byArray.length) {
                    n13 = n4 + n3;
                    this.myText.getChunkAt(objectArray, n13);
                    byArray = (byte[])objectArray[1];
                    if (byArray != null) {
                        n3 = (Integer)objectArray[0];
                    }
                    n4 = n13 - n3;
                } else if (n4 + n3 >= n10) {
                    byArray = null;
                    break;
                }
                if (byArray == null || byArray.length == 0) break;
                n13 = byArray[n3] & 0xFF;
                if (bl) {
                    n13 |= byArray[n3 + 1] << 8;
                } else if (font != null && n13 > 127) {
                    n13 = "\u0402\u0403\u201a\u0453\u201e\u2026\u2020\u2021\u20ac\u2030\u0409\u2039\u040a\u040c\u040b\u040f\u0452\u2018\u2019\u201c\u201d\u2022\u2013\u2014\ufffd\u2122\u0459\u203a\u045a\u045c\u045b\u045f\u00a0\u040e\u045e\u0408\u00a4\u0490\u00a6\u00a7\u0401\u00a9\u0404\u00ab\u00ac\u00ad\u00ae\u0407\u00b0\u00b1\u0406\u0456\u0491\u00b5\u00b6\u00b7\u0451\u2116\u0454\u00bb\u0458\u0405\u0455\u0457\u0410\u0411\u0412\u0413\u0414\u0415\u0416\u0417\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042a\u042b\u042c\u042d\u042e\u042f\u0430\u0431\u0432\u0433\u0434\u0435\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u044f".charAt(n13 - 128);
                }
                if (n13 == 10 || n13 == 13) {
                    if (n7 != 0) {
                        n11 = n13;
                        n8 = -1;
                        break;
                    }
                } else if (n13 == 32 || n13 == 9) {
                    bl3 = true;
                } else if (n13 != 0) {
                    if (bl3) {
                        bl3 = false;
                        if (n7 != 0) {
                            cArray[n7++] = 32;
                        }
                        n8 = -1;
                    }
                    if (n7 >= cArray.length) break;
                    cArray[n7++] = (char)n13;
                    n12 = GlyphRenderer.isWordPart(n13, bl || font != null) ? 1 : 0;
                    if (n12 != 0) {
                        if (n8 == -1 || n9 == 0) {
                            n8 = n7 - 1;
                        }
                    } else {
                        boolean bl4;
                        boolean bl5 = bl4 = n12 == 0 && (n13 == 63 || n13 == 33 || n13 == 46 || n13 == 59 || n13 == 44);
                        if (!bl4) {
                            n8 = -1;
                        }
                    }
                    n9 = n12;
                    long l2 = System.currentTimeMillis();
                    int n14 = font != null ? font.charsWidth(cArray, 0, n7) : n7 * this.myCharWidth;
                    l += System.currentTimeMillis() - l2;
                    if (n14 > this.myPageWidth) {
                        --n7;
                        if (n8 != 0) break;
                        n8 = n7;
                        break;
                    }
                }
                n3 += bl ? 2 : 1;
            }
            if (n7 == 0) {
                System.out.println("Empty Line: ");
                n8 = -1;
                n9 = 0;
            } else {
                int n15 = n13 = n8 <= 0 ? n7 : n8;
                if (font != null) {
                    graphics.drawChars(cArray, 0, n13, 0, n5, 0x10 | 4);
                } else {
                    this.drawScreenLine(graphics, n5, cArray, n13);
                }
                ++this.myLinesPerPage;
                n12 = n3 + n4;
                if (n8 > -1) {
                    int n16 = n7 - n8 + 1;
                    n12 -= n16;
                    if (bl) {
                        n12 -= n16;
                    }
                    System.arraycopy(cArray, n8, cArray, 0, n16);
                    n9 = 1;
                    n8 = 0;
                    n7 = n16;
                } else {
                    n9 = 0;
                    n8 = -1;
                    n7 = 0;
                }
                if ((n5 += n6) + n6 / 2 > this.getHeight()) break;
                this.myNextPagePos = n12;
                if (!bl2) {
                    bl2 = true;
                    this.myNextLinePos = n12;
                }
            }
            n3 += bl ? 2 : 1;
        }
        if (bl) {
            this.myNextLinePos /= 2;
            this.myNextPagePos /= 2;
        }
        Logger.LOG.put("gcw", "" + l);
        if (n5 + n6 < this.getHeight()) {
            this.myNextLinePos = this.myNextPagePos = n;
        }
    }

    public static boolean isWordPart(int n, boolean bl) {
        if (!bl || n < 128) {
            return n == 39 || n == 34 || n >= 192 && n <= 223 || n >= 224 && n <= 255 || n == 168 || n == 184 || n >= 48 && n <= 57 || n >= 65 && n <= 90 || n >= 97 && n <= 122;
        }
        if ((n & 0xFF00) == 1024) {
            return true;
        }
        return true;
    }

    private void drawScreenLine(Graphics graphics, int n, char[] cArray, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n2 != 0) {
            this.paintGlyph(graphics, cArray[n4], n3, n);
            n3 += this.myCharWidth;
            ++n4;
            --n2;
        }
    }

    public int getHeight() {
        return this.myPageHeight;
    }

    public int getNextLinePos() {
        return this.myNextLinePos;
    }

    public int getNextPagePos() {
        return this.myNextPagePos;
    }

    public int getPrevLinePos(int n) {
        return this.skipLines(n, -1);
    }

    public int getPrevPagePos(int n) {
        int n2 = -this.myLinesPerPage;
        if (n2 == 0) {
            n2 = -1;
        }
        return this.skipLines(n, n2);
    }

    private int skipLines(int n, int n2) {
        boolean bl = this.myText.isUnicode();
        int n3 = n;
        if (bl) {
            n3 += n3;
        }
        Object[] objectArray = new Object[2];
        this.myText.getChunkAt(objectArray, n3);
        byte[] byArray = (byte[])objectArray[1];
        int n4 = byArray == null ? 0 : (Integer)objectArray[0];
        int n5 = n3 - n4;
        boolean bl2 = false;
        int n6 = bl ? 2 : 1;
        try {
            while (n2 < 0 && byArray != null) {
                boolean bl3;
                int n7 = byArray[n4] & 0xFF;
                if (bl) {
                    n7 |= byArray[n4 + 1] << 8;
                }
                boolean bl4 = bl3 = n7 == 10 || n7 == 13;
                if (bl3 && !bl2) {
                    ++n2;
                }
                bl2 = bl3;
                if ((n4 -= n6) >= 0) continue;
                n3 = n5 + n4;
                if (n3 >= 0) {
                    this.myText.getChunkAt(objectArray, n3);
                    n4 = (Integer)objectArray[0];
                    byArray = (byte[])objectArray[1];
                    n5 = n3 - n4;
                    continue;
                }
                byArray = null;
                n4 = 0;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("ArrayIndexOutOfBoundsException: " + n4);
        }
        if (byArray == null) {
            n4 = 0;
        } else {
            n4 = n5 + n4;
            if (bl) {
                n4 /= 2;
            }
        }
        return n4;
    }
}

