/*
 * Decompiled with CFR 0.152.
 */
package br;

import br.BookReader;
import br.GlyphRenderer;
import br.Logger;
import br.Text;
import java.util.Calendar;
import java.util.Date;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.TextBox;

public class ReadCanvas
extends Canvas
implements Runnable,
CommandListener {
    Text myText = new Text();
    int myLastClickX = 0;
    int myLastClickY = 0;
    GlyphRenderer myRenderer = null;
    Display display;
    Thread myAutoScrollThread = null;
    private long myLastPaintTime = 0L;
    private boolean myAutoScrollAllowed = false;
    String myPageDownKeyName = null;
    String myTextLabel = null;
    boolean myBkLightState = true;
    private String myTextMenuItems = "# Read\n1 Books list\n2 Exit\n3 Search\n4 Goto\n5 Autoscroll\n6 Show last line\n7 Orientation\n8 Light off/on\n9 Help";
    public static final int TEXT = 0;
    public static final int AUTOSCROLL = 1;
    public static final int OPTIONSMENU = 2;
    int myDisplayMode = 0;
    int myAutoScrollDelayMs = 0;
    int AUTOSCROLL_MAX_MS = 20000;
    public final String HELP_MESSAGE = "Book Reader by Alex Vdovichenko aka tequilaCat\nDIAL-read /options\n*-backlight\n#-rotate\n2/4/6/8/ Arrows- scroll\n1-Home,7-End\n3,9-Autoscroll" + (this.hasPointerEvents() ? "\nClick upper/lower screen half: scroll up/down\nDrag up/left - toggle orientation" : "");
    public Alert myMessageBox = new Alert("Book Reader", this.HELP_MESSAGE, null, AlertType.INFO);
    TextBox myInputBox = new TextBox("", "", 50, 0);
    int myInputMode = 0;
    private static final int SEARCH = 1;
    private static final int GOTOPERCENT = 2;

    public ReadCanvas(Display display) {
        this.display = display;
        this.myPageDownKeyName = BookReader.instance.getAppProperty("TC-BookReader-PageDownKey");
        this.myInputBox.addCommand(BookReader.CMD_OK);
        this.myInputBox.addCommand(BookReader.CMD_CANCEL);
        this.myInputBox.setCommandListener((CommandListener)this);
        int n = this.getWidth();
        int n2 = this.getHeight();
        Logger.LOG.put("screen", "" + n + "x" + n2);
        if (n == 120) {
            n2 = 160;
        } else if (n == 240) {
            n2 = 276;
        }
        this.myRenderer = new GlyphRenderer(this, n, n2);
        this.myRenderer.setMenu(this.myTextMenuItems.toCharArray(), 0);
    }

    public void setText(String string, String string2) {
        this.myText.init(string);
        this.myTextLabel = string2;
        this.myAutoScrollAllowed = false;
        this.myDisplayMode = 0;
        if (this.myText == null) {
            this.myAutoScrollThread = null;
        }
        this.myRenderer.setText(string == null ? null : this.myText);
    }

    public void paint(Graphics graphics) {
        this.myLastPaintTime = System.currentTimeMillis();
        int n = graphics.getClipX();
        int n2 = graphics.getClipY();
        int n3 = graphics.getClipWidth();
        int n4 = graphics.getClipHeight();
        if (this.myDisplayMode == 2) {
            this.myRenderer.displayMenu(graphics);
        } else if (this.myDisplayMode == 1) {
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(n, n2, n3, n4);
            graphics.setColor(0);
            int n5 = graphics.getFont().getHeight();
            int n6 = n3 / 2;
            int n7 = n4 / 2 - n5 - n5;
            graphics.drawString("AutoScroll:", n6, n7, 1 | 0x10);
            String string = "OFF";
            if (this.myAutoScrollDelayMs != 0) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.myAutoScrollDelayMs / 1000);
                if (this.myAutoScrollDelayMs % 1000 > 0) {
                    stringBuffer.append(",5");
                }
                stringBuffer.append(" sec");
                string = stringBuffer.toString();
            }
            graphics.drawString(string, n6, n7 += n5, 1 | 0x10);
            graphics.drawString("change-", n6, n7 += n5, 1 | 0x10);
            graphics.drawString("keys 3,9", n6, n7 += n5, 1 | 0x10);
        } else {
            String string = this.myRenderer.render(graphics, this.myText, this.myText.getPosition(), !this.isDoubleBuffered());
            if (string != null) {
                BookReader.instance.showBooksList();
                this.myMessageBox.setType(AlertType.ERROR);
                this.myMessageBox.setString(string);
                this.display.setCurrent(this.myMessageBox, (Displayable)BookReader.instance.myBookList);
            }
        }
    }

    private void lineUp() {
        this.myText.setPosition(this.myRenderer.getPrevLinePos(this.myText.getPosition()));
        this.repaint();
    }

    private void lineDown() {
        int n = this.myRenderer.getNextLinePos();
        if (n != this.myText.getPosition() && n < this.myText.getCharCount()) {
            this.myText.setPosition(n);
            this.repaint();
        }
    }

    private void pageUp() {
        int n = this.myText.getPosition();
        this.myText.setPosition(this.myRenderer.getPrevPagePos(this.myText.getPosition()));
        this.repaint();
    }

    private void pageDown() {
        this.myAutoScrollAllowed = true;
        int n = this.myRenderer.getNextPagePos();
        if (n != this.myText.getPosition() && n < this.myText.getCharCount()) {
            this.myText.setPosition(n);
            this.repaint();
        }
    }

    private void goHome() {
        this.myText.setPosition(0);
        this.repaint();
    }

    private void goEnd() {
        this.myText.setPosition(this.myText.getCharCount() - 1);
        this.pageUp();
    }

    private boolean menuItemSelected(int n) {
        System.out.println("Menu Selected: " + n);
        String string = null;
        if (n == 0) {
            return true;
        }
        if (n == 1) {
            BookReader.instance.showBooksList();
        } else if (n == 2) {
            BookReader.instance.destroyApp(true);
        } else if (n == 3) {
            string = "Not implemented (HE PA6OTAET)";
        } else if (n == 4) {
            this.gotoPercent();
        } else if (n == 5) {
            this.myDisplayMode = 1;
            this.repaint();
        } else if (n == 6) {
            string = "Not implemented (HE PA6OTAET)";
        } else {
            if (n == 7) {
                this.myRenderer.nextDisplayType();
                return true;
            }
            if (n == 8) {
                this.myBkLightState = !this.myBkLightState;
                BookReader.setBackLight(this.myBkLightState);
                return true;
            }
            if (n == 9) {
                string = this.HELP_MESSAGE;
            }
        }
        if (string != null) {
            this.myMessageBox.setTitle(this.getTimeStr());
            this.myMessageBox.setType(n == 9 ? AlertType.INFO : AlertType.WARNING);
            this.myMessageBox.setString(string);
            this.display.setCurrent((Displayable)this.myMessageBox);
            this.myDisplayMode = 0;
        }
        return false;
    }

    protected void keyPressed(int n) {
        BookReader.setBackLight(true);
        int n2 = this.getGameAction(n);
        if (this.myDisplayMode == 2) {
            int n3 = -1;
            if (n == 35) {
                n3 = 0;
            } else if (n2 == 1 || n2 == 6) {
                this.myRenderer.moveMenuSelection(n2 == 6);
                this.repaint();
            } else if (n2 == 8) {
                n3 = this.myRenderer.getCurrentItemIndex();
            } else if (n >= 48 && n <= 57) {
                n3 = n - 48;
            }
            if (n3 >= 0 && this.menuItemSelected(n3)) {
                this.myDisplayMode = 0;
                this.repaint();
            }
            return;
        }
        this.myAutoScrollAllowed = false;
        boolean bl = "clockwise".equals(BookReader.getProperty(this.myText.getId(), "pagedisplay"));
        int n4 = 8;
        if (bl ? n == 57 : n == 51) {
            this.changeAutoScroll(-1);
            return;
        }
        if (bl ? n == 55 : n == 57) {
            this.changeAutoScroll(1);
            return;
        }
        if (this.myDisplayMode == 1) {
            this.myAutoScrollAllowed = true;
            this.myDisplayMode = 0;
        }
        if (this.getKeyName(n).equals(this.myPageDownKeyName)) {
            this.pageDown();
        } else if (n2 == 2 || n == 52) {
            n4 = bl ? 6 : 2;
        } else if (n2 == 5 || n == 54) {
            n4 = bl ? 1 : 5;
        } else if (n2 == 1 || n == 50) {
            n4 = bl ? 2 : 1;
        } else if (n2 == 6 || n == 56) {
            n4 = bl ? 5 : 6;
        } else if (bl ? n == 51 : n == 49) {
            this.goHome();
        } else if (bl ? n == 49 : n == 55) {
            this.goEnd();
        } else if (n2 == 8) {
            this.myDisplayMode = 2;
            this.repaint();
        } else if (n == 42) {
            this.myBkLightState = !this.myBkLightState;
            BookReader.setBackLight(this.myBkLightState);
        } else if (n == 35 && this.myRenderer.nextDisplayType()) {
            this.repaint();
        }
        switch (n4) {
            case 2: {
                this.pageUp();
                break;
            }
            case 5: {
                this.pageDown();
                break;
            }
            case 1: {
                this.lineUp();
                break;
            }
            case 6: {
                this.lineDown();
            }
        }
    }

    private void changeAutoScroll(int n) {
        this.myAutoScrollAllowed = true;
        int n2 = this.myAutoScrollDelayMs;
        if (n == 0) {
            n2 = 0;
        } else {
            int n3 = n2 >= 10000 ? 1000 : 500;
            if ((n2 += n > 0 ? n3 : -n3) < 0) {
                n2 = this.AUTOSCROLL_MAX_MS;
            } else if (n2 > this.AUTOSCROLL_MAX_MS) {
                n2 = 0;
            }
        }
        if (this.myAutoScrollDelayMs != n2) {
            this.myAutoScrollDelayMs = n2;
            this.myDisplayMode = 1;
            this.repaint();
            if (this.myAutoScrollThread == null && this.myAutoScrollDelayMs != 0) {
                this.myAutoScrollThread = new Thread(this);
                this.myAutoScrollThread.start();
            }
        }
        System.out.println("Now, Delay is " + this.myAutoScrollDelayMs + "");
    }

    public void run() {
        try {
            while (this.myText != null && this.myAutoScrollThread != null) {
                long l = System.currentTimeMillis();
                if (this.myDisplayMode == 0 && this.myAutoScrollAllowed && this.myAutoScrollDelayMs != 0 && (long)this.myAutoScrollDelayMs + this.myLastPaintTime < l && this.isShown()) {
                    this.pageDown();
                }
                Thread.sleep(500L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.myAutoScrollThread = null;
    }

    public void pointerReleased(int n, int n2) {
        if (this.myDisplayMode == 0) {
            int n3;
            boolean bl = "clockwise".equals(BookReader.getProperty(this.myText.getId(), "pagedisplay"));
            if ((this.myLastClickX - n > this.getWidth() / 5 || this.myLastClickY - n2 > this.getHeight() / 5) && this.myRenderer.nextDisplayType()) {
                this.repaint();
                return;
            }
            int n4 = this.myRenderer.getHeight();
            int n5 = n3 = bl ? n4 - n : n2;
            if (n3 < n4 / 4) {
                this.pageUp();
            } else if (n3 < n4 / 2) {
                this.lineUp();
            } else if (n3 < n4 * 3 / 4) {
                this.lineDown();
            } else {
                this.pageDown();
            }
        }
    }

    public void pointerPressed(int n, int n2) {
        if (this.myDisplayMode == 0) {
            this.myLastClickX = n;
            this.myLastClickY = n2;
        }
    }

    private String getTimeStr() {
        StringBuffer stringBuffer = new StringBuffer();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        int n = calendar.get(11);
        int n2 = calendar.get(12);
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n).append(':');
        if (n2 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n2);
        return stringBuffer.toString();
    }

    private void search() {
        this.myInputMode = 1;
        this.myInputBox.setTitle("search");
        this.myInputBox.setString("");
        this.myInputBox.setConstraints(0);
        this.display.setCurrent((Displayable)this.myInputBox);
    }

    private void gotoPercent() {
        this.myInputMode = 2;
        this.myInputBox.setTitle("Go to %");
        this.myInputBox.setString("" + this.myText.getPosition() * 100 / this.myText.getCharCount());
        this.myInputBox.setConstraints(2);
        this.display.setCurrent((Displayable)this.myInputBox);
    }

    public void commandAction(Command command, Displayable displayable) {
        boolean bl = true;
        if (command != BookReader.CMD_CANCEL) {
            if (this.myInputMode == 2) {
                int n = this.myText.getCharCount();
                int n2 = this.myText.getPosition() * 100 / n;
                int n3 = Integer.parseInt(this.myInputBox.getString());
                if (n3 != n2) {
                    if (n3 >= 0 && n3 <= 100) {
                        int n4 = n * n3 / 100;
                        if (n4 >= n) {
                            n4 = n - 1;
                        }
                        this.myText.setPosition(n4);
                    } else {
                        this.myInputBox.setTitle("Enter %! 0-100");
                        bl = false;
                    }
                }
            } else if (this.myInputMode == 1) {
                // empty if block
            }
        }
        if (bl) {
            this.myDisplayMode = 0;
            this.display.setCurrent((Displayable)this);
            this.repaint();
        }
    }
}

