/*
 * Decompiled with CFR 0.152.
 */
package br;

import br.BookReader;
import br.Logger;
import java.io.InputStream;
import java.util.Vector;

public class Text {
    int mySize = 0;
    String myId = null;
    boolean myIsUnicode = false;
    boolean myIsUnicodeBigEndian = false;
    char myTextType = '\u0000';
    Vector myContentChunks = new Vector();
    byte[] myLastChunk = null;
    int myLastChunkStart = 0;
    int myPosition = 0;
    public static final String WIN1251_TO_UNICODE = "\u0402\u0403\u201a\u0453\u201e\u2026\u2020\u2021\u20ac\u2030\u0409\u2039\u040a\u040c\u040b\u040f\u0452\u2018\u2019\u201c\u201d\u2022\u2013\u2014\ufffd\u2122\u0459\u203a\u045a\u045c\u045b\u045f\u00a0\u040e\u045e\u0408\u00a4\u0490\u00a6\u00a7\u0401\u00a9\u0404\u00ab\u00ac\u00ad\u00ae\u0407\u00b0\u00b1\u0406\u0456\u0491\u00b5\u00b6\u00b7\u0451\u2116\u0454\u00bb\u0458\u0405\u0455\u0457\u0410\u0411\u0412\u0413\u0414\u0415\u0416\u0417\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042a\u042b\u042c\u042d\u042e\u042f\u0430\u0431\u0432\u0433\u0434\u0435\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u044f";

    public void init(String string) {
        this.myLastChunk = null;
        this.myLastChunkStart = 0;
        this.myPosition = 0;
        this.mySize = 0;
        this.myContentChunks.removeAllElements();
        System.gc();
        this.myId = string;
        if (this.myId != null) {
            this.myTextType = this.myId.charAt(0);
            this.readJarEntry();
            String string2 = BookReader.getProperty(this.myId, "position");
            this.setPosition(string2 == null ? 0 : Integer.parseInt(string2));
        }
    }

    public int getPosition() {
        return this.myPosition;
    }

    public void setPosition(int n) {
        if (n < 0 || n >= this.getCharCount()) {
            n = 0;
        }
        this.myPosition = n;
        BookReader.setProperty(this.myId, "position", "" + n);
    }

    public String getId() {
        return this.myId;
    }

    private void readJarEntry() {
        String string = this.myId.substring(1);
        try {
            long l;
            int n;
            long l2 = System.currentTimeMillis();
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            long l3 = System.currentTimeMillis();
            int n2 = 5000;
            byte[] byArray = new byte[n2];
            for (n = 0; n < n2; ++n) {
                byArray[n] = 35;
            }
            this.mySize = 0;
            long l4 = 0L;
            while (true) {
                l = System.currentTimeMillis();
                n = inputStream.read(byArray, 0, byArray.length);
                l4 += System.currentTimeMillis() - l;
                if (n <= 0) break;
                if (this.mySize == 0) {
                    this.myIsUnicodeBigEndian = byArray[0] == -2 && byArray[1] == -1;
                    this.myIsUnicode = this.myIsUnicodeBigEndian || byArray[0] == -1 && byArray[1] == -2;
                }
                this.mySize += n;
                this.myContentChunks.addElement(byArray);
                if (n != byArray.length) continue;
                try {
                    System.out.println("Create chunk " + n + "");
                    byArray = new byte[n];
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    // empty catch block
                    break;
                }
            }
            inputStream.close();
            l = System.currentTimeMillis();
            Logger.LOG.put("read", "" + (l - l2) + "/" + (l3 - l2) + "/" + l4 + "[" + this.myContentChunks.size() + "]");
        }
        catch (Exception exception) {
            System.out.println("cant read JAR entry '" + string);
            this.mySize = 0;
            this.myContentChunks.removeAllElements();
        }
    }

    boolean isUnicode() {
        return this.myIsUnicode;
    }

    public int getCharCount() {
        return this.myIsUnicode ? this.mySize / 2 : this.mySize;
    }

    public synchronized void getChunkAt(Object[] objectArray, int n) {
        if (n >= this.mySize) {
            this.myLastChunk = null;
        } else if ((this.myLastChunk == null || n < this.myLastChunkStart || n >= this.myLastChunkStart + this.myLastChunk.length) && this.myTextType == 'J') {
            System.out.println("Retrieve JAR Chunk @" + n + "");
            int n2 = ((byte[])this.myContentChunks.elementAt(0)).length;
            this.myLastChunk = (byte[])this.myContentChunks.elementAt(n / n2);
            this.myLastChunkStart = n - n % n2;
        }
        if (this.myLastChunk == null) {
            objectArray[1] = null;
            objectArray[0] = null;
        } else {
            objectArray[0] = new Integer(n - this.myLastChunkStart);
            objectArray[1] = this.myLastChunk;
        }
    }
}

