/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;
import maze.MazeGenerator;
import misc.Point;
import sets.Bricket;

public class GraphicsMIDlet
extends MIDlet
implements CommandListener {
    Random r = new Random();
    public SettingsVars settings = new SettingsVars();
    public Point[] nextBricket = new Point[0];
    public Point nextBricketPoint = new Point(0, 0);
    public int nextBricketIndex = 0;
    public int nextBricketRotation = 0;
    public Point[] currBricket = new Point[0];
    public Point currBricketPoint = new Point(0, 0);
    public int currBricketIndex = 0;
    public int currBricketRotation = 0;
    public Point[] maze = new Point[0];
    public Point[] had = new Point[1];
    public Bricket[] set = new Bricket[0];
    public int size = 10;
    public int score = 0;
    int totalLinesOut;
    public int speed = 100;
    public boolean pause = true;
    public int usedW;
    public int usedH;
    public Canvas c;
    private Display display;
    protected boolean started;
    private Command exitCommand;
    private Command backCommand;
    private List examplesList;
    private Canvas[] canvases;
    private String[] examples = new String[]{"Help", "Settings", "Tetris"};
    Point oldPoint;

    protected void startApp() {
        if (!this.started) {
            this.started = true;
            this.display = Display.getDisplay((MIDlet)this);
            this.createCommands();
            this.createCanvases();
            this.createList();
            this.display.setCurrent((Displayable)this.examplesList);
        }
    }

    protected void pauseApp() {
    }

    protected void destroyApp(boolean unconditional) {
    }

    public void commandAction(Command c, Displayable d) {
        if (d == this.examplesList) {
            int index = this.examplesList.getSelectedIndex();
            if (index == 2) {
                this.reloadMaze(this.c, this.size);
                this.resetSnake();
            }
            if (index == 1) {
                this.reloadMaze(this.c, 10);
            }
            this.display.setCurrent((Displayable)this.canvases[index]);
        } else if (c == this.exitCommand) {
            this.notifyDestroyed();
        } else if (c == this.backCommand) {
            this.display.setCurrent((Displayable)this.examplesList);
        }
    }

    void constraints() {
        int w = this.usedW;
        int h = this.usedH;
        this.smashWall();
    }

    void embedd() {
        int i;
        Point[] nwMaze = new Point[this.maze.length + this.currBricket.length];
        for (i = 0; i < this.maze.length; ++i) {
            nwMaze[i] = this.maze[i];
        }
        for (i = 0; i < this.currBricket.length; ++i) {
            nwMaze[i + this.maze.length] = this.currBricket[i];
        }
        this.maze = nwMaze;
    }

    void evauate() {
        int rows = 0;
        for (int y = this.usedH; y > 0; y -= this.size) {
            if (!this.canDelete(y)) continue;
            ++rows;
            this.delete(y);
            y += this.size;
        }
        this.totalLinesOut += rows;
        this.score += rows * rows * (300 - this.speed + this.size);
    }

    String getTitle() {
        String s = "   <" + this.score + ">  " + this.totalLinesOut + "  ";
        s = s + (300 - this.speed) + "/" + this.size;
        return s;
    }

    public void moveBricket(int x, int y) {
        if (this.willBeSomeInMaze(this.currBricket, x, y)) {
            return;
        }
        if (this.currBricket != null) {
            for (int i = 0; i < this.currBricket.length; ++i) {
                this.currBricket[i].y += y;
                this.currBricket[i].x += x;
            }
        }
        if (this.currBricketPoint != null) {
            this.currBricketPoint.y += y;
            this.currBricketPoint.x += x;
        }
        if (this.isSomeOut(this.currBricket, 0)) {
            this.moveBricket(this.size, 0);
        }
        if (this.isSomeOut(this.currBricket, 2)) {
            this.moveBricket(-this.size, 0);
        }
        if (this.isSomeOut(this.currBricket, 3)) {
            this.moveBricket(0, -this.size);
        }
    }

    Point newPoint() {
        int w = this.usedW;
        int h = this.usedH;
        int x = Math.abs(this.r.nextInt() % (w -= this.size) / this.size * this.size);
        int y = Math.abs(this.r.nextInt() % (h -= this.size) / this.size * this.size);
        int sx = x;
        int sy = y;
        for (int mi = 0; mi < this.maze.length; ++mi) {
            if (x != this.maze[mi].x || y != this.maze[mi].y) continue;
            if (sx == (x += this.size) && sy == y) break;
            if (x <= w) continue;
            x = 0;
            if ((y += this.size) <= h) continue;
            y = 0;
        }
        return new Point(x, y);
    }

    void resolveKeys(int keyCode) {
        if (keyCode == 49) {
            this.rotatebricket(1);
        }
        if (keyCode == 51) {
            this.rotatebricket(-1);
        }
        if (keyCode == 52) {
            this.moveBricket(-this.size, 0);
        }
        if (keyCode == 54) {
            this.moveBricket(this.size, 0);
        }
        if (keyCode == 50) {
            this.newnextBricket();
        }
        if (keyCode == 56) {
            this.moveBricket(0, this.size);
        }
        if (keyCode == 53) {
            boolean bl = this.pause = !this.pause;
        }
        if (keyCode == 42 && this.speed > 20) {
            this.speed -= 10;
        }
        if (keyCode == 35) {
            this.speed += 10;
        }
        if (keyCode == 55 && this.size > 2) {
            --this.size;
            this.reloadMaze(this.c, this.size);
            this.resetSnake();
        }
        if (keyCode == 57) {
            ++this.size;
            this.reloadMaze(this.c, this.size);
            this.resetSnake();
        }
    }

    private boolean canDelete(int y) {
        int columns = 0;
        for (int i = 0; i < this.maze.length; ++i) {
            if (this.maze[i].y != y) continue;
            ++columns;
        }
        return columns >= this.usedW / this.size;
    }

    private void delete(int y) {
        int nulled = 0;
        for (int i = 0; i < this.maze.length; ++i) {
            if (this.maze[i].y != y) continue;
            ++nulled;
            this.maze[i] = null;
        }
        Point[] nwMaze = new Point[this.maze.length - nulled];
        int q = -1;
        for (int i = 0; i < this.maze.length; ++i) {
            if (this.maze[i] == null) continue;
            if (this.maze[i].y < y) {
                this.maze[i].y += this.size;
            }
            nwMaze[++q] = this.maze[i];
        }
        this.maze = nwMaze;
    }

    private void createCommands() {
        this.exitCommand = new Command("Exit", 7, 0);
        this.backCommand = new Command("Back", 2, 1);
    }

    private void createList() {
        this.examplesList = new List("Select Example", 3);
        for (int i = 0; i < this.examples.length; ++i) {
            this.examplesList.append(this.examples[i], null);
        }
        this.examplesList.setCommandListener((CommandListener)this);
    }

    private void createCanvases() {
        this.canvases = new Canvas[this.examples.length];
        this.canvases[0] = this.createTextCanvas();
        this.canvases[1] = this.createSettingsCanvas(this);
        this.canvases[2] = this.createSnakeCanvas(this);
    }

    private void addCommands(Displayable d) {
        d.addCommand(this.exitCommand);
        d.addCommand(this.backCommand);
        d.setCommandListener((CommandListener)this);
    }

    private Canvas createSnakeCanvas(GraphicsMIDlet parent) {
        this.resetSnake(100, 100);
        SnakeCanvas canvas = new SnakeCanvas(parent);
        this.c = canvas;
        parent.resetSnake(canvas.getWidth(), canvas.getHeight());
        Thread keys = new Thread(new Keys(canvas, parent));
        keys.start();
        this.addCommands((Displayable)canvas);
        return canvas;
    }

    private Canvas createTextCanvas() {
        TextCanvas canvas = new TextCanvas();
        this.addCommands((Displayable)canvas);
        return canvas;
    }

    private Canvas createSettingsCanvas(GraphicsMIDlet parent) {
        SettingsCanvas canvas = new SettingsCanvas(this.settings, parent);
        this.addCommands((Displayable)canvas);
        return canvas;
    }

    public void fromNextToCurrent() {
        this.currBricketIndex = this.nextBricketIndex;
        this.currBricketRotation = this.nextBricketRotation;
        this.currBricketPoint = new Point(this.usedW / this.size / 2 * this.size, 0);
        this.currBricket = this.set[this.currBricketIndex].expose(this.currBricketPoint, this.size, this.currBricketRotation);
        this.oldPoint = null;
        this.newnextBricket();
    }

    public void newnextBricket() {
        this.nextBricketIndex = MazeGenerator.random(this.set.length);
        this.nextBricketRotation = MazeGenerator.random(4);
        int ww = this.usedW;
        if (this.c != null) {
            ww = this.c.getWidth();
        }
        this.nextBricketPoint = new Point(ww - 3 * this.size, 3 * this.size);
        this.nextBricket = this.set[this.nextBricketIndex].expose(this.nextBricketPoint, this.size, this.nextBricketRotation);
    }

    public void reloadMaze(Canvas canvas, int s) {
        try {
            this.maze = new MazeGenerator().createMaze(((SettingsCanvas)this.canvases[1]).getMazename(), this.usedW, this.usedH, s, this.settings.eatenlost);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void rotatebricket(int i) {
        Point[] p;
        this.currBricketRotation += i;
        if (this.currBricketRotation < 0) {
            this.currBricketRotation = 3;
        }
        if (this.currBricketRotation > 3) {
            this.currBricketRotation = 0;
        }
        if (this.isSomeInMaze(p = this.set[this.currBricketIndex].expose(this.currBricketPoint, this.size, this.currBricketRotation))) {
            return;
        }
        this.currBricket = p;
        if (this.isSomeOut(this.currBricket, 0)) {
            this.moveBricket(this.size, 0);
        }
        if (this.isSomeOut(this.currBricket, 2)) {
            this.moveBricket(-this.size, 0);
        }
        if (this.isSomeOut(this.currBricket, 3)) {
            this.moveBricket(0, -this.size);
        }
    }

    public boolean isSomeOut(Point[] p, int inDir) {
        for (int i = 0; i < p.length; ++i) {
            Point point = p[i];
            if (inDir == 0 && point.x < 0) {
                return true;
            }
            if (inDir == 2 && point.x > this.usedW - this.size) {
                return true;
            }
            if (inDir != 3 || point.y <= this.usedH - this.size) continue;
            return true;
        }
        return false;
    }

    public boolean willBeSomeInMaze(Point[] p, int x, int y) {
        for (int i = 0; i < p.length; ++i) {
            Point point = p[i];
            for (int j = 0; j < this.maze.length; ++j) {
                if (!this.maze[j].equals(point, x, y)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSomeInMaze(Point[] p) {
        for (int i = 0; i < p.length; ++i) {
            Point point = p[i];
            for (int j = 0; j < this.maze.length; ++j) {
                if (!this.maze[j].equals(point)) continue;
                return true;
            }
        }
        return false;
    }

    private void smashWall() {
        int w = this.usedW;
        int h = this.usedH;
        if (this.had[0].x > w - this.size) {
            this.had[0].x = w - this.size;
        }
        if (this.had[0].x < 0) {
            this.had[0].x = 0;
        }
        if (this.had[0].y > h - this.size) {
            this.had[0].y = h - this.size;
        }
        if (this.had[0].y < 0) {
            this.had[0].y = 0;
        }
    }

    private void resetSnake(int w, int h) {
        this.usedW = w * this.settings.usedWidth / 100 / this.size * this.size;
        this.usedH = h % this.size == 0 ? h : h / this.size * this.size;
        for (int i = 0; i < this.had.length; ++i) {
            this.had[i] = new Point(this.size * 2, this.size * 2);
        }
        this.newnextBricket();
        this.fromNextToCurrent();
    }

    public void resetSnake() {
        this.resetSnake(this.c.getWidth(), this.c.getHeight());
    }
}

