/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import maze.MazeGenerator;
import misc.Point;
import sets.Bricket;
import sets.SetGenerator;

class SettingsCanvas
extends Canvas {
    SettingsItem[] si;
    int selected = 0;
    int scroll = 0;
    SettingsVars settings;
    private MazeGenerator mazegen = new MazeGenerator();
    private SetGenerator enemygen = new SetGenerator();
    private GraphicsMIDlet parent;
    private SetSettingsItem mazeSetter;
    private SetSettingsItem enemySetter;

    public void selectItem(int i, int move) {
        this.selected = i + move;
        if (this.selected < 0) {
            this.selected = this.si.length - 1;
        }
        if (this.selected >= this.si.length) {
            this.selected = 0;
        }
        while (!(this.si[this.selected] instanceof SelectableSettingsItem)) {
            this.selected = move < 0 ? --this.selected : ++this.selected;
            if (this.selected < 0) {
                this.selected = this.si.length - 1;
            }
            if (this.selected < this.si.length) continue;
            this.selected = 0;
        }
        this.repaint();
    }

    public void keyPressed(int keyCode) {
        if (keyCode == 50) {
            this.selectItem(this.selected, -1);
        }
        if (keyCode == 56) {
            this.selectItem(this.selected, 1);
        }
        if (keyCode == 52) {
            this.si[this.selected].minus();
            this.repaint();
        }
        if (keyCode == 54) {
            this.si[this.selected].plus();
            this.repaint();
        }
        if (keyCode == 35) {
            this.scroll += 20;
            this.repaint();
        }
        if (keyCode == 42) {
            this.scroll -= 20;
            this.repaint();
        }
    }

    protected void paint(Graphics g) {
        int hcounter = 0;
        int wcounter = 0;
        int w = this.getWidth();
        int h = this.getHeight();
        g.setColor(this.settings.bgColorR, this.settings.bgColorG, this.settings.bgColorB);
        g.fillRect(1, 1, w - 2, h - 2);
        g.setColor(this.settings.bordColorR, this.settings.bordColorG, this.settings.bordColorB);
        g.drawRect(0, 0, w * this.settings.usedWidth / 100 - 1, h - 1);
        int tmpsize = 10;
        int tmpl = 10;
        int tmpt = 20;
        g.setColor(this.settings.mazeColorR, this.settings.mazeColorG, this.settings.mazeColorB);
        for (int i = 0; i < this.parent.maze.length; ++i) {
            g.fillRect(this.parent.maze[i].x, this.parent.maze[i].y, tmpsize, tmpsize);
        }
        g.setColor(this.settings.snbdColorR, this.settings.snbdColorG, this.settings.snbdColorB);
        int ii = 4;
        for (int i = 0; i < this.parent.set.length; ++i) {
            if (i % 5 == 0) {
                ii += 6;
            }
            Point exp = new Point(tmpl + (ii + 1) * tmpsize, h - tmpt - i % 5 * 6 * tmpsize);
            Point[] p = this.parent.set[i].expose(exp, tmpsize, 3);
            for (int j = 0; j < p.length; ++j) {
                Point point = p[j];
                g.fillRect(point.x, point.y, tmpsize, tmpsize);
            }
        }
        g.setColor(this.settings.snhdColorR, this.settings.snhdColorG, this.settings.snhdColorB);
        ii = 5;
        g.fillRect(tmpl + ii * tmpsize, h - tmpt, tmpsize, tmpsize);
        ii = 6;
        g.fillRect(tmpl + ii * tmpsize, h - tmpt, tmpsize, tmpsize);
        ii = 5;
        g.fillRect(tmpl + ii * tmpsize, h - tmpt - tmpsize, tmpsize, tmpsize);
        ii = 6;
        g.fillRect(tmpl + ii * tmpsize, h - tmpt - tmpsize, tmpsize, tmpsize);
        Font font = g.getFont();
        for (int i = 0; i < this.si.length; ++i) {
            SettingsItem sis = this.si[i];
            if (sis instanceof ColorSettingsItem) {
                if (i == 0 || !(this.si[i - 1] instanceof ColorSettingsItem)) {
                    wcounter = 0;
                    ++hcounter;
                } else {
                    wcounter += font.stringWidth(this.si[i - 1].toCanvasString() + 5);
                }
            } else {
                wcounter = 0;
                ++hcounter;
            }
            if (i == this.selected) {
                g.setColor(250, 50, 50);
                g.drawRect(wcounter, this.scroll + hcounter * font.getHeight(), font.stringWidth(sis.toCanvasString()), font.getHeight());
            }
            if (!(sis instanceof SelectableSettingsItem)) {
                g.setColor(50, 50, 200);
                g.drawLine(wcounter, this.scroll + (hcounter + 1) * font.getHeight() + 1, wcounter + font.stringWidth(sis.toCanvasString()), this.scroll + (hcounter + 1) * font.getHeight() + 1);
            }
            g.setColor(this.settings.txtColorR, this.settings.txtColorG, this.settings.txtColorB);
            g.drawString(sis.toCanvasString(), wcounter, this.scroll + hcounter * font.getHeight(), 20);
        }
    }

    public SettingsCanvas(SettingsVars s, GraphicsMIDlet parent) {
        this.parent = parent;
        this.settings = s;
        SettingsItem si1 = new SettingsItem();
        si1.text = "Options 4,6/2,8/*#";
        IntSettingsItem si3 = new IntSettingsItem();
        si3.text = "Rows at start with random 'maze'";
        si3.ivalue = 0;
        si3.step = 1;
        si3.max = 100;
        si3.min = 0;
        si3.key = "CAMPAIGN";
        SettingsItem si4 = new SettingsItem();
        si4.text = "brickets color";
        ColorSettingsItem si5 = new ColorSettingsItem();
        si5.text = "R";
        si5.key = "BCR";
        ColorSettingsItem si6 = new ColorSettingsItem();
        si6.text = "G";
        si6.key = "BCG";
        ColorSettingsItem si7 = new ColorSettingsItem();
        si7.text = "B";
        si7.key = "BCB";
        SettingsItem si8 = new SettingsItem();
        si8.text = "Background color";
        ColorSettingsItem si9 = new ColorSettingsItem();
        si9.text = "R";
        si9.key = "BGCR";
        ColorSettingsItem si10 = new ColorSettingsItem();
        si10.text = "G";
        si10.key = "BGCG";
        ColorSettingsItem si11 = new ColorSettingsItem();
        si11.text = "B";
        si11.key = "BGCB";
        SettingsItem si12 = new SettingsItem();
        si12.text = "Border color";
        ColorSettingsItem si13 = new ColorSettingsItem();
        si13.text = "R";
        si13.key = "BRDCR";
        ColorSettingsItem si14 = new ColorSettingsItem();
        si14.text = "G";
        si14.key = "BRDCG";
        ColorSettingsItem si15 = new ColorSettingsItem();
        si15.text = "B";
        si15.key = "BRDCB";
        SettingsItem si28 = new SettingsItem();
        si28.text = "Next one color";
        ColorSettingsItem si29 = new ColorSettingsItem();
        si29.text = "R";
        si29.key = "HR";
        ColorSettingsItem si30 = new ColorSettingsItem();
        si30.text = "G";
        si30.key = "HG";
        ColorSettingsItem si31 = new ColorSettingsItem();
        si31.text = "B";
        si31.key = "HB";
        SettingsItem si32 = new SettingsItem();
        si32.text = "Text color";
        ColorSettingsItem si33 = new ColorSettingsItem();
        si33.text = "R";
        si33.key = "TR";
        ColorSettingsItem si34 = new ColorSettingsItem();
        si34.text = "G";
        si34.key = "TG";
        ColorSettingsItem si35 = new ColorSettingsItem();
        si35.text = "B";
        si35.key = "TB";
        SettingsItem si36 = new SettingsItem();
        si36.text = "settled color";
        ColorSettingsItem si37 = new ColorSettingsItem();
        si37.text = "R";
        si37.key = "MR";
        ColorSettingsItem si38 = new ColorSettingsItem();
        si38.text = "G";
        si38.key = "MG";
        ColorSettingsItem si39 = new ColorSettingsItem();
        si39.text = "B";
        si39.key = "MB";
        String[] ss = new String[]{"none"};
        try {
            ss = this.mazegen.getListOfMazes("mazes");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        SetSettingsItem si40 = new SetSettingsItem(ss);
        si40.text = "Starting shapes";
        si40.key = "MAZE";
        String[] sss = new String[]{"none"};
        try {
            sss = this.enemygen.getListSets("sets");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        SetSettingsItem si41 = new SetSettingsItem(sss);
        si41.text = "Brickets set";
        si41.key = "ENEMY";
        IntSettingsItem si43 = new IntSettingsItem();
        si43.text = "percent of wirdt used";
        si43.ivalue = 50;
        si43.step = 2;
        si43.max = 100;
        si43.min = 1;
        si43.key = "PERCENTWIDTH";
        this.si = new SettingsItem[29];
        this.si[0] = si1;
        this.si[1] = si3;
        this.si[2] = si4;
        this.si[3] = si5;
        this.si[4] = si6;
        this.si[5] = si7;
        this.si[6] = si8;
        this.si[7] = si9;
        this.si[8] = si10;
        this.si[9] = si11;
        this.si[10] = si12;
        this.si[11] = si13;
        this.si[12] = si14;
        this.si[13] = si15;
        this.si[14] = si28;
        this.si[15] = si29;
        this.si[16] = si30;
        this.si[17] = si31;
        this.si[18] = si32;
        this.si[19] = si33;
        this.si[20] = si34;
        this.si[21] = si35;
        this.si[22] = si36;
        this.si[23] = si37;
        this.si[24] = si38;
        this.si[25] = si39;
        this.si[26] = si40;
        this.si[27] = si41;
        this.si[28] = si43;
        this.mazeSetter = si40;
        this.enemySetter = si41;
        for (int i = 0; i < this.si.length; ++i) {
            SettingsItem sis = this.si[i];
            sis.update();
        }
        this.selectItem(-1, 1);
    }

    public String getMazename() {
        return this.mazeSetter.getSelectedValue();
    }

    public String getEnemiesSetName() {
        return this.enemySetter.getSelectedValue();
    }

    private class SettingsItem {
        public String text = "";
        public String key = "";

        private SettingsItem() {
        }

        public String toCanvasString() {
            return this.text;
        }

        public void plus() {
        }

        public void minus() {
        }

        public void setValue(Object o) {
        }

        public Object getValue() {
            return null;
        }

        public void update() {
        }
    }

    private class SelectableSettingsItem
    extends SettingsItem {
        private SelectableSettingsItem() {
        }
    }

    private class IntSettingsItem
    extends SelectableSettingsItem {
        public int step = 1;
        public int max = 0;
        public int min = 0;
        public int ivalue = 0;

        public String toCanvasString() {
            return this.text + ": " + this.ivalue;
        }

        public void plus() {
            int tmp = this.ivalue + this.step;
            if (tmp <= this.max && tmp >= this.min) {
                this.ivalue = tmp;
            }
            SettingsCanvas.this.settings.setValueInt(this.key, this.ivalue);
        }

        public void minus() {
            int tmp = this.ivalue - this.step;
            if (tmp <= this.max && tmp >= this.min) {
                this.ivalue = tmp;
            }
            SettingsCanvas.this.settings.setValueInt(this.key, this.ivalue);
        }

        public void setValue(Object o) {
            if (o instanceof Integer) {
                int i = (Integer)o;
                if (i >= this.min && i <= this.max) {
                    this.ivalue = i;
                }
                if (i < this.min) {
                    this.ivalue = this.min;
                }
                if (i > this.max) {
                    this.ivalue = this.max;
                }
            } else {
                throw new IllegalArgumentException("Only Integer supported");
            }
            SettingsCanvas.this.settings.setValueInt(this.key, this.ivalue);
        }

        public Object getValue() {
            return new Integer(this.ivalue);
        }

        public void update() {
            this.ivalue = SettingsCanvas.this.settings.getIntValue(this.key);
        }
    }

    private class SetSettingsItem
    extends IntSettingsItem {
        String[] values;

        public SetSettingsItem(String[] values) {
            this.values = values;
            this.step = 1;
            this.max = values.length - 1;
            this.min = 0;
            this.ivalue = 0;
        }

        public String getSelectedValue() {
            return this.values[this.ivalue];
        }

        public void plus() {
            super.plus();
            this.relaodMaze();
        }

        public void minus() {
            super.minus();
            this.relaodMaze();
        }

        public void setValue(Object o) {
            super.setValue(o);
            this.relaodMaze();
        }

        public String toCanvasString() {
            return this.text + ": " + this.values[this.ivalue];
        }

        public void update() {
            super.update();
            this.relaodMaze();
        }

        public void relaodMaze() {
            if (this.key.equals("MAZE")) {
                try {
                    Point[] a = SettingsCanvas.this.mazegen.createMaze(this.values[this.ivalue], SettingsCanvas.this.getWidth(), SettingsCanvas.this.getHeight(), 10, SettingsCanvas.this.settings.eatenlost);
                    ((SettingsCanvas)SettingsCanvas.this).parent.maze = a;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (this.key.equals("ENEMY")) {
                try {
                    Bricket[] b = SettingsCanvas.this.enemygen.createSet(this.values[this.ivalue]);
                    ((SettingsCanvas)SettingsCanvas.this).parent.set = b;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private class ColorSettingsItem
    extends IntSettingsItem {
        public ColorSettingsItem() {
            this.step = 5;
            this.max = 255;
            this.min = 0;
        }
    }

    private class BoolSettingsItem
    extends SelectableSettingsItem {
        public boolean bvalue = false;

        private BoolSettingsItem() {
        }

        public String toCanvasString() {
            return this.text + ": " + this.bvalue;
        }

        public void plus() {
            this.bvalue = !this.bvalue;
            SettingsCanvas.this.settings.setValueBool(this.key, this.bvalue);
        }

        public void minus() {
            this.bvalue = !this.bvalue;
            SettingsCanvas.this.settings.setValueBool(this.key, this.bvalue);
        }

        public void setValue(Object o) {
            boolean i;
            if (!(o instanceof Boolean)) {
                throw new IllegalArgumentException("Onli Integer supported");
            }
            this.bvalue = i = ((Boolean)o).booleanValue();
            SettingsCanvas.this.settings.setValueBool(this.key, this.bvalue);
        }

        public Object getValue() {
            return new Boolean(this.bvalue);
        }

        public void update() {
            this.bvalue = SettingsCanvas.this.settings.getBooleValue(this.key);
        }
    }
}

