/*
 * Decompiled with CFR 0.152.
 */
package maze;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Random;
import misc.Point;
import net.jscience.math.MathFP;

public class MazeGenerator {
    protected static Random seed = new Random();

    public static int random(int i) {
        if (i <= 0) {
            return 0;
        }
        return Math.abs(seed.nextInt()) % i;
    }

    public Point[] createMaze(String name, int w, int h, int csize, int randomRows) throws IOException {
        w /= csize;
        h /= csize;
        if (name.equals("none")) {
            return new Point[0];
        }
        if (name.equals("random")) {
            return this.randomMaze(w, h, csize, randomRows);
        }
        StringBuffer sb = this.readResourceToMyfuckingString(name);
        String s = sb.toString();
        int rows = 0;
        int columns = -1;
        s = sb.toString();
        int cc = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != ' ') {
                ++cc;
                continue;
            }
            if (columns < 0) {
                columns = cc;
            } else if (cc != columns) {
                throw new IllegalArgumentException(cc + " != " + columns);
            }
            ++rows;
            cc = 0;
        }
        System.out.println("Maze " + name + " have " + columns + " columns and " + rows + " rows");
        int[][] a = new int[columns][rows];
        rows = 0;
        cc = 0;
        int total = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != ' ') {
                if (s.charAt(i) == 'x') {
                    a[cc][rows] = 1;
                    ++total;
                } else {
                    a[cc][rows] = 0;
                }
                ++cc;
                continue;
            }
            ++rows;
            cc = 0;
        }
        long doubleW = MathFP.toFP(w);
        long doubleH = MathFP.toFP(h);
        long doubleCols = MathFP.toFP(columns);
        long doubleRows = MathFP.toFP(rows);
        long doubleTotal = MathFP.toFP(total);
        long wscale = MathFP.div(doubleW, doubleCols);
        long hscale = MathFP.div(doubleH, doubleRows);
        long nwTotal = MathFP.mul(MathFP.mul(wscale, hscale), doubleTotal);
        long size = MathFP.toLong(MathFP.round(MathFP.add(nwTotal, MathFP.toFP("0.555555")), 8));
        System.out.println(size);
        Point[] maze = new Point[(int)size];
        int index = -1;
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                long doubleX = MathFP.toFP(x);
                long doubleY = MathFP.toFP(y);
                long doubleXX = MathFP.div(doubleX, wscale);
                long doubleYY = MathFP.div(doubleY, hscale);
                int xx = (int)MathFP.toLong(doubleXX);
                int yy = (int)MathFP.toLong(doubleYY);
                if (xx >= columns || yy >= rows || a[xx][yy] != 1 || index + 1 >= maze.length) continue;
                maze[++index] = new Point(x * csize, y * csize);
            }
        }
        for (int i = index + 1; i < maze.length; ++i) {
            maze[i] = new Point(-100, -100);
        }
        System.out.println(index);
        return maze;
    }

    public String[] getListOfMazes(String name) throws IOException {
        StringBuffer sb = this.readResourceToMyfuckingString(name);
        int length = 0;
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != ' ') continue;
            ++length;
        }
        ++length;
        String[] l = new String[++length];
        l[0] = "none";
        l[1] = "random";
        int thisS = 0;
        int lastS = 0;
        int index = 1;
        String s = sb.toString();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != ' ') continue;
            thisS = i;
            l[++index] = s.substring(lastS, thisS).trim();
            lastS = thisS;
        }
        return l;
    }

    private Point[] randomMaze(int w, int h, int size, int randomRows) {
        int[] rowsLengths = new int[randomRows];
        int totalLength = 0;
        for (int i = 0; i < rowsLengths.length; ++i) {
            int j = MazeGenerator.random(2 * w / 3) + 2 * w / 3;
            totalLength += j;
            rowsLengths[i] = j;
        }
        Point[] result = new Point[totalLength];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new Point(MazeGenerator.random(w) * size, (h - MazeGenerator.random(randomRows) - 1) * size);
        }
        result = this.removeDuplicates(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer readResourceToMyfuckingString(String name) throws IOException {
        InputStream is = null;
        try {
            int i;
            is = this.getClass().getResourceAsStream(name);
            InputStreamReader ir = new InputStreamReader(is);
            StringBuffer sb = new StringBuffer();
            while ((i = ir.read()) >= 0) {
                sb.append((char)i);
            }
            String s = sb.toString();
            s = s.replace('\r', ' ');
            s = s.replace('\n', ' ');
            sb = new StringBuffer(s);
            for (int i2 = 0; i2 < sb.length() - 1; ++i2) {
                if (sb.charAt(i2) != ' ' || sb.charAt(i2 + 1) != ' ') continue;
                sb.deleteCharAt(i2);
            }
            if (sb.charAt(sb.length() - 1) == ' ' && sb.charAt(sb.length() - 2) == ' ') {
                sb.deleteCharAt(sb.length() - 1);
            }
            if (sb.charAt(sb.length() - 1) != ' ') {
                sb = sb.append(' ');
            }
            StringBuffer stringBuffer = sb;
            return stringBuffer;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    private Point[] removeDuplicates(Point[] result) {
        int nulled = 0;
        for (int i = 0; i < result.length; ++i) {
            Point point = result[i];
            if (point == null) continue;
            for (int j = i + 1; j < result.length; ++j) {
                Point point1 = result[j];
                if (point1 == null || !point.equals(point1)) continue;
                result[j] = null;
                ++nulled;
            }
        }
        Point[] p = new Point[result.length - nulled];
        int q = -1;
        for (int i = 0; i < result.length; ++i) {
            Point point = result[i];
            if (point == null) continue;
            p[++q] = point;
        }
        return p;
    }
}

