/*
 * Decompiled with CFR 0.152.
 */
package sets;

import java.util.Random;
import misc.Point;

public class Bricket {
    protected static Random seed = new Random();
    Point[] base = new Point[25];

    int random(int i) {
        if (i <= 0) {
            return 0;
        }
        return Math.abs(seed.nextInt()) % i;
    }

    public static Bricket createFromString(String s) {
        Bricket b = new Bricket();
        int line = 0;
        int column = 0;
        for (int i = 0; i < s.length() && s.charAt(i) != '-'; ++i) {
            if (s.charAt(i) == ' ') {
                ++line;
                column = 0;
                continue;
            }
            if (s.charAt(i) == 'x') {
                b.base[column + line * 5] = new Point(column - 2, line - 2);
            }
            ++column;
        }
        return b;
    }

    public Point[] expose(Point to, int size, int rotation) {
        int l = 0;
        for (int i = 0; i < this.base.length; ++i) {
            if (this.base[i] == null) continue;
            ++l;
        }
        Point[] a = new Point[l];
        switch (rotation) {
            case 1: {
                l = 0;
                for (int i = 0; i < this.base.length; ++i) {
                    if (this.base[i] == null) continue;
                    a[l] = new Point(-this.base[i].y * size + to.x, this.base[i].x * size + to.y);
                    ++l;
                }
                break;
            }
            case 3: {
                l = 0;
                for (int i = 0; i < this.base.length; ++i) {
                    if (this.base[i] == null) continue;
                    a[l] = new Point(this.base[i].y * size + to.x, -this.base[i].x * size + to.y);
                    ++l;
                }
                break;
            }
            case 2: {
                l = 0;
                for (int i = 0; i < this.base.length; ++i) {
                    if (this.base[i] == null) continue;
                    a[l] = new Point(-this.base[i].x * size + to.x, -this.base[i].y * size + to.y);
                    ++l;
                }
                break;
            }
            default: {
                l = 0;
                for (int i = 0; i < this.base.length; ++i) {
                    if (this.base[i] == null) continue;
                    a[l] = new Point(this.base[i].x * size + to.x, this.base[i].y * size + to.y);
                    ++l;
                }
            }
        }
        return a;
    }
}

