/*
 * Decompiled with CFR 0.152.
 */
package com.gowtham.jmp3tag;

public class Frame {
    private final int headerSize;
    private String id;
    private int size;
    private byte[] flags;
    private String data;
    private byte[] bytes;
    private boolean isEditableFrame;

    public byte[] getBytes() {
        return this.bytes;
    }

    public Frame(String string, byte[] byArray, String string2, byte[] byArray2, boolean bl) {
        this.headerSize = 10;
        this.id = string;
        this.flags = byArray;
        this.isEditableFrame = bl;
        if (this.isEditableFrame) {
            this.data = string2;
            this.size = this.data.length();
        } else {
            this.bytes = byArray2;
            this.size = this.bytes.length;
        }
    }

    public int getFrameSize() {
        return this.size;
    }

    public String getFrameID() {
        return this.id;
    }

    public void setData(String string) {
        this.data = string;
        this.size = this.data.length();
    }

    public byte[] serialize() {
        int n;
        int n2;
        byte[] byArray = new byte[this.size + 10 + 2];
        int n3 = 0;
        for (n2 = 0; n2 < this.id.length(); ++n2) {
            byArray[n3] = (byte)this.id.charAt(n2);
            ++n3;
        }
        System.out.println("\tSize (before BOM and null addition, 2 extra)" + this.size);
        int n4 = this.size + 2;
        for (n2 = 0; n2 <= 3; ++n2) {
            byArray[n3 + 3 - n2] = n = (int)(n4 & 0xFF);
            System.out.println(n);
            n4 >>= 8;
        }
        n3 += 4;
        for (n2 = 1; n2 >= 0; --n2) {
            byArray[n3] = this.flags[n2];
            ++n3;
        }
        if (this.isEditableFrame) {
            byArray[n3] = 0;
            ++n3;
            for (n2 = 0; n2 < this.data.length(); ++n2) {
                byArray[n3] = (byte)this.data.charAt(n2);
                ++n3;
            }
            byArray[n3] = 0;
            ++n3;
        } else {
            while (n2 < this.bytes.length) {
                byArray[n3] = this.bytes[n2];
                ++n3;
                ++n2;
            }
        }
        System.out.println("Serializing frame " + this.id);
        for (n = 0; n < byArray.length; ++n) {
            System.out.print(byArray[n] + " ");
        }
        System.out.println("\n");
        return byArray;
    }

    public static int calculateFrameSize(byte[] byArray, int n, int n2) {
        int n3 = 0;
        for (int i = n; i <= n2; ++i) {
            System.out.println("Byte : " + byArray[i]);
            int n4 = byArray[i];
            if (n4 < 0) {
                n4 = 256 + n4;
                System.out.println("Corrected byte " + n4);
            }
            if (i > n) {
                n3 <<= 8;
            }
            n3 += n4;
        }
        if (n3 < 0) {
            System.out.println("Negative " + n3);
        }
        return n3;
    }

    public static boolean isValidFrame(String string) {
        for (int i = 0; i < 4; ++i) {
            char c = string.charAt(i);
            if ('A' <= c && c <= 'Z' || '0' <= c && c <= '9') continue;
            return false;
        }
        return true;
    }
}

