/*
 * Decompiled with CFR 0.152.
 */
package com.gowtham.jmp3tag;

import com.gowtham.jmp3tag.APICTag;
import com.gowtham.jmp3tag.FileBrowser;
import com.gowtham.jmp3tag.FileBrowserEvent;
import com.gowtham.jmp3tag.Frame;
import com.gowtham.jmp3tag.Logger;
import com.gowtham.jmp3tag.Preferences;
import com.gowtham.jmp3tag.SettingsEvent;
import com.gowtham.jmp3tag.SettingsForm;
import com.gowtham.jmp3tag.Tag;
import java.io.IOException;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.lcdui.Ticker;
import javax.microedition.midlet.MIDlet;

public class Mp3Tag
extends MIDlet
implements CommandListener,
FileBrowserEvent,
Runnable,
SettingsEvent {
    private Gauge gauge;
    private Form progressForm;
    private Form tagEditor;
    private Command cmdBrowseFile;
    private Command cmdSaveTags;
    private Command cmdExit;
    private Command cmdAbout;
    private TextField textFieldPath;
    private TextField textFieldTitle;
    private TextField textFieldAlbum;
    private TextField textFieldArtist;
    private TextField textFieldYear;
    private TextField textFieldComposer;
    private Command cmdHelp;
    private Command cmdCancel;
    private Ticker ticker;
    private Tag tag;
    private FileBrowser fileBrowser;
    private FileBrowser imageBrowser;
    private Command replaceArtCommand;
    private Form imageForm = null;
    private Command showImageCmd = null;
    private Command backFromImageFormCmd = null;
    private Logger logger = new Logger("Logger", this);
    private Command showLogCommand;
    private SettingsForm settingsForm;
    private Preferences pref;
    private Command configureSettingsCmd = null;
    private Command deleteArtCmd = null;

    public Mp3Tag() {
        this.initialize();
        this.ticker = new Ticker("Select Browse to load a MP3 file");
        this.tagEditor.setTicker(this.ticker);
        if (this.progressForm == null) {
            this.progressForm = new Form("Saving...");
        }
        if (this.gauge == null) {
            this.gauge = new Gauge("Progress", false, 100, 0);
            this.gauge.setLabel("Progress");
        }
        this.progressForm.append((Item)this.gauge);
        this.showLogCommand = new Command("View Log", 1, 10);
        if (this.fileBrowser == null) {
            this.fileBrowser = new FileBrowser("MP3 browser", this, "/", new String[]{"mp3"}, false, this);
        }
        if (this.imageBrowser == null) {
            this.imageBrowser = new FileBrowser("Image browser", this, "/", new String[]{"jpg", "png", "bmp", "gif"}, false, this);
        }
        if (this.imageForm == null) {
            this.imageForm = new Form("Album Art");
        }
        this.replaceArtCommand = new Command("Replace", 1, 0);
        this.imageForm.addCommand(this.replaceArtCommand);
        this.showImageCmd = new Command("Album Art...", "Album Art...", 1, 100);
        this.backFromImageFormCmd = new Command("Back", "Back", 1, 0);
        this.deleteArtCmd = new Command("Delete", "Delete Image", 1, 1);
        this.imageForm.addCommand(this.backFromImageFormCmd);
        this.imageForm.setCommandListener((CommandListener)this);
        this.tagEditor.addCommand(this.showImageCmd);
        this.tagEditor.addCommand(this.showLogCommand);
        this.settingsForm = new SettingsForm(this);
        this.settingsForm.setListener(this);
        this.printf("Preferences loading");
        try {
            String string;
            String string2;
            this.pref = new Preferences("settings");
            String string3 = this.pref.get("overwrite");
            this.printf("Overwrite mode read: " + string3);
            if (string3 != null) {
                this.settingsForm.setOvewrite(string3);
            }
            if ((string2 = this.pref.get("sort")) != null) {
                this.printf("Sort mode read: " + string2);
                this.settingsForm.setSort(string2);
            }
            if ((string = this.pref.get("showticker")) != null) {
                this.printf("Show ticker read: " + string);
                this.settingsForm.setShowTicker(string);
                if (string.equalsIgnoreCase("No")) {
                    this.tagEditor.setTicker(null);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.configureSettingsCmd = new Command("Settings...", "Settings...", 1, 10);
        this.tagEditor.addCommand(this.configureSettingsCmd);
        this.setupImages();
    }

    public void populateTextBoxes(Tag tag) {
        try {
            this.textFieldAlbum.setString(tag.getAlbum());
            this.textFieldArtist.setString(tag.getArtist());
            this.textFieldTitle.setString(tag.getTitile());
            this.textFieldYear.setString(tag.getYear());
            this.textFieldComposer.setString(tag.getComposer());
        }
        catch (Exception exception) {
            this.ticker.setString(exception.toString());
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this.tagEditor) {
            if (command == this.cmdBrowseFile) {
                this.fileBrowser.show(this.getDisplay().getCurrent());
            } else if (command == this.cmdExit) {
                this.exitMIDlet();
            } else if (command == this.cmdAbout) {
                this.info("JMp3Tag v0.8 by Gowtham, built on 3 May 2011\n\nEmail: gowthamgowtham@gmail.com", "About");
            } else if (command == this.cmdSaveTags) {
                new Thread(new Runnable(){

                    public void run() {
                        Mp3Tag.this.handleSave();
                    }
                }).start();
            } else if (command == this.cmdHelp) {
                this.info("This program helps to edit the tags in MP3 files. Your phone should have support for JSR-75 API. To minimize the number of confirmation dialogs, grant the 'Read user data' and 'Write user data' permissions to this application.", "Help");
            } else if (command == this.showImageCmd) {
                this.loadImage();
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.imageForm);
            } else if (command == this.configureSettingsCmd) {
                this.settingsForm.show();
            } else if (command == this.showLogCommand) {
                this.logger.show((Displayable)this.tagEditor);
            }
        } else if (displayable == this.imageForm) {
            if (command == this.backFromImageFormCmd) {
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.tagEditor);
            } else if (command == this.deleteArtCmd) {
                this.tag.deleteAPICFrame();
                this.ticker.setString("Remember to select Save to remove the art");
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.tagEditor);
            } else if (command == this.replaceArtCommand) {
                this.logger.log("Showing image browser");
                this.imageBrowser.show((Displayable)this.imageForm);
            }
        }
    }

    private void initialize() {
        this.getDisplay().setCurrent((Displayable)this.get_tagEditor());
    }

    public Display getDisplay() {
        return Display.getDisplay((MIDlet)this);
    }

    public void exitMIDlet() {
        this.getDisplay().setCurrent(null);
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public Form get_tagEditor() {
        if (this.tagEditor == null) {
            this.tagEditor = new Form("JMp3Tag", new Item[]{this.get_textFieldPath(), this.get_textFieldTitle(), this.get_textFieldAlbum(), this.get_textFieldArtist(), this.get_textFieldYear(), this.get_textFieldComposer()});
            this.tagEditor.addCommand(this.get_cmdBrowseFile());
            this.tagEditor.addCommand(this.get_cmdSaveTags());
            this.tagEditor.addCommand(this.get_cmdExit());
            this.tagEditor.addCommand(this.get_cmdAbout());
            this.tagEditor.addCommand(this.get_cmdHelp());
            this.tagEditor.setCommandListener((CommandListener)this);
        }
        return this.tagEditor;
    }

    public Command get_cmdBrowseFile() {
        if (this.cmdBrowseFile == null) {
            this.cmdBrowseFile = new Command("Browse", 1, 1);
        }
        return this.cmdBrowseFile;
    }

    public Command get_cmdSaveTags() {
        if (this.cmdSaveTags == null) {
            this.cmdSaveTags = new Command("Save", 1, 1);
        }
        return this.cmdSaveTags;
    }

    public Command get_cmdExit() {
        if (this.cmdExit == null) {
            this.cmdExit = new Command("Exit", 7, 1);
        }
        return this.cmdExit;
    }

    public Command get_cmdAbout() {
        if (this.cmdAbout == null) {
            this.cmdAbout = new Command("About", 1, 1);
        }
        return this.cmdAbout;
    }

    public TextField get_textFieldPath() {
        if (this.textFieldPath == null) {
            this.textFieldPath = new TextField("MP3 file", "", 1000, 131072);
        }
        return this.textFieldPath;
    }

    public TextField get_textFieldTitle() {
        if (this.textFieldTitle == null) {
            this.textFieldTitle = new TextField("Title", null, 120, 0);
        }
        return this.textFieldTitle;
    }

    public TextField get_textFieldAlbum() {
        if (this.textFieldAlbum == null) {
            this.textFieldAlbum = new TextField("Album", null, 120, 0);
        }
        return this.textFieldAlbum;
    }

    public TextField get_textFieldArtist() {
        if (this.textFieldArtist == null) {
            this.textFieldArtist = new TextField("Artist", null, 120, 0);
        }
        return this.textFieldArtist;
    }

    public TextField get_textFieldYear() {
        if (this.textFieldYear == null) {
            this.textFieldYear = new TextField("Year", null, 120, 0);
        }
        return this.textFieldYear;
    }

    public TextField get_textFieldComposer() {
        if (this.textFieldComposer == null) {
            this.textFieldComposer = new TextField("Composer", null, 120, 0);
        }
        return this.textFieldComposer;
    }

    public Command get_cmdHelp() {
        if (this.cmdHelp == null) {
            this.cmdHelp = new Command("Help", 1, 1);
        }
        return this.cmdHelp;
    }

    public Command get_cmdCancel() {
        if (this.cmdCancel == null) {
            this.cmdCancel = new Command("Cancel", 1, 1);
        }
        return this.cmdCancel;
    }

    public void startApp() {
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
        this.saveSettings();
    }

    public void run() {
    }

    public void handleSave() {
        if (this.tag != null) {
            try {
                this.gauge.setValue(0);
                this.getDisplay().setCurrent((Displayable)this.progressForm);
                this.tag.setAlbum(this.textFieldAlbum.getString());
                this.tag.setArtist(this.textFieldArtist.getString());
                this.tag.setTitile(this.textFieldTitle.getString());
                this.tag.setYear(this.textFieldYear.getString());
                this.tag.setComposer(this.textFieldComposer.getString());
                this.ticker.setString("Saving... Please wait");
                this.tag.Save(this.gauge, this.settingsForm.canOverwrite());
                this.ticker.setString("Tags saved successfully");
                this.getDisplay().setCurrent((Displayable)this.tagEditor);
            }
            catch (Exception exception) {
                this.ticker.setString(exception.toString());
                this.getDisplay().setCurrent((Displayable)this.tagEditor);
            }
        } else {
            this.ticker.setString("No MP3 file loaded!");
        }
    }

    public void info(String string, String string2) {
        Alert alert = new Alert(string2);
        alert.setType(AlertType.INFO);
        alert.setString(string);
        alert.setTimeout(-2);
        this.getDisplay().setCurrent((Displayable)alert);
    }

    public void debug(String string) {
        Alert alert = new Alert("DEBUG");
        alert.setType(AlertType.INFO);
        alert.setString(string);
        alert.setTimeout(-2);
        this.getDisplay().setCurrent((Displayable)alert);
    }

    public void error(String string) {
        Alert alert = new Alert("ERROR");
        alert.setType(AlertType.ERROR);
        alert.setString(string);
        alert.setTimeout(3000);
        this.getDisplay().setCurrent((Displayable)alert);
    }

    public void handleRead() {
        this.tag = new Tag(this.textFieldPath.getString());
        try {
            this.tag.Read();
            if (this.tag.tagExists()) {
                this.ticker.setString("Tags loaded");
            } else {
                this.ticker.setString("No tags found");
            }
        }
        catch (Exception exception) {
            this.ticker.setString(exception.toString());
        }
        this.populateTextBoxes(this.tag);
    }

    public void someThingSelected(FileBrowser fileBrowser, String string) {
        if (fileBrowser == this.fileBrowser) {
            this.textFieldPath.setString(string);
            this.handleRead();
        }
        if (fileBrowser == this.imageBrowser) {
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.imageForm);
            this.replaceAlbumArt(string);
        }
    }

    private void loadImage() {
        this.imageForm.deleteAll();
        this.imageForm.removeCommand(this.deleteArtCmd);
        StringItem stringItem = new StringItem("Error: ", "");
        StringItem stringItem2 = new StringItem("Image type: ", "");
        StringItem stringItem3 = new StringItem("Description: ", "");
        if (this.tag == null) {
            this.imageForm.append((Item)stringItem);
            stringItem.setText("No MP3 file loaded");
            return;
        }
        if (!this.tag.tagExists()) {
            this.imageForm.append((Item)stringItem);
            stringItem.setText("No tag exists in the loaded MP3 file");
            return;
        }
        byte[] byArray = this.tag.getFrame("APIC");
        if (byArray == null) {
            this.imageForm.append((Item)stringItem);
            stringItem.setText("No album art exists in the loaded MP3 file");
            return;
        }
        this.printf("Image exists");
        this.printf("Size : " + byArray.length);
        APICTag aPICTag = new APICTag(byArray);
        this.printf(aPICTag.getMimeType());
        this.printf(aPICTag.getDescription());
        stringItem2.setText(aPICTag.getMimeType());
        stringItem3.setText(aPICTag.getDescription());
        int n = aPICTag.getImageStartIndex();
        this.printf("Image length = " + aPICTag.getImageLength());
        this.printf("Bytes: " + Integer.toHexString(byArray[n] & 0xFF) + Integer.toHexString(byArray[n + 1] & 0xFF));
        Image image = Image.createImage((byte[])byArray, (int)n, (int)aPICTag.getImageLength());
        this.imageForm.append((Item)stringItem2);
        this.imageForm.append((Item)stringItem3);
        this.imageForm.append(image);
        this.imageForm.addCommand(this.deleteArtCmd);
    }

    private void printf(String string) {
        System.out.println(string);
    }

    public void settingsSaved() {
        String string = this.settingsForm.canOverwriteString();
        this.printf("Overwrite mode: " + string);
        if (string != null) {
            this.pref.put("overwrite", string);
        }
        String string2 = this.settingsForm.canSortString();
        this.printf("Sort mode: " + string2);
        if (string2 != null) {
            this.pref.put("sort", string2);
            this.fileBrowser.setSort(this.settingsForm.canSort());
        }
        String string3 = this.settingsForm.canShowTickerString();
        this.printf("Ticker show: " + string3);
        if (string3 != null) {
            this.pref.put("showticker", string3);
        }
        if (this.settingsForm.canShowTicker()) {
            this.tagEditor.setTicker(this.ticker);
        } else {
            this.tagEditor.setTicker(null);
        }
    }

    private void saveSettings() {
        try {
            this.pref.save();
            this.printf("Save ok");
        }
        catch (Exception exception) {
            this.error("Error saving settings: " + exception.toString());
        }
    }

    private void replaceAlbumArt(String string) {
        this.tag.deleteAPICFrame();
        try {
            APICTag aPICTag = new APICTag(string);
            aPICTag.setLogger(this.logger);
            byte[] byArray = aPICTag.toByteArray();
            Frame frame = new Frame("APIC", new byte[]{0, 0}, null, byArray, false);
            this.tag.addTag(frame);
            int n = aPICTag.getImageOffset();
            Image image = Image.createImage((byte[])byArray, (int)n, (int)(byArray.length - n));
            this.imageForm.deleteAll();
            StringItem stringItem = new StringItem("New image:", string);
            this.imageForm.append((Item)stringItem);
            this.imageForm.append(image);
            this.ticker.setString("Remember to select Save to edit the art image");
        }
        catch (IOException iOException) {
            this.logger.log(iOException.toString());
        }
    }

    private void setupImages() {
        try {
            Image image = Image.createImage((String)"folder.png");
            Image image2 = Image.createImage((String)"music.png");
            Image image3 = Image.createImage((String)"up.png");
            Image image4 = Image.createImage((String)"image.png");
            this.fileBrowser.setFileImage(image2);
            this.fileBrowser.setUpImage(image3);
            this.fileBrowser.setFolderImage(image);
            this.imageBrowser.setFileImage(image4);
            this.imageBrowser.setUpImage(image3);
            this.imageBrowser.setFolderImage(image);
        }
        catch (Exception exception) {
            this.logger.log(exception.toString());
        }
    }
}

