/*
 * Decompiled with CFR 0.152.
 */
package com.wapindustrial.calc;

import com.wapindustrial.calc.Base64;
import com.wapindustrial.calc.MicroCalc;
import com.wapindustrial.calc.Result;
import com.wapindustrial.calc.Sheet;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.SocketConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class EmailClient
implements Runnable {
    static final Command endCommand = new Command("OK", 4, 2);
    static final Command backCommand = new Command("Back", 2, 3);
    static final Command exitCommand = new Command("Exit", 8, 1);
    static final Command abortCommand = new Command("Abort", 8, 1);
    private RecordStore recst;
    private MicroCalc parent;
    private Sheet sheet;
    private Display display;
    private Form f;
    private Form form;
    private StringItem si;
    private SocketConnection sc;
    private StringBuffer sb;
    private InputStream is;
    private OutputStream os;
    private TextField txtField;
    String[] fnames = null;
    private String from;
    private String to;
    private String user;
    private String pwd;
    private String srvr;
    private String psrvr;
    private String str;
    private String tmpstr;
    private String fname;
    public int done;
    public int debug;
    public int pushdebug;
    public int fc;
    public int type;

    public EmailClient(MicroCalc microCalc, Display display, Form form, Sheet sheet, String string, int n) {
        this.parent = microCalc;
        this.display = display;
        this.f = form;
        this.sheet = sheet;
        this.fname = "ff_" + string;
        this.type = n;
        display = Display.getDisplay((MIDlet)this.parent);
        this.si = new StringItem("", "Progress:");
        this.si.setFont(Font.getFont((int)64, (int)0, (int)8));
        display.setCurrent((Displayable)this.f);
    }

    public void start() {
        Thread thread = new Thread(this);
        thread.start();
    }

    public void status(String string) {
        if (this.debug < 1) {
            this.si.setText(this.si.getText() + "\n" + string);
        }
    }

    public void info(String string) {
        if (this.debug > 0) {
            this.si.setText(string + "\n" + this.truncSI());
        }
    }

    public synchronized void send(String string) throws IOException {
        this.os.write((string + "\r\n").getBytes());
        this.os.flush();
        if (this.debug > 0) {
            this.si.setText(">> " + string + "\n" + this.truncSI());
        }
    }

    public synchronized String waitServer() throws IOException {
        String string = "";
        boolean bl = false;
        long l = System.currentTimeMillis();
        while (!bl) {
            try {
                string = this.readString();
            }
            catch (Exception exception) {
                throw new IOException();
            }
            if (string.length() >= 1) break;
            if (System.currentTimeMillis() - l <= 10000L) continue;
            throw new IOException();
        }
        return string;
    }

    public synchronized String readString() throws IOException {
        int n;
        this.sb = new StringBuffer();
        while ((n = this.is.read()) != -1 && (char)n != '\n') {
            this.sb.append((char)n);
        }
        String string = this.sb.toString();
        String string2 = string.replace('\r', ' ');
        if (this.debug > 0) {
            this.si.setText("<< " + string2 + "\n" + this.truncSI());
        }
        return string;
    }

    private String truncSI() {
        String string = this.si.getText();
        if (string.length() > 900) {
            string = string.substring(0, 900);
        }
        return string;
    }

    public static String lf2crlf(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if ((c >= '\u0080' || c <= '\u001f') && c != '\n' && c != '\r' && c != '\u00a3') continue;
                stringBuffer.append(c);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        string = "";
        string = stringBuffer.toString();
        if (string.length() > 900) {
            string = string.substring(0, 901);
        }
        stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        try {
            while ((n = string.indexOf(10, n)) != -1) {
                if (n > 0 && string.charAt(n - 1) != '\r') {
                    stringBuffer.append(string.substring(n2, n) + "\r\n");
                } else {
                    stringBuffer.append(string.substring(n2, n) + "\n");
                }
                n2 = ++n;
            }
            stringBuffer.append(string.substring(n2));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    public String readData() {
        String string = "";
        try {
            while (!(this.tmpstr = this.waitServer()).equals(".\r")) {
                this.tmpstr = this.tmpstr.trim();
                if (this.tmpstr.startsWith("ID;")) {
                    this.sheet.clearSheet();
                    this.debug = this.pushdebug;
                    this.status("Installing sheet....");
                    this.info("<< " + this.tmpstr);
                    int n = 0;
                    while (n < 1) {
                        this.tmpstr = this.waitServer().trim();
                        if (this.tmpstr.startsWith("E")) {
                            this.tmpstr = "";
                            n = 2;
                            break;
                        }
                        if (this.tmpstr.equals(".\r")) {
                            n = 2;
                            break;
                        }
                        if (this.tmpstr.length() <= 0) continue;
                        string = this.sheet.getSylkLine(this.tmpstr);
                    }
                    this.debug = 0;
                }
                if (!this.tmpstr.equals(".\r")) continue;
                break;
            }
        }
        catch (Exception exception) {
            this.message(exception.getMessage().toString(), exception.toString());
        }
        this.debug = 0;
        return this.tmpstr;
    }

    public void run() {
        String[] stringArray = new String[]{"FROM:", "RCPT:", "USER:", "PSWD:", "SRVR:", "POP3:"};
        String[] stringArray2 = new String[5];
        stringArray2 = EmailClient.readData("mc_email", stringArray);
        this.f.deleteAll();
        this.f.append((Item)new TextField("Destination email address:", stringArray2[1], 32, 1));
        this.f.insert(0, (Item)new TextField("Password on server:", stringArray2[3], 90, 65536));
        this.f.insert(0, (Item)new TextField("Username on server:", stringArray2[2], 15, 0));
        this.f.insert(0, (Item)new TextField("POP server:", stringArray2[5], 90, 4));
        this.f.insert(0, (Item)new TextField("SMTP server:", stringArray2[4], 90, 4));
        this.txtField = new TextField("Your email address:", stringArray2[0], 32, 1);
        this.f.insert(0, (Item)this.txtField);
        this.f.addCommand(backCommand);
        this.f.addCommand(endCommand);
        this.display.setCurrentItem((Item)this.txtField);
    }

    public void sender() {
        block29: {
            this.f.setTitle("Send");
            try {
                this.sc = (SocketConnection)Connector.open((String)("socket://" + this.srvr + ":25"));
            }
            catch (Exception exception) {
                this.message("Connection Fail", exception.toString());
                this.sc = null;
            }
            try {
                int n;
                this.sc.setSocketOption((byte)4, 32768);
                int n2 = this.sc.getSocketOption((byte)4);
                int n3 = this.sc.getSocketOption((byte)3);
                this.info("Send buffer: " + n2 + "\nReceive buffer: " + n3);
                this.is = this.sc.openInputStream();
                this.os = this.sc.openOutputStream();
                this.status("Connecting....");
                this.str = this.waitServer();
                this.str = this.from.replace('@', '.');
                this.send("EHLO " + EmailClient.lf2crlf(this.str));
                int n4 = 0;
                String string = "NONE";
                for (int i = 0; i < 10; ++i) {
                    this.str = this.waitServer();
                    n4 = this.str.indexOf("AUTH");
                    if (n4 > 0 && (n4 = (string = this.str.substring(n4 + 5, this.str.length())).indexOf("\n")) > 0) {
                        string = string.substring(0, n4);
                    }
                    if (this.str.charAt(3) == ' ') break;
                }
                if (string != "NONE") {
                    this.send("AUTH " + string);
                    this.str = this.waitServer();
                    if (this.debug > 0) {
                        this.si.setText("    " + this.str.substring(0, 4) + Base64.decode(this.str.substring(4, this.str.length())) + "\n" + this.si.getText());
                    }
                    if (this.str.indexOf("334") != -1) {
                        this.send(Base64.encode(this.user));
                    }
                    this.str = this.waitServer();
                    if (this.debug > 0) {
                        this.si.setText("    " + this.str.substring(0, 4) + Base64.decode(this.str.substring(4, this.str.length())) + "\n" + this.si.getText());
                    }
                    if (this.str.indexOf("334") != -1) {
                        this.send(Base64.encode(this.pwd));
                    }
                    this.str = this.waitServer();
                    if (this.str.indexOf("235") == -1) {
                        this.done = 4;
                        this.closeAll();
                        if (this.debug < 1) {
                            this.message("Login Error", "Can't authenticate user");
                        }
                    }
                }
                this.status("Connected");
                this.send("MAIL FROM: <" + this.from + ">");
                this.str = this.waitServer();
                this.send("RCPT TO: <" + this.to + ">");
                this.str = this.waitServer();
                this.send("DATA");
                this.str = this.waitServer();
                this.send("From: <" + this.from + ">");
                this.send("To: <" + this.to + ">");
                this.send("Subject: MicroCalc worksheet transfer");
                this.send("MIME-Version: 1.0");
                this.send("Content-Type: multipart/mixed;");
                this.send("     boundary=\"----=_NextPart_000_0035_01C74E11.51E32640\"");
                this.send("X-Priority: 1");
                this.send("X-MSMail-Priority: High");
                this.send("X-Mailer: Microsoft Outlook Express 6.00.2900.2180");
                this.send("X-MimeOLE: Produced By Microsoft MimeOLE V6.00.2900.2180");
                this.send("This is a multi-part message in MIME format.");
                try {
                    this.status("Sending sheet \"" + this.fname.substring(3, this.fname.length()) + "\"");
                    this.send("------=_NextPart_000_0035_01C74E11.51E32640");
                    this.send("Content-Type: application/octet-stream;");
                    this.send("    name=\"" + this.fname.substring(3, this.fname.length()) + ".slk\"");
                    this.send("Content-Transfer-Encoding: 7bit");
                    this.send("Content-Disposition: attachment;");
                    this.send("    filename=\"" + this.fname.substring(3, this.fname.length()) + ".slk\"");
                    this.send(EmailClient.lf2crlf("ID;PMMC;N;E"));
                    this.send(EmailClient.lf2crlf("B;Y" + this.sheet.rows + ";X" + this.sheet.columns));
                    int n5 = 0;
                    String string2 = "";
                    for (n = 0; n < this.sheet.rows; ++n) {
                        for (n5 = 0; n5 < this.sheet.columns; ++n5) {
                            string2 = this.sheet.getCell((int)n, (int)n5).str;
                            if (string2.length() <= 0) continue;
                            String string3 = "";
                            Result result = Result.RESULT_ERROR;
                            try {
                                result = Result.Evaluate(string2);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (string2.charAt(0) >= '-' && string2.charAt(0) <= '9' && this.isNum(string2)) {
                                this.send(EmailClient.lf2crlf("C;Y" + (n + 1) + ";X" + (n5 + 1) + ";K" + string2));
                                continue;
                            }
                            if (string2.charAt(0) == '=') {
                                string3 = ";E" + Sheet.getSylkFormula(result, n, n5);
                            }
                            if (string2.charAt(0) == '\'' && string2.length() > 1) {
                                string2 = string2.substring(1, string2.length());
                            }
                            this.send(EmailClient.lf2crlf("C;Y" + (n + 1) + ";X" + (n5 + 1) + ";K\"" + string2 + "\"" + string3));
                        }
                    }
                    this.send(EmailClient.lf2crlf("E"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.send("------=_NextPart_000_0035_01C74E11.51E32640--");
                this.send("\r\n.");
                this.str = this.waitServer();
                this.done = this.str.indexOf("250 ") != -1 ? 2 : 0;
                this.send("QUIT");
                this.str = this.waitServer();
                if (this.debug > 0) {
                    for (n = 0; n < 100000; ++n) {
                    }
                }
                this.closeAll();
            }
            catch (IOException iOException) {
                this.closeAll();
                if (this.debug >= 1) break block29;
                this.message("Connection error", iOException.toString());
            }
        }
        if (this.debug < 1) {
            if (this.done == 2) {
                this.status("Email Sent");
            } else if (this.done == 4) {
                this.message("Login Error", "Can't authenticate user");
            } else {
                this.message("Error Sending Email", "General Failure");
            }
        }
        this.sc = null;
        this.f.removeCommand(abortCommand);
        this.f.addCommand(exitCommand);
    }

    public void receiver() {
        block22: {
            this.f.setTitle("Receive");
            this.si.setText("Please be patient, this can take a few minutes....");
            try {
                this.sc = (SocketConnection)Connector.open((String)("socket://" + this.psrvr + ":110"));
            }
            catch (Exception exception) {
                this.message("Connection Fail", exception.toString());
                this.sc = null;
            }
            try {
                int n;
                this.sc.setSocketOption((byte)3, 1024);
                int n2 = this.sc.getSocketOption((byte)4);
                int n3 = this.sc.getSocketOption((byte)3);
                this.info("Send buffer: " + n2 + "\nReceive buffer: " + n3);
                this.is = this.sc.openInputStream();
                this.os = this.sc.openOutputStream();
                this.fc = 0;
                this.status("Connecting....");
                this.str = this.waitServer();
                this.send("USER " + this.user);
                this.str = this.waitServer();
                this.send("PASS " + this.pwd);
                this.str = this.waitServer();
                if (this.str.indexOf("+OK") == -1) {
                    this.closeAll();
                    this.done = 4;
                    if (this.debug > 0) {
                        for (n = 0; n < 100000; ++n) {
                        }
                    }
                    if (this.debug < 1) {
                        this.message("Login Error", "Can't authenticate user");
                    }
                }
                this.status("Connected");
                this.send("STAT");
                this.str = this.waitServer();
                n = this.str.indexOf("+OK ");
                this.str = this.str.substring(n + 4, this.str.length());
                n = this.str.indexOf(" ");
                if (n > 0) {
                    this.str = this.str.substring(0, n);
                }
                try {
                    n = Integer.parseInt(this.str);
                }
                catch (NumberFormatException numberFormatException) {
                    n = 0;
                }
                this.pushdebug = this.debug;
                this.debug = 0;
                if (n > 0) {
                    int n4 = 0;
                    for (int i = 1; i <= n; ++i) {
                        if (this.pushdebug < 1) {
                            this.si.setText(this.si.getText() + "\nSearching email " + i + " of " + n + "....");
                        }
                        this.send("RETR " + i);
                        while (!(this.str = this.waitServer()).equals(".\r")) {
                            if (!this.str.startsWith("Subject:") || (n4 = this.str.indexOf("MicroCalc")) <= 0) continue;
                            this.str = this.readData();
                            if (!this.str.equals(".\r")) continue;
                        }
                    }
                }
                this.debug = this.pushdebug;
                this.send("QUIT");
                this.str = this.waitServer();
                this.done = this.str.indexOf("+OK ") != -1 ? 2 : 0;
                if (this.debug > 0) {
                    for (int i = 0; i < 100000; ++i) {
                    }
                }
                this.closeAll();
            }
            catch (IOException iOException) {
                this.closeAll();
                if (this.debug >= 1) break block22;
                this.message("Connection error", iOException.toString());
            }
        }
        if (this.debug < 1) {
            if (this.done == 2) {
                this.status("Connection Closed");
            } else if (this.done == 4) {
                this.message("Login Error", "Can't authenticate user");
            } else {
                this.message("Error Getting Sheet", "General Failure");
            }
        }
        this.sc = null;
        this.f.removeCommand(abortCommand);
        this.f.addCommand(exitCommand);
    }

    public void online() {
        String[] stringArray = new String[]{"FROM:", "SRVR:", "POP3:", "USER:", "PSWD:", "RCPT:"};
        for (int i = 0; i < 6; ++i) {
            stringArray[i] = stringArray[i] + ((TextField)this.f.get(i)).getString().trim();
        }
        this.to = ((TextField)this.f.get(5)).getString();
        this.from = ((TextField)this.f.get(0)).getString();
        this.user = ((TextField)this.f.get(3)).getString();
        this.pwd = ((TextField)this.f.get(4)).getString();
        this.srvr = ((TextField)this.f.get(1)).getString();
        this.psrvr = ((TextField)this.f.get(2)).getString();
        EmailClient.writeData("mc_email", stringArray);
        this.debug = 0;
        this.debug = this.to.toLowerCase().indexOf(".debug");
        if (this.debug > 0) {
            this.to = this.to.substring(0, this.debug);
        }
        this.f.deleteAll();
        this.f.removeCommand(endCommand);
        this.f.removeCommand(backCommand);
        this.f.append((Item)this.si);
        this.f.addCommand(abortCommand);
        if (this.type == 3) {
            new Thread(){

                public void run() {
                    try {
                        EmailClient.this.receiver();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }.start();
        }
        if (this.type == 1 || this.type == 2) {
            new Thread(){

                public void run() {
                    try {
                        EmailClient.this.sender();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }.start();
        }
    }

    public static synchronized String[] readData(String string, String[] stringArray) {
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        if (n < 1) {
            return stringArray2;
        }
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = "";
        }
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true, (int)1, (boolean)false);
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
            int n2 = recordEnumeration.numRecords();
            for (int i = 1; i <= n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    String string2 = new String(recordStore.getRecord(i));
                    if (!string2.substring(2, 7).equals(stringArray[j])) continue;
                    stringArray2[j] = string2.substring(7, string2.length()).trim();
                }
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object var4_6 = null;
        return stringArray2;
    }

    public static synchronized void writeData(String string, String[] stringArray) {
        RecordStore recordStore;
        int n = stringArray.length;
        if (n < 1) {
            return;
        }
        try {
            recordStore = RecordStore.openRecordStore((String)string, (boolean)true, (int)1, (boolean)true);
            recordStore.closeRecordStore();
            RecordStore.deleteRecordStore((String)string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            recordStore = RecordStore.openRecordStore((String)string, (boolean)true, (int)1, (boolean)false);
            for (int i = 0; i < n; ++i) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                try {
                    dataOutputStream.writeUTF(stringArray[i]);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                byte[] byArray = byteArrayOutputStream.toByteArray();
                try {
                    recordStore.addRecord(byArray, 0, byArray.length);
                    continue;
                }
                catch (RecordStoreException recordStoreException) {
                    // empty catch block
                }
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        recordStore = null;
    }

    public void closeAll() {
        try {
            this.is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.os.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.sc.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.sc = null;
        this.is = null;
        this.os = null;
    }

    public void message(String string, String string2) {
        String string3 = string;
        if (this.debug > 0 && string2.length() > 0) {
            string3 = string3 + "\n\n(" + string2 + ")";
        }
        Alert alert = new Alert("Error", string3, null, AlertType.ERROR);
        alert.setTimeout(3000);
        this.display.setCurrent(alert, (Displayable)this.f);
        if (this.debug > 0) {
            this.si.setText("An error has occurred\n(" + string2 + ")\n" + this.si.getText());
        } else {
            this.si.setText(this.si.getText() + "\nAn error has occurred");
        }
        this.f.removeCommand(abortCommand);
        this.f.addCommand(exitCommand);
    }

    public void aborted() {
        this.message("Aborted by user", "User Interrupted Thread");
        this.closeAll();
    }

    public boolean isNum(String string) {
        long l = 0L;
        try {
            l = Result.createLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return l != 0L;
    }

    public void commandAction(Command command, Displayable displayable) {
    }
}

