/*
 * Decompiled with CFR 0.152.
 */
package com.wapindustrial.calc;

import com.wapindustrial.calc.MicroCalcCanvas;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class LCDFont {
    public final int fontWidth;
    public final int fontHeight;
    private final int imageWidth;
    private final int imageHeight;
    private int[] bwBuf;
    private int[] colorBuf;
    private int[] currentBuf;
    private long currentColor;
    private long[] cacheColor;
    private int FR;
    private int FG;
    private int FB;
    private int BR;
    private int BG;
    private int BB;

    public LCDFont(String string) {
        Image image;
        try {
            image = Image.createImage((String)string);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Cannot load LCDFont: " + iOException);
        }
        this.imageWidth = image.getWidth();
        this.imageHeight = image.getHeight();
        this.fontWidth = this.imageWidth / 32;
        this.fontHeight = this.imageHeight / 3;
        this.bwBuf = new int[this.imageWidth * (this.imageHeight + 1)];
        this.colorBuf = new int[this.imageWidth * (this.imageHeight + 1)];
        image.getRGB(this.bwBuf, 0, this.imageWidth, 0, 0, this.imageWidth, this.imageHeight);
        this.cacheColor = new long[96];
        this.currentBuf = this.bwBuf;
        this.currentColor = 0L;
    }

    public void setColor(Graphics graphics, int n, int n2) {
        if (MicroCalcCanvas.FONT_SIZE == 0) {
            graphics.setColor(n);
            return;
        }
        if (n == 0xFFFFFF && n2 == 0) {
            this.currentBuf = this.bwBuf;
        } else if (((long)n << 32) + (long)n2 != this.currentColor) {
            this.currentColor = ((long)n << 32) + (long)n2;
            this.currentBuf = this.colorBuf;
            this.FR = n >> 16 & 0xFF;
            this.FG = n >> 8 & 0xFF;
            this.FB = n & 0xFF;
            this.BR = n2 >> 16 & 0xFF;
            this.BG = n2 >> 8 & 0xFF;
            this.BB = n2 & 0xFF;
        }
    }

    private void renderColorChar(int n) {
        for (int i = 0; i < this.fontHeight; ++i) {
            for (int j = 0; j < this.fontWidth; ++j) {
                int n2 = this.bwBuf[n + i * this.imageWidth + j];
                int n3 = n2 >> 16 & 0xFF;
                int n4 = n2 >> 8 & 0xFF;
                int n5 = n2 & 0xFF;
                n3 = this.FR * n3 + this.BR * (255 - n3) >> 8;
                n4 = this.FG * n4 + this.BG * (255 - n4) >> 8;
                n5 = this.FB * n5 + this.BB * (255 - n5) >> 8;
                this.colorBuf[n + i * this.imageWidth + j] = (n3 << 16) + (n4 << 8) + n5;
            }
        }
    }

    public void drawChar(Graphics graphics, char c, int n, int n2) {
        if (c == '\u00a3') {
            c = (char)127;
        }
        if (c <= ' ' || c > '\u007f') {
            return;
        }
        c = (char)(c - 32);
        int n3 = (c >> 5) * this.fontHeight * this.imageWidth + (c & 0x1F) * this.fontWidth;
        if (this.currentBuf == this.colorBuf && this.cacheColor[c] != this.currentColor) {
            this.renderColorChar(n3);
            this.cacheColor[c] = this.currentColor;
        }
        graphics.drawRGB(this.currentBuf, n3, this.imageWidth, n, n2, this.fontWidth, this.fontHeight, false);
    }

    public void drawText(Graphics graphics, String string, int n, int n2) {
        if (MicroCalcCanvas.FONT_SIZE > 0) {
            int n3 = 0;
            for (int i = 0; i < string.length(); ++i) {
                n3 = i * this.fontWidth;
                this.drawChar(graphics, string.charAt(i), n + n3, n2);
            }
        } else {
            graphics.drawString(string, n, n2, 20);
        }
    }
}

