/*
 * Decompiled with CFR 0.152.
 */
package com.wapindustrial.calc;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

public final class Menu
implements CommandListener {
    static final short MASK_CONFIRM = 256;
    static final short MASK_PROMPT = 512;
    static final short MASK_SELECTED = 1024;
    String[] labels;
    short[] codes;
    byte[] parents;
    int current;
    int nselected;
    int ms0 = -1;
    int ms1 = -1;
    int ms = -1;
    List list;
    public static Command cmdItem;
    private static final Command cmdOK;
    private static final Command cmdBack;
    private static final Command cmdCancel;
    private CommandListener cmdHandler;
    private MIDlet midlet;
    private Displayable oldScreen;
    private Display display;

    public Menu(String[] stringArray, short[] sArray, byte[] byArray) {
        this.labels = stringArray;
        this.codes = sArray;
        this.parents = byArray;
    }

    public void start(MIDlet mIDlet, CommandListener commandListener, int n, Displayable displayable) {
        this.midlet = mIDlet;
        this.cmdHandler = commandListener;
        this.display = Display.getDisplay((MIDlet)this.midlet);
        this.oldScreen = displayable;
        if (this.oldScreen == null) {
            this.oldScreen = this.display.getCurrent();
        }
        this.loadMenu(n);
    }

    public void start(MIDlet mIDlet, CommandListener commandListener) {
        this.start(mIDlet, commandListener, 0, null);
    }

    private int menuItems(int n) {
        int n2 = 0;
        for (int i = 0; i < this.labels.length; ++i) {
            if (this.parents[i] != n) continue;
            ++n2;
        }
        return n2;
    }

    private int nextItem(int n, int n2) {
        ++n2;
        while (n2 < this.labels.length) {
            if (this.parents[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private int itemIndex(int n, int n2) {
        for (int i = 0; i < this.labels.length; ++i) {
            if (this.parents[i] == n) {
                --n2;
            }
            if (n2 >= 0) continue;
            return i;
        }
        return -1;
    }

    private String getPath(int n) {
        if (n == 0) {
            return "";
        }
        if (this.parents[n] == 0) {
            return this.labels[n];
        }
        return this.getPath(this.parents[n]) + "/" + this.labels[n];
    }

    private void loadMenu(int n) {
        int n2;
        int n3 = this.menuItems(n);
        String string = n == 0 ? this.labels[n] : this.getPath(n);
        this.list = new List(string, 3);
        if (string.equals("Start menu")) {
            this.list.addCommand(cmdCancel);
        } else {
            this.list.addCommand(cmdBack);
        }
        int n4 = n;
        this.ms = n;
        this.nselected = 0;
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            n4 = this.nextItem(n, n4);
            this.list.append(this.labels[n4], null);
            if ((this.codes[n4] & 0x400) == 0) continue;
            this.nselected = n4;
            n5 = n2;
        }
        if (this.oldScreen.getWidth() < 160) {
            for (n2 = 0; n2 < this.list.size(); ++n2) {
                this.list.setFont(n2, Font.getFont((int)0, (int)0, (int)8));
            }
        }
        if (this.ms == 0 && this.ms0 >= 0) {
            n5 = this.ms0;
        }
        this.list.setSelectedIndex(n5, true);
        this.current = n;
        this.list.addCommand(cmdOK);
        this.list.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.list);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this.list) {
            if (this.ms == 0) {
                this.ms0 = this.list.getSelectedIndex();
            }
            if (command == List.SELECT_COMMAND || command == cmdOK) {
                int n = this.list.getSelectedIndex();
                if (n < 0) {
                    return;
                }
                int n2 = this.current = this.itemIndex(this.current, n);
                this.codes[n2] = (short)(this.codes[n2] | 0x400);
                if ((this.codes[this.current] & 0xFFFFFBFF) == 0) {
                    this.loadMenu(this.current);
                    return;
                }
                this.executeCommand(this.current);
                this.current = this.parents[this.current];
            } else if (command == cmdCancel) {
                this.restoreScreen();
            } else if (command == cmdBack) {
                if (this.current == 0) {
                    this.restoreScreen();
                } else {
                    this.loadMenu(this.parents[this.current]);
                }
            }
            return;
        }
    }

    private void restoreScreen() {
        if (this.oldScreen != null) {
            this.display.setCurrent(this.oldScreen);
        }
    }

    private void executeCommand(int n) {
        cmdItem = new Command("", 1, this.codes[n] & 0xFFFFF8FF);
        this.cmdHandler.commandAction(cmdItem, (Displayable)this.list);
        if ((this.codes[n] & 0x200) == 0) {
            this.restoreScreen();
        }
    }

    static {
        cmdOK = new Command("OK", 4, 1);
        cmdBack = new Command("Back", 2, 2);
        cmdCancel = new Command("Cancel", 2, 2);
    }
}

