/*
 * Decompiled with CFR 0.152.
 */
package com.wapindustrial.calc;

import com.wapindustrial.calc.BadFormulaException;
import com.wapindustrial.calc.EmailClient;
import com.wapindustrial.calc.LCDFont;
import com.wapindustrial.calc.Menu;
import com.wapindustrial.calc.MicroCalc;
import com.wapindustrial.calc.Result;
import com.wapindustrial.calc.Sheet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;

public final class MicroCalcCanvas
extends Canvas
implements CommandListener {
    public static final String BDATE = "v1.1  21/12/07";
    static final byte CELL_EDIT = 1;
    static final byte CELL_CLEAR = 2;
    static final byte CELL_COPY = 3;
    static final byte CELL_PASTE = 4;
    static final byte CELL_SERIES = 10;
    static final byte CELL_FPASTE = 11;
    static final byte COLUMN_WIDTH = 5;
    static final byte SHEET_NEW = 6;
    static final byte SHEET_SAVE = 7;
    static final byte SHEET_LOAD = 8;
    static final byte SHEET_DELETE = 9;
    static final byte SHEET_SEND = 90;
    static final byte SHEET_RECEIVE = 91;
    static final byte ABOUT = 13;
    static final byte SHEET_NEW1 = 19;
    static final byte COLUMN_INSERT = 20;
    static final byte COLUMN_DELETE = 22;
    static final byte ROW_INSERT = 24;
    static final byte ROW_DELETE = 26;
    static final byte SHEET_RESIZE = 28;
    static final byte FORMAT_NUMBER = 30;
    static final byte FORMAT_ALIGN = 32;
    static final byte FORMAT_CLEAR = 33;
    static final byte FORMAT_DATE = 34;
    static final byte FORMAT_DECS = 35;
    static final byte FORMAT_LABELS = 36;
    static final byte FORMAT_STATUS = 37;
    static final byte FORMAT_CELLS = 38;
    static final byte FORMAT_SEL = 39;
    static final byte FORMAT_FONT = 40;
    static final byte CONFIRM_OK = 50;
    static final byte CONFIRM_CANCEL = 51;
    static final byte COMMAND_EXIT = 52;
    static final byte EXIT = 100;
    private static final String[] confirmMenuLabels = new String[]{"Sheet has changed!", "Discard changes", "Cancel"};
    private static final short[] confirmMenuCodes = new short[]{0, 50, 51};
    private static final byte[] confirmMenuParents = new byte[]{-1, 0, 0};
    private byte confirmCode;
    private static final String[] defaultLabels = new String[]{"Main menu", "Cell...", "Column...", "Row...", "Sheet...", "Help", "Exit", "Edit cell", "Clear range", "Copy range", "Paste range", "Series fill", "Paste format", "Format...", "Width", "Insert", "Delete", "Insert", "Delete", "New", "Save", "Load", "Delete", "Send", "Receive", "Resize", "Preferences...", "Alignment", "Number", "Clear format", "Date format", "Decimal places", "Labels colour", "Status Line colour", "Cell text colour", "Highlight colour", "Font size"};
    private static final byte[] defaultParents = new byte[]{-1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 13, 13, 13, 26, 26, 26, 26, 26, 26, 26};
    private static final short[] defaultCodes = new short[]{0, 0, 0, 0, 0, 525, 612, 513, 514, 515, 516, 522, 523, 0, 517, 532, 534, 536, 538, 518, 519, 520, 521, 602, 603, 540, 0, 544, 542, 33, 546, 547, 548, 549, 550, 551, 552};
    public static final Menu defaultMenu = new Menu(defaultLabels, defaultCodes, defaultParents);
    private static final Menu confirmMenu = new Menu(confirmMenuLabels, confirmMenuCodes, confirmMenuParents);
    public static final byte CURSOR_UP = 0;
    public static final byte CURSOR_DOWN = 1;
    public static final byte CURSOR_LEFT = 2;
    public static final byte CURSOR_RIGHT = 4;
    public static final byte CURSOR_NONE = 5;
    private static final String DEFAULT_WIDTH = "######";
    private static final String DEFAULT_HEADER = "##";
    private static final String SINGLE_LINES = "'__________";
    private static final String DOUBLE_LINES = "'==========";
    private static final int WHITE = 0xFFFFFF;
    private static final int BLACK = 0;
    private static final int RED = 0xF00000;
    private static final int GREEN = 57344;
    private static final int BLUE = 224;
    private static final int YELLOW = 0xF0F000;
    private static final int BROWN = 0xB08800;
    private static final int GREY = 0x909090;
    public static int LABELS = 0;
    public static int STATUS = 0;
    public static int CELLS = 0;
    public static int SELECTED = 0;
    private static final Command cmdMenu = new Command("Menu", 4, 1);
    private static final Command cancelEditCommand = new Command("Cancel", 2, 2);
    private static final Command okEditCommand = new Command("OK", 4, 1);
    private static final Command cmdDelete = new Command("Delete", 1, 3);
    private static Command cmdOK = new Command("OK", 4, 2);
    private int sizeX;
    private int sizeY;
    private int windowX1;
    private int windowY1;
    private int windowX2;
    private int windowY2;
    public static int cursorI;
    public static int cursorJ;
    int dirI;
    int dirJ;
    public static int clipboardI;
    public static int clipboardJ;
    public static int clipboardI2;
    public static int clipboardJ2;
    Font font;
    static int fontHeight;
    static int fontWidth;
    static int defaultColumnWidth;
    static int headerWidth;
    Display display;
    Displayable prevdisp;
    MicroCalc parent;
    private Form frmNewSheet;
    private Form frmResize;
    private Form frmSeries;
    private Form frmFormatNumber;
    private Form frmFormatAlign;
    private Form frmInsertColumn;
    private Form frmInsertRow;
    private Form frmDeleteColumn;
    private Form frmDeleteRow;
    private Form directions;
    private Form frmFormatDate;
    private Form frmFormatDecs;
    private Form frmColors;
    private Form frmFonts;
    private TextBox edit;
    private TextBox copy;
    private TextBox paste;
    private TextBox clear;
    private TextBox fpaste;
    public TextBox editName;
    private Form editColumnWidth;
    private TextBox editRowHeight;
    public List selectList;
    private ChoiceGroup colorList;
    public Sheet sheet;
    public String statusLine;
    private byte statusLinePart;
    private boolean statusGold;
    private boolean statusNumeric;
    private String numericLine;
    public static boolean statusInfo;
    private boolean wizMode = false;
    private int wiz2;
    private int wiz3;
    private int wiz4;
    private int wiz5;
    private int wiz6;
    private int wiz7;
    private int wiz8;
    private String[] wizFuncs = new String[]{"ABS", "COUNT", "AND", "COS", "ASIN", "ACOS", "ATAN", "ATAN2", "COT", "CELL", "E", "EXP", "FRAC", "EXACT", "IF", "IPMT", "INFO", "LN", "LOWER", "MID", "NOT", "NPER", "OR", "SUM", "SQRT", "PI", "ROUND", "POW", "SIN", "PMT", "PPMT", "RATE", "TAN", "TRUNC", "TEXT", "VALUE", "TRIM", "UPPER", "TYPE"};
    public EmailClient client = null;
    public Form eform;
    RecordStore recst = null;
    public LCDFont lcdFont = null;
    public static int FONT_SIZE;

    public MicroCalcCanvas(MicroCalc microCalc) {
        this.parent = microCalc;
        this.display = Display.getDisplay((MIDlet)this.parent);
        String[] stringArray = new String[]{"LBLS:", "STLN:", "CELL:", "SLTD:", "FONT:"};
        String[] stringArray2 = new String[4];
        stringArray2 = EmailClient.readData("mc_prefs", stringArray);
        try {
            LABELS = Integer.parseInt(stringArray2[0]);
            STATUS = Integer.parseInt(stringArray2[1]);
            CELLS = Integer.parseInt(stringArray2[2]);
            SELECTED = Integer.parseInt(stringArray2[3]);
            FONT_SIZE = Integer.parseInt(stringArray2[4]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.font = Font.getFont((int)64, (int)0, (int)8);
        this.sizeX = this.getWidth();
        this.sizeY = this.getHeight();
        this.lcdFont = new LCDFont("/font5x9lcd.png");
        if (FONT_SIZE == 0) {
            fontHeight = this.font.getHeight();
            defaultColumnWidth = this.font.stringWidth(DEFAULT_WIDTH);
            headerWidth = this.font.stringWidth(DEFAULT_HEADER);
        } else {
            this.lcdFont = FONT_SIZE == 1 ? new LCDFont("/font6x9lcd.png") : new LCDFont("/font5x9lcd.png");
            fontHeight = this.lcdFont.fontHeight;
            fontWidth = this.lcdFont.fontWidth;
            defaultColumnWidth = fontWidth * DEFAULT_WIDTH.length();
            headerWidth = fontWidth * DEFAULT_HEADER.length();
        }
        this.sheet = new Sheet(Sheet.newRows, Sheet.newColumns, defaultColumnWidth + 3, fontHeight + 3);
        this.setWindow(0, 0, 1, 4);
        this.addCommand(cmdMenu);
        this.setCommandListener(this);
    }

    public void startup() {
        this.importSheets();
        this.selectSheet();
        if (this.selectList.size() < 1) {
            this.setCurrent();
        }
    }

    public void setWindow(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = this.sizeX - headerWidth;
        int n7 = this.sizeY - fontHeight;
        cursorI = n;
        cursorJ = n2;
        this.dirI = n3;
        this.dirJ = n4;
        if (this.dirI == 1) {
            this.windowY1 = this.sheet.cellY(cursorI);
            this.windowY2 = this.windowY1 + n7;
        } else if (this.dirI == 0) {
            this.windowY2 = this.sheet.cellY(cursorI + 1);
            this.windowY1 = this.windowY2 - n7;
        }
        if (this.dirJ == 4) {
            this.windowX1 = this.sheet.cellX(cursorJ);
            this.windowX2 = this.windowX1 + n6;
        } else if (this.dirJ == 2) {
            this.windowX2 = this.sheet.cellX(cursorJ + 1);
            this.windowX1 = this.windowX2 - n6;
        }
        if (this.windowX1 < 0) {
            this.windowX1 = 0;
            this.windowX2 = n6;
        }
        if (this.windowY1 < 0) {
            this.windowY1 = 0;
            this.windowY2 = n7;
        }
        if (this.windowX2 > (n5 = this.sheet.cellX(this.sheet.columns)) && n5 > n6) {
            this.windowX2 = n5;
            this.windowX1 = this.windowX2 - n6;
        }
        if (this.windowY2 > (n5 = this.sheet.cellY(this.sheet.rows)) && n5 > n7) {
            this.windowY2 = n5;
            this.windowY1 = this.windowY2 - n7;
        }
        if (statusInfo) {
            this.statusLine = this.getStatusInfo(cursorI, cursorJ);
        }
    }

    private void repaintCell(int n, int n2) {
        this.repaint(headerWidth + this.sheet.cellX(n2) - this.windowX1 + 1, fontHeight + this.sheet.cellY(n) - this.windowY1 + 1, this.sheet.columnWidth[n2], this.sheet.rowHeight[n]);
    }

    private boolean setCursor(int n, int n2) {
        int n3 = 5;
        int n4 = 5;
        int n5 = cursorI;
        int n6 = cursorJ;
        boolean bl = false;
        if (n < 0 || n >= this.sheet.rows || n2 < 0 || n2 >= this.sheet.columns) {
            return false;
        }
        if (this.sheet.cellY(n) < this.windowY1) {
            bl = true;
            n3 = 0;
        } else if (this.sheet.cellY(n + 1) >= this.windowY2) {
            bl = true;
            n3 = 1;
        }
        if (this.sheet.cellX(n2) < this.windowX1) {
            bl = true;
            n4 = 2;
        } else if (this.sheet.cellX(n2 + 1) >= this.windowX2) {
            bl = true;
            n4 = 4;
        }
        if (bl) {
            this.setWindow(n, n2, n3, n4);
            this.repaint();
        } else if (n5 != n || n6 != n2) {
            this.repaintCell(n5, n6);
            cursorI = n;
            cursorJ = n2;
            this.repaintCell(cursorI, cursorJ);
        }
        return bl;
    }

    protected void keyPressed(int n) {
        int n2 = 0;
        boolean bl = false;
        if (this.wizMode) {
            switch (n) {
                case 48: 
                case 49: 
                case 57: {
                    return;
                }
                case 50: {
                    ++this.wiz2;
                    this.wiz3 = 0;
                    this.wiz4 = 0;
                    this.wiz5 = 0;
                    this.wiz6 = 0;
                    this.wiz7 = 0;
                    this.wiz8 = 0;
                    if (this.wiz2 > 10) {
                        this.wiz2 = 1;
                    }
                    this.setStatusLine("Function? " + this.wizFuncs[this.wiz2 - 1]);
                    return;
                }
                case 51: {
                    ++this.wiz3;
                    this.wiz2 = 0;
                    this.wiz4 = 0;
                    this.wiz5 = 0;
                    this.wiz6 = 0;
                    this.wiz7 = 0;
                    this.wiz8 = 0;
                    if (this.wiz3 > 4) {
                        this.wiz3 = 1;
                    }
                    this.setStatusLine("Function? " + this.wizFuncs[this.wiz3 + 9]);
                    return;
                }
                case 52: {
                    ++this.wiz4;
                    this.wiz2 = 0;
                    this.wiz3 = 0;
                    this.wiz5 = 0;
                    this.wiz6 = 0;
                    this.wiz7 = 0;
                    this.wiz8 = 0;
                    if (this.wiz4 > 3) {
                        this.wiz4 = 1;
                    }
                    this.setStatusLine("Function? " + this.wizFuncs[this.wiz4 + 13]);
                    return;
                }
                case 53: {
                    ++this.wiz5;
                    this.wiz2 = 0;
                    this.wiz3 = 0;
                    this.wiz4 = 0;
                    this.wiz6 = 0;
                    this.wiz7 = 0;
                    this.wiz8 = 0;
                    if (this.wiz5 > 2) {
                        this.wiz5 = 1;
                    }
                    this.setStatusLine("Function? " + this.wizFuncs[this.wiz5 + 16]);
                    return;
                }
                case 54: {
                    ++this.wiz6;
                    this.wiz2 = 0;
                    this.wiz3 = 0;
                    this.wiz4 = 0;
                    this.wiz5 = 0;
                    this.wiz7 = 0;
                    this.wiz8 = 0;
                    if (this.wiz6 > 4) {
                        this.wiz6 = 1;
                    }
                    this.setStatusLine("Function? " + this.wizFuncs[this.wiz6 + 18]);
                    return;
                }
                case 55: {
                    ++this.wiz7;
                    this.wiz2 = 0;
                    this.wiz3 = 0;
                    this.wiz4 = 0;
                    this.wiz5 = 0;
                    this.wiz6 = 0;
                    this.wiz8 = 0;
                    if (this.wiz7 > 9) {
                        this.wiz7 = 1;
                    }
                    this.setStatusLine("Function? " + this.wizFuncs[this.wiz7 + 22]);
                    return;
                }
                case 56: {
                    ++this.wiz8;
                    this.wiz2 = 0;
                    this.wiz3 = 0;
                    this.wiz4 = 0;
                    this.wiz5 = 0;
                    this.wiz6 = 0;
                    this.wiz7 = 0;
                    if (this.wiz8 > 7) {
                        this.wiz8 = 1;
                    }
                    this.setStatusLine("Function? " + this.wizFuncs[this.wiz8 + 31]);
                    return;
                }
                case -5: {
                    if (this.wiz2 == 0 && this.wiz3 == 0 && this.wiz4 == 0 && this.wiz5 == 0 && this.wiz6 == 0 && this.wiz7 == 0 && this.wiz8 == 0) {
                        this.statusGold = true;
                        break;
                    }
                    String string = Result.cellAddress(cursorI, cursorJ, 0);
                    String string2 = this.statusLine.substring(10, this.statusLine.length()).trim();
                    string2 = this.wiz2 == 8 || this.wiz3 == 4 || this.wiz7 == 5 ? string2 + "(" + string + "," + string + ")" : (this.wiz2 == 2 || this.wiz7 == 1 ? string2 + "(" + string + ":" + string + ")" : (this.wiz3 == 1 || this.wiz7 == 3 ? string2 + "()" : (this.wiz4 == 3 ? string2 + "(\"HELP\")" : (this.wiz6 == 1 || this.wiz6 == 3 || this.wiz7 == 7 || this.wiz7 == 9 ? string2 + "(" + string + "," + string + "," + string + ")" : (this.wiz4 == 2 || this.wiz7 == 8 ? string2 + "(" + string + "," + string + "," + string + "," + string + ")" : (this.wiz6 == 2 ? string2 + "(" + string + "<=>" + string + ")" : (this.wiz2 == 3 || this.wiz6 == 4 ? string2 + "(" + string + "<=>" + string + "," + string + "<=>" + string + ")" : (this.wiz4 == 1 ? string2 + "(" + string + "<=>" + string + ",\"" + string + "\",\"" + string + "\")" : string2 + "(" + string + ")"))))))));
                    this.wizMode = false;
                    this.wiz2 = 0;
                    this.wiz3 = 0;
                    this.wiz4 = 0;
                    this.wiz5 = 0;
                    this.wiz6 = 0;
                    this.wiz7 = 0;
                    this.wiz8 = 0;
                    this.editCell2(cursorI, cursorJ, "=" + string2);
                    String string3 = null;
                    if (statusInfo) {
                        string3 = this.getStatusInfo(cursorI, cursorJ);
                    }
                    this.setStatusLine(string3);
                    return;
                }
            }
        }
        this.wizMode = false;
        if (this.statusNumeric) {
            switch (n) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.numericLine = this.numericLine + (char)(48 + (n - 48));
                    break;
                }
                case -8: {
                    if (this.numericLine.length() <= 0) break;
                    this.numericLine = this.numericLine.substring(0, this.numericLine.length() - 1);
                    break;
                }
                case 42: {
                    if (this.numericLine.indexOf(46) >= 0) {
                        this.numericLine = this.numericLine.charAt(0) == '-' ? "" : "-";
                        break;
                    }
                    this.numericLine = this.numericLine + '.';
                    break;
                }
                case 35: {
                    this.setStatusLine(null);
                    if (this.numericLine.length() != 0) {
                        try {
                            this.sheet.setFormula(cursorI, cursorJ, this.numericLine);
                            this.sheet.calculateDepended(cursorI, cursorJ, true);
                            this.fitCell(cursorI, cursorJ);
                            this.sheet.changed = true;
                            this.repaint();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.statusNumeric = false;
                    this.numericLine = null;
                    return;
                }
            }
            this.setStatusLine("NUM: " + this.numericLine);
            return;
        }
        if (this.statusGold) {
            this.statusGold = false;
            switch (n) {
                case 48: {
                    this.wizMode = true;
                    this.setStatusLine("Function? ");
                    return;
                }
                case 49: {
                    clipboardI = cursorI;
                    clipboardJ = cursorJ;
                    clipboardI2 = cursorI;
                    clipboardJ2 = cursorJ;
                    bl = true;
                    break;
                }
                case 50: {
                    if (clipboardI < 0 || clipboardJ < 0) break;
                    this.removeCommand(cmdMenu);
                    cmdOK = new Command(Result.cellAddress(clipboardI, clipboardJ, 0), 4, 2);
                    this.addCommand(cmdOK);
                    this.sheet.copyCell1(clipboardI, clipboardJ, cursorI - clipboardI, cursorJ - clipboardJ);
                    this.removeCommand(cmdOK);
                    this.addCommand(cmdMenu);
                    this.sheet.changed = true;
                    bl = true;
                    break;
                }
                case 51: {
                    long l;
                    if (clipboardI < 0 || clipboardJ < 0) break;
                    this.sheet.getCell((int)MicroCalcCanvas.cursorI, (int)MicroCalcCanvas.cursorJ).ll = l = this.sheet.getCell((int)MicroCalcCanvas.clipboardI, (int)MicroCalcCanvas.clipboardJ).ll;
                    this.sheet.changed = true;
                    bl = true;
                    break;
                }
                case 52: {
                    this.removeCommand(cmdMenu);
                    try {
                        this.sheet.fullCalc((Displayable)this);
                    }
                    catch (Exception exception) {
                        this.warning("Error: " + exception.getMessage());
                    }
                    this.addCommand(cmdMenu);
                    bl = true;
                    break;
                }
                case 54: {
                    this.removeCommand(cmdMenu);
                    cmdOK = new Command("Saving", 4, 2);
                    this.addCommand(cmdOK);
                    try {
                        MicroCalcCanvas.saveSheet(this.sheet);
                    }
                    catch (Exception exception) {
                        this.warning("Cannot save the sheet");
                    }
                    this.removeCommand(cmdOK);
                    this.addCommand(cmdMenu);
                    bl = true;
                    break;
                }
                case 55: {
                    n2 = this.sheet.columnWidth[cursorJ] / this.font.charWidth('_');
                    if (n2 < 2) {
                        n2 = 2;
                    }
                    if (n2 > 11) {
                        n2 = 11;
                    }
                    this.sheet.setFormula1(cursorI, cursorJ, SINGLE_LINES.substring(0, n2));
                    if (statusInfo) {
                        this.statusLine = this.getStatusInfo(cursorI, cursorJ);
                    }
                    this.fitCell(cursorI, cursorJ);
                    this.sheet.changed = true;
                    bl = true;
                    break;
                }
                case 56: {
                    n2 = this.sheet.columnWidth[cursorJ] / this.font.charWidth('=');
                    if (n2 < 2) {
                        n2 = 2;
                    }
                    if (n2 > 11) {
                        n2 = 11;
                    }
                    this.sheet.setFormula1(cursorI, cursorJ, DOUBLE_LINES.substring(0, n2));
                    if (statusInfo) {
                        this.statusLine = this.getStatusInfo(cursorI, cursorJ);
                    }
                    this.fitCell(cursorI, cursorJ);
                    this.sheet.changed = true;
                    bl = true;
                    break;
                }
                case -8: {
                    this.sheet.clear(cursorI, cursorJ);
                    this.sheet.calculateDepended(cursorI, cursorJ, true);
                    this.sheet.changed = true;
                    bl = true;
                }
            }
            String string = null;
            if (statusInfo) {
                string = this.getStatusInfo(cursorI, cursorJ);
            } else if (this.statusNumeric) {
                string = "NUM: ";
            }
            this.setStatusLine(string);
            if (bl) {
                this.repaint();
            }
            return;
        }
        if (n == 42) {
            this.statusGold = true;
            this.setStatusLine("Shortcut? ");
            return;
        }
        this.statusNumeric = false;
        this.statusGold = false;
        this.statusLine = null;
        int n3 = this.getGameAction(n);
        int n4 = cursorI;
        int n5 = cursorJ;
        switch (n3) {
            case 6: {
                ++n4;
                break;
            }
            case 1: {
                --n4;
                break;
            }
            case 5: {
                ++n5;
                break;
            }
            case 2: {
                --n5;
                break;
            }
            case 8: {
                this.editCell(cursorI, cursorJ);
                return;
            }
        }
        switch (n) {
            case -8: {
                int n6 = this.windowY1;
                while (cursorI > 0 && n6 == this.windowY1) {
                    this.setCursor(cursorI - 1, cursorJ);
                }
                n = 99;
                break;
            }
            case 48: {
                int n7 = this.windowY1;
                while (cursorI < this.sheet.rows - 1 && n7 == this.windowY1) {
                    this.setCursor(cursorI + 1, cursorJ);
                }
                n = 99;
                break;
            }
            case 35: {
                this.statusNumeric = true;
                statusInfo = false;
                this.numericLine = "";
                n = 99;
                break;
            }
            case 49: 
            case 51: {
                statusInfo = !statusInfo;
                n = 99;
                break;
            }
            case 55: {
                int n8 = this.windowX1;
                while (cursorJ > 0 && n8 == this.windowX1) {
                    this.setCursor(cursorI, cursorJ - 1);
                }
                n = 99;
                break;
            }
            case 57: {
                int n9 = this.windowX1;
                while (cursorJ < this.sheet.columns - 1 && n9 == this.windowX1) {
                    this.setCursor(cursorI, cursorJ + 1);
                }
                n = 99;
            }
        }
        if (n != 99) {
            bl = this.setCursor(n4, n5);
        }
        if (statusInfo) {
            this.statusLine = this.getStatusInfo(cursorI, cursorJ);
        } else if (this.statusNumeric) {
            this.statusLine = "NUM: ";
        }
        if (!bl || n == 99) {
            this.setStatusLine(this.statusLine);
        }
    }

    protected void keyRepeated(int n) {
        this.keyPressed(n);
    }

    protected void pointerPressed(int n, int n2) {
        int n3;
        if (n >= this.sizeX || n2 >= this.sizeY) {
            return;
        }
        if ((n += this.windowX1 - headerWidth) < 0 || (n2 += this.windowY1 - fontHeight) < 0) {
            return;
        }
        int n4 = this.sheet.rows - 1;
        int n5 = this.sheet.columns - 1;
        int n6 = 0;
        for (n3 = 0; n3 < this.sheet.rows; ++n3) {
            if (n2 >= (n6 += this.sheet.rowHeight[n3])) continue;
            n4 = n3;
            break;
        }
        n3 = 0;
        for (int i = 0; i < this.sheet.columns; ++i) {
            if (n >= (n3 += this.sheet.columnWidth[i])) continue;
            n5 = i;
            break;
        }
        if (cursorI == n4 && cursorJ == n5) {
            this.editCell(cursorI, cursorJ);
        } else {
            this.setCursor(n4, n5);
        }
    }

    protected void paint(Graphics graphics) {
        int n;
        int n2;
        short s;
        int n3;
        int n4 = graphics.getClipX();
        int n5 = graphics.getClipY();
        int n6 = graphics.getClipWidth();
        int n7 = graphics.getClipHeight();
        boolean bl = this.intersect(n4, n5, n4 + n6, n5 + n7, headerWidth, 0, this.sizeX, fontHeight);
        boolean bl2 = this.intersect(n4, n5, n4 + n6, n5 + n7, 0, fontHeight, headerWidth, this.sizeY);
        boolean bl3 = this.intersect(n4, n5, n4 + n6, n5 + n7, headerWidth + 1, fontHeight + 1, this.sizeX, this.sizeY);
        boolean bl4 = this.statusLine != null && bl;
        int n8 = this.windowX1 + (n4 - headerWidth);
        int n9 = this.windowY1 + (n5 - fontHeight);
        int n10 = n8 + n6;
        int n11 = n9 + n7;
        if (bl) {
            n8 = this.windowX1;
        }
        if (bl2) {
            n9 = this.windowY1;
        }
        int n12 = -1;
        int n13 = this.sheet.rows - 1;
        int n14 = -1;
        int n15 = this.sheet.columns - 1;
        int n16 = 0;
        for (n3 = 0; n3 < this.sheet.columns; ++n3) {
            if (n16 >= n10) {
                n15 = n3 - 1;
                break;
            }
            s = this.sheet.columnWidth[n3];
            if (n14 == -1 && (n16 >= n8 || n16 + s > n8)) {
                n14 = n3;
            }
            n16 += s;
        }
        n3 = 0;
        for (n2 = 0; n2 < this.sheet.rows; ++n2) {
            if (n3 >= n11) {
                n13 = n2 - 1;
                break;
            }
            s = this.sheet.rowHeight[n2];
            if (n12 == -1 && (n3 >= n9 || n3 + s > n9)) {
                n12 = n2;
            }
            n3 += s;
        }
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, this.sizeX, this.sizeY);
        graphics.setFont(this.font);
        if (bl) {
            graphics.setColor(0);
            graphics.drawLine(headerWidth, fontHeight, this.sizeX - 1, fontHeight);
            if (bl4) {
                this.lcdFont.setColor(graphics, STATUS, 0xFFFFFF);
                this.lcdFont.drawText(graphics, this.statusLine, 2, 0);
            } else {
                graphics.setClip(headerWidth, 0, this.sizeX - headerWidth, fontHeight);
                n16 = this.sheet.cellX(n14) - this.windowX1 + headerWidth;
                graphics.drawLine(n16, 0, n16, fontHeight - 1);
                for (n = n14; n <= n15; ++n) {
                    n2 = n16 + this.sheet.columnWidth[n];
                    graphics.setColor(0);
                    graphics.drawLine(n2, 0, n2, fontHeight - 1);
                    this.lcdFont.setColor(graphics, LABELS, 0xFFFFFF);
                    this.lcdFont.drawText(graphics, Result.columnName(n), (n16 + n2) / 2, 1);
                    n16 = n2;
                }
            }
            graphics.setClip(0, 0, this.sizeX, this.sizeY);
        }
        if (bl2) {
            graphics.setColor(0);
            graphics.drawLine(headerWidth, fontHeight, headerWidth, this.sizeY - 1);
            graphics.setClip(0, fontHeight, headerWidth, this.sizeY - fontHeight);
            n3 = this.sheet.cellY(n12) - this.windowY1 + fontHeight;
            String string = "";
            graphics.drawLine(0, n3, headerWidth - 1, n3);
            for (int i = n12; i <= n13; ++i) {
                n2 = n3 + this.sheet.rowHeight[i];
                string = "";
                if (i < 9) {
                    string = string + " ";
                }
                graphics.setColor(0);
                graphics.drawLine(0, n2, headerWidth - 1, n2);
                this.lcdFont.setColor(graphics, LABELS, 0xFFFFFF);
                this.lcdFont.drawText(graphics, string + String.valueOf(i + 1), 0, n3 + 2);
                n3 = n2;
            }
        }
        if (bl3) {
            for (n2 = n12; n2 <= n13; ++n2) {
                for (n = n15; n >= n14; --n) {
                    graphics.setClip(headerWidth + 1, fontHeight + 1, this.sizeX - headerWidth - 1, this.sizeY - fontHeight - 1);
                    this.paintCell(graphics, n2, n, n2 == cursorI && n == cursorJ);
                }
            }
        }
    }

    void paintCell(Graphics graphics, int n, int n2, boolean bl) {
        int n3 = this.sheet.cellX(n2) - this.windowX1 + headerWidth;
        int n4 = this.sheet.cellY(n) - this.windowY1 + fontHeight;
        short s = this.sheet.columnWidth[n2];
        short s2 = this.sheet.rowHeight[n];
        int n5 = n3 + s;
        int n6 = n4 + s2;
        boolean bl2 = true;
        graphics.clipRect(n3, n4 + 1, s + 1, (int)s2);
        Result result = this.sheet.getCell(n, n2);
        Result result2 = result.funcargs[0];
        int n7 = (int)result.ll;
        if (n >= clipboardI && n2 >= clipboardJ && n <= clipboardI2 && n2 <= clipboardJ2 && statusInfo) {
            graphics.setColor(0xF0F0F0);
            graphics.fillRect(n3 + 1, n4 + 1, s - 1, s2 - 1);
            graphics.setColor(0xFFFFFF);
        }
        if (!result.isEmptyCell()) {
            if (n >= clipboardI && n2 >= clipboardJ && n <= clipboardI2 && n2 <= clipboardJ2 && statusInfo) {
                this.lcdFont.setColor(graphics, CELLS, 0xF0F0F0);
            } else {
                this.lcdFont.setColor(graphics, CELLS, 0xFFFFFF);
            }
            String string = result2.toString(false, n7);
            boolean bl3 = false;
            if ((n7 & 0x1000) != 0) {
                this.drawText(graphics, string, n3 + 1, n4 + 2, s, s2);
                bl2 = !this.sheet.isEmpty(n, n2 + 1) || this.stringWidth(string) + 3 <= s;
            } else if ((n7 & 0x2000) != 0) {
                if (this.stringWidth(string) + 3 > s) {
                    string = DEFAULT_WIDTH;
                }
                this.drawText(graphics, string, n5 - this.stringWidth(string), n4 + 2, s, s2);
            } else if (result2.type == 5 && string.length() > 0) {
                if (string.substring(0, 1).equals("_") || string.substring(0, 1).equals("=")) {
                    this.lcdFont.drawText(graphics, string, n5 - this.stringWidth(string), n4 + 2);
                } else {
                    this.drawText(graphics, string, n3 + 1, n4 + 2, s, s2);
                }
                bl2 = !this.sheet.isEmpty(n, n2 + 1) || this.stringWidth(string) + 3 <= s;
            } else {
                if (this.stringWidth(string) + 3 > s) {
                    string = DEFAULT_WIDTH;
                }
                this.lcdFont.drawText(graphics, string, n5 - this.stringWidth(string), n4 + 2);
            }
        } else {
            int n8 = 0;
            for (int i = n2 - 1; i >= 0; --i) {
                String string;
                int n9;
                n8 += this.sheet.columnWidth[i];
                result2 = this.sheet.getCellValue(n, i);
                if (result2.type == 0) continue;
                if (result2.type != 5 || (n9 = this.stringWidth(string = result2.toString()) + 3) <= n8 || string.indexOf("\n") >= 0) break;
                this.lcdFont.setColor(graphics, CELLS, 0xFFFFFF);
                this.lcdFont.drawText(graphics, string, n3 + 2 - n8, n4 + 2);
                bl2 = !this.sheet.isEmpty(n, n2 + 1) || n9 <= n8 + s;
                break;
            }
        }
        graphics.setColor(0);
        if (bl2) {
            graphics.drawLine(n5, n4 + 1, n5, n6 - 1);
        }
        graphics.drawLine(n3 + 1, n6, n5, n6);
        if (bl) {
            graphics.setColor(SELECTED);
            graphics.drawRect(n3 + 1, n4 + 1, s - 2, s2 - 2);
            graphics.drawRect(n3, n4, (int)s, (int)s2);
        }
    }

    private int stringWidth(String string) {
        if (FONT_SIZE == 0) {
            return this.font.stringWidth(string);
        }
        return fontWidth * string.length();
    }

    private void drawText(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        if (string.indexOf("\n") < 0) {
            this.lcdFont.drawText(graphics, string, n, n2);
            return;
        }
        int n5 = n2;
        boolean bl = false;
        int n6 = 0;
        String string2 = string;
        String string3 = "";
        while (!bl) {
            n6 = string2.indexOf("\n");
            if (n6 < 0) {
                graphics.setClip(n, n5, this.sizeX - n, n4);
                this.lcdFont.drawText(graphics, string2, n, n5);
                break;
            }
            string3 = string2.substring(0, n6);
            string2 = string2.substring(n6 + 1, string2.length());
            graphics.setClip(n, n5, this.sizeX - n, n4);
            this.lcdFont.drawText(graphics, string3, n, n5);
            if (string2.length() >= 1 && (n5 += n4) + 1 <= this.sizeY) continue;
        }
        graphics.setClip(n - 1, n2 - 1, n3 + 1, n4);
    }

    public void commandAction(Command command, Displayable displayable) {
        int n;
        if (command.getLabel().toString().equals("Back") && displayable.getTitle().toString().equals("Email")) {
            this.setCurrent();
        }
        if (command.getLabel().toString().equals("Abort")) {
            this.client.aborted();
        }
        if (command.getLabel().toString().equals("Exit") && displayable.getTitle().toString().equals("Send")) {
            this.setCurrent();
        }
        if (command.getLabel().toString().equals("Exit") && displayable.getTitle().toString().equals("Receive")) {
            this.setCurrent();
            for (int i = 0; i < this.sheet.rows; ++i) {
                for (n = 0; n < this.sheet.columns; ++n) {
                    this.fitCell(i, n);
                }
            }
            this.setCurrent();
        }
        if (command.getLabel().toString().equals("OK") && displayable.getTitle().toString().equals("Email")) {
            this.client.online();
        }
        try {
            Result result = this.sheet.getCell(cursorI, cursorJ);
            n = (int)result.ll;
            if (command == cmdMenu) {
                defaultMenu.start(this.parent, this);
                return;
            }
            if (displayable == this.selectList) {
                if (command == cmdDelete) {
                    int n2 = this.selectList.getSelectedIndex();
                    if (n2 >= 0) {
                        String string = this.selectList.getString(n2);
                        try {
                            MicroCalcCanvas.deleteSheet(string);
                            this.selectList.removeCommand(cmdDelete);
                            this.selectList.addCommand(okEditCommand);
                            this.setCurrent();
                        }
                        catch (Exception exception) {
                            Alert alert = new Alert("Cannot access the sheet, error: ", exception.getMessage(), null, AlertType.ERROR);
                            this.display.setCurrent(alert, (Displayable)this.selectList);
                        }
                    }
                    return;
                }
                if (command == okEditCommand) {
                    int n3 = this.selectList.getSelectedIndex();
                    if (n3 >= 0) {
                        this.parent.loadSheet(this.selectList.getString(n3));
                    }
                } else {
                    this.setCurrent();
                }
                return;
            }
            if (displayable == this.editName) {
                if (command == okEditCommand) {
                    this.sheet.name = this.editName.getString();
                    this.sheet.changed = true;
                    this.parent.saveSheet(null);
                } else {
                    this.setCurrent();
                }
                this.editName = null;
                return;
            }
            if (displayable == this.frmNewSheet) {
                if (command == okEditCommand) {
                    String string = ((TextField)this.frmNewSheet.get(0)).getString();
                    int n4 = Integer.parseInt(((TextField)this.frmNewSheet.get(1)).getString());
                    int n5 = Integer.parseInt(((TextField)this.frmNewSheet.get(2)).getString());
                    if (n4 < 2 || n5 < 2) {
                        throw new IOException("Wrong sheet size");
                    }
                    short s = Short.parseShort(((TextField)this.frmNewSheet.get(3)).getString());
                    if (s < 0 || s > 7) {
                        throw new IOException("Wrong number of decimals");
                    }
                    MicroCalc.DEFAULT_PRECISION = s;
                    Result.FORMAT_DATE = 0;
                    MicroCalcCanvas.saveSheet(this.sheet);
                    cursorI = 0;
                    cursorJ = 0;
                    Sheet.newRows = n4;
                    Sheet.newColumns = n5;
                    this.sheet = new Sheet(n4, n5, defaultColumnWidth + 3, fontHeight + 3);
                    this.setWindow(0, 0, 1, 4);
                    this.sheet.name = string;
                    clipboardI = -1;
                    clipboardJ = -1;
                    clipboardI2 = -1;
                    clipboardJ2 = -1;
                    if (statusInfo) {
                        this.statusLine = this.getStatusInfo(cursorI, cursorJ);
                    }
                }
                this.frmNewSheet = null;
                this.setCurrent();
                return;
            }
            if (displayable == this.frmInsertRow) {
                if (command == okEditCommand) {
                    int n6;
                    int n7 = Integer.parseInt(((TextField)this.frmInsertRow.get(0)).getString());
                    boolean bl = ((ChoiceGroup)this.frmInsertRow.get(1)).getSelectedIndex() == 1;
                    int n8 = ((ChoiceGroup)this.frmInsertRow.get(2)).getSelectedIndex();
                    if (n7 < 1) {
                        throw new IOException("Wrong number of rows");
                    }
                    this.sheet.insertCells(cursorI, cursorJ, n7, 0, bl);
                    if (n8 == 1 && cursorI != 0) {
                        for (n6 = 0; n6 < n7; ++n6) {
                            this.sheet.copyRow1(cursorI - 1, n6 + 1);
                        }
                    }
                    if (n8 == 2) {
                        for (n6 = 0; n6 < n7; ++n6) {
                            this.sheet.copyRow1(cursorI + n7, -n6 - 1);
                        }
                    }
                }
                this.frmInsertRow = null;
                this.setCurrent();
                return;
            }
            if (displayable == this.frmDeleteRow) {
                if (command == okEditCommand) {
                    boolean bl;
                    int n9 = Integer.parseInt(((TextField)this.frmDeleteRow.get(0)).getString());
                    boolean bl2 = bl = ((ChoiceGroup)this.frmDeleteRow.get(1)).getSelectedIndex() == 1;
                    if (n9 < 1) {
                        throw new IOException("Wrong number of rows");
                    }
                    this.sheet.insertCells(cursorI, cursorJ, -n9, 0, bl);
                }
                this.frmDeleteRow = null;
                this.setCurrent();
                return;
            }
            if (displayable == this.frmInsertColumn) {
                if (command == okEditCommand) {
                    boolean bl;
                    int n10 = Integer.parseInt(((TextField)this.frmInsertColumn.get(0)).getString());
                    boolean bl3 = bl = ((ChoiceGroup)this.frmInsertColumn.get(1)).getSelectedIndex() == 1;
                    if (n10 < 1) {
                        throw new IOException("Wrong number of columns");
                    }
                    this.sheet.insertCells(cursorI, cursorJ, 0, n10, bl);
                }
                this.frmInsertColumn = null;
                this.setCurrent();
                return;
            }
            if (displayable == this.frmDeleteColumn) {
                if (command == okEditCommand) {
                    boolean bl;
                    int n11 = Integer.parseInt(((TextField)this.frmDeleteColumn.get(0)).getString());
                    boolean bl4 = bl = ((ChoiceGroup)this.frmDeleteColumn.get(1)).getSelectedIndex() == 1;
                    if (n11 < 1) {
                        throw new IOException("Wrong number of columns");
                    }
                    this.sheet.insertCells(cursorI, cursorJ, 0, -n11, bl);
                }
                this.frmDeleteColumn = null;
                this.setCurrent();
                return;
            }
            if (displayable == this.editColumnWidth) {
                int n12;
                if (command == okEditCommand && (n12 = Integer.parseInt(((TextField)this.editColumnWidth.get(0)).getString())) > 4) {
                    this.sheet.columnWidth[MicroCalcCanvas.cursorJ] = (short)n12;
                }
                this.editColumnWidth = null;
                this.setCurrent();
                return;
            }
            if (displayable == this.frmResize) {
                if (command == okEditCommand) {
                    int n13 = Integer.parseInt(((TextField)this.frmResize.get(0)).getString());
                    int n14 = Integer.parseInt(((TextField)this.frmResize.get(1)).getString());
                    if (n13 < 2 || n14 < 2) {
                        throw new IOException("Wrong sheet size");
                    }
                    if (cursorI + 1 > n13) {
                        cursorI = n13 - 1;
                    }
                    if (cursorJ + 1 > n14) {
                        cursorJ = n14 - 1;
                    }
                    this.sheet.resize(n13, n14);
                }
                this.frmResize = null;
                this.setCurrent();
                return;
            }
            if (displayable == this.directions) {
                if (command == okEditCommand) {
                    this.setCurrent();
                }
                this.directions = null;
                return;
            }
            if (displayable == this.frmSeries) {
                if (command == okEditCommand) {
                    int n15;
                    int n16;
                    String string = ((TextField)this.frmSeries.get(0)).getString();
                    Result result2 = Result.parseAddress(string);
                    int n17 = result2.i1;
                    int n18 = result2.j1;
                    short s = result2.i2;
                    short s2 = result2.j2;
                    String string2 = ((TextField)this.frmSeries.get(1)).getString();
                    long l = 8192L;
                    if (string2.length() != 0) {
                        l = Result.createLong(string2);
                    }
                    Result result3 = this.sheet.getCell((int)n17, (int)n18).funcargs[0];
                    long l2 = result3.ll;
                    this.frmSeries.removeCommand(cancelEditCommand);
                    this.frmSeries.removeCommand(okEditCommand);
                    cmdOK = new Command(" ", 4, 2);
                    this.frmSeries.addCommand(cmdOK);
                    if (((ChoiceGroup)this.frmSeries.get(2)).getSelectedIndex() == 0) {
                        for (n16 = n18; n16 <= s2; ++n16) {
                            for (n15 = n17; n15 <= s; ++n15) {
                                this.frmSeries.removeCommand(cmdOK);
                                cmdOK = new Command(Result.cellAddress(n15, n16, 0), 4, 2);
                                this.frmSeries.addCommand(cmdOK);
                                this.sheet.setFormula(n15, n16, Result.createString(l2));
                                l2 += l;
                                Runtime.getRuntime().gc();
                                this.fitCell(n15, n16);
                                this.sheet.calculateDepended(n15, n16, true);
                            }
                        }
                    } else {
                        for (n15 = n17; n15 <= s; ++n15) {
                            for (n16 = n18; n16 <= s2; ++n16) {
                                this.frmSeries.removeCommand(cmdOK);
                                cmdOK = new Command(Result.cellAddress(n15, n16, 0), 4, 2);
                                this.frmSeries.addCommand(cmdOK);
                                this.sheet.setFormula(n15, n16, Result.createString(l2));
                                l2 += l;
                                Runtime.getRuntime().gc();
                                this.fitCell(n15, n16);
                                this.sheet.calculateDepended(n15, n16, true);
                            }
                        }
                    }
                    if (statusInfo) {
                        this.statusLine = this.getStatusInfo(cursorI, cursorJ);
                    }
                    this.sheet.changed = true;
                }
                this.frmSeries = null;
                this.setCurrent();
                return;
            }
            if (displayable == this.frmFormatNumber) {
                if (command == okEditCommand) {
                    if ((n & 0x100) != 0) {
                        n ^= 0x100;
                    }
                    if ((n & 0x200) != 0) {
                        n ^= 0x200;
                    }
                    n >>= 3;
                    n <<= 3;
                    n |= Result.FORMAT_NUMBER;
                    String string = ((TextField)this.frmFormatNumber.get(0)).getString();
                    short s = 0;
                    if (string.length() != 0 && (s = Short.parseShort(string)) < 8) {
                        n |= s;
                    }
                    if (((ChoiceGroup)this.frmFormatNumber.get(1)).getSelectedIndex() == 0) {
                        n |= 0x100;
                    }
                    if (((ChoiceGroup)this.frmFormatNumber.get(2)).getSelectedIndex() == 0) {
                        n |= 0x200;
                    }
                    result.ll = n;
                    this.fitCell(cursorI, cursorJ);
                    this.sheet.changed = true;
                }
                this.frmFormatNumber = null;
                this.setCurrent();
                return;
            }
            if (displayable == this.frmFormatAlign) {
                if (command == okEditCommand) {
                    n <<= 20;
                    n >>= 20;
                    if (((ChoiceGroup)this.frmFormatAlign.get(0)).getSelectedIndex() == 1) {
                        n |= 0x1000;
                    }
                    if (((ChoiceGroup)this.frmFormatAlign.get(0)).getSelectedIndex() == 2) {
                        n |= 0x2000;
                    }
                    result.ll = n;
                    this.fitCell(cursorI, cursorJ);
                    this.sheet.changed = true;
                }
                this.frmFormatAlign = null;
                this.setCurrent();
                return;
            }
            if (displayable == this.frmFormatDate) {
                if (command == okEditCommand) {
                    Result.FORMAT_DATE = ((ChoiceGroup)this.frmFormatDate.get(0)).getSelectedIndex();
                    this.fitCell(cursorI, cursorJ);
                    this.sheet.changed = true;
                }
                this.frmFormatDate = null;
                this.setCurrent();
                return;
            }
            if (displayable == this.frmFonts) {
                int n19;
                if (command == okEditCommand && (n19 = ((ChoiceGroup)this.frmFonts.get(0)).getSelectedIndex()) != FONT_SIZE) {
                    FONT_SIZE = n19;
                    this.frmFonts.deleteAll();
                    this.savePrefs();
                    this.sheet.changed = true;
                    MicroCalcCanvas.saveSheet(this.sheet);
                    this.frmFonts.append("\n\n\n Updating files....");
                    this.display.setCurrent((Displayable)this.frmFonts);
                    new Thread(){

                        public void run() {
                            MicroCalcCanvas.this.parent.exitSheet();
                        }
                    }.start();
                    return;
                }
                this.frmFonts = null;
                this.setCurrent();
                return;
            }
            if (displayable == this.frmColors) {
                if (command == okEditCommand) {
                    this.setColors();
                }
                this.frmColors = null;
                this.setCurrent();
                return;
            }
            if (displayable == this.frmFormatDecs) {
                if (command == okEditCommand) {
                    String string = ((TextField)this.frmFormatDecs.get(0)).getString();
                    short s = 0;
                    if (string.length() != 0 && (s = Short.parseShort(string)) < 8) {
                        MicroCalc.DEFAULT_PRECISION = s;
                    }
                    this.fitCell(cursorI, cursorJ);
                    this.sheet.changed = true;
                }
                this.frmFormatDecs = null;
                this.setCurrent();
                return;
            }
            if (displayable == this.edit) {
                String string = null;
                if (command == okEditCommand) {
                    String string3;
                    block175: {
                        string3 = this.edit.getString();
                        try {
                            if (string3.charAt(1) != '/' && string3.charAt(2) != '/' || string3.charAt(3) != '/' && string3.charAt(4) != '/' && string3.charAt(5) != '/') break block175;
                            try {
                                String string4 = string3.substring(string3.lastIndexOf(47) + 1, string3.length());
                                if (string4.length() < 3) {
                                    string4 = string4.charAt(0) < '7' ? "20" + string4 : "19" + string4;
                                    string3 = string3.substring(0, string3.lastIndexOf(47) + 1) + string4;
                                }
                            }
                            catch (Exception exception) {}
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    try {
                        this.sheet.setFormula(cursorI, cursorJ, string3);
                        if (string3.length() < 1) {
                            this.sheet.clear(cursorI, cursorJ);
                        }
                        if (statusInfo) {
                            this.statusLine = this.getStatusInfo(cursorI, cursorJ);
                        }
                        this.sheet.calculateDepended(cursorI, cursorJ, true);
                        this.fitCell(cursorI, cursorJ);
                        this.sheet.changed = true;
                    }
                    catch (ArithmeticException arithmeticException) {
                        string = "Arithmetic error, division by zero or negative argument";
                    }
                    catch (Exception exception) {
                        string = exception.getMessage();
                    }
                }
                if (string == null) {
                    this.edit = null;
                    this.setCurrent();
                } else {
                    this.warning(string, (Displayable)this.edit);
                }
                return;
            }
            if (displayable == this.clear) {
                try {
                    this.clear.removeCommand(cancelEditCommand);
                    this.clear.removeCommand(okEditCommand);
                    cmdOK = new Command(" ", 4, 2);
                    this.clear.addCommand(cmdOK);
                    if (command == okEditCommand) {
                        String string = this.clear.getString();
                        Result result4 = Result.parseAddress(string);
                        int n20 = result4.i1;
                        int n21 = result4.j1;
                        short s = result4.i2;
                        short s3 = result4.j2;
                        int n22 = n21;
                        for (int i = n20; i <= s; ++i) {
                            for (n22 = n21; n22 <= s3; ++n22) {
                                this.clear.removeCommand(cmdOK);
                                cmdOK = new Command(Result.cellAddress(i, n22, 0), 4, 2);
                                this.clear.addCommand(cmdOK);
                                this.sheet.clear(i, n22);
                                Runtime.getRuntime().gc();
                                this.sheet.calculateDepended(i, n22, true);
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    this.warning("Error: " + exception.getMessage());
                }
                if (statusInfo) {
                    this.setStatusLine(this.getStatusInfo(cursorI, cursorJ));
                } else {
                    this.setStatusLine(null);
                }
                this.setCurrent();
                this.sheet.changed = true;
                this.clear = null;
                return;
            }
            if (displayable == this.copy) {
                if (command == okEditCommand) {
                    String string = this.copy.getString();
                    Result result5 = Result.parseAddress(string);
                    clipboardI = result5.i1;
                    clipboardJ = result5.j1;
                    clipboardI2 = result5.i2;
                    clipboardJ2 = result5.j2;
                }
                this.setCurrent();
                this.copy = null;
                return;
            }
            if (displayable == this.paste) {
                try {
                    this.paste.removeCommand(cancelEditCommand);
                    this.paste.removeCommand(okEditCommand);
                    cmdOK = new Command(" ", 4, 2);
                    this.paste.addCommand(cmdOK);
                    if (command == okEditCommand) {
                        if (clipboardI < 0 || clipboardJ < 0) {
                            this.warning("No cells selected");
                            return;
                        }
                        String string = this.paste.getString();
                        Result result6 = Result.parseAddress(string);
                        int n23 = result6.i1;
                        int n24 = result6.j1;
                        short s = result6.i2;
                        short s4 = result6.j2;
                        if (clipboardI == clipboardI2 && clipboardJ == clipboardJ2) {
                            int n25 = n24;
                            for (int i = n23; i <= s; ++i) {
                                for (n25 = n24; n25 <= s4; ++n25) {
                                    this.sheet.copyCell1(clipboardI, clipboardJ, i - clipboardI, n25 - clipboardJ);
                                    this.paste.removeCommand(cmdOK);
                                    cmdOK = new Command(Result.cellAddress(i, n25, 0), 4, 2);
                                    this.paste.addCommand(cmdOK);
                                    Runtime.getRuntime().gc();
                                }
                            }
                        } else {
                            if (clipboardI - clipboardI2 != n23 - s || clipboardJ - clipboardJ2 != n24 - s4) {
                                this.warning("Copy/paste range mismatch");
                                return;
                            }
                            int n26 = n23;
                            int n27 = n24;
                            int n28 = clipboardI;
                            int n29 = clipboardJ;
                            while (n26 <= s) {
                                while (n27 <= s4) {
                                    this.paste.removeCommand(cmdOK);
                                    cmdOK = new Command(Result.cellAddress(n28, n29, 0), 4, 2);
                                    this.paste.addCommand(cmdOK);
                                    this.sheet.copyCell1(n28, n29, n26 - n28, n27 - n29);
                                    Runtime.getRuntime().gc();
                                    ++n27;
                                    ++n29;
                                }
                                n27 = n24;
                                n29 = clipboardJ;
                                ++n26;
                                ++n28;
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    this.warning("Error: " + exception.getMessage());
                }
                if (statusInfo) {
                    this.setStatusLine(this.getStatusInfo(cursorI, cursorJ));
                } else {
                    this.setStatusLine(null);
                }
                this.setCurrent();
                this.sheet.changed = true;
                this.paste = null;
                return;
            }
            if (displayable == this.fpaste) {
                try {
                    if (command == okEditCommand) {
                        if (clipboardI < 0 || clipboardJ < 0) {
                            this.warning("No cell selected");
                            return;
                        }
                        String string = this.fpaste.getString();
                        Result result7 = Result.parseAddress(string);
                        int n30 = result7.i1;
                        int n31 = result7.j1;
                        short s = result7.i2;
                        short s5 = result7.j2;
                        long l = this.sheet.getCell((int)MicroCalcCanvas.clipboardI, (int)MicroCalcCanvas.clipboardJ).ll;
                        int n32 = n31;
                        for (int i = n30; i <= s; ++i) {
                            for (n32 = n31; n32 <= s5; ++n32) {
                                this.sheet.getCell((int)i, (int)n32).ll = l;
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    this.warning("Error: " + exception.getMessage());
                }
                this.setCurrent();
                this.sheet.changed = true;
                this.fpaste = null;
                return;
            }
            if (command == Menu.cmdItem) {
                int n33 = command.getPriority();
                if (n33 == 51) {
                    return;
                }
                if (n33 == 50) {
                    this.sheet.changed = false;
                    n33 = this.confirmCode;
                }
                switch (n33) {
                    case 100: {
                        if (this.sheet.changed) {
                            this.confirmCode = (byte)52;
                            confirmMenu.start(this.parent, this);
                            break;
                        }
                        this.savePrefs();
                        this.parent.notifyDestroyed();
                        break;
                    }
                    case 3: {
                        this.copy = new TextBox("Copy cells from:", Result.cellAddress(cursorI, cursorJ, 0), 16, 0);
                        this.addCmds((Displayable)this.copy);
                        break;
                    }
                    case 4: {
                        this.paste = new TextBox("Paste cells into:", Result.cellAddress(cursorI, cursorJ, 0), 16, 0);
                        this.addCmds((Displayable)this.paste);
                        break;
                    }
                    case 11: {
                        this.fpaste = new TextBox("Paste format into:", Result.cellAddress(cursorI, cursorJ, 0), 16, 0);
                        this.addCmds((Displayable)this.fpaste);
                        break;
                    }
                    case 1: {
                        this.editCell(cursorI, cursorJ);
                        break;
                    }
                    case 2: {
                        this.clear = new TextBox("Clear cell range:", Result.cellAddress(cursorI, cursorJ, 0), 16, 0);
                        this.addCmds((Displayable)this.clear);
                        break;
                    }
                    case 10: {
                        this.frmSeries = new Form("Series Fill");
                        this.frmSeries.append((Item)new TextField("Cell range:", Result.cellAddress(cursorI, cursorJ, 0), 16, 0));
                        this.frmSeries.append((Item)new TextField("Step value:", "1", 16, 5));
                        ChoiceGroup choiceGroup = new ChoiceGroup("Fill range by:", 1, new String[]{"Column", "Row"}, null);
                        choiceGroup.setSelectedIndex(0, true);
                        this.frmSeries.append((Item)choiceGroup);
                        this.addCmds((Displayable)this.frmSeries);
                        break;
                    }
                    case 30: {
                        int n34 = n << 28;
                        String string = (n & Result.FORMAT_NUMBER) != 0 ? Integer.toString(n34 >>= 28) : "";
                        this.frmFormatNumber = new Form("Number");
                        this.frmFormatNumber.append((Item)new TextField("Number of decimals", string, 2, 2));
                        ChoiceGroup choiceGroup = new ChoiceGroup("Thousands separator", 1, new String[]{"Yes", "No"}, null);
                        if ((n & 0x100) != 0) {
                            choiceGroup.setSelectedIndex(0, true);
                        } else {
                            choiceGroup.setSelectedIndex(1, true);
                        }
                        this.frmFormatNumber.append((Item)choiceGroup);
                        ChoiceGroup choiceGroup2 = new ChoiceGroup("Brackets instead of minus", 1, new String[]{"Yes", "No"}, null);
                        if ((n & 0x200) != 0) {
                            choiceGroup2.setSelectedIndex(0, true);
                        } else {
                            choiceGroup2.setSelectedIndex(1, true);
                        }
                        this.frmFormatNumber.append((Item)choiceGroup2);
                        this.addCmds((Displayable)this.frmFormatNumber);
                        break;
                    }
                    case 32: {
                        int n35 = n;
                        this.frmFormatAlign = new Form("Alignment");
                        ChoiceGroup choiceGroup = new ChoiceGroup("Within cell", 1, new String[]{"Default", "Left", "Right"}, null);
                        if ((n35 & 0x1000) != 0) {
                            choiceGroup.setSelectedIndex(1, true);
                        } else if ((n35 & 0x2000) != 0) {
                            choiceGroup.setSelectedIndex(2, true);
                        } else {
                            choiceGroup.setSelectedIndex(0, true);
                        }
                        this.frmFormatAlign.append((Item)choiceGroup);
                        this.addCmds((Displayable)this.frmFormatAlign);
                        break;
                    }
                    case 34: {
                        this.frmFormatDate = new Form("Date format");
                        ChoiceGroup choiceGroup = new ChoiceGroup("", 1, new String[]{"DD/MM/YY", "DD/MM/YYYY", "D/M/YY", "D MMM YYYY"}, null);
                        choiceGroup.setSelectedIndex(Result.FORMAT_DATE, true);
                        this.frmFormatDate.append((Item)choiceGroup);
                        this.addCmds((Displayable)this.frmFormatDate);
                        break;
                    }
                    case 40: {
                        this.frmFonts = new Form("Font size");
                        ChoiceGroup choiceGroup = new ChoiceGroup("", 1, new String[]{"Large", "Medium", "Small"}, null);
                        choiceGroup.setSelectedIndex(FONT_SIZE, true);
                        this.frmFonts.append((Item)choiceGroup);
                        this.frmFonts.append("Caution: The current sheet will be saved and MicroCalc restarted if you change the font size");
                        this.addCmds((Displayable)this.frmFonts);
                        break;
                    }
                    case 35: {
                        this.frmFormatDecs = new Form("Default decimal places");
                        this.frmFormatDecs.append((Item)new TextField("Number of decimals", "" + MicroCalc.DEFAULT_PRECISION, 2, 2));
                        this.addCmds((Displayable)this.frmFormatDecs);
                        break;
                    }
                    case 33: {
                        result.ll = 0L;
                        break;
                    }
                    case 6: 
                    case 19: {
                        if (this.sheet.changed) {
                            this.confirmCode = (byte)6;
                            confirmMenu.start(this.parent, this);
                            return;
                        }
                        this.newSheet();
                        break;
                    }
                    case 9: {
                        this.selectSheet();
                        this.selectList.removeCommand(okEditCommand);
                        this.selectList.addCommand(cmdDelete);
                        this.selectList.setSelectCommand(cmdDelete);
                        break;
                    }
                    case 8: {
                        if (this.sheet.changed) {
                            this.confirmCode = (byte)8;
                            confirmMenu.start(this.parent, this);
                            return;
                        }
                        this.selectSheet();
                        this.selectList.setSelectCommand(okEditCommand);
                        break;
                    }
                    case 7: {
                        this.editName = new TextBox("Sheet Name", this.sheet.name, 24, 0);
                        this.addCmds((Displayable)this.editName);
                        break;
                    }
                    case 90: {
                        this.eform = new Form("Email");
                        this.eform.setCommandListener((CommandListener)this);
                        this.display.setCurrent((Displayable)this.eform);
                        this.client = new EmailClient(this.parent, this.display, this.eform, this.sheet, this.sheet.name, 1);
                        this.client.start();
                        break;
                    }
                    case 91: {
                        this.eform = new Form("Email");
                        this.eform.setCommandListener((CommandListener)this);
                        this.display.setCurrent((Displayable)this.eform);
                        this.client = new EmailClient(this.parent, this.display, this.eform, this.sheet, "", 3);
                        this.client.start();
                        break;
                    }
                    case 28: {
                        this.frmResize = new Form("Sheet Size");
                        this.frmResize.append((Item)new TextField("Number of Rows", Integer.toString(this.sheet.rows), 3, 2));
                        this.frmResize.append((Item)new TextField("Number of Columns", Integer.toString(this.sheet.columns), 3, 2));
                        this.addCmds((Displayable)this.frmResize);
                        break;
                    }
                    case 5: {
                        this.editColumnWidth = new Form("Column " + Result.columnName(cursorJ));
                        this.editColumnWidth.append((Item)new TextField("Enter new width: ", Integer.toString(this.sheet.columnWidth[cursorJ]), 3, 2));
                        this.addCmds((Displayable)this.editColumnWidth);
                        break;
                    }
                    case 20: {
                        this.frmInsertColumn = new Form("Insert Columns");
                        this.frmInsertColumn.append((Item)new TextField("Number of Columns", "1", 2, 2));
                        this.frmInsertColumn.append((Item)new ChoiceGroup("Resize", 1, new String[]{"No", "Yes"}, null));
                        this.addCmds((Displayable)this.frmInsertColumn);
                        break;
                    }
                    case 22: {
                        this.frmDeleteColumn = new Form("Delete Columns");
                        this.frmDeleteColumn.append((Item)new TextField("Number of Columns", "1", 2, 2));
                        this.frmDeleteColumn.append((Item)new ChoiceGroup("Resize", 1, new String[]{"No", "Yes"}, null));
                        this.addCmds((Displayable)this.frmDeleteColumn);
                        break;
                    }
                    case 24: {
                        this.frmInsertRow = new Form("Insert Rows");
                        this.frmInsertRow.append((Item)new TextField("Number of Rows", "1", 2, 2));
                        this.frmInsertRow.append((Item)new ChoiceGroup("Resize", 1, new String[]{"No", "Yes"}, null));
                        this.frmInsertRow.append((Item)new ChoiceGroup("Copy values from row", 1, new String[]{"No", "above", "below"}, null));
                        this.addCmds((Displayable)this.frmInsertRow);
                        break;
                    }
                    case 26: {
                        this.frmDeleteRow = new Form("Delete Rows");
                        this.frmDeleteRow.append((Item)new TextField("Number of Rows", "1", 2, 2));
                        this.frmDeleteRow.append((Item)new ChoiceGroup("Resize", 1, new String[]{"No", "Yes"}, null));
                        this.addCmds((Displayable)this.frmDeleteRow);
                        break;
                    }
                    case 13: {
                        StringItem stringItem = new StringItem("", "Formulae start with   =\nText, numbers, dates are entered directly. Date formats are DD/MM/YYYY or DD/MM/YY\nCell reference style is  A1  (not R1C1) and $ is an absolute marker\nOperators: + - / * & ^(power)\nLogical operators: = <> != > < >= <=\nMathematical functions:\n  SIN(num)      COS(num)\n  TAN(num)     COT(num)\n  ASIN(num)    ACOS(num)\n  ATAN(num)   SQRT(num)\n  EXP(num)     LN(num)\n  ABS(num)     ROUND(num)\n  PI()              FRAC(num)\n  E()               TRUNC(num)\n  SUM(num1,num2,...)\n  COUNT(num1,num2,...)\n  POW(num, power)\n  ATAN2(x_num,y_num)\nLogical functions:\n  IF(logic_test,if_true,if_false)\n  AND(logic_test1,logic_test2)\n  OR(logic_test1,logic_test2)\n  NOT(logic_test)\nText functions:\n  TRIM(text)\n  UPPER(text)\n  LOWER(text)\n  MID(text,start_num,num_chars)\n  EXACT(text1,text2)\n  VALUE(text)\n  TEXT(num)\nFinancial functions:\n  PMT(rate,nper,initsum)\n  IPMT(rate,period,nper,initsum)\n  PPMT(rate,period,nper,initsum)\n  RATE(nper,payment,initsum)\n  NPER(rate,payment,initsum)\nInformation functions:\n  INFO(\"info_type\")   try \"help\"\n  CELL(ref)\n  TYPE(ref)\n\nStandard key functions:\n                      (C)\n                   page up\n      (1)             (2)             (3)\n status       cell up       status\n      (4)             (5)             (6)\n cell left     edit cell    cell right\n      (7)             (8)             (9)\npage left    cell down   page right\n      (*)             (0)             (#)\nshortcuts  page down  num mode\n\nPress <#> for NUMERIC mode,\n    then <#> again to finish\n\nPress <*> for SHORTCUT mode,\n    then the following keys:\n                      (C)\n                  clear cell\n      (1)             (2)             (3)\ncopy cell  paste cell  paste fmt\n      (4)             (5)             (6)\nfull recalc                  quick save\n      (7)             (8)             (9)\nsingle line  double lines\n      (*)             (0)             (#)\n                 functions\n\nPress <*><0> for FUNCTIONS mode,\nthen press keys <2> to <8>\nuntil desired function is found, then press <SELECT> to insert function.\n\nEmail operations:\nSEND will email the current sheet\n    to your chosen email address\nRECEIVE will import one sheet at a\n    time by email. The subject line\n    must start with  MicroCalc  and\n    the email be sent as plain text.\nFiles are emailed in Sylk (.SLK) format. The maximum size is 26 columns by 199 rows.\nAppend  .debug  to destination email address for full dialogue.");
                        stringItem.setFont(this.font);
                        this.directions = new Form("Help");
                        this.directions.append((Item)stringItem);
                        this.directions.addCommand(okEditCommand);
                        this.directions.setCommandListener((CommandListener)this);
                        this.display.setCurrent((Displayable)this.directions);
                        break;
                    }
                    case 36: {
                        this.selectColor("Col/Row Labels Colour:", LABELS);
                        break;
                    }
                    case 37: {
                        this.selectColor("Status Line Colour:", STATUS);
                        break;
                    }
                    case 38: {
                        this.selectColor("Cell Text Colour:", CELLS);
                        break;
                    }
                    case 39: {
                        this.selectColor("Highlight Colour:", SELECTED);
                    }
                }
            }
        }
        catch (RecordStoreFullException recordStoreFullException) {
            this.warning("Cannot save the sheet - storage is full, try to delete old sheets");
        }
        catch (RecordStoreException recordStoreException) {
            this.warning("Cannot load/save the sheet");
        }
        catch (IOException iOException) {
            this.warning("Cannot load/save the sheet");
        }
        catch (Exception exception) {
            this.warning("Error: " + exception.getMessage() + "\n\n(" + exception.toString() + ")");
        }
    }

    private void newSheet() {
        this.frmNewSheet = new Form("New Sheet");
        this.frmNewSheet.append((Item)new TextField("Name", "Untitled", 29, 0));
        this.frmNewSheet.append((Item)new TextField("Rows", Integer.toString(Sheet.newRows), 3, 2));
        this.frmNewSheet.append((Item)new TextField("Columns", Integer.toString(Sheet.newColumns), 2, 2));
        this.frmNewSheet.append((Item)new TextField("Number of decimals", "2", 2, 2));
        this.addCmds((Displayable)this.frmNewSheet);
    }

    private void savePrefs() {
        String[] stringArray = new String[]{"DATE:" + Result.FORMAT_DATE, "NDEC:" + MicroCalc.DEFAULT_PRECISION, "LBLS:" + LABELS, "STLN:" + STATUS, "CELL:" + CELLS, "SLTD:" + SELECTED, "FONT:" + FONT_SIZE};
        EmailClient.writeData("mc_prefs", stringArray);
    }

    private void fitCell(int n, int n2) {
        Result result = this.sheet.getCell(n, n2);
        Result result2 = result.funcargs[0];
        if (result2.type != 5) {
            String string = result2.toString(false, (int)result.ll);
            int n3 = this.stringWidth(string) + 3;
            if (n3 > this.sheet.columnWidth[n2]) {
                this.sheet.columnWidth[n2] = (short)n3;
            }
            this.sheet.changed = true;
        }
    }

    private void editCell(int n, int n2) {
        Result result = this.sheet.getCell(n, n2);
        String string = result.str;
        if (!result.hasFormula()) {
            string = "=";
        }
        this.edit = new TextBox(Result.cellAddress(n, n2, 0) + ": Edit", string, 256, 0);
        this.addCmds((Displayable)this.edit);
    }

    private void editCell2(int n, int n2, String string) {
        Result result = this.sheet.getCell(n, n2);
        this.edit = new TextBox(Result.cellAddress(n, n2, 0) + ": Edit", string, 256, 0);
        this.addCmds((Displayable)this.edit);
    }

    public void importSheets() {
        String string = "";
        RecordStore recordStore = null;
        RecordStore recordStore2 = null;
        for (int i = 0; i < 10; ++i) {
            try {
                recordStore = RecordStore.openRecordStore((String)("Proforma" + i), (String)"Mike", (String)"MCSupport");
            }
            catch (Exception exception) {
                return;
            }
            try {
                if (recordStore.getNumRecords() <= 0) continue;
                string = new String(recordStore.getRecord(1));
                recordStore2 = RecordStore.openRecordStore((String)("ff_" + string.trim()), (boolean)true, (int)1, (boolean)true);
                byte[] byArray = recordStore.getRecord(2);
                byte[] byArray2 = recordStore.getRecord(3);
                recordStore2.addRecord(byArray, 0, byArray.length);
                recordStore2.addRecord(byArray2, 0, byArray2.length);
                if (recordStore != null) {
                    recordStore.deleteRecord(1);
                    recordStore.deleteRecord(2);
                    recordStore.deleteRecord(3);
                    recordStore.closeRecordStore();
                    recordStore = null;
                }
                if (recordStore2 != null) {
                    recordStore2.closeRecordStore();
                    recordStore2 = null;
                }
                byArray = null;
                byArray2 = null;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static List selectSheet(String string) {
        String[] stringArray = RecordStore.listRecordStores();
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        List list = new List(string, 3);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (!string2.startsWith("ff_")) continue;
                stringArray2[n] = string2;
                ++n;
                list.append(string2.substring("ff_".length()), null);
            }
        }
        EmailClient.writeData("mc_sheets", stringArray2);
        if (list.getWidth() < 160) {
            for (n = 0; n < list.size(); ++n) {
                list.setFont(n, Font.getFont((int)64, (int)0, (int)8));
            }
        }
        return list;
    }

    public void selectSheet() {
        List list = MicroCalcCanvas.selectSheet("Select sheet:");
        list.addCommand(cancelEditCommand);
        if (list.size() > 0) {
            list.addCommand(okEditCommand);
            list.setSelectCommand(okEditCommand);
        }
        list.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)list);
        this.selectList = list;
    }

    public void selectColor(String string, int n) {
        this.frmColors = new Form(string);
        ChoiceGroup choiceGroup = new ChoiceGroup("", 1, new String[]{"Black", "Red", "Green", "Blue", "Yellow", "Brown", "Grey"}, null);
        int n2 = 0;
        switch (n) {
            case 0xF00000: {
                n2 = 1;
                break;
            }
            case 57344: {
                n2 = 2;
                break;
            }
            case 224: {
                n2 = 3;
                break;
            }
            case 0xF0F000: {
                n2 = 4;
                break;
            }
            case 0xB08800: {
                n2 = 5;
                break;
            }
            case 0x909090: {
                n2 = 6;
            }
        }
        choiceGroup.setSelectedIndex(n2, true);
        this.frmColors.append((Item)choiceGroup);
        this.addCmds((Displayable)this.frmColors);
        this.colorList = choiceGroup;
    }

    public void setColors() {
        int n = ((ChoiceGroup)this.frmColors.get(0)).getSelectedIndex();
        String string = this.frmColors.getTitle().substring(0, 4);
        int n2 = 0;
        switch (n) {
            case 1: {
                n2 = 0xF00000;
                break;
            }
            case 2: {
                n2 = 57344;
                break;
            }
            case 3: {
                n2 = 224;
                break;
            }
            case 4: {
                n2 = 0xF0F000;
                break;
            }
            case 5: {
                n2 = 0xB08800;
                break;
            }
            case 6: {
                n2 = 0x909090;
            }
        }
        if (string.equals("Col/")) {
            LABELS = n2;
        } else if (string.equals("Stat")) {
            STATUS = n2;
        } else if (string.equals("Cell")) {
            CELLS = n2;
        } else if (string.equals("High")) {
            SELECTED = n2;
        }
    }

    public void warning(String string, Displayable displayable) {
        Alert alert = new Alert("Error", string, null, AlertType.ERROR);
        alert.setTimeout(2000);
        this.display.setCurrent(alert, displayable);
    }

    public void warning(String string) {
        this.warning(string, (Displayable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSheet(Sheet sheet, String string) throws IOException, BadFormulaException, RecordStoreException {
        RecordStore recordStore = null;
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            recordStore = RecordStore.openRecordStore((String)("ff_" + string), (boolean)false);
            byte[] byArray = recordStore.getRecord(1);
            byte[] byArray2 = recordStore.getRecord(2);
            byte[] byArray3 = new byte[byArray.length + byArray2.length];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
            byteArrayInputStream = new ByteArrayInputStream(byArray3);
            sheet.loadSheet(string, byteArrayInputStream);
        }
        finally {
            if (recordStore != null) {
                recordStore.closeRecordStore();
            }
            if (byteArrayInputStream != null) {
                byteArrayInputStream.close();
            }
        }
        cursorI = Sheet.cursorI;
        cursorJ = Sheet.cursorJ;
        clipboardI = Sheet.clipboardI;
        clipboardJ = Sheet.clipboardJ;
        clipboardI2 = Sheet.clipboardI2;
        clipboardJ2 = Sheet.clipboardJ2;
        statusInfo = Sheet.statusInfo;
    }

    public static void saveSheet(Sheet sheet) throws RecordStoreException, IOException {
        if (!sheet.changed) {
            return;
        }
        MicroCalcCanvas.saveSheet(sheet, sheet.name);
        sheet.changed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveSheet(Sheet sheet, String string) throws IOException, RecordStoreException {
        if (string == null) {
            string = "Untitled";
        }
        if (string.compareTo(sheet.name) == 0 && !sheet.changed) {
            return;
        }
        sheet.name = string;
        try {
            RecordStore.deleteRecordStore((String)("ff_" + sheet.name));
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            // empty catch block
        }
        RecordStore recordStore = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            recordStore = RecordStore.openRecordStore((String)("ff_" + sheet.name), (boolean)true, (int)1, (boolean)true);
            byteArrayOutputStream = new ByteArrayOutputStream();
            ++sheet.serverVersion;
            sheet.saveSheet(byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            recordStore.addRecord(byArray, 0, 6);
            recordStore.addRecord(byArray, 6, byArray.length - 6);
        }
        finally {
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
            if (recordStore != null) {
                recordStore.closeRecordStore();
            }
        }
        sheet.changed = false;
    }

    public static void deleteSheet(String string) {
        try {
            RecordStore.deleteRecordStore((String)("ff_" + string));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addCmds(Displayable displayable) {
        displayable.addCommand(okEditCommand);
        displayable.addCommand(cancelEditCommand);
        displayable.setCommandListener((CommandListener)this);
        this.display.setCurrent(displayable);
    }

    public static void deleteSheet(Sheet sheet) throws RecordStoreException {
        MicroCalcCanvas.deleteSheet(sheet.name);
        sheet.rows = Sheet.newRows;
        sheet.columns = Sheet.newColumns;
        sheet.allocate();
        sheet.clearSheet();
        sheet.name = "Untitled";
    }

    void setCurrent() {
        this.display.setCurrent((Displayable)this);
    }

    public void setStatusLine(String string) {
        this.statusLine = string;
        this.repaint(0, 0, this.sizeX, this.sizeY);
    }

    public String getStatusInfo(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(Result.cellAddress(n, n2, 0));
        stringBuffer.append(": ");
        stringBuffer.append(this.sheet.getCell((int)n, (int)n2).str);
        return stringBuffer.toString();
    }

    private boolean intersect(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = n > n5 ? n : n5;
        int n10 = n3 < n7 ? n3 : n7;
        int n11 = n2 > n6 ? n2 : n6;
        int n12 = n4 < n8 ? n4 : n8;
        return n9 < n10 && n11 < n12;
    }

    static {
        clipboardI = -1;
        clipboardJ = -1;
        clipboardI2 = -1;
        clipboardJ2 = -1;
        FONT_SIZE = 0;
    }
}

