/*
 * Decompiled with CFR 0.152.
 */
package com.wapindustrial.calc;

import com.wapindustrial.calc.BadFormulaException;
import com.wapindustrial.calc.MicroCalc;
import com.wapindustrial.calc.Sheet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import javax.microedition.rms.RecordStore;
import net.jscience.math.MathFP;

public final class Result {
    public static final byte TYPE_EMPTY = 0;
    public static final byte TYPE_BOOLEAN = 1;
    public static final byte TYPE_DATE = 2;
    public static final byte TYPE_LONG = 3;
    public static final byte TYPE_BCD = 4;
    public static final byte TYPE_STRING = 5;
    public static final byte TYPE_RANGE = 15;
    public static final byte OPER_UMIN = 20;
    public static final byte OPER_ADD = 21;
    public static final byte OPER_SUB = 22;
    public static final byte OPER_MUL = 23;
    public static final byte OPER_DIV = 24;
    public static final byte OPER_POW = 25;
    public static final byte OPER_CONCAT = 26;
    public static final byte OPER_EQ = 27;
    public static final byte OPER_NE = 28;
    public static final byte OPER_LT = 29;
    public static final byte OPER_GT = 30;
    public static final byte OPER_LE = 31;
    public static final byte OPER_GE = 32;
    public static final byte OPER_BRACK = 33;
    public static final byte TYPE_FUNC = 50;
    public static final byte TYPE_CELL = 51;
    public static final byte TYPE_ERROR = 100;
    private static final byte FUNC_SUM = 0;
    private static final byte FUNC_IF = 1;
    private static final byte FUNC_AND = 2;
    private static final byte FUNC_OR = 3;
    private static final byte FUNC_POW = 4;
    private static final byte FUNC_EXP = 5;
    private static final byte FUNC_LN = 6;
    private static final byte FUNC_SQRT = 7;
    private static final byte FUNC_SIN = 8;
    private static final byte FUNC_COS = 9;
    private static final byte FUNC_TAN = 10;
    private static final byte FUNC_COT = 11;
    private static final byte FUNC_ASIN = 12;
    private static final byte FUNC_ACOS = 13;
    private static final byte FUNC_ATAN = 14;
    private static final byte FUNC_ATAN2 = 15;
    private static final byte FUNC_ABS = 16;
    private static final byte FUNC_PI = 17;
    private static final byte FUNC_E = 18;
    private static final byte FUNC_PMT = 19;
    private static final byte FUNC_IPMT = 20;
    private static final byte FUNC_PPMT = 21;
    private static final byte FUNC_INFO = 22;
    private static final byte FUNC_CELL = 23;
    private static final byte FUNC_TYPE = 24;
    private static final byte FUNC_FRAC = 25;
    private static final byte FUNC_TRUNC = 26;
    private static final byte FUNC_ROUND = 27;
    private static final byte FUNC_EXACT = 28;
    private static final byte FUNC_NOT = 29;
    private static final byte FUNC_RATE = 30;
    private static final byte FUNC_COUNT = 31;
    private static final byte FUNC_TRIM = 32;
    private static final byte FUNC_UPPER = 33;
    private static final byte FUNC_LOWER = 34;
    private static final byte FUNC_MID = 35;
    private static final byte FUNC_NPER = 36;
    private static final byte FUNC_VALUE = 37;
    private static final byte FUNC_TEXT = 38;
    private static final String[] FUNCTION_NAMES = new String[]{"SUM", "IF", "AND", "OR", "POW", "EXP", "LN", "SQRT", "SIN", "COS", "TAN", "COT", "ASIN", "ACOS", "ATAN", "ATAN2", "ABS", "PI", "E", "PMT", "IPMT", "PPMT", "INFO", "CELL", "TYPE", "FRAC", "TRUNC", "ROUND", "EXACT", "NOT", "RATE", "COUNT", "TRIM", "UPPER", "LOWER", "MID", "NPER", "VALUE", "TEXT"};
    private static final String MSG_INTERNAL_ERROR = "Internal error";
    private static final String MSG_ILLEGAL_DATE_OPER = "Illegal date operation";
    private static final String MSG_WRONG_ARG_NUMBER = "Wrong number of arguments in function";
    private static final String MSG_WRONG_ARG_TYPE = "Wrong type of function argument";
    public static final short FORMAT_JUSTIFY_LEFT = 4096;
    public static final short FORMAT_JUSTIFY_RIGHT = 8192;
    public static short FORMAT_NUMBER = (short)16;
    public static final short FORMAT_NUMBER_SEP = 256;
    public static final short FORMAT_BRACKETS = 512;
    public static int FORMAT_DATE = 0;
    public static final byte ABS_I1 = 1;
    public static final byte ABS_J1 = 2;
    public static final byte ABS_I2 = 4;
    public static final byte ABS_J2 = 8;
    public static final byte CALCULATED = 16;
    public static final byte FORMULA = 32;
    private static final String EMPTY_FORMULA = "";
    private static final long DAY_BCD_MS_LONG = 86400000L;
    private static final long DAY_BCD_MS = 86400000L;
    private static final Result[] FUNCARGS_ZERO = new Result[0];
    public static final Result RESULT_ERROR = new Result(100);
    public static final Result RESULT_EMPTY = new Result(0);
    public byte type;
    public long ll;
    public String str = "";
    public short i1;
    public short i2;
    public short j1;
    public short j2;
    public byte absolute = 0;
    public Result[] funcargs = FUNCARGS_ZERO;
    private static char[] buf;
    private static int nBuf;
    private static boolean inExpression;
    private static StringBuffer sBuf;
    private static final String MSG_FUNCTION = "Missing ')' in function";
    private static final String MSG_DATE = "Bad date format (must be DD/MM/YYYY)";

    public Result() {
        this.type = 0;
    }

    public Result(byte by) {
        this.type = by;
    }

    public Result(byte by, long l) {
        this.type = by;
        this.ll = l;
    }

    public Result(long l) {
        this.type = (byte)3;
        this.ll = l;
    }

    public Result(String string) {
        this.type = (byte)5;
        this.str = string;
    }

    Result(boolean bl) {
        this.type = 1;
        this.ll = bl ? 1L : 0L;
    }

    public Result(short s, short s2, short s3, short s4, byte by) {
        this.type = (byte)15;
        this.i1 = s;
        this.j1 = s2;
        this.i2 = s3;
        this.j2 = s4;
        this.absolute = by;
        this.normalizeRange();
    }

    public Result(byte by, Result result, Result result2) {
        this.type = by;
        if (result2 != null) {
            this.funcargs = new Result[2];
            this.funcargs[0] = result;
            this.funcargs[1] = result2;
        } else {
            this.funcargs = new Result[1];
            this.funcargs[0] = result;
        }
    }

    public Result(byte by, Result[] resultArray) {
        this.type = (byte)50;
        this.ll = by;
        this.funcargs = resultArray;
    }

    public Result(Result result) {
        if (result == null) {
            return;
        }
        this.type = result.type;
        this.ll = result.ll;
        this.i1 = result.i1;
        this.j1 = result.j1;
        this.i2 = result.i2;
        this.j2 = result.j2;
        this.absolute = result.absolute;
        this.str = result.str;
        this.funcargs = result.funcargs;
    }

    public Result(DataInputStream dataInputStream, int n) throws BadFormulaException, IOException {
        this.type = dataInputStream.readByte();
        switch (this.type) {
            case 0: 
            case 100: {
                break;
            }
            case 1: {
                this.ll = dataInputStream.readByte();
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.ll = dataInputStream.readLong();
                break;
            }
            case 5: {
                this.str = dataInputStream.readUTF();
                break;
            }
            default: {
                throw new BadFormulaException(MSG_INTERNAL_ERROR);
            }
        }
    }

    public static Result restoreCell(DataInputStream dataInputStream, int n) throws BadFormulaException, IOException {
        short s = dataInputStream.readShort();
        short s2 = dataInputStream.readShort();
        Result result = new Result(dataInputStream, n);
        long l = dataInputStream.readShort();
        String string = dataInputStream.readUTF();
        Result result2 = Result.createCell(s, s2, string, result);
        result2.ll = l;
        return result2;
    }

    public void save(DataOutputStream dataOutputStream, boolean bl) throws IOException {
        if (bl) {
            dataOutputStream.writeByte(this.type);
        }
        switch (this.type) {
            case 0: 
            case 100: {
                break;
            }
            case 1: {
                dataOutputStream.writeByte((byte)this.ll);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                dataOutputStream.writeLong(this.ll);
                break;
            }
            case 5: {
                dataOutputStream.writeUTF(this.str);
                break;
            }
            case 51: {
                dataOutputStream.writeShort(this.i1);
                dataOutputStream.writeShort(this.j1);
                this.funcargs[0].save(dataOutputStream, true);
                dataOutputStream.writeShort((short)this.ll);
                dataOutputStream.writeUTF(this.str);
                break;
            }
            default: {
                throw new IOException(MSG_INTERNAL_ERROR);
            }
        }
    }

    public static String commas(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        StringBuffer stringBuffer2 = new StringBuffer(string);
        if ((n & 0x100) != 0 && string.indexOf("#NUM#") < 0) {
            int n2;
            for (n2 = stringBuffer.length() - 1; n2 >= 0 && stringBuffer.charAt(n2) != '.'; --n2) {
            }
            if (n2 == -1) {
                n2 = stringBuffer.length();
            }
            if (n2 > 9) {
                stringBuffer2.insert(n2 - 3, ',');
                stringBuffer2.insert(n2 - 6, ',');
                stringBuffer2.insert(n2 - 9, ',');
            } else if (n2 > 6) {
                stringBuffer2.insert(n2 - 3, ',');
                stringBuffer2.insert(n2 - 6, ',');
            } else if (n2 > 3) {
                stringBuffer2.insert(n2 - 3, ',');
            }
        }
        return stringBuffer2.toString();
    }

    public String toString() {
        return this.toString(false, 0);
    }

    public String toString(boolean bl, int n) {
        String string = EMPTY_FORMULA;
        String string2 = null;
        String string3 = null;
        if (this.funcargs.length > 0) {
            string2 = this.funcargs[0].toString(true, 0);
        }
        if (this.funcargs.length > 1) {
            string3 = this.funcargs[1].toString(true, 0);
        }
        switch (this.type) {
            case 0: {
                string = EMPTY_FORMULA;
                break;
            }
            case 1: {
                string = Result.booleanToString(this.ll);
                break;
            }
            case 2: {
                string = Result.dateToString(this.ll);
                if (!bl) break;
                string = '#' + string + '#';
                break;
            }
            case 3: {
                string = Long.toString(this.ll) + "L";
                break;
            }
            case 4: {
                if ((n & FORMAT_NUMBER) != 0) {
                    int n2 = n << 28;
                    n2 >>= 28;
                    boolean bl2 = false;
                    if (this.ll < 0L && (n & 0x200) != 0) {
                        string = Result.commas(MathFP.toString(-this.ll, n2, n2), n);
                        string = "(" + string + ")";
                        break;
                    }
                    string = Result.commas(MathFP.toString(this.ll, n2, n2), n);
                    break;
                }
                string = Result.commas(MathFP.toString(this.ll, MicroCalc.DEFAULT_PRECISION, MicroCalc.DEFAULT_PRECISION), n);
                break;
            }
            case 5: {
                string = this.str;
                if (!bl) break;
                string = '\"' + string + '\"';
                break;
            }
            case 15: {
                string = Result.rangeAddress(this.i1, this.j1, this.i2, this.j2, this.absolute);
                break;
            }
            case 20: {
                string = '-' + string2;
                break;
            }
            case 21: {
                string = string2 + '+' + string3;
                break;
            }
            case 22: {
                string = string2 + '-' + string3;
                break;
            }
            case 23: {
                string = string2 + '*' + string3;
                break;
            }
            case 24: {
                string = string2 + '/' + string3;
                break;
            }
            case 25: {
                string = string2 + '^' + string3;
                break;
            }
            case 26: {
                string = string2 + '&' + string3;
                break;
            }
            case 27: {
                string = string2 + '=' + string3;
                break;
            }
            case 28: {
                string = string2 + "<>" + string3;
                break;
            }
            case 29: {
                string = string2 + '<' + string3;
                break;
            }
            case 30: {
                string = string2 + '>' + string3;
                break;
            }
            case 31: {
                string = string2 + "<=" + string3;
                break;
            }
            case 32: {
                string = string2 + ">=" + string3;
                break;
            }
            case 33: {
                string = '(' + string2 + ')';
                break;
            }
            case 50: {
                string = FUNCTION_NAMES[(int)this.ll] + '(';
                for (int i = 0; i < this.funcargs.length; ++i) {
                    string = string + this.funcargs[i].toString(true, 0);
                    if (i == this.funcargs.length - 1) continue;
                    string = string + ',';
                }
                string = string + ')';
                break;
            }
            case 100: {
                string = "#ERR#";
            }
        }
        return string;
    }

    private void normalizeRange() {
        short s;
        if (this.i1 > this.i2) {
            s = this.i1;
            this.i1 = this.i2;
            this.i2 = s;
            this.absolute = (byte)(this.absolute & 0xFFFFFFFA | this.absolute & 4 | this.absolute & 1);
        }
        if (this.j1 > this.j2) {
            s = this.j1;
            this.j1 = this.j2;
            this.j2 = s;
            this.absolute = (byte)(this.absolute & 0xFFFFFFF5 | this.absolute & 8 | this.absolute & 2);
        }
        if (this.i1 == this.i2) {
            this.absolute = (byte)(this.absolute & 0xFFFFFFFB | (this.absolute & 1) << 2);
        }
        if (this.j1 == this.j2) {
            this.absolute = (byte)(this.absolute & 0xFFFFFFF7 | (this.absolute & 2) << 2);
        }
    }

    public static String columnName(int n) {
        StringBuffer stringBuffer = new StringBuffer(2);
        int n2 = n / 26;
        if (n2 > 0) {
            stringBuffer.append((char)(65 + n2 - 1));
        }
        stringBuffer.append((char)(65 + (n %= 26)));
        return stringBuffer.toString();
    }

    public static String cellAddress(int n, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer(10);
        if ((n3 & 2) != 0) {
            stringBuffer.append('$');
        }
        stringBuffer.append(Result.columnName(n2));
        if ((n3 & 1) != 0) {
            stringBuffer.append('$');
        }
        stringBuffer.append(String.valueOf(n + 1));
        return stringBuffer.toString();
    }

    public static String rangeAddress(int n, int n2, int n3, int n4, int n5) {
        StringBuffer stringBuffer = new StringBuffer(Result.cellAddress(n, n2, n5));
        if (n != n3 || n2 != n4) {
            stringBuffer.append(':');
            stringBuffer.append(Result.cellAddress(n3, n4, n5 >> 2));
        }
        return stringBuffer.toString();
    }

    public static Result parseAddress(String string) throws BadFormulaException {
        byte[] byArray = string.toUpperCase().getBytes();
        int n = 0;
        try {
            char c;
            byte by = 0;
            short s = 0;
            short s2 = 0;
            if (byArray[0] == 36) {
                n = 1;
                by = 2;
            }
            while (!Character.isDigit(c = (char)byArray[n]) && c != '$') {
                if (c < 'A' || c > 'Z') {
                    throw new Exception();
                }
                s = (short)(s * 25);
                s = (short)(s + (short)(c - 65));
                ++n;
                if (s < 625) continue;
                throw new Exception();
            }
            if (n >= byArray.length) {
                throw new Exception();
            }
            if (c == '$') {
                ++n;
                by = (byte)(by | 1);
            }
            while (n < byArray.length && Character.isDigit(c = (char)byArray[n])) {
                s2 = (short)(s2 * 10);
                s2 = (short)(s2 + (short)(c - 48));
                ++n;
            }
            if ((s2 = (short)((short)(s2 - 1))) < 0) {
                throw new Exception();
            }
            if (n == byArray.length) {
                return new Result(s2, s, s2, s, by);
            }
            if (c == ':') {
                if (string.indexOf(58, n + 1) != -1) {
                    throw new Exception();
                }
                Result result = Result.parseAddress(string.substring(n + 1));
                result.i1 = s2;
                result.j1 = s;
                result.absolute = (byte)(result.absolute << 2 | by);
                result.normalizeRange();
                return result;
            }
            if (n != byArray.length) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new BadFormulaException("Illegal cell address [" + string + "]");
    }

    private Result sumRange(Sheet sheet) throws BadFormulaException {
        Result result = new Result(4);
        for (int i = this.i1; i <= this.i2; ++i) {
            for (int j = this.j1; j <= this.j2; ++j) {
                Result result2 = sheet.getCellValue(i, j);
                if (result2.type == 0 || result2.type == 5) continue;
                result = Result.operation(21, result, result2);
            }
        }
        return result;
    }

    private Result countRange(Sheet sheet) throws BadFormulaException {
        Result result = new Result(4);
        Result result2 = new Result(4, MathFP.ONE);
        for (int i = this.i1; i <= this.i2; ++i) {
            for (int j = this.j1; j <= this.j2; ++j) {
                if (sheet.getCellValue((int)i, (int)j).type != 4) continue;
                result = Result.operation(21, result, result2);
            }
        }
        return result;
    }

    private Result toMaxType(int n) throws BadFormulaException {
        if (this.type < n) {
            if (n == 5) {
                String string = EMPTY_FORMULA;
                if (this.type == 1) {
                    string = Result.booleanToString(this.ll);
                }
                if (this.type == 2) {
                    string = Result.dateToString(this.ll);
                }
                if (this.type == 3) {
                    string = Long.toString(this.ll);
                }
                if (this.type == 4) {
                    string = EMPTY_FORMULA + this.ll;
                }
                return new Result(string);
            }
            if (n == 4) {
                long l = 0L;
                if (this.type == 1 && this.ll != 0L) {
                    l = MathFP.ONE;
                }
                if (this.type == 2) {
                    l = MathFP.div(this.ll, 86400000L);
                }
                if (this.type == 3) {
                    l = this.ll;
                }
                return Result.createFloat(l);
            }
            if (n == 3) {
                long l = 0L;
                if (this.type == 1 || this.type == 2) {
                    l = this.ll;
                }
                return new Result(l);
            }
            if (n == 2) {
                long l = 0L;
                if (this.type == 1) {
                    throw new BadFormulaException("Cannot convert boolean to datetime");
                }
                return new Result(2, l);
            }
            if (n == 1 && this.type == 0) {
                return new Result(false);
            }
            if (n == 100) {
                return RESULT_ERROR;
            }
        }
        return this;
    }

    public static String booleanToString(long l) {
        return l != 0L ? "TRUE" : "FALSE";
    }

    public static String dateToString(long l) {
        StringBuffer stringBuffer = new StringBuffer(20);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(l));
        int n = calendar.get(1);
        int n2 = calendar.get(5);
        int n3 = calendar.get(2) + 1;
        String string = "/";
        if (FORMAT_DATE == 3) {
            string = " ";
        }
        if (n2 < 10 && FORMAT_DATE < 2) {
            stringBuffer.append('0');
        }
        stringBuffer.append(Integer.toString(n2));
        stringBuffer.append(string);
        if (n3 < 10 && FORMAT_DATE < 2) {
            stringBuffer.append('0');
        }
        String string2 = Integer.toString(n3);
        if (FORMAT_DATE == 3) {
            String[] stringArray = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
            string2 = stringArray[n3 - 1];
        }
        stringBuffer.append(string2);
        stringBuffer.append(string);
        string2 = Integer.toString(n);
        if (FORMAT_DATE == 0 || FORMAT_DATE == 2) {
            string2 = string2.substring(2);
        }
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    public static long bcdToMillis(long l) {
        return MathFP.mul(l, 86400000L);
    }

    public static long millisToBcd(long l) {
        return MathFP.div(l, 86400000L);
    }

    public static Result operation(int n, Result result, Result result2) throws BadFormulaException {
        boolean bl;
        if (!result.isConstant() || !result2.isConstant()) {
            throw new BadFormulaException(MSG_INTERNAL_ERROR);
        }
        boolean bl2 = result.type == 2;
        boolean bl3 = bl = result2.type == 2;
        if (bl2 || bl) {
            if (bl2 && bl) {
                if (n != 22 && (n < 27 || n > 32)) {
                    throw new BadFormulaException(MSG_ILLEGAL_DATE_OPER);
                }
            } else {
                if (n != 22 && n != 21) {
                    throw new BadFormulaException(MSG_ILLEGAL_DATE_OPER);
                }
                Result result3 = bl2 ? result : result2;
                result2 = bl2 ? result2 : result;
                result = result3;
                if (result2.type != 5) {
                    if (result2.type == 3) {
                        return new Result(2, n == 21 ? result.ll + result2.ll : result.ll - result2.ll);
                    }
                    if (result2.type == 4) {
                        long l = Result.bcdToMillis(result2.ll);
                        l = n == 21 ? result.ll + l : result.ll - l;
                        Result result4 = new Result(2, l);
                        return result4;
                    }
                    if (result2.type == 0) {
                        return new Result(result);
                    }
                    throw new BadFormulaException(MSG_ILLEGAL_DATE_OPER);
                }
            }
        }
        if (n == 26) {
            result = result.toMaxType(5);
            result2 = result2.toMaxType(5);
        }
        result = result.toMaxType(result2.type);
        result2 = result2.toMaxType(result.type);
        byte by = result.type;
        if (by == 100 || by == 0) {
            return result;
        }
        switch (n) {
            case 27: {
                return new Result(result.equals(result2));
            }
            case 28: {
                return new Result(!result.equals(result2));
            }
            case 21: {
                if (by == 3 || by == 1) {
                    return new Result(result.ll + result2.ll);
                }
                if (by == 4) {
                    return Result.createFloat(result.ll + result2.ll);
                }
                if (by == 5) {
                    return new Result(result.str + result2.str);
                }
            }
            case 22: {
                if (by == 2) {
                    return Result.createFloat(MathFP.div(MathFP.toFP(result.ll - result2.ll), 86400000L));
                }
                if (by == 3 || by == 1) {
                    return new Result(result.ll - result2.ll);
                }
                if (by == 4) {
                    return Result.createFloat(result.ll - result2.ll);
                }
                if (by == 5) {
                    return RESULT_ERROR;
                }
            }
            case 23: {
                if (by == 3 || by == 1) {
                    return new Result(result.ll * result2.ll);
                }
                if (by == 4) {
                    return Result.createFloat(MathFP.mul(result.ll, result2.ll));
                }
                if (by == 5) {
                    return RESULT_ERROR;
                }
            }
            case 24: {
                if (by == 1) {
                    return RESULT_ERROR;
                }
                if (by == 3) {
                    return new Result(result.ll / result2.ll);
                }
                if (by == 4) {
                    return Result.createFloat(MathFP.div(result.ll, result2.ll));
                }
                if (by == 5) {
                    return RESULT_ERROR;
                }
            }
            case 25: {
                if (by == 1) {
                    return RESULT_ERROR;
                }
                if (by == 3) {
                    return new Result(MathFP.pow(result.ll, result2.ll));
                }
                if (by == 4) {
                    return new Result(4, MathFP.pow(result.ll, result2.ll));
                }
                if (by == 5) {
                    return RESULT_ERROR;
                }
            }
            case 26: {
                return new Result(result.str + result2.str);
            }
            case 31: {
                if (result.equals(result2)) {
                    return new Result(true);
                }
                if (by == 1) {
                    return new Result(result.ll == 0L);
                }
                if (by == 3 || by == 2) {
                    return new Result(result.ll <= result2.ll);
                }
                if (by == 4) {
                    return new Result(result.ll <= result2.ll);
                }
                if (by == 5) {
                    return new Result(result.str.length() < result2.str.length());
                }
            }
            case 29: {
                if (by == 1) {
                    return new Result(result.ll == 0L && result2.ll != 0L);
                }
                if (by == 3 || by == 2) {
                    return new Result(result.ll < result2.ll);
                }
                if (by == 4) {
                    return new Result(result.ll < result2.ll);
                }
                if (by == 5) {
                    return new Result(result.str.length() < result2.str.length());
                }
            }
            case 32: {
                if (result.equals(result2)) {
                    return new Result(true);
                }
                if (by == 1) {
                    return new Result(result.ll != 0L);
                }
                if (by == 3 || by == 2) {
                    return new Result(result.ll >= result2.ll);
                }
                if (by == 4) {
                    return new Result(result.ll >= result2.ll);
                }
                if (by == 5) {
                    return new Result(result.str.length() > result2.str.length());
                }
            }
            case 30: {
                if (by == 1) {
                    return new Result(result.ll != 0L && result2.ll == 0L);
                }
                if (by == 3 || by == 2) {
                    return new Result(result.ll > result2.ll);
                }
                if (by == 4) {
                    return new Result(result.ll > result2.ll);
                }
                if (by != 5) break;
                return new Result(result.str.length() > result2.str.length());
            }
        }
        throw new BadFormulaException(MSG_INTERNAL_ERROR);
    }

    public boolean equals(Result result) {
        return this.toString().compareTo(result.toString()) == 0;
    }

    public boolean isOperator() {
        return this.type >= 20 && this.type <= 32;
    }

    public boolean isConstant() {
        return this.type >= 0 && this.type <= 5 || this.type == 100;
    }

    public Result calculate(Sheet sheet) throws BadFormulaException {
        if (this.isConstant()) {
            return this;
        }
        if (this.type == 15) {
            if (this.i1 >= sheet.rows || this.j2 >= sheet.rows || this.j1 >= sheet.columns || this.j2 >= sheet.columns) {
                throw new BadFormulaException("Reference outside the sheet");
            }
            return sheet.getCell((int)this.i1, (int)this.j1).funcargs[0];
        }
        Result result = null;
        Result result2 = null;
        if (this.funcargs.length > 0) {
            result = this.funcargs[0].calculate(sheet);
        }
        if (this.funcargs.length > 1) {
            result2 = this.funcargs[1].calculate(sheet);
        }
        if (this.type == 33) {
            return result;
        }
        if (this.type == 20) {
            switch (result.type) {
                case 3: {
                    return new Result(3, -result.ll);
                }
                case 4: {
                    return Result.createFloat(-result.ll);
                }
            }
            throw new BadFormulaException("Unary minus with unsupported data type");
        }
        if (this.isOperator()) {
            return Result.operation(this.type, result, result2);
        }
        if (this.type == 50) {
            return this.calculateFunc(sheet);
        }
        throw new BadFormulaException(MSG_INTERNAL_ERROR);
    }

    private Result calculateFunc(Sheet sheet) throws BadFormulaException {
        Result result = null;
        Result result2 = null;
        Result result3 = null;
        int n = (int)this.ll;
        String string = null;
        String string2 = null;
        switch (n) {
            case 18: {
                return Result.createFloat(MathFP.E);
            }
            case 17: {
                return Result.createFloat(MathFP.PI);
            }
            case 0: {
                Result result4 = new Result(0);
                for (int i = 0; i < this.funcargs.length; ++i) {
                    Result result5 = this.funcargs[i];
                    result5 = result5.type == 15 ? result5.sumRange(sheet) : result5.calculate(sheet);
                    result4 = Result.operation(21, result4, result5);
                }
                return result4;
            }
            case 31: {
                Result result6 = new Result(0);
                for (int i = 0; i < this.funcargs.length; ++i) {
                    Result result7 = this.funcargs[i];
                    if (result7.type == 15) {
                        result7 = result7.countRange(sheet);
                    }
                    result6 = Result.operation(21, result6, result7);
                }
                return result6;
            }
            case 1: {
                if (this.funcargs.length != 3) {
                    throw new BadFormulaException(MSG_WRONG_ARG_NUMBER);
                }
                result = this.funcargs[0].calculate(sheet).toMaxType(1);
                result2 = this.funcargs[1].calculate(sheet);
                Result result8 = this.funcargs[2].calculate(sheet);
                if (result.type != 1) {
                    throw new BadFormulaException(MSG_WRONG_ARG_TYPE);
                }
                return result.ll != 0L ? result2 : result8;
            }
            case 19: 
            case 36: {
                if (this.funcargs.length != 3) {
                    throw new BadFormulaException(MSG_WRONG_ARG_NUMBER);
                }
                result = this.funcargs[0].calculate(sheet).toMaxType(4);
                result2 = this.funcargs[1].calculate(sheet).toMaxType(4);
                Result result9 = this.funcargs[2].calculate(sheet).toMaxType(4);
                switch (n) {
                    case 19: {
                        return Result.createFloat(MathFP.pmt(result.ll, result2.ll, result9.ll));
                    }
                    case 36: {
                        return Result.createFloat(MathFP.nper(result.ll, result2.ll, result9.ll));
                    }
                }
            }
            case 30: {
                if (this.funcargs.length != 3) {
                    throw new BadFormulaException(MSG_WRONG_ARG_NUMBER);
                }
                result = this.funcargs[0].calculate(sheet).toMaxType(4);
                result2 = this.funcargs[1].calculate(sheet).toMaxType(4);
                Result result9 = this.funcargs[2].calculate(sheet).toMaxType(4);
                long l = MathFP.rate(result.ll, result2.ll, result9.ll);
                if (l == -MathFP.ONE) {
                    return new Result("#NUM#");
                }
                return Result.createFloat(MathFP.rate(result.ll, result2.ll, result9.ll));
            }
            case 20: 
            case 21: {
                if (this.funcargs.length != 4) {
                    throw new BadFormulaException(MSG_WRONG_ARG_NUMBER);
                }
                result = this.funcargs[0].calculate(sheet).toMaxType(4);
                result3 = this.funcargs[1].calculate(sheet).toMaxType(4);
                result2 = this.funcargs[2].calculate(sheet).toMaxType(4);
                Result result10 = this.funcargs[3].calculate(sheet).toMaxType(4);
                switch (n) {
                    case 20: {
                        return Result.createFloat(MathFP.ipmt(result.ll, result3.ll, result2.ll, result10.ll));
                    }
                    case 21: {
                        return Result.createFloat(MathFP.ppmt(result.ll, result3.ll, result2.ll, result10.ll));
                    }
                }
            }
            case 22: {
                if (this.funcargs.length != 1) {
                    throw new BadFormulaException(MSG_WRONG_ARG_NUMBER);
                }
                result = this.funcargs[0].calculate(sheet).toMaxType(4);
                string = result.str.toUpperCase().trim();
                Runtime.getRuntime().gc();
                int n2 = 0;
                try {
                    RecordStore recordStore = RecordStore.openRecordStore((String)"mc_prefs", (boolean)true);
                    n2 = recordStore.getSizeAvailable();
                    recordStore.closeRecordStore();
                    recordStore = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                string = string.equals("TOTMEM") ? EMPTY_FORMULA + Runtime.getRuntime().totalMemory() : (string.equals("MEMAVAIL") ? EMPTY_FORMULA + Runtime.getRuntime().freeMemory() : (string.equals("RECAVAIL") ? EMPTY_FORMULA + n2 : (string.equals("RELEASE") ? "v1.1  21/12/07" : (string.equals("AUTHOR") ? "Created by Michael Alsop from\nMicroCalc1 by Michael Zemljanukha 2003,\nMathFP by Dan Carter 2004,\nand LCDFont by Roar Lauritzsen 2005" : (string.equals("SYSTEM") ? System.getProperty("microedition.profiles") + "   " + System.getProperty("microedition.configuration") : "Try TOTMEM , MEMAVAIL , RECAVAIL , RELEASE , AUTHOR or SYSTEM")))));
                return new Result(string);
            }
            case 28: {
                if (this.funcargs.length != 2) {
                    throw new BadFormulaException(MSG_WRONG_ARG_NUMBER);
                }
                result = this.funcargs[0].calculate(sheet).toMaxType(5);
                string = result.str.trim();
                result2 = this.funcargs[1].calculate(sheet).toMaxType(5);
                string2 = result2.str.trim();
                boolean bl = false;
                if (string.equals(string2)) {
                    bl = true;
                }
                return new Result(bl);
            }
            case 32: 
            case 33: 
            case 34: 
            case 37: {
                if (this.funcargs.length != 1) {
                    throw new BadFormulaException(MSG_WRONG_ARG_NUMBER);
                }
                result = this.funcargs[0].calculate(sheet).toMaxType(5);
                string = result.str;
                switch (n) {
                    case 32: {
                        string = string.trim();
                        break;
                    }
                    case 33: {
                        string = string.toUpperCase();
                        break;
                    }
                    case 34: {
                        string = string.toLowerCase();
                        break;
                    }
                    case 37: {
                        string = string.trim();
                        return Result.createFloat(MathFP.toFP(string));
                    }
                }
                return new Result(string);
            }
            case 35: {
                if (this.funcargs.length != 3) {
                    throw new BadFormulaException(MSG_WRONG_ARG_NUMBER);
                }
                result = this.funcargs[0].calculate(sheet).toMaxType(5);
                string = result.str;
                result2 = this.funcargs[1].calculate(sheet).toMaxType(4);
                Result result11 = this.funcargs[2].calculate(sheet).toMaxType(4);
                int n3 = 0;
                int n4 = 0;
                try {
                    long l = result2.ll / MathFP.ONE;
                    n3 = (int)l;
                    l = result11.ll / MathFP.ONE;
                    n4 = (int)l;
                    string = string.substring(n3 - 1, n3 + n4 - 1);
                }
                catch (Exception exception) {
                    string = "#ERR#";
                }
                return new Result(string);
            }
            case 23: {
                if (this.funcargs.length != 1) {
                    throw new BadFormulaException(MSG_WRONG_ARG_NUMBER);
                }
                result = this.funcargs[0];
                result3 = sheet.getCell(result.i1, result.j1);
                string = Long.toString(result3.ll, 16);
                string = "0x0000".substring(0, 6 - string.length()) + string;
                return new Result(string);
            }
            case 24: {
                if (this.funcargs.length != 1) {
                    throw new BadFormulaException(MSG_WRONG_ARG_NUMBER);
                }
                result = this.funcargs[0];
                result3 = sheet.getCell(result.i1, result.j1);
                string = "OTHER";
                switch (result3.funcargs[0].type) {
                    case 0: {
                        string = "EMPTY";
                        break;
                    }
                    case 1: {
                        string = "LOGIC";
                        break;
                    }
                    case 2: {
                        string = "DATE";
                        break;
                    }
                    case 4: {
                        string = "VALUE";
                        break;
                    }
                    case 5: {
                        string = "TEXT";
                        break;
                    }
                    case 100: {
                        string = "ERROR";
                    }
                }
                return new Result(string);
            }
            case 4: 
            case 15: {
                if (this.funcargs.length != 2) {
                    throw new BadFormulaException(MSG_WRONG_ARG_NUMBER);
                }
                result = this.funcargs[0].calculate(sheet).toMaxType(4);
                result2 = this.funcargs[1].calculate(sheet).toMaxType(4);
                long l = n == 4 ? MathFP.pow(result.ll, result2.ll) : MathFP.atan2(result.ll, result2.ll);
                return Result.createFloat(l);
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 25: 
            case 26: 
            case 27: 
            case 38: {
                if (this.funcargs.length != 1) {
                    throw new BadFormulaException(MSG_WRONG_ARG_NUMBER);
                }
                result = this.funcargs[0].calculate(sheet).toMaxType(4);
                if (result.type != 4) {
                    throw new BadFormulaException(MSG_WRONG_ARG_TYPE);
                }
                long l = result.ll;
                switch (n) {
                    case 8: {
                        return Result.createFloat(MathFP.sin(l));
                    }
                    case 9: {
                        return Result.createFloat(MathFP.cos(l));
                    }
                    case 10: {
                        return Result.createFloat(MathFP.tan(l));
                    }
                    case 11: {
                        return Result.createFloat(MathFP.cos(l));
                    }
                    case 5: {
                        return new Result(4, MathFP.exp(l));
                    }
                    case 6: {
                        return new Result(4, MathFP.log(l));
                    }
                    case 7: {
                        return Result.createFloat(MathFP.sqrt(l));
                    }
                    case 16: {
                        return new Result(4, l < 0L ? -l : l);
                    }
                    case 12: {
                        return Result.createFloat(MathFP.asin(l));
                    }
                    case 13: {
                        return Result.createFloat(MathFP.acos(l));
                    }
                    case 14: {
                        return Result.createFloat(MathFP.atan(l));
                    }
                    case 25: {
                        return Result.createFloat(MathFP.frac(l));
                    }
                    case 26: {
                        return Result.createFloat(MathFP.trunc(l));
                    }
                    case 27: {
                        return Result.createFloat(MathFP.round(l));
                    }
                    case 38: {
                        result3 = sheet.getCell(this.funcargs[0].i1, this.funcargs[0].j1);
                        return new Result(result.toString(false, (int)result3.ll));
                    }
                }
                break;
            }
            case 29: {
                if (this.funcargs.length != 1) {
                    throw new BadFormulaException(MSG_WRONG_ARG_NUMBER);
                }
                result = this.funcargs[0].calculate(sheet).toMaxType(1);
                boolean bl = result.ll == 0L;
                return new Result(bl);
            }
            case 2: 
            case 3: {
                boolean bl;
                boolean bl2 = bl = n == 2;
                if (this.funcargs.length != 2) {
                    throw new BadFormulaException(MSG_WRONG_ARG_NUMBER);
                }
                boolean bl3 = bl;
                for (int i = 0; i < this.funcargs.length; ++i) {
                    Result result12 = this.funcargs[i].calculate(sheet).toMaxType(1);
                    if (result12.type != 1) {
                        throw new BadFormulaException(MSG_WRONG_ARG_TYPE);
                    }
                    bl3 = bl ? bl3 && result12.ll != 0L : bl3 || result12.ll != 0L;
                }
                return new Result(bl3);
            }
        }
        throw new BadFormulaException(MSG_INTERNAL_ERROR);
    }

    private static char get1() {
        char c;
        while ((c = buf[nBuf++]) == ' ' || c == '\t' || c == '\n') {
        }
        return c;
    }

    private static void unget1() {
        --nBuf;
    }

    private static boolean isLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '_';
    }

    public static Result Evaluate(String string) throws BadFormulaException {
        Result result;
        int n = string.length();
        buf = new char[n + 1];
        string.getChars(0, n, buf, 0);
        Result.buf[n] = '\u0000';
        nBuf = 0;
        if (Result.get1() == '=') {
            result = Result.f_comp();
            if (Result.get1() != '\u0000') {
                throw new BadFormulaException("Bad expression");
            }
        } else {
            Result.unget1();
            try {
                result = Result.f_const();
                if (Result.get1() != '\u0000') {
                    throw new BadFormulaException();
                }
            }
            catch (BadFormulaException badFormulaException) {
                result = new Result(string);
            }
        }
        buf = null;
        return result;
    }

    private static Result f_comp() throws BadFormulaException {
        Result result = Result.f_comp1();
        while (Result.get1() == '&') {
            result = new Result(26, result, Result.f_comp1());
        }
        Result.unget1();
        return result;
    }

    private static Result f_comp1() throws BadFormulaException {
        char c;
        Result result = Result.f_add();
        while ((c = Result.get1()) == '=' || c == '<' || c == '>' || c == '!') {
            int n = 27;
            if (c == '!') {
                if (buf[nBuf++] != '=') {
                    throw new BadFormulaException("Expected '!=' statement");
                }
                n = 28;
            } else if (c == '<' && buf[nBuf] == '>') {
                n = 28;
                ++nBuf;
            } else if (c != '=') {
                if (buf[nBuf] == '=') {
                    ++nBuf;
                    n = c == '>' ? 32 : 31;
                } else {
                    n = c == '>' ? 30 : 29;
                }
            }
            Result result2 = Result.f_add();
            result = new Result((byte)n, result, result2);
        }
        Result.unget1();
        return result;
    }

    private static Result f_add() throws BadFormulaException {
        char c;
        Result result = Result.f_mul();
        while ((c = Result.get1()) == '+' || c == '-') {
            Result result2 = Result.f_mul();
            result = new Result(c == '+' ? (byte)21 : 22, result, result2);
        }
        Result.unget1();
        return result;
    }

    private static Result f_mul() throws BadFormulaException {
        char c;
        Result result = Result.f_pow();
        while ((c = Result.get1()) == '*' || c == '/') {
            Result result2 = Result.f_pow();
            result = new Result(c == '*' ? (byte)23 : 24, result, result2);
        }
        Result.unget1();
        return result;
    }

    private static Result f_pow() throws BadFormulaException {
        Result result = Result.f_uminus();
        while (Result.get1() == '^') {
            Result result2 = Result.f_pow();
            result = new Result(25, result, result2);
        }
        Result.unget1();
        return result;
    }

    private static Result f_uminus() throws BadFormulaException {
        if (Result.get1() == '-') {
            return new Result(20, Result.f_brackets(), null);
        }
        Result.unget1();
        return Result.f_brackets();
    }

    private static Result f_brackets() throws BadFormulaException {
        if (Result.get1() == '(') {
            Result result = Result.f_comp();
            if (Result.get1() != ')') {
                throw new BadFormulaException("missing ')'");
            }
            return new Result(33, result, null);
        }
        Result.unget1();
        return Result.f_name();
    }

    private static Result f_const() throws BadFormulaException {
        char c = Result.get1();
        Result.unget1();
        if (c == '\'') {
            return Result.f_const_string1();
        }
        if (c == '-') {
            c = Result.get1();
            Result result = Result.f_const_numeric();
            if (result.type == 3 || result.type == 4) {
                result.ll = -result.ll;
            }
            return result;
        }
        if (Character.isDigit(c)) {
            int n = nBuf;
            while ((c = buf[n++]) != '\u0000') {
                if (c != '/' && c != ':') continue;
                return Result.f_const_date();
            }
            return Result.f_const_numeric();
        }
        StringBuffer stringBuffer = new StringBuffer(10);
        while (Result.isLetter(c = buf[nBuf++]) || Character.isDigit(c)) {
            stringBuffer.append(c);
        }
        Result.unget1();
        String string = stringBuffer.toString().toUpperCase();
        if (string.compareTo("TRUE") == 0) {
            return new Result(true);
        }
        if (string.compareTo("FALSE") == 0) {
            return new Result(false);
        }
        throw new BadFormulaException();
    }

    private static Result f_name() throws BadFormulaException {
        char c = Result.get1();
        if (c == '#') {
            Result result = Result.f_const_date();
            if (Result.get1() != '#') {
                throw new BadFormulaException("Expected trailing '#' in date constant");
            }
            return result;
        }
        Result.unget1();
        if (c == '\"') {
            return Result.f_const_string();
        }
        if (Character.isDigit(c)) {
            return Result.f_const_numeric();
        }
        StringBuffer stringBuffer = new StringBuffer(10);
        while (Result.isLetter(c = buf[nBuf++]) || Character.isDigit(c) || c == '$' || c == ':') {
            stringBuffer.append(c);
        }
        Result.unget1();
        if (stringBuffer.length() <= 0) {
            throw new BadFormulaException("Bad formula - expected a constant");
        }
        String string = stringBuffer.toString().toUpperCase();
        if (Result.get1() == '(') {
            byte by;
            Vector<Result> vector = new Vector<Result>(3);
            c = Result.get1();
            if (c != ')') {
                Result.unget1();
            }
            while (c != ')') {
                if (c == '\u0000') {
                    throw new BadFormulaException(MSG_FUNCTION);
                }
                vector.addElement(Result.f_comp());
                c = Result.get1();
                if (c == ',' || c == ')') continue;
                throw new BadFormulaException(MSG_FUNCTION);
            }
            byte by2 = vector.size();
            Result[] resultArray = new Result[by2];
            for (by = 0; by < by2; ++by) {
                resultArray[by] = (Result)vector.elementAt(by);
            }
            by = (byte)Result.findFunction(string);
            if (by == -1) {
                throw new BadFormulaException("Unknown function <" + string + ">");
            }
            return new Result(by, resultArray);
        }
        Result.unget1();
        if (string.compareTo("TRUE") == 0) {
            return new Result(true);
        }
        if (string.compareTo("FALSE") == 0) {
            return new Result(false);
        }
        Result result = Result.parseAddress(string);
        return result;
    }

    private static Result f_const_string() throws BadFormulaException {
        char c;
        StringBuffer stringBuffer = new StringBuffer(20);
        ++nBuf;
        while ((c = buf[nBuf++]) != '\"') {
            if (c == '\u0000') {
                Result.unget1();
                break;
            }
            stringBuffer.append(c);
        }
        Result result = new Result(stringBuffer.toString());
        return result;
    }

    private static Result f_const_string1() throws BadFormulaException {
        char c;
        StringBuffer stringBuffer = new StringBuffer(20);
        ++nBuf;
        while ((c = buf[nBuf]) != '\u0000') {
            ++nBuf;
            stringBuffer.append(c);
        }
        Result result = new Result(stringBuffer.toString());
        return result;
    }

    private static Result f_const_numeric() throws BadFormulaException {
        char c;
        StringBuffer stringBuffer = new StringBuffer(20);
        while ((c = buf[nBuf++]) >= '0' && c <= '9' || c == '.') {
            stringBuffer.append(c);
        }
        String string = stringBuffer.toString();
        if (c == 'L' || c == 'l') {
            return new Result(3, Long.parseLong(string));
        }
        Result.unget1();
        return Result.createFloat(MathFP.toFP(string));
    }

    private static Result f_const_date() throws BadFormulaException {
        char c;
        StringBuffer stringBuffer = new StringBuffer(20);
        while ((c = buf[nBuf++]) >= '0' && c <= '9' || c == '/') {
            stringBuffer.append(c);
        }
        Result.unget1();
        String string = stringBuffer.toString();
        int n = string.indexOf(47);
        int n2 = string.indexOf(47, n + 1);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Calendar calendar = Calendar.getInstance();
        try {
            if (n > 0 && n2 > 0) {
                n3 = Integer.parseInt(string.substring(0, n));
                n4 = Integer.parseInt(string.substring(n + 1, n2));
                n5 = Integer.parseInt(string.substring(n2 + 1, string.length()));
                if (n3 < 0 || n3 > 31 || n4 <= 0 || n4 > 12 || n5 < 1970) {
                    throw new BadFormulaException(MSG_DATE);
                }
                calendar.set(5, n3);
                calendar.set(2, n4 - 1);
                calendar.set(1, n5);
            }
        }
        catch (Exception exception) {
            throw new BadFormulaException(MSG_DATE);
        }
        return new Result(2, calendar.getTime().getTime());
    }

    public static boolean intersect(short s, short s2, short s3, short s4, short s5, short s6, short s7, short s8) {
        short s9 = s4 < s8 ? s4 : s8;
        short s10 = s3 < s7 ? s3 : s7;
        short s11 = s2 > s6 ? s2 : s6;
        short s12 = s > s5 ? s : s5;
        return s9 <= s11 && s10 <= s12;
    }

    public boolean shiftReferences(short s, short s2, short s3, short s4) {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (n = 0; n < this.funcargs.length; ++n) {
            bl2 = this.funcargs[n].shiftReferences(s, s2, s3, s4);
            bl = bl || bl2;
        }
        if (this.type != 15) {
            return bl || bl2 || bl3;
        }
        n = this.i1;
        short s5 = this.j1;
        short s6 = this.i2;
        short s7 = this.j2;
        if (s3 < 0) {
            if (this.i1 >= s && this.i2 < s - s3) {
                this.type = (byte)100;
                return true;
            }
            bl4 = Result.intersect(this.i1, this.j1, this.i2, this.j2, s, s2, (short)(s - s3), this.j2);
            if (this.i1 >= s - s3) {
                this.i1 = (short)(this.i1 + s3);
            } else if (this.i1 > s) {
                this.i1 = s;
            }
            if (this.i2 >= s - s3) {
                this.i2 = (short)(this.i2 + s3);
            } else if (this.i2 > s) {
                this.i2 = s;
            }
        } else if (s3 > 0) {
            if (this.i1 >= s) {
                this.i1 = (short)(this.i1 + s3);
            }
            if (this.i2 >= s) {
                this.i2 = (short)(this.i2 + s3);
            }
            bl4 = Result.intersect(this.i1, this.j1, this.i2, this.j2, s, s2, (short)(s + s3), this.j2);
        }
        if (s4 < 0) {
            if (this.j1 >= s2 && this.j2 < s2 - s4) {
                this.type = (byte)100;
                return true;
            }
            bl4 = Result.intersect(this.i1, this.j1, this.i2, this.j2, s, s2, this.i2, (short)(s2 - s4));
            if (this.j1 >= s2 - s4) {
                this.j1 = (short)(this.j1 + s4);
            } else if (this.j1 > s2) {
                this.j1 = s2;
            }
            if (this.j2 >= s2 - s4) {
                this.j2 = (short)(this.j2 + s4);
            } else if (this.j2 > s2) {
                this.j2 = s2;
            }
        } else if (s4 > 0) {
            if (this.j1 >= s2) {
                this.j1 = (short)(this.j1 + s4);
            }
            if (this.j2 >= s2) {
                this.j2 = (short)(this.j2 + s4);
            }
            bl4 = Result.intersect(this.i1, this.j1, this.i2, this.j2, s, s2, this.i2, (short)(s2 + s4));
        }
        bl = bl4 || this.i1 != n || this.j1 != s5 || this.i2 != s6 || this.j2 != s7;
        return bl;
    }

    public boolean moveReferences(int n, int n2) {
        boolean bl = false;
        for (int i = 0; i < this.funcargs.length; ++i) {
            boolean bl2 = this.funcargs[i].moveReferences(n, n2);
            bl = bl || bl2;
        }
        if (this.type == 15) {
            if ((this.absolute & 1) == 0) {
                this.i1 = (short)(this.i1 + n);
            }
            if ((this.absolute & 2) == 0) {
                this.j1 = (short)(this.j1 + n2);
            }
            if ((this.absolute & 4) == 0) {
                this.i2 = (short)(this.i2 + n);
            }
            if ((this.absolute & 8) == 0) {
                this.j2 = (short)(this.j2 + n2);
            }
            bl = (this.absolute & 0xF) != 15;
        }
        return bl;
    }

    private static int findFunction(String string) {
        string = string.toUpperCase();
        for (int i = 0; i < FUNCTION_NAMES.length; ++i) {
            if (string.compareTo(FUNCTION_NAMES[i]) != 0) continue;
            return i;
        }
        return -1;
    }

    public String getFunctionName() {
        return FUNCTION_NAMES[(int)this.ll];
    }

    public static Result createCell(int n, int n2, String string, Result result) {
        Result result2 = new Result(51);
        result2.i1 = (short)n;
        result2.j1 = (short)n2;
        result2.funcargs = new Result[1];
        result2.funcargs[0] = result;
        result2.str = string;
        if (string.length() > 0 && string.charAt(0) == '=') {
            result2.absolute = (byte)(result2.absolute | 0x20);
        }
        return result2;
    }

    public static Result createFloat(long l) {
        Result result = new Result(4, l);
        return result;
    }

    public boolean isFormula() {
        return (this.absolute & 0x20) != 0;
    }

    public boolean hasFormula() {
        return this.str != EMPTY_FORMULA;
    }

    public boolean isEmptyCell() {
        return this.funcargs[0].type == 0;
    }

    public int hashCode() {
        return this.i1 << 16 | this.j1;
    }

    public boolean equals(Object object) {
        return this.hashCode() == object.hashCode();
    }

    public static long createLong(String string) {
        return MathFP.toFP(string);
    }

    public static String createString(long l) {
        return MathFP.toString(l);
    }
}

