/*
 * Decompiled with CFR 0.152.
 */
package com.wapindustrial.calc;

import com.wapindustrial.calc.BadFormulaException;
import com.wapindustrial.calc.MicroCalc;
import com.wapindustrial.calc.MicroCalcCanvas;
import com.wapindustrial.calc.Result;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;

public final class Sheet {
    public static final int VERSION = 1800;
    public static final int MAX_FORMULA = 256;
    public static final int MAX_REFERENCES = 20;
    private static final int HEADER_SIZE = 14;
    public static final String DEFAULT_NAME = "Untitled";
    public static final String SHEET_PREFIX = "ff_";
    public static int cursorI;
    public static int cursorJ;
    public static int clipboardI;
    public static int clipboardJ;
    public static int clipboardI2;
    public static int clipboardJ2;
    public static boolean statusInfo;
    public int rows;
    public int columns;
    public int serverVersion;
    public static int newRows;
    public static int newColumns;
    private static Command cmdOK;
    public Hashtable cells = new Hashtable();
    private short[][] links;
    private int nLinks;
    public boolean changed;
    public String name;
    public short[] columnWidth;
    public short[] rowHeight;
    public int defaultWidth;
    public int defaultHeight;
    private int slkx;
    private int slky;
    private int sptr;

    public Sheet() {
        this(0, 0, 0, 0);
    }

    public Sheet(int n, int n2, int n3, int n4) {
        this.rows = n;
        this.columns = n2;
        this.defaultWidth = n3;
        this.defaultHeight = n4;
        this.allocate();
        this.clearSheet();
        this.name = DEFAULT_NAME;
    }

    public void allocate() {
        this.columnWidth = new short[this.columns];
        this.rowHeight = new short[this.rows];
    }

    public void clearSheet() {
        int n;
        this.cells.clear();
        this.links = null;
        this.nLinks = 0;
        this.changed = false;
        for (n = 0; n < this.rows; ++n) {
            this.rowHeight[n] = (short)this.defaultHeight;
        }
        for (n = 0; n < this.columns; ++n) {
            this.columnWidth[n] = (short)this.defaultWidth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSheet(String string, InputStream inputStream) throws IOException, BadFormulaException {
        DataInputStream dataInputStream = null;
        this.clearSheet();
        cursorI = 0;
        cursorJ = 0;
        clipboardI = -1;
        clipboardJ = -1;
        clipboardI2 = -1;
        clipboardJ2 = -1;
        statusInfo = false;
        int n = this.defaultWidth;
        int n2 = this.defaultHeight;
        this.name = string;
        try {
            int n3;
            int n4;
            dataInputStream = new DataInputStream(inputStream);
            short s = dataInputStream.readShort();
            if (s <= 1795) {
                throw new IOException("Too old sheet version, cannot open the sheet");
            }
            this.serverVersion = dataInputStream.readInt();
            if (s > 1800) {
                n4 = 0;
                cursorI = dataInputStream.readInt();
                cursorJ = dataInputStream.readInt();
                clipboardI = dataInputStream.readInt();
                clipboardJ = dataInputStream.readInt();
                clipboardI2 = dataInputStream.readInt();
                clipboardJ2 = dataInputStream.readInt();
                statusInfo = dataInputStream.readBoolean();
                Result.FORMAT_DATE = dataInputStream.readInt();
                MicroCalc.DEFAULT_PRECISION = dataInputStream.readShort();
                n4 = dataInputStream.readInt();
                n4 = dataInputStream.readInt();
                n4 = dataInputStream.readInt();
                n4 = dataInputStream.readInt();
                n = dataInputStream.readInt();
                n2 = dataInputStream.readInt();
            } else {
                this.changed = true;
            }
            this.rows = dataInputStream.readInt();
            this.columns = dataInputStream.readInt();
            if (this.rows <= 0 || this.columns <= 0) {
                throw new IOException();
            }
            this.allocate();
            n4 = dataInputStream.readInt();
            for (n3 = 0; n3 < this.rows; ++n3) {
                this.rowHeight[n3] = dataInputStream.readShort();
            }
            for (n3 = 0; n3 < this.columns; ++n3) {
                this.columnWidth[n3] = dataInputStream.readShort();
            }
            for (n3 = 0; n3 < n4; ++n3) {
                Result result = Result.restoreCell(dataInputStream, s);
                this.cells.put(result, result);
                this.addReferences(Result.Evaluate(result.str), result.i1, result.j1);
            }
        }
        finally {
            if (dataInputStream != null) {
                dataInputStream.close();
            }
        }
        this.fontScaling(n, n2);
    }

    public void fontScaling(int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (this.defaultHeight != n2) {
            n5 = this.defaultHeight - n2;
            for (n4 = 0; n4 < this.rows; ++n4) {
                n3 = this.rowHeight[n4] + n5;
                this.rowHeight[n4] = (short)n3;
            }
        }
        if (this.defaultWidth != n) {
            n5 = this.defaultWidth - n;
            for (n4 = 0; n4 < this.columns; ++n4) {
                n3 = this.columnWidth[n4] + n5;
                this.columnWidth[n4] = (short)n3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSheet(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = null;
        try {
            int n;
            dataOutputStream = new DataOutputStream(outputStream);
            dataOutputStream.writeShort(1801);
            dataOutputStream.writeInt(this.serverVersion);
            dataOutputStream.writeInt(MicroCalcCanvas.cursorI);
            dataOutputStream.writeInt(MicroCalcCanvas.cursorJ);
            dataOutputStream.writeInt(MicroCalcCanvas.clipboardI);
            dataOutputStream.writeInt(MicroCalcCanvas.clipboardJ);
            dataOutputStream.writeInt(MicroCalcCanvas.clipboardI2);
            dataOutputStream.writeInt(MicroCalcCanvas.clipboardJ2);
            dataOutputStream.writeBoolean(MicroCalcCanvas.statusInfo);
            dataOutputStream.writeInt(Result.FORMAT_DATE);
            dataOutputStream.writeShort(MicroCalc.DEFAULT_PRECISION);
            dataOutputStream.writeInt(MicroCalcCanvas.LABELS);
            dataOutputStream.writeInt(MicroCalcCanvas.STATUS);
            dataOutputStream.writeInt(MicroCalcCanvas.CELLS);
            dataOutputStream.writeInt(MicroCalcCanvas.SELECTED);
            dataOutputStream.writeInt(this.defaultWidth);
            dataOutputStream.writeInt(this.defaultHeight);
            dataOutputStream.writeInt(this.rows);
            dataOutputStream.writeInt(this.columns);
            dataOutputStream.writeInt(this.cells.size());
            for (n = 0; n < this.rows; ++n) {
                dataOutputStream.writeShort(this.rowHeight[n]);
            }
            for (n = 0; n < this.columns; ++n) {
                dataOutputStream.writeShort(this.columnWidth[n]);
            }
            Enumeration enumeration = this.cells.elements();
            while (enumeration.hasMoreElements()) {
                Result result = (Result)enumeration.nextElement();
                result.save(dataOutputStream, false);
            }
        }
        finally {
            if (dataOutputStream != null) {
                dataOutputStream.close();
            }
        }
    }

    public boolean isEmpty(int n, int n2) {
        return this.getCell(n, n2).isEmptyCell();
    }

    public boolean isFormula(int n, int n2) {
        return this.getCell(n, n2).isFormula();
    }

    public int cellY(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += this.rowHeight[i];
        }
        return n2;
    }

    public int cellX(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += this.columnWidth[i];
        }
        return n2;
    }

    private void addReference(int n, int n2, int n3, int n4, int n5, int n6) {
        for (int i = 0; i < this.nLinks; ++i) {
            if (this.links[i][0] != n || this.links[i][1] != n2 || this.links[i][2] != n3 || this.links[i][3] != n4 || this.links[i][4] != n5 || this.links[i][5] != n6) continue;
            return;
        }
        if (this.links == null || this.links.length < this.nLinks + 1) {
            short[][] sArray = new short[this.nLinks + 1][6];
            for (int i = 0; i < this.nLinks; ++i) {
                sArray[i][0] = this.links[i][0];
                sArray[i][1] = this.links[i][1];
                sArray[i][2] = this.links[i][2];
                sArray[i][3] = this.links[i][3];
                sArray[i][4] = this.links[i][4];
                sArray[i][5] = this.links[i][5];
            }
            this.links = sArray;
        }
        this.links[this.nLinks][0] = (short)n;
        this.links[this.nLinks][1] = (short)n2;
        this.links[this.nLinks][2] = (short)n3;
        this.links[this.nLinks][3] = (short)n4;
        this.links[this.nLinks][4] = (short)n5;
        this.links[this.nLinks][5] = (short)n6;
        ++this.nLinks;
    }

    public void clear(int n, int n2) {
        for (int i = 0; i < this.nLinks; ++i) {
            if (this.links[i][4] != n || this.links[i][5] != n2) continue;
            for (int j = i; j < this.nLinks - 1; ++j) {
                this.links[j][0] = this.links[j + 1][0];
                this.links[j][1] = this.links[j + 1][1];
                this.links[j][2] = this.links[j + 1][2];
                this.links[j][3] = this.links[j + 1][3];
                this.links[j][4] = this.links[j + 1][4];
                this.links[j][5] = this.links[j + 1][5];
            }
            --this.nLinks;
        }
        this.cells.remove(new Integer(n << 16 | n2));
    }

    public void setFormula(int n, int n2, String string) throws BadFormulaException {
        int n3 = (int)this.getCell((int)n, (int)n2).ll;
        Result result = Result.Evaluate(string);
        Result result2 = result.calculate(this);
        this.clear(n, n2);
        Result result3 = Result.createCell(n, n2, string, result2);
        this.cells.put(result3, result3);
        this.addReferences(result, n, n2);
        this.getCell((int)n, (int)n2).ll = n3;
    }

    public void setFormula1(int n, int n2, String string) {
        try {
            this.setFormula(n, n2, string);
            this.changed = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addReferences(Result result, int n, int n2) {
        if (result.type == 15) {
            this.addReference(result.i1, result.j1, result.i2, result.j2, n, n2);
            return;
        }
        for (int i = 0; i < result.funcargs.length; ++i) {
            this.addReferences(result.funcargs[i], n, n2);
        }
    }

    public void calculateDepended(int n, int n2, boolean bl) {
        Result result;
        Object object;
        if (bl) {
            object = this.cells.elements();
            while (object.hasMoreElements()) {
                result = (Result)object.nextElement();
                result.absolute = (byte)(result.absolute & 0xFFFFFFEF);
            }
        }
        object = this.getCell(n, n2);
        if ((((Result)object).absolute & 0x10) != 0) {
            ((Result)object).funcargs[0] = Result.RESULT_ERROR;
            return;
        }
        if (!bl) {
            result = Result.RESULT_ERROR;
            try {
                result = Result.Evaluate(((Result)object).str).calculate(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (((Result)object).funcargs[0].equals(result)) {
                return;
            }
            ((Result)object).funcargs[0] = result;
        }
        ((Result)object).absolute = (byte)(((Result)object).absolute | 0x10);
        for (int i = 0; i < this.nLinks; ++i) {
            if (n < this.links[i][0] || n > this.links[i][2] || n2 < this.links[i][1] || n2 > this.links[i][3]) continue;
            this.calculateDepended(this.links[i][4], this.links[i][5], false);
        }
        ((Result)object).absolute = (byte)(((Result)object).absolute & 0xFFFFFFEF);
    }

    public void shiftReferences(int n, int n2, int n3, int n4) {
        this.nLinks = 0;
        Enumeration enumeration = this.cells.elements();
        while (enumeration.hasMoreElements()) {
            Result result = (Result)enumeration.nextElement();
            if (!result.isFormula()) continue;
            Result result2 = Result.RESULT_ERROR;
            try {
                result2 = Result.Evaluate(result.str);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result2.shiftReferences((short)n, (short)n2, (short)n3, (short)n4)) {
                Result result3 = Result.RESULT_ERROR;
                try {
                    result3 = result2.calculate(this);
                }
                catch (BadFormulaException badFormulaException) {
                    // empty catch block
                }
                result.str = '=' + result2.toString();
                if (!result3.equals(result.funcargs[0])) {
                    result.funcargs[0] = result3;
                    this.calculateDepended(result.i1, result.j1, true);
                }
            }
            this.addReferences(result2, result.i1, result.j1);
        }
    }

    public void resize(int n, int n2) {
        Object object;
        Object object2 = this.cells.elements();
        while (object2.hasMoreElements()) {
            object = (Result)object2.nextElement();
            if (((Result)object).i1 < n && ((Result)object).j1 < n2) continue;
            this.cells.remove(object);
        }
        if (n > this.rows || n2 > this.columns) {
            int n3;
            object2 = new short[n2];
            object = new short[n];
            for (n3 = 0; n3 < n; ++n3) {
                object[n3] = n3 < this.rows ? (Object)this.rowHeight[n3] : (Object)((short)this.defaultHeight);
            }
            for (n3 = 0; n3 < n2; ++n3) {
                object2[n3] = n3 < this.columns ? (Object)this.columnWidth[n3] : (Object)((short)this.defaultWidth);
            }
            this.rowHeight = (short[])object;
            this.columnWidth = (short[])object2;
        }
        this.rows = n;
        this.columns = n2;
        this.changed = true;
    }

    public void insertCells(int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            this.resize(this.rows + n3, this.columns + n4);
        }
        Hashtable<Result, Result> hashtable = new Hashtable<Result, Result>(this.cells.size());
        Enumeration enumeration = this.cells.elements();
        while (enumeration.hasMoreElements()) {
            Result result = (Result)enumeration.nextElement();
            boolean bl2 = false;
            if (result.i1 >= n) {
                if (n3 > 0 && result.i1 + n3 >= this.rows || n3 < 0 && result.i1 + n3 < n) {
                    bl2 = true;
                } else {
                    result.i1 = (short)(result.i1 + n3);
                }
            }
            if (result.j1 >= n2) {
                if (n4 > 0 && result.j1 + n4 >= this.columns || n4 < 0 && result.j1 + n4 < n2) {
                    bl2 = true;
                } else {
                    result.j1 = (short)(result.j1 + n4);
                }
            }
            if (bl2) {
                this.clear(result.i1, result.j1);
                continue;
            }
            hashtable.put(result, result);
        }
        this.cells = hashtable;
        if (n3 > 0) {
            for (int i = this.rows - n3 - 1; i >= n; --i) {
                this.rowHeight[i + n3] = this.rowHeight[i];
            }
        } else if (n3 < 0) {
            for (int i = n; i < this.rows + n3; ++i) {
                this.rowHeight[i] = this.rowHeight[i - n3];
            }
        }
        if (n4 > 0) {
            for (int i = this.columns - n4 - 1; i >= n2; --i) {
                this.columnWidth[i + n4] = this.columnWidth[i];
            }
        } else if (n4 < 0) {
            for (int i = n2; i < this.columns + n4; ++i) {
                this.columnWidth[i] = this.columnWidth[i - n4];
            }
        }
        this.shiftReferences(n, n2, n3, n4);
        this.changed = true;
    }

    public void copyCell1(int n, int n2, int n3, int n4) {
        if (n3 == 0 && n4 == 0) {
            return;
        }
        int n5 = n + n3;
        int n6 = n2 + n4;
        Result result = this.getCell(n, n2);
        Result result2 = new Result(result);
        String string = result.str;
        this.clear(n5, n6);
        result2.i1 = (short)n5;
        result2.j1 = (short)n6;
        if (result.isFormula()) {
            Result result3 = Result.RESULT_ERROR;
            try {
                result3 = Result.Evaluate(result.str);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result3.moveReferences(n3, n4)) {
                Result result4;
                try {
                    result4 = result3.calculate(this);
                }
                catch (Exception exception) {
                    result4 = Result.RESULT_ERROR;
                }
                result2.funcargs = new Result[1];
                result2.funcargs[0] = result4;
                string = result2.str = '=' + result3.toString();
            }
            this.addReferences(result3, n5, n6);
        }
        this.cells.put(result2, result2);
        try {
            this.setFormula(n5, n6, string);
            this.calculateDepended(n5, n6, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void copyRow1(int n, int n2) {
        for (int i = 0; i < this.columns; ++i) {
            this.copyCell1(n, i, n2, 0);
        }
    }

    public Result getCell(int n, int n2) {
        Result result = (Result)this.cells.get(new Integer(n << 16 | n2));
        if (result == null) {
            result = Result.createCell(n, n2, "", Result.RESULT_EMPTY);
        }
        return result;
    }

    public Result getCellValue(int n, int n2) {
        return this.getCell((int)n, (int)n2).funcargs[0];
    }

    public void fullCalc(Displayable displayable) throws Exception {
        if (displayable != null) {
            cmdOK = new Command(" ", 4, 2);
            displayable.addCommand(cmdOK);
        }
        try {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    Result result = this.getCell(i, j);
                    String string = result.str.trim();
                    if (string.length() > 0) {
                        this.setFormula(i, j, string);
                        this.calculateDepended(i, j, true);
                    }
                    if (displayable != null) {
                        displayable.removeCommand(cmdOK);
                        cmdOK = new Command(Result.cellAddress(i, j, 0), 4, 2);
                        displayable.addCommand(cmdOK);
                    }
                    Runtime.getRuntime().gc();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (displayable != null) {
            displayable.removeCommand(cmdOK);
        }
        this.changed = true;
    }

    private static String getSylkAddress(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(10);
        int n5 = n - n3;
        int n6 = n2 - n4;
        stringBuffer.append('R');
        if (bl) {
            stringBuffer.append(n + 1);
        } else if (n5 != 0) {
            stringBuffer.append('[');
            stringBuffer.append(Integer.toString(n5));
            stringBuffer.append(']');
        }
        stringBuffer.append('C');
        if (bl2) {
            stringBuffer.append(n2 + 1);
        } else if (n6 != 0) {
            stringBuffer.append('[');
            stringBuffer.append(Integer.toString(n6));
            stringBuffer.append(']');
        }
        return stringBuffer.toString();
    }

    public static String getSylkFormula(Result result, int n, int n2) {
        String string = "";
        String string2 = null;
        String string3 = null;
        if (result.funcargs.length > 0) {
            string2 = Sheet.getSylkFormula(result.funcargs[0], n, n2);
        }
        if (result.funcargs.length > 1) {
            string3 = Sheet.getSylkFormula(result.funcargs[1], n, n2);
        }
        switch (result.type) {
            case 1: {
                string = Result.booleanToString(result.ll);
                break;
            }
            case 2: {
                string = '\"' + result.toString() + '\"';
                break;
            }
            case 3: {
                string = Long.toString(result.ll);
                break;
            }
            case 4: {
                string = result.toString();
                break;
            }
            case 5: {
                string = '\"' + result.str + '\"';
                break;
            }
            case 15: {
                string = Sheet.getSylkAddress(result.i1, result.j1, n, n2, (result.absolute & 1) != 0, (result.absolute & 2) != 0);
                if (result.i1 == result.i2 && result.j1 == result.j2) break;
                string = string + ':' + Sheet.getSylkAddress(result.i2, result.j2, n, n2, (result.absolute & 4) != 0, (result.absolute & 8) != 0);
                break;
            }
            case 20: {
                string = '-' + string2;
                break;
            }
            case 21: {
                string = string2 + '+' + string3;
                break;
            }
            case 22: {
                string = string2 + '-' + string3;
                break;
            }
            case 23: {
                string = string2 + '*' + string3;
                break;
            }
            case 24: {
                string = string2 + '/' + string3;
                break;
            }
            case 25: {
                string = string2 + '^' + string3;
                break;
            }
            case 26: {
                string = string2 + '&' + string3;
                break;
            }
            case 27: {
                string = string2 + '=' + string3;
                break;
            }
            case 28: {
                string = string2 + "!=" + string3;
                break;
            }
            case 29: {
                string = string2 + '<' + string3;
                break;
            }
            case 30: {
                string = string2 + '>' + string3;
                break;
            }
            case 31: {
                string = string2 + "<=" + string3;
                break;
            }
            case 32: {
                string = string2 + ">=" + string3;
                break;
            }
            case 33: {
                string = '(' + string2 + ')';
                break;
            }
            case 50: {
                string = result.getFunctionName() + '(';
                for (int i = 0; i < result.funcargs.length; ++i) {
                    string = string + Sheet.getSylkFormula(result.funcargs[i], n, n2);
                    if (i == result.funcargs.length - 1) continue;
                    string = string + ',';
                }
                string = string + ')';
                break;
            }
            case 100: {
                string = "#ERR#";
                break;
            }
            default: {
                System.out.println("Internal error: unknown Result type");
            }
        }
        return string;
    }

    public String getSylkLine(String string) {
        String string2;
        block13: {
            String string3 = string.trim();
            string2 = "";
            if (!(string3.startsWith("F;") || string3.startsWith("C;") || string3.startsWith("B;"))) {
                return "";
            }
            string3 = string3.substring(2, string3.length());
            int n = string3.indexOf("K");
            int n2 = 0;
            if (n >= 0 && (n2 = string3.indexOf(";E")) > n) {
                string3 = n > 0 ? string3.substring(0, n) + string3.substring(n2 + 1, string3.length()) : string3.substring(n2 + 1, string3.length());
                string3 = string3.trim();
            }
            int n3 = 0;
            while (n3 == 0) {
                String string4 = string3;
                int n4 = string3.indexOf(";");
                if (n4 > 0) {
                    string4 = string3.substring(0, n4);
                    string3 = string3.substring(n4 + 1, string3.length());
                }
                string2 = string2 + this.getSylkSegment(string4);
                if (n4 >= 0) continue;
                n3 = 2;
                break;
            }
            if (string.trim().startsWith("B;")) {
                int n5;
                this.clearSheet();
                this.rows = this.slky;
                this.columns = this.slkx;
                this.allocate();
                for (n5 = 0; n5 < this.rows; ++n5) {
                    this.rowHeight[n5] = (short)this.defaultHeight;
                }
                for (n5 = 0; n5 < this.columns; ++n5) {
                    this.columnWidth[n5] = (short)this.defaultWidth;
                }
                this.resize(this.rows, this.columns);
            } else if (string2.trim().length() > 0) {
                try {
                    this.setFormula(this.slky - 1, this.slkx - 1, string2);
                }
                catch (Exception exception) {
                    if (string3.length() <= 1) break block13;
                    string3 = "'=" + string3.substring(1, string3.length()) + "  {" + exception.getMessage() + "}";
                    try {
                        this.setFormula(this.slky - 1, this.slkx - 1, string3);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
            }
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getSylkSegment(String string) {
        int n;
        String string2 = string.trim().toUpperCase();
        String string3 = string.trim();
        String string4 = "";
        int n2 = 0;
        if (string2.startsWith("X")) {
            try {
                n2 = Integer.parseInt(string2.substring(1, string2.length()));
            }
            catch (Exception exception) {
                n2 = 0;
            }
            if (n2 > 0 && n2 < 27) {
                this.slkx = n2;
            }
        }
        if (string2.startsWith("Y")) {
            try {
                n2 = Integer.parseInt(string2.substring(1, string2.length()));
            }
            catch (Exception exception) {
                n2 = 0;
            }
            if (n2 > 0 && n2 < 200) {
                this.slky = n2;
            }
        }
        if (string2.startsWith("K") && (string4 = string3.substring(1, string3.length())).startsWith("\"")) {
            if (string4.endsWith("\"")) {
                string4 = string4.substring(0, string4.length() - 1);
            }
            string4 = string4.replace('\"', '\'');
        }
        if (!string2.startsWith("E")) return string4;
        string2 = string2.substring(1, string2.length());
        string4 = "=";
        int n3 = 0;
        if (string2.indexOf("R") < 0) {
            string4 = string4 + string2;
            n3 = 2;
        }
        do {
            block21: {
                if (n3 != 0) return string4;
                n = string2.indexOf("R");
                if (n < 0) continue;
                if (string2.charAt(n + 1) == '(' || string2.charAt(n + 1) > '@' && string2.charAt(n + 1) < '[' && string2.charAt(n + 1) != 'C') {
                    n = string2.indexOf("(");
                    if (n > 0) {
                        string4 = string4 + string2.substring(0, n);
                    }
                    if (n >= 0) {
                        string2 = string2.substring(n, string2.length());
                    }
                    if ((n = string2.indexOf("R")) >= 0) {
                        if (n > 0) {
                            string4 = string4 + string2.substring(0, n);
                        }
                        string2 = string2.substring(n, string2.length());
                        string4 = string4 + this.getSylkRef(string2);
                        break block21;
                    } else {
                        if (string2.length() > 0) {
                            return string4 + string2;
                        }
                        n3 = 2;
                        return string4;
                    }
                }
                if (n > 0) {
                    string4 = string4 + string2.substring(0, n);
                }
                string2 = string2.substring(n, string2.length());
                string4 = string4 + this.getSylkRef(string2);
            }
            string2 = this.sptr < string2.length() ? string2.substring(this.sptr, string2.length()) : "";
        } while (n >= 0);
        if (string2.length() > 0) {
            return string4 + string2;
        }
        n3 = 2;
        return string4;
    }

    public String getSylkRef(String string) {
        int n = string.indexOf("R");
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = n;
        String string2 = "";
        StringBuffer stringBuffer = new StringBuffer();
        if (n >= 0) {
            if (string.substring(n + 1, n + 2).equals("[")) {
                for (n5 = n + 2; n5 <= string.length() && string.charAt(n5) != ']'; ++n5) {
                    stringBuffer.append(string.charAt(n5));
                }
                if (stringBuffer.charAt(0) == '+') {
                    stringBuffer.setCharAt(0, ' ');
                }
                try {
                    n2 = Integer.parseInt(stringBuffer.toString().trim());
                }
                catch (Exception exception) {
                    n2 = 0;
                }
            }
            if ((n3 = this.slky + n2) < 1) {
                n3 = 1;
            }
        }
        n = string.indexOf("C");
        n2 = 0;
        n5 = n;
        stringBuffer = new StringBuffer();
        if (n >= 0) {
            string = string + " ";
        }
        if (n >= 0) {
            if (string.substring(n + 1, n + 2).equals("[")) {
                for (n5 = n + 2; n5 <= string.length() && string.charAt(n5) != ']'; ++n5) {
                    stringBuffer.append(string.charAt(n5));
                }
                if (stringBuffer.charAt(0) == '+') {
                    stringBuffer.setCharAt(0, ' ');
                }
                try {
                    n2 = Integer.parseInt(stringBuffer.toString().trim());
                }
                catch (Exception exception) {
                    n2 = 0;
                }
            }
            n4 = this.slkx + n2;
            this.sptr = n5 + 1;
            if (n4 < 1 || n4 > 26) {
                n4 = 1;
            }
        }
        string2 = "" + (char)(64 + n4) + n3;
        return string2;
    }

    static {
        newRows = 32;
        newColumns = 8;
        cmdOK = new Command("OK", 4, 2);
    }
}

