/*
 * Decompiled with CFR 0.152.
 */
package com.wapindustrial.calc;

import com.wapindustrial.calc.MicroCalc;
import com.wapindustrial.calc.MicroCalcCanvas;
import com.wapindustrial.calc.Sheet;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;

final class TempScreen
extends Canvas
implements Runnable {
    private String sheetname;
    private Displayable okScreen;
    private Displayable errScreen;
    private MicroCalcCanvas canvas;
    MicroCalc parent;
    private boolean done;

    TempScreen(MicroCalc microCalc, MicroCalcCanvas microCalcCanvas, String string, Displayable displayable, Displayable displayable2, int n) {
        this.sheetname = string;
        this.okScreen = displayable;
        this.errScreen = displayable2;
        this.canvas = microCalcCanvas;
        this.parent = microCalc;
        this.done = false;
    }

    protected void paint(Graphics graphics) {
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(0);
        graphics.drawString(this.sheetname != null ? "Loading..." : "Saving...", this.getWidth() / 2, this.getHeight() / 2, 17);
        this.canvas.display.callSerially((Runnable)this);
    }

    public void run() {
        if (this.done) {
            return;
        }
        this.done = true;
        try {
            if (this.sheetname == null) {
                MicroCalcCanvas.saveSheet(this.canvas.sheet);
                this.canvas.display.setCurrent(this.okScreen);
            } else {
                this.canvas.loadSheet(this.canvas.sheet, this.sheetname);
                Sheet cfr_ignored_0 = this.canvas.sheet;
                Sheet cfr_ignored_1 = this.canvas.sheet;
                this.canvas.setWindow(Sheet.cursorI, Sheet.cursorJ, 1, 4);
                Sheet cfr_ignored_2 = this.canvas.sheet;
                MicroCalcCanvas.cursorI = Sheet.cursorI;
                Sheet cfr_ignored_3 = this.canvas.sheet;
                MicroCalcCanvas.cursorJ = Sheet.cursorJ;
                Sheet cfr_ignored_4 = this.canvas.sheet;
                Sheet cfr_ignored_5 = this.canvas.sheet;
                this.canvas.setWindow(Sheet.cursorI, Sheet.cursorJ, 0, 2);
                this.canvas.display.setCurrent(this.okScreen);
                if (MicroCalcCanvas.statusInfo) {
                    this.canvas.setStatusLine(this.canvas.getStatusInfo(MicroCalcCanvas.cursorI, MicroCalcCanvas.cursorJ));
                } else {
                    this.canvas.setStatusLine(null);
                }
            }
        }
        catch (Exception exception) {
            Alert alert = new Alert("Error", "Cannot " + (this.sheetname == null ? "save" : "load") + " the sheet, error: " + exception.toString(), null, AlertType.ERROR);
            alert.setTimeout(-2);
            this.canvas.display.setCurrent(alert, this.errScreen);
        }
    }
}

