/*
 * Decompiled with CFR 0.152.
 */
package net.jscience.math;

public abstract class MathFP {
    public static long default_precision = 13L;
    public static long precision = 0L;
    public static long frac_mask = 0L;
    private static final long maxPrecision = 30L;
    private static final long fin_precision = 17L;
    private static final long e_precision = 29L;
    private static final long e = 1459366444L;
    private static final long pi_precision = 29L;
    private static final long pi = 1686629713L;
    private static long one_eighty_over_pi;
    private static long pi_over_one_eighty;
    private static int maxDigits;
    private static int maxDigitsInt;
    public static long ONE;
    public static long HALF;
    public static long TWO;
    public static long E;
    public static long PI;
    public static long PI_HALF;
    public static long PI_TWO;
    public static final long INFINITY = Integer.MAX_VALUE;
    private static final long sk_precision = 31L;
    private static final long[] sk;
    private static long[] SK;
    private static final long as_precision = 30L;
    private static final long[] as;
    private static long[] AS;
    private static final long ln2_precision = 30L;
    private static final long ln2 = 744261117L;
    private static final long ln2_inv = 1549082004L;
    private static long LN2;
    private static long LN2_INV;
    private static final long lg_precision = 31L;
    private static final long[] lg;
    private static long[] LG;
    private static final long exp_p_precision = 31L;
    private static final long[] exp_p;
    private static long[] EXP_P;
    private static int atan2_zero_error;

    public static long toFP(long l) {
        return l < 0L ? -(-l << (int)precision) : l << (int)precision;
    }

    public static long toInt(long l) {
        return l < 0L ? -(-l >> (int)precision) : l >> (int)precision;
    }

    public static long convert(long l, long l2) {
        long l3 = MathFP.abs(l);
        if (l2 > 30L || l2 < 0L) {
            return l;
        }
        long l4 = l2 > precision ? l3 >> (int)(l2 - precision) : l3 << (int)(precision - l2);
        if (l < 0L) {
            l4 = -l4;
        }
        return l4;
    }

    public static long toFP(String string) {
        long l;
        int n;
        long l2 = 0L;
        String string2 = null;
        boolean bl = false;
        if (string.charAt(0) == '-') {
            bl = true;
            string = string.substring(1, string.length());
        }
        if ((n = string.indexOf(46)) < 0) {
            l = Integer.parseInt(string);
        } else if (n == 0) {
            l = 0L;
            string2 = string.substring(1, string.length());
        } else if (n == string.length() - 1) {
            l = Integer.parseInt(string.substring(0, n));
        } else {
            l = Integer.parseInt(string.substring(0, n));
            string2 = string.substring(n + 1, string.length());
        }
        if (string2 != null) {
            if (string2.length() > maxDigits) {
                string2 = string2.substring(0, maxDigits);
            }
            if (string2.length() > 0) {
                l2 = Integer.parseInt(string2);
                for (long i = 0L; i < (long)(maxDigits - string2.length()); ++i) {
                    l2 *= 10L;
                }
            }
        }
        long l3 = (l << (int)precision) + l2 * ONE / (long)maxDigitsInt;
        if (bl) {
            l3 = -l3;
        }
        return l3;
    }

    public static String toString(long l, long l2, long l3) {
        long l4;
        int n;
        if (l / ONE > Integer.MAX_VALUE || l / ONE < -2147483647L) {
            return "#NUM#";
        }
        boolean bl = false;
        boolean bl2 = false;
        if (l < 0L) {
            bl = true;
            l = -l;
        }
        String string = Long.toString((l & frac_mask) * (long)maxDigitsInt / ONE);
        int n2 = maxDigits - string.length();
        for (n = 0; n < n2; ++n) {
            string = "0" + string;
        }
        int n3 = l3 + 1L < (long)string.length() ? (int)l3 + 1 : string.length();
        int n4 = 0;
        char[] cArray = string.toCharArray();
        if (cArray[n3 - 1] < '5') {
            cArray[n3 - 1] = 48;
        } else {
            cArray[n3 - 1] = 48;
            for (n = n3 - 2; n >= 0; --n) {
                if (cArray[n] != '9') {
                    int n5 = n;
                    cArray[n5] = (char)(cArray[n5] + '\u0001');
                    break;
                }
                cArray[n] = 48;
            }
            if (n == -1) {
                n4 = 1;
            }
        }
        for (n = n3; n < cArray.length; ++n) {
            cArray[n] = 48;
        }
        string = String.valueOf(cArray);
        for (n = string.length() - 1; n >= 0 && string.charAt(n) == '0'; --n) {
        }
        string = string.substring(0, n + 1);
        n = string.length();
        while ((long)n < l2) {
            string = string + "0";
            ++n;
        }
        if ((long)string.length() > l3) {
            string = string.substring(0, (int)l3);
        }
        if ((l4 = (l >> (int)precision) + (long)n4) < 0L) {
            l4 = -l4;
        }
        for (n = string.length() - 1; n >= 0; --n) {
            if (string.charAt(n) == '0') continue;
            bl2 = true;
            break;
        }
        if (string.length() > 0) {
            string = "." + string;
        }
        return (bl && (l4 != 0L || bl2) ? "-" : "") + Integer.toString((int)l4) + string;
    }

    public static String toString(long l) {
        return MathFP.toString(l, 0L, maxDigits);
    }

    public static void setPrecision(long l) {
        int n;
        if (l > 30L || l < 0L) {
            return;
        }
        precision = l;
        PI = l <= 29L ? 1686629713L >> (int)(29L - l) : 1686629713L << (int)(l - 29L);
        PI_HALF = PI >> 1;
        PI_TWO = PI << 1;
        ONE = 1 << (int)l;
        HALF = ONE >> 1;
        TWO = ONE << 1;
        E = l <= 29L ? 1459366444L >> (int)(29L - l) : 1459366444L >> (int)(l - 29L);
        for (n = 0; n < sk.length; ++n) {
            MathFP.SK[n] = l <= 31L ? sk[n] >> (int)(31L - l) : sk[n] << (int)(l - 31L);
        }
        for (n = 0; n < as.length; ++n) {
            MathFP.AS[n] = l <= 30L ? as[n] >> (int)(30L - l) : as[n] << (int)(l - 30L);
        }
        LN2 = l <= 30L ? 744261117L >> (int)(30L - l) : 744261117L << (int)(l - 30L);
        LN2_INV = l <= 30L ? 1549082004L >> (int)(30L - l) : 1549082004L << (int)(l - 30L);
        for (n = 0; n < lg.length; ++n) {
            MathFP.LG[n] = l <= 31L ? lg[n] >> (int)(31L - l) : lg[n] << (int)(l - 31L);
        }
        for (n = 0; n < exp_p.length; ++n) {
            MathFP.EXP_P[n] = l <= 31L ? exp_p[n] >> (int)(31L - l) : exp_p[n] << (int)(l - 31L);
        }
        frac_mask = ONE - 1L;
        pi_over_one_eighty = MathFP.div(PI, MathFP.toFP(180L));
        one_eighty_over_pi = MathFP.div(MathFP.toFP(180L), PI);
        long l2 = 1 << (int)(30L - l);
        maxDigitsInt = 1;
        maxDigits = 0;
        while ((long)maxDigitsInt <= l2) {
            maxDigitsInt *= 10;
            ++maxDigits;
        }
        maxDigitsInt /= 10;
        --maxDigits;
    }

    public static long abs(long l) {
        return l < 0L ? -l : l;
    }

    public static long ceil(long l) {
        boolean bl = false;
        if (l < 0L) {
            l = -l;
            bl = true;
        }
        if ((l & frac_mask) == 0L) {
            return bl ? -l : l;
        }
        if (bl) {
            return -(l & (frac_mask ^ 0xFFFFFFFFFFFFFFFFL));
        }
        return (l & (frac_mask ^ 0xFFFFFFFFFFFFFFFFL)) + ONE;
    }

    public static long floor(long l) {
        boolean bl = false;
        if (l < 0L) {
            l = -l;
            bl = true;
        }
        if ((l & frac_mask) == 0L) {
            return bl ? -l : l;
        }
        if (bl) {
            return -(l & (frac_mask ^ 0xFFFFFFFFFFFFFFFFL)) - ONE;
        }
        return l & (frac_mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static long trunc(long l) {
        return l < 0L ? -(-l & (frac_mask ^ 0xFFFFFFFFFFFFFFFFL)) : l & (frac_mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static long frac(long l) {
        return l < 0L ? -(-l & frac_mask) : l & frac_mask;
    }

    public static long round(long l) {
        boolean bl = false;
        if (l < 0L) {
            l = -l;
            bl = true;
        }
        l += HALF;
        return bl ? -l : (l &= frac_mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static long mul(long l, long l2) {
        if (l == 0L || l2 == 0L) {
            return 0L;
        }
        if (l2 < ONE / 10L && l2 > -(ONE / 10L) && (l > ONE * 1000000L || l < -(ONE * 1000000L))) {
            return 0x80000000L * ONE;
        }
        long l3 = 0L;
        long l4 = 0L;
        if (l < 0L) {
            l3 = 1L;
            l = -l;
        }
        if (l2 < 0L) {
            l4 = 1L;
            l2 = -l2;
        }
        long l5 = ((l >> (int)precision) * (l2 >> (int)precision) << (int)precision) + (l & frac_mask) * (l2 >> (int)precision) + (l >> (int)precision) * (l2 & frac_mask) + ((l & frac_mask) * (l2 & frac_mask) >> (int)precision);
        if ((l3 ^ l4) == 1L) {
            l5 = -l5;
        }
        return l5;
    }

    public static long div(long l, long l2) {
        if (l == 0L) {
            return 0L;
        }
        if (l2 == 0L) {
            return l < 0L ? Integer.MIN_VALUE * ONE : 0x80000000L * ONE;
        }
        if (l2 < ONE / 10L && l2 > -(ONE / 10L) && (l > ONE * 1000000L || l < -(ONE * 1000000L))) {
            return 0x80000000L * ONE;
        }
        long l3 = 0L;
        long l4 = 0L;
        if (l < 0L) {
            l3 = 1L;
            l = -l;
        }
        if (l2 < 0L) {
            l4 = 1L;
            l2 = -l2;
        }
        long l5 = 0L;
        long l6 = 0L;
        while ((l & (long)(1 << (int)(30L - l5))) == 0L) {
            ++l5;
        }
        while ((l2 & (long)(1 << (int)l6)) == 0L) {
            ++l6;
        }
        long l7 = precision - (l5 + l6);
        long l8 = (l << (int)l5) / (l2 >> (int)l6);
        l8 = l7 > 0L ? (l8 <<= (int)l7) : (l8 >>= (int)(-l7));
        if (l7 < -21L && l8 < ONE && l8 > -ONE) {
            l8 += l / l2 * ONE;
        }
        if ((l3 ^ l4) == 1L) {
            l8 = -l8;
        }
        return l8;
    }

    public static long sqrt(long l) {
        long l2 = l + ONE >> 1;
        for (long i = 0L; i < 8L; ++i) {
            l2 = l2 + MathFP.div(l, l2) >> 1;
        }
        return l2;
    }

    public static long sin(long l) {
        long l2 = 1L;
        if ((l %= PI * 2L) < 0L) {
            l = PI * 2L + l;
        }
        if (l > PI_HALF && l <= PI) {
            l = PI - l;
        } else if (l > PI && l <= PI + PI_HALF) {
            l -= PI;
            l2 = -1L;
        } else if (l > PI + PI_HALF) {
            l = (PI << 1) - l;
            l2 = -1L;
        }
        long l3 = MathFP.mul(l, l);
        long l4 = SK[0];
        l4 = MathFP.mul(l4, l3);
        l4 -= SK[1];
        l4 = MathFP.mul(l4, l3);
        l4 += ONE;
        l4 = MathFP.mul(l4, l);
        return l2 * l4;
    }

    public static long cos(long l) {
        return MathFP.sin(PI_HALF - l);
    }

    public static long tan(long l) {
        return MathFP.div(MathFP.sin(l), MathFP.cos(l));
    }

    public static long asin(long l) {
        boolean bl = false;
        if (l < 0L) {
            bl = true;
            l = -l;
        }
        long l2 = MathFP.sqrt(ONE - l);
        long l3 = AS[0];
        l3 = MathFP.mul(l3, l);
        l3 += AS[1];
        l3 = MathFP.mul(l3, l);
        l3 -= AS[2];
        l3 = MathFP.mul(l3, l);
        l3 += AS[3];
        l3 = PI_HALF - MathFP.mul(l2, l3);
        if (bl) {
            l3 = -l3;
        }
        return l3;
    }

    public static long acos(long l) {
        return PI_HALF - MathFP.asin(l);
    }

    public static long atan(long l) {
        return MathFP.asin(MathFP.div(l, MathFP.sqrt(ONE + MathFP.mul(l, l))));
    }

    public static long atan2(long l, long l2) {
        if (l == 0L) {
            if (l2 >= 0L) {
                return 0L;
            }
            if (l2 < 0L) {
                return PI;
            }
        } else if (l2 >= (long)(-atan2_zero_error) && l2 <= (long)atan2_zero_error) {
            return l > 0L ? PI_HALF : -PI_HALF;
        }
        long l3 = MathFP.atan(MathFP.abs(MathFP.div(l, l2)));
        if (l2 > 0L) {
            return l > 0L ? l3 : -l3;
        }
        return l > 0L ? PI - l3 : l3 - PI;
    }

    public static long exp(long l) {
        if (l == 0L) {
            return ONE;
        }
        long l2 = MathFP.abs(l);
        long l3 = MathFP.mul(l2, LN2_INV);
        l3 += HALF;
        l3 &= frac_mask ^ 0xFFFFFFFFFFFFFFFFL;
        if (l < 0L) {
            l3 = -l3;
        }
        long l4 = MathFP.mul(l -= MathFP.mul(l3, LN2), l);
        long l5 = TWO + MathFP.mul(l4, EXP_P[0] + MathFP.mul(l4, EXP_P[1] + MathFP.mul(l4, EXP_P[2] + MathFP.mul(l4, EXP_P[3] + MathFP.mul(l4, EXP_P[4])))));
        long l6 = ONE + MathFP.div(MathFP.mul(TWO, l), l5 - l);
        l3 = l3 < 0L ? ONE >> (int)(-l3 >> (int)precision) : ONE << (int)(l3 >> (int)precision);
        return MathFP.mul(l3, l6);
    }

    public static long log(long l) {
        if (l < 0L) {
            return 0L;
        }
        if (l == 0L) {
            return -2147483647L;
        }
        long l2 = 0L;
        long l3 = l;
        while (l3 >= TWO) {
            l3 >>= 1;
            ++l2;
        }
        long l4 = l3 - ONE;
        long l5 = MathFP.div(l4, TWO + l4);
        long l6 = MathFP.mul(l5, l5);
        long l7 = MathFP.mul(l6, l6);
        long l8 = MathFP.mul(l7, LG[1] + MathFP.mul(l7, LG[3] + MathFP.mul(l7, LG[5]))) + MathFP.mul(l6, LG[0] + MathFP.mul(l7, LG[2] + MathFP.mul(l7, LG[4] + MathFP.mul(l7, LG[6]))));
        return MathFP.mul(LN2, l2 << (int)precision) + l4 - MathFP.mul(l5, l4 - l8);
    }

    public static long log(long l, long l2) {
        return MathFP.div(MathFP.log(l), MathFP.log(l2));
    }

    public static long pow(long l, long l2) {
        if (l2 == 0L) {
            return ONE;
        }
        if (l < 0L) {
            return 0L;
        }
        return MathFP.exp(MathFP.mul(MathFP.log(l), l2));
    }

    public static long min(long l, long l2) {
        return l < l2 ? l : l2;
    }

    public static long max(long l, long l2) {
        return l > l2 ? l : l2;
    }

    public static long deg2rad(long l) {
        return MathFP.mul(l, pi_over_one_eighty);
    }

    public static long rad2deg(long l) {
        return MathFP.mul(l, one_eighty_over_pi);
    }

    public static long pmt(long l, long l2, long l3) {
        MathFP.setPrecision(17L);
        long l4 = MathFP.mul(-(l3 *= (long)(1 << (int)(17L - default_precision))), MathFP.div(l *= (long)(1 << (int)(17L - default_precision)), ONE - MathFP.pow(ONE + l, -(l2 *= (long)(1 << (int)(17L - default_precision))))));
        MathFP.setPrecision(default_precision);
        return l4 /= (long)(1 << (int)(17L - default_precision));
    }

    public static long ipmt(long l, long l2, long l3, long l4) {
        MathFP.setPrecision(17L);
        long l5 = MathFP.mul(-(l4 *= (long)(1 << (int)(17L - default_precision))), MathFP.div(l *= (long)(1 << (int)(17L - default_precision)), ONE - MathFP.pow(ONE + l, -(l3 *= (long)(1 << (int)(17L - default_precision))))));
        long l6 = l5 - MathFP.div(l5, MathFP.pow(ONE + l, l3 - ((l2 *= (long)(1 << (int)(17L - default_precision))) - ONE)));
        MathFP.setPrecision(default_precision);
        return l6 /= (long)(1 << (int)(17L - default_precision));
    }

    public static long ppmt(long l, long l2, long l3, long l4) {
        MathFP.setPrecision(17L);
        long l5 = MathFP.mul(-(l4 *= (long)(1 << (int)(17L - default_precision))), MathFP.div(l *= (long)(1 << (int)(17L - default_precision)), ONE - MathFP.pow(ONE + l, -(l3 *= (long)(1 << (int)(17L - default_precision))))));
        long l6 = MathFP.div(l5, MathFP.pow(ONE + l, l3 - ((l2 *= (long)(1 << (int)(17L - default_precision))) - ONE)));
        MathFP.setPrecision(default_precision);
        return l6 /= (long)(1 << (int)(17L - default_precision));
    }

    public static long rate(long l, long l2, long l3) {
        long l4;
        MathFP.setPrecision(17L);
        long l5 = MathFP.div(MathFP.mul(l *= (long)(1 << (int)(17L - default_precision)), l2 *= (long)(1 << (int)(17L - default_precision))), -(l3 *= (long)(1 << (int)(17L - default_precision)))) - ONE;
        long l6 = MathFP.mul(-l3, MathFP.div(l5, ONE - MathFP.pow(ONE + l5, -l)));
        long l7 = MathFP.div(l5, l);
        long l8 = MathFP.mul(-l3, MathFP.div(l7, ONE - MathFP.pow(ONE + l7, -l)));
        long l9 = l6 - l8;
        long l10 = l5 - l7;
        l5 = l4 = l5 - MathFP.mul(MathFP.div(l6 - l2, l9), l10);
        l6 = MathFP.mul(-l3, MathFP.div(l5, ONE - MathFP.pow(ONE + l5, -l)));
        l9 = l6 - l8;
        l10 = l5 - l7;
        l4 = l5 - MathFP.mul(MathFP.div(l6 - l2, l9), l10);
        MathFP.setPrecision(default_precision);
        l4 /= (long)(1 << (int)(17L - default_precision));
        if (l3 >= 0L && l2 >= 0L) {
            l4 = -ONE;
        }
        if (l3 < 0L && l2 < 0L) {
            l4 = -ONE;
        }
        return l4;
    }

    public static long nper(long l, long l2, long l3) {
        l *= (long)(1 << (int)(17L - default_precision));
        l3 *= (long)(1 << (int)(17L - default_precision));
        if ((l2 *= (long)(1 << (int)(17L - default_precision))) < 0L) {
            l2 = MathFP.abs(l2);
        }
        if (l3 < 0L) {
            l3 = MathFP.abs(l3);
        }
        MathFP.setPrecision(17L);
        long l4 = -MathFP.div(MathFP.log(ONE - MathFP.div(MathFP.mul(l, l3), l2)), MathFP.log(ONE + l));
        MathFP.setPrecision(default_precision);
        return l4 /= (long)(1 << (int)(17L - default_precision));
    }

    static {
        sk = new long[]{16342350L, 356589659L};
        SK = new long[sk.length];
        as = new long[]{-20110432L, 79737141L, 227756102L, 1686557206L};
        AS = new long[as.length];
        lg = new long[]{0x55555555L, 0x33333333L, 613566760L, 477218077L, 390489238L, 328862160L, 317788895L};
        LG = new long[lg.length];
        exp_p = new long[]{0x15555555L, -5965232L, 142029L, -3550L, 88L};
        EXP_P = new long[exp_p.length];
        MathFP.setPrecision(default_precision);
        atan2_zero_error = 65;
    }
}

