/*
 * Decompiled with CFR 0.152.
 */
package net.hsnav;

import java.util.Date;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.location.Coordinates;
import javax.microedition.location.Location;
import net.hsnav.GpsListener;
import net.hsnav.GpsProvider;
import net.hsnav.HotSpotNavigatorMIDlet;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class GpsInfoScreen
extends Form
implements CommandListener,
GpsListener {
    private GpsProvider a;
    private Command a;
    private HotSpotNavigatorMIDlet a;
    private StringItem a = GpsProvider.getInstance();
    private static GpsInfoScreen a;

    public GpsInfoScreen(HotSpotNavigatorMIDlet hotSpotNavigatorMIDlet) {
        super("GPS Info");
        this.a.addListener(this);
        this.a = new Command("Back", 2, 0);
        this.a = hotSpotNavigatorMIDlet;
        this.addCommand(this.a);
        this.setCommandListener(this);
        this.a = new StringItem("Current position : \n", null);
        this.append((Item)this.a);
        a = this;
    }

    public static GpsInfoScreen getInstance() {
        if (a == null) {
            a = new GpsInfoScreen(HotSpotNavigatorMIDlet.getInstance());
        }
        return a;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.a) {
            this.a.getDisplay().setCurrent(this.a.getMainScreen());
        }
    }

    public void displayString(String string) {
        this.a.setText(string);
    }

    public static String locationMethod(int n) {
        String string = "";
        switch (n & 0xFF) {
            case 1: {
                string = string + "using satellites (GPS)";
                break;
            }
            case 32: {
                string = string + "Angle of Arrival GSM";
                break;
            }
            case 2: {
                string = string + "Time Difference GSM / (Enhanced Observed Time Difference (E-OTD)";
                break;
            }
            case 4: {
                string = string + "Time of Arrival (TOA) GSM";
                break;
            }
            case 8: {
                string = string + "Cell-ID GSM";
                break;
            }
            case 16: {
                string = string + "Bluetooth LP";
                break;
            }
            default: {
                string = string + "unknown method";
            }
        }
        switch (n & 0x30000) {
            case 131072: {
                string = string + " network based";
                break;
            }
            case 65536: {
                string = string + " terminal based";
                break;
            }
            default: {
                string = string + " unknown based";
            }
        }
        switch (n & 0xC0000) {
            case 262144: {
                string = string + " assisted";
                break;
            }
            case 524288: {
                string = string + " unassisted";
                break;
            }
            default: {
                string = string + " unknown ass.";
            }
        }
        return string;
    }

    public void locationChanged(Location location) {
        this.a.setText("lat : " + location.getQualifiedCoordinates().getLatitude() + "\n lon : " + location.getQualifiedCoordinates().getLongitude() + "\n alt : " + location.getQualifiedCoordinates().getAltitude() + " m" + "\n hdop : " + location.getQualifiedCoordinates().getHorizontalAccuracy() + "\n vdop : " + location.getQualifiedCoordinates().getVerticalAccuracy() + "\n course : " + location.getCourse() + "\n speed : " + location.getSpeed() * 3.6f + " km/h" + "\n timestamp : " + location.getTimestamp() + "\n parsed time : " + new Date(location.getTimestamp()) + "\n valid :  " + location.isValid() + "\n method : " + GpsInfoScreen.locationMethod(location.getLocationMethod()) + "(" + location.getLocationMethod() + ")" + "\n NMEA :  " + location.getExtraInfo("application/X-jsr179-location-nmea"));
    }

    public void stateChanged(int n) {
    }

    public void gpsTick() {
    }

    public void proximityEvent(Coordinates coordinates) {
    }
}

