/*
 * Decompiled with CFR 0.152.
 */
package net.hsnav;

import net.hsnav.MathJ2ME;

public final class OsmMercator {
    public static final int TILE_SIZE = 256;
    public static final double MAX_LAT = 85.05112877980659;
    public static final double MIN_LAT = -85.05112877980659;
    public static final double PI_DIV_2 = 1.5707963267949;
    public static final double PI_MUL_2 = 6.28318530717959;
    public static final double TILE_SIZE_DIV_PI_MUL_2 = 40.74366543152519;

    public static double radius(int n) {
        return 40.74366543152519 * (double)(1 << n);
    }

    public static int getMaxPixels(int n) {
        return 256 * (1 << n);
    }

    public static int falseEasting(int n) {
        return OsmMercator.getMaxPixels(n) / 2;
    }

    public static int falseNorthing(int n) {
        return (int)(-0.5 * (double)OsmMercator.getMaxPixels(n));
    }

    public static int LonToX(double d2, int n) {
        double d3 = Math.toRadians(d2);
        int n2 = (int)(OsmMercator.radius(n) * d3 + (double)OsmMercator.falseEasting(n));
        n2 = Math.min(n2, OsmMercator.getMaxPixels(n) - 1);
        n2 = Math.max(n2, 0);
        return n2;
    }

    public static int LatToY(double d2, int n) {
        d2 = Math.max(d2, -85.05112877980659);
        d2 = Math.min(d2, 85.05112877980659);
        double d3 = Math.toRadians(d2);
        int n2 = (int)(-0.5 * (OsmMercator.radius(n) * MathJ2ME.ln((1.0 + Math.sin(d3)) / (1.0 - Math.sin(d3)))) - (double)OsmMercator.falseNorthing(n));
        n2 = Math.min(n2, OsmMercator.getMaxPixels(n) - 1);
        n2 = Math.max(n2, 0);
        return n2;
    }

    public static double XToLon(int n, int n2) {
        double d2 = (double)(n -= OsmMercator.falseEasting(n2)) / OsmMercator.radius(n2);
        double d3 = Math.toDegrees(d2);
        d3 = Math.max(d3, -180.0);
        d3 = Math.min(d3, 179.999999);
        return d3;
    }

    public static double YToLat(int n, int n2) {
        double d2 = 1.5707963267949 - 2.0 * MathJ2ME.arctan(MathJ2ME.exp(-1.0 * (double)(n += OsmMercator.falseNorthing(n2)) / OsmMercator.radius(n2)));
        double d3 = -1.0 * Math.toDegrees(d2);
        d3 = Math.max(d3, -85.05112877980659);
        d3 = Math.min(d3, 85.05112877980659);
        return d3;
    }
}

