/*
 * Decompiled with CFR 0.152.
 */
package net.hsnav;

import net.hsnav.Real$NumberFormat;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class Real {
    public long mantissa;
    public int exponent;
    public byte sign;
    public static boolean magicRounding = true;
    public static final Real ZERO = new Real(0, 0, 0L);
    public static final Real ONE = new Real(0, 0x40000000, 0x4000000000000000L);
    public static final Real TWO = new Real(0, 0x40000001, 0x4000000000000000L);
    public static final Real THREE = new Real(0, 0x40000001, 0x6000000000000000L);
    public static final Real FIVE = new Real(0, 0x40000002, 0x5000000000000000L);
    public static final Real TEN = new Real(0, 0x40000003, 0x5000000000000000L);
    public static final Real HUNDRED = new Real(0, 0x40000006, 0x6400000000000000L);
    public static final Real HALF = new Real(0, 0x3FFFFFFF, 0x4000000000000000L);
    public static final Real THIRD = new Real(0, 0x3FFFFFFE, 0x5555555555555555L);
    public static final Real TENTH = new Real(0, 0x3FFFFFFC, 0x6666666666666666L);
    public static final Real PERCENT = new Real(0, 0x3FFFFFF9, 5902958103587056517L);
    public static final Real SQRT2 = new Real(0, 0x40000000, 6521908912666391106L);
    public static final Real SQRT1_2 = new Real(0, 0x3FFFFFFF, 6521908912666391106L);
    public static final Real PI2 = new Real(0, 0x40000002, 7244019458077122842L);
    public static final Real PI = new Real(0, 0x40000001, 7244019458077122842L);
    public static final Real PI_2 = new Real(0, 0x40000000, 7244019458077122842L);
    public static final Real PI_4 = new Real(0, 0x3FFFFFFF, 7244019458077122842L);
    public static final Real PI_8 = new Real(0, 0x3FFFFFFE, 7244019458077122842L);
    public static final Real E = new Real(0, 0x40000001, 6267931151224907085L);
    public static final Real LN2 = new Real(0, 0x3FFFFFFF, 6393154322601327830L);
    public static final Real LN10 = new Real(0, 0x40000001, 5309399739799983627L);
    public static final Real LOG2E = new Real(0, 0x40000000, 6653256548922161246L);
    public static final Real LOG10E = new Real(0, 0x3FFFFFFE, 8011319160293570763L);
    public static final Real MAX = new Real(0, Integer.MAX_VALUE, Long.MAX_VALUE);
    public static final Real MIN = new Real(0, 0, 0x4000000000000000L);
    public static final Real NAN = new Real(0, Integer.MIN_VALUE, 0x4000000000000000L);
    public static final Real INF = new Real(0, Integer.MIN_VALUE, 0L);
    public static final Real INF_N = new Real(1, Integer.MIN_VALUE, 0L);
    public static final Real ZERO_N = new Real(1, 0, 0L);
    public static final Real ONE_N = new Real(1, 0x40000000, 0x4000000000000000L);
    private static final byte[] a = new byte[]{31, 22, 30, 21, 18, 10, 29, 2, 20, 17, 15, 13, 9, 6, 28, 1, 23, 19, 11, 3, 16, 14, 7, 24, 12, 4, 8, 25, 5, 26, 27, 0};
    private static Real a = new Real();
    private static Real b = new Real();
    private static Real c = new Real();
    private static Real d = new Real();
    private static Real e = new Real();
    private static Real f = new Real();
    private static Real g = new Real();
    private static Real h = new Real();
    private static Real i = new Real();
    private static Real j = new Real();
    private static Real k = new Real();
    private static Real l = new Real();
    public static long randSeedA = 7244019458077122842L;
    public static long randSeedB = 6267931151224907085L;
    private static byte[] b = new byte[65];
    private static StringBuffer a = new StringBuffer(40);
    private static StringBuffer b = new StringBuffer(15);
    public static final String hexChar = "0123456789ABCDEF";
    private static Real$NumberFormat a = new Real$NumberFormat();

    public Real() {
    }

    public Real(Real real) {
        this.mantissa = real.mantissa;
        this.exponent = real.exponent;
        this.sign = real.sign;
    }

    public Real(int n) {
        this.assign(n);
    }

    public Real(long l) {
        this.assign(l);
    }

    public Real(String string) {
        this.assign(string, 10);
    }

    public Real(String string, int n) {
        this.assign(string, n);
    }

    public Real(int n, int n2, long l) {
        this.sign = (byte)n;
        this.exponent = n2;
        this.mantissa = l;
    }

    public Real(byte[] byArray, int n) {
        this.assign(byArray, n);
    }

    public final void assign(Real real) {
        if (real == null) {
            this.makeZero();
            return;
        }
        this.sign = real.sign;
        this.exponent = real.exponent;
        this.mantissa = real.mantissa;
    }

    public final void assign(int n) {
        if (n == 0) {
            this.makeZero();
            return;
        }
        this.sign = 0;
        if (n < 0) {
            this.sign = 1;
            n = -n;
        }
        int n2 = n;
        n2 |= n2 >> 1;
        n2 |= n2 >> 2;
        n2 |= n2 >> 4;
        n2 |= n2 >> 8;
        n2 |= n2 >> 16;
        n2 = a[n2 * 130329821 >>> 27] - 1;
        this.exponent = 1073741854 - n2;
        this.mantissa = (long)n << n2 + 32;
    }

    public final void assign(long l) {
        this.sign = 0;
        if (l < 0L) {
            this.sign = 1;
            l = -l;
        }
        this.exponent = 1073741886;
        this.mantissa = l;
        this.normalize();
    }

    public final void assign(String string) {
        this.assign(string, 10);
    }

    public final void assign(String object, int n) {
        int n2;
        int n3;
        if (object == null || ((String)object).length() == 0) {
            this.assign(ZERO);
            return;
        }
        int n4 = n;
        String string = object;
        object = this;
        ((Real)object).makeZero();
        int n5 = string.length();
        byte by = 0;
        int n6 = 0;
        for (n3 = 0; n3 < n5 && string.charAt(n3) == ' '; ++n3) {
        }
        if (n3 < n5 && string.charAt(n3) == '-') {
            by = 1;
            ++n3;
        } else if (n3 < n5 && string.charAt(n3) == '+') {
            ++n3;
        } else if (n3 < n5 && string.charAt(n3) == '/') {
            n6 = 1;
            by = 1;
            ++n3;
        }
        while (n3 < n5 && (n2 = Real.a(string.charAt(n3), n4, n6 != 0)) >= 0) {
            super.a(n4);
            ((Real)object).add(n2);
            ++n3;
        }
        int n7 = 0;
        if (n3 < n5 && (string.charAt(n3) == '.' || string.charAt(n3) == ',')) {
            while (++n3 < n5 && (n2 = Real.a(string.charAt(n3), n4, n6 != 0)) >= 0) {
                super.a(n4);
                ((Real)object).add(n2);
                --n7;
            }
        }
        if (n6 != 0) {
            ((Real)object).add(ONE);
        }
        while (n3 < n5 && string.charAt(n3) == ' ') {
            ++n3;
        }
        if (n3 < n5 && (string.charAt(n3) == 'e' || string.charAt(n3) == 'E')) {
            n6 = 0;
            n2 = 0;
            if (++n3 < n5 && string.charAt(n3) == '-') {
                n2 = 1;
                ++n3;
            } else if (n3 < n5 && string.charAt(n3) == '+') {
                ++n3;
            }
            while (n3 < n5 && string.charAt(n3) >= '0' && string.charAt(n3) <= '9') {
                if (n6 < 400000000) {
                    n6 = n6 * 10 + string.charAt(n3) - 48;
                }
                ++n3;
            }
            if (n2 != 0) {
                n6 = -n6;
            }
            n7 += n6;
        }
        if (n4 == 2) {
            ((Real)object).scalbn(n7);
        } else if (n4 == 8) {
            ((Real)object).scalbn(n7 * 3);
        } else if (n4 == 16) {
            ((Real)object).scalbn(n7 << 2);
        } else {
            if (n7 > 300000000 || n7 < -300000000) {
                Real.h.mantissa = Real.TEN.mantissa;
                Real.h.exponent = Real.TEN.exponent;
                Real.h.sign = Real.TEN.sign;
                if (n7 < 0) {
                    h.pow(-n7 / 2);
                    ((Real)object).div(h);
                } else {
                    h.pow(n7 / 2);
                    ((Real)object).mul(h);
                }
                n7 -= n7 / 2;
            }
            Real.h.mantissa = Real.TEN.mantissa;
            Real.h.exponent = Real.TEN.exponent;
            Real.h.sign = Real.TEN.sign;
            if (n7 < 0) {
                h.pow(-n7);
                ((Real)object).div(h);
            } else if (n7 > 0) {
                h.pow(n7);
                ((Real)object).mul(h);
            }
        }
        ((Real)object).sign = by;
    }

    public final void assign(int n, int n2, long l) {
        this.sign = (byte)n;
        this.exponent = n2;
        this.mantissa = l;
    }

    public final void assign(byte[] byArray, int n) {
        this.sign = (byte)(byArray[n + 4] >> 7 & 1);
        this.exponent = ((byArray[n] & 0xFF) << 24) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 2] & 0xFF) << 8) + (byArray[n + 3] & 0xFF);
        this.mantissa = ((long)(byArray[n + 4] & 0x7F) << 56) + ((long)(byArray[n + 5] & 0xFF) << 48) + ((long)(byArray[n + 6] & 0xFF) << 40) + ((long)(byArray[n + 7] & 0xFF) << 32) + ((long)(byArray[n + 8] & 0xFF) << 24) + ((long)(byArray[n + 9] & 0xFF) << 16) + ((long)(byArray[n + 10] & 0xFF) << 8) + (long)(byArray[n + 11] & 0xFF);
    }

    public final void toBytes(byte[] byArray, int n) {
        byArray[n] = this.exponent >> 24;
        byArray[n + 1] = (byte)(this.exponent >> 16);
        byArray[n + 2] = (byte)(this.exponent >> 8);
        byArray[n + 3] = (byte)this.exponent;
        byArray[n + 4] = (byte)((long)(this.sign << 7) + (this.mantissa >> 56));
        byArray[n + 5] = (byte)(this.mantissa >> 48);
        byArray[n + 6] = (byte)(this.mantissa >> 40);
        byArray[n + 7] = (byte)(this.mantissa >> 32);
        byArray[n + 8] = (byte)(this.mantissa >> 24);
        byArray[n + 9] = (byte)(this.mantissa >> 16);
        byArray[n + 10] = (byte)(this.mantissa >> 8);
        byArray[n + 11] = (byte)this.mantissa;
    }

    public final void assignFloatBits(int n) {
        this.sign = (byte)(n >>> 31);
        this.exponent = n >> 23 & 0xFF;
        this.mantissa = (long)(n & 0x7FFFFF) << 39;
        if (this.exponent == 0 && this.mantissa == 0L) {
            return;
        }
        if (this.exponent == 0 && this.mantissa != 0L) {
            this.exponent = 1073741698;
            this.normalize();
            return;
        }
        if (this.exponent <= 254) {
            this.exponent += 1073741697;
            this.mantissa |= 0x4000000000000000L;
            return;
        }
        if (this.mantissa == 0L) {
            this.makeInfinity(this.sign);
            return;
        }
        this.makeNan();
    }

    public final void assignDoubleBits(long l) {
        this.sign = (byte)(l >> 63 & 1L);
        this.exponent = (int)(l >> 52 & 0x7FFL);
        this.mantissa = (l & 0xFFFFFFFFFFFFFL) << 10;
        if (this.exponent == 0 && this.mantissa == 0L) {
            return;
        }
        if (this.exponent == 0 && this.mantissa != 0L) {
            this.exponent = 1073740802;
            this.normalize();
            return;
        }
        if (this.exponent <= 2046) {
            this.exponent += 1073740801;
            this.mantissa |= 0x4000000000000000L;
            return;
        }
        if (this.mantissa == 0L) {
            this.makeInfinity(this.sign);
            return;
        }
        this.makeNan();
    }

    public final int toFloatBits() {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return Integer.MAX_VALUE;
        }
        int n = this.exponent - 0x40000000 + 127;
        long l = this.mantissa;
        if ((l += 0x4000000000L) < 0L) {
            l >>>= 1;
            ++n;
            if (this.exponent < 0) {
                return this.sign << 31 | 0x7F800000;
            }
        }
        if (this.exponent < 0 && this.mantissa == 0L || n > 254) {
            return this.sign << 31 | 0x7F800000;
        }
        if (this.exponent == 0 && this.mantissa == 0L || n < -22) {
            return this.sign << 31;
        }
        if (n <= 0) {
            return this.sign << 31 | (int)(l >>> 40 - n) & 0x7FFFFF;
        }
        return this.sign << 31 | n << 23 | (int)(l >>> 39) & 0x7FFFFF;
    }

    public final long toDoubleBits() {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return Long.MAX_VALUE;
        }
        int n = this.exponent - 0x40000000 + 1023;
        long l = this.mantissa;
        if ((l += 512L) < 0L) {
            l >>>= 1;
            ++n;
            if (this.exponent < 0) {
                return (long)this.sign << 63 | 0x7FF0000000000000L;
            }
        }
        if (this.exponent < 0 && this.mantissa == 0L || n > 2046) {
            return (long)this.sign << 63 | 0x7FF0000000000000L;
        }
        if (this.exponent == 0 && this.mantissa == 0L || n < -51) {
            return (long)this.sign << 63;
        }
        if (n <= 0) {
            return (long)this.sign << 63 | l >>> 11 - n & 0xFFFFFFFFFFFFFL;
        }
        return (long)this.sign << 63 | (long)n << 52 | l >>> 10 & 0xFFFFFFFFFFFFFL;
    }

    public final void makeZero() {
        this.sign = 0;
        this.mantissa = 0L;
        this.exponent = 0;
    }

    public final void makeZero(int n) {
        this.sign = (byte)n;
        this.mantissa = 0L;
        this.exponent = 0;
    }

    public final void makeInfinity(int n) {
        this.sign = (byte)n;
        this.mantissa = 0L;
        this.exponent = Integer.MIN_VALUE;
    }

    public final void makeNan() {
        this.sign = 0;
        this.mantissa = 0x4000000000000000L;
        this.exponent = Integer.MIN_VALUE;
    }

    public final boolean isZero() {
        return this.exponent == 0 && this.mantissa == 0L;
    }

    public final boolean isInfinity() {
        return this.exponent < 0 && this.mantissa == 0L;
    }

    public final boolean isNan() {
        return this.exponent < 0 && this.mantissa != 0L;
    }

    public final boolean isFinite() {
        return this.exponent >= 0;
    }

    public final boolean isFiniteNonZero() {
        return this.exponent >= 0 && this.mantissa != 0L;
    }

    public final boolean isNegative() {
        return this.sign != 0;
    }

    public final void abs() {
        this.sign = 0;
    }

    public final void neg() {
        if (this.exponent >= 0 || this.mantissa == 0L) {
            this.sign = (byte)(this.sign ^ 1);
        }
    }

    public final void copysign(Real real) {
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L) {
            this.makeNan();
            return;
        }
        this.sign = real.sign;
    }

    public final void normalize() {
        if (this.exponent >= 0) {
            if (this.mantissa > 0L) {
                int n = 0;
                int n2 = (int)(this.mantissa >>> 32);
                if (n2 == 0) {
                    n = 32;
                    n2 = (int)this.mantissa;
                }
                n2 |= n2 >> 1;
                n2 |= n2 >> 2;
                n2 |= n2 >> 4;
                n2 |= n2 >> 8;
                n2 |= n2 >> 16;
                this.mantissa <<= (n += a[n2 * 130329821 >>> 27] - 1);
                this.exponent -= n;
                if (this.exponent < 0) {
                    this.makeZero(this.sign);
                }
                return;
            }
            if (this.mantissa < 0L) {
                this.mantissa = this.mantissa + 1L >>> 1;
                ++this.exponent;
                if (this.mantissa == 0L) {
                    this.mantissa = 0x4000000000000000L;
                    ++this.exponent;
                }
                if (this.exponent < 0) {
                    this.makeInfinity(this.sign);
                    return;
                }
            } else {
                this.exponent = 0;
            }
        }
    }

    public final long normalize128(long l) {
        if (this.exponent < 0) {
            return 0L;
        }
        if (this.mantissa == 0L) {
            if (l == 0L) {
                this.exponent = 0;
                return 0L;
            }
            this.mantissa = l;
            l = 0L;
            this.exponent -= 64;
            if (this.exponent < 0) {
                this.makeZero(this.sign);
                return 0L;
            }
        }
        if (this.mantissa < 0L) {
            l = (this.mantissa << 63) + (l >>> 1);
            this.mantissa >>>= 1;
            ++this.exponent;
            if (this.exponent < 0) {
                this.makeInfinity(this.sign);
                return 0L;
            }
            return l;
        }
        int n = 0;
        int n2 = (int)(this.mantissa >>> 32);
        if (n2 == 0) {
            n = 32;
            n2 = (int)this.mantissa;
        }
        n2 |= n2 >> 1;
        n2 |= n2 >> 2;
        n2 |= n2 >> 4;
        n2 |= n2 >> 8;
        if ((n += a[(n2 |= n2 >> 16) * 130329821 >>> 27] - 1) == 0) {
            return l;
        }
        this.mantissa = (this.mantissa << n) + (l >>> 64 - n);
        l <<= n;
        this.exponent -= n;
        if (this.exponent < 0) {
            this.makeZero(this.sign);
            return 0L;
        }
        return l;
    }

    public final void roundFrom128(long l) {
        this.mantissa += l >> 63 & 1L;
        this.normalize();
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    private int a(Real real) {
        int n;
        if (this.exponent == 0 && this.mantissa == 0L && real.exponent == 0 && real.mantissa == 0L) {
            return 0;
        }
        if (this.sign != real.sign) {
            return real.sign - this.sign;
        }
        int n2 = n = this.sign == 0 ? 1 : -1;
        if (this.exponent < 0 && this.mantissa == 0L) {
            return n;
        }
        if (real.exponent < 0 && real.mantissa == 0L) {
            return -n;
        }
        if (this.exponent != real.exponent) {
            if (this.exponent < real.exponent) {
                return -n;
            }
            return n;
        }
        if (this.mantissa != real.mantissa) {
            if (this.mantissa < real.mantissa) {
                return -n;
            }
            return n;
        }
        return 0;
    }

    private boolean a(Real real) {
        return this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L || this.exponent < 0 && this.mantissa == 0L && real.exponent < 0 && real.mantissa == 0L && this.sign == real.sign;
    }

    public final boolean equalTo(Real real) {
        if (this.a(real)) {
            return false;
        }
        return this.a(real) == 0;
    }

    public final boolean equalTo(int n) {
        a.assign(n);
        return this.equalTo(a);
    }

    public final boolean notEqualTo(Real real) {
        if (this.a(real)) {
            return false;
        }
        return this.a(real) != 0;
    }

    public final boolean notEqualTo(int n) {
        a.assign(n);
        return this.notEqualTo(a);
    }

    public final boolean lessThan(Real real) {
        if (this.a(real)) {
            return false;
        }
        return this.a(real) < 0;
    }

    public final boolean lessThan(int n) {
        a.assign(n);
        return this.lessThan(a);
    }

    public final boolean lessEqual(Real real) {
        if (this.a(real)) {
            return false;
        }
        return this.a(real) <= 0;
    }

    public final boolean lessEqual(int n) {
        a.assign(n);
        return this.lessEqual(a);
    }

    public final boolean greaterThan(Real real) {
        if (this.a(real)) {
            return false;
        }
        return this.a(real) > 0;
    }

    public final boolean greaterThan(int n) {
        a.assign(n);
        return this.greaterThan(a);
    }

    public final boolean greaterEqual(Real real) {
        if (this.a(real)) {
            return false;
        }
        return this.a(real) >= 0;
    }

    public final boolean greaterEqual(int n) {
        a.assign(n);
        return this.greaterEqual(a);
    }

    public final boolean absLessThan(Real real) {
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L || this.exponent < 0 && this.mantissa == 0L) {
            return false;
        }
        if (real.exponent < 0 && real.mantissa == 0L) {
            return true;
        }
        if (this.exponent != real.exponent) {
            return this.exponent < real.exponent;
        }
        return this.mantissa < real.mantissa;
    }

    public final void scalbn(int n) {
        if (this.exponent < 0 || this.mantissa == 0L) {
            return;
        }
        this.exponent += n;
        if (this.exponent < 0) {
            if (n < 0) {
                this.makeZero(this.sign);
                return;
            }
            this.makeInfinity(this.sign);
        }
    }

    public final void nextafter(Real real) {
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L) {
            this.makeNan();
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L && real.exponent < 0 && real.mantissa == 0L && this.sign == real.sign) {
            return;
        }
        int n = -this.a(real);
        if (n == 0) {
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.mantissa = Real.MIN.mantissa;
            this.exponent = Real.MIN.exponent;
            this.sign = Real.MIN.sign;
            this.sign = (byte)(n < 0 ? 1 : 0);
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            this.mantissa = Real.MAX.mantissa;
            this.exponent = Real.MAX.exponent;
            this.sign = Real.MAX.sign;
            this.sign = (byte)(n >= 0 ? 1 : 0);
            return;
        }
        if (this.sign == 0 ^ n < 0) {
            ++this.mantissa;
        } else {
            if (this.mantissa == 0x4000000000000000L) {
                this.mantissa <<= 1;
                --this.exponent;
            }
            --this.mantissa;
        }
        this.normalize();
    }

    public final void floor() {
        if (this.exponent < 0 || this.mantissa == 0L) {
            return;
        }
        if (this.exponent < 0x40000000) {
            if (this.sign == 0) {
                this.makeZero(this.sign);
                return;
            }
            this.exponent = Real.ONE.exponent;
            this.mantissa = Real.ONE.mantissa;
            return;
        }
        int n = 1073741886 - this.exponent;
        if (n <= 0) {
            return;
        }
        if (this.sign != 0) {
            this.mantissa += (1L << n) - 1L;
        }
        this.mantissa &= (1L << n) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        if (this.sign != 0) {
            this.normalize();
        }
    }

    public final void ceil() {
        this.neg();
        this.floor();
        this.neg();
    }

    public final void round() {
        if (this.exponent < 0 || this.mantissa == 0L) {
            return;
        }
        if (this.exponent < 0x3FFFFFFF) {
            this.makeZero(this.sign);
            return;
        }
        int n = 1073741886 - this.exponent;
        if (n <= 0) {
            return;
        }
        this.mantissa += 1L << n - 1;
        this.mantissa &= (1L << n) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        this.normalize();
    }

    public final void trunc() {
        if (this.exponent < 0 || this.mantissa == 0L) {
            return;
        }
        if (this.exponent < 0x40000000) {
            this.makeZero(this.sign);
            return;
        }
        int n = 1073741886 - this.exponent;
        if (n <= 0) {
            return;
        }
        this.mantissa &= (1L << n) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        this.normalize();
    }

    public final void frac() {
        if (this.exponent < 0 || this.mantissa == 0L || this.exponent < 0x40000000) {
            return;
        }
        int n = 1073741886 - this.exponent;
        if (n <= 0) {
            this.makeZero(this.sign);
            return;
        }
        this.mantissa &= (1L << n) - 1L;
        this.normalize();
    }

    public final int toInteger() {
        if (this.exponent == 0 && this.mantissa == 0L || this.exponent < 0 && this.mantissa != 0L) {
            return 0;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            if (this.sign == 0) {
                return Integer.MAX_VALUE;
            }
            return -2147483647;
        }
        if (this.exponent < 0x40000000) {
            return 0;
        }
        int n = 1073741886 - this.exponent;
        if (n < 32) {
            if (this.sign == 0) {
                return Integer.MAX_VALUE;
            }
            return -2147483647;
        }
        if (this.sign == 0) {
            return (int)(this.mantissa >>> n);
        }
        return -((int)(this.mantissa >>> n));
    }

    public final long toLong() {
        if (this.exponent == 0 && this.mantissa == 0L || this.exponent < 0 && this.mantissa != 0L) {
            return 0L;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            if (this.sign == 0) {
                return Long.MAX_VALUE;
            }
            return -9223372036854775807L;
        }
        if (this.exponent < 0x40000000) {
            return 0L;
        }
        int n = 1073741886 - this.exponent;
        if (n < 0) {
            if (this.sign == 0) {
                return Long.MAX_VALUE;
            }
            return -9223372036854775807L;
        }
        if (this.sign == 0) {
            return this.mantissa >>> n;
        }
        return -(this.mantissa >>> n);
    }

    public final boolean isIntegral() {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return false;
        }
        if (this.exponent == 0 && this.mantissa == 0L || this.exponent < 0 && this.mantissa == 0L) {
            return true;
        }
        if (this.exponent < 0x40000000) {
            return false;
        }
        int n = 1073741886 - this.exponent;
        if (n <= 0) {
            return true;
        }
        return (this.mantissa & (1L << n) - 1L) == 0L;
    }

    public final boolean isOdd() {
        if (this.exponent < 0 || this.mantissa == 0L || this.exponent < 0x40000000 || this.exponent > 1073741886) {
            return false;
        }
        int n = 1073741886 - this.exponent;
        return (this.mantissa >>> n & 1L) != 0L;
    }

    public final void swap(Real real) {
        long l = this.mantissa;
        this.mantissa = real.mantissa;
        real.mantissa = l;
        int n = this.exponent;
        this.exponent = real.exponent;
        real.exponent = n;
        n = this.sign;
        this.sign = real.sign;
        real.sign = (byte)n;
    }

    public final void add(Real real) {
        long l;
        int n;
        byte by;
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L) {
            this.makeNan();
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L || real.exponent < 0 && real.mantissa == 0L) {
            if (this.exponent < 0 && this.mantissa == 0L && real.exponent < 0 && real.mantissa == 0L && this.sign != real.sign) {
                this.makeNan();
                return;
            }
            this.makeInfinity(this.exponent < 0 && this.mantissa == 0L ? this.sign : real.sign);
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L || real.exponent == 0 && real.mantissa == 0L) {
            if (this.exponent == 0 && this.mantissa == 0L) {
                this.mantissa = real.mantissa;
                this.exponent = real.exponent;
                this.sign = real.sign;
            }
            if (this.exponent == 0 && this.mantissa == 0L) {
                this.sign = 0;
            }
            return;
        }
        if (this.exponent > real.exponent || this.exponent == real.exponent && this.mantissa >= real.mantissa) {
            by = real.sign;
            n = real.exponent;
            l = real.mantissa;
        } else {
            by = this.sign;
            n = this.exponent;
            l = this.mantissa;
            this.sign = real.sign;
            this.exponent = real.exponent;
            this.mantissa = real.mantissa;
        }
        int n2 = this.exponent - n;
        if (n2 >= 64) {
            return;
        }
        if (this.sign == by) {
            this.mantissa += l >>> n2;
            if (this.mantissa >= 0L && n2 > 0 && (l >>> n2 - 1 & 1L) != 0L) {
                ++this.mantissa;
            }
            if (this.mantissa < 0L) {
                this.mantissa = this.mantissa + 1L >>> 1;
                ++this.exponent;
                if (this.exponent < 0) {
                    this.makeInfinity(this.sign);
                    return;
                }
            }
        } else {
            if (n2 > 0) {
                this.mantissa <<= 1;
                --this.exponent;
                --n2;
            }
            l = -l;
            this.mantissa += l >> n2;
            if (this.mantissa >= 0L && n2 > 0 && (l >>> n2 - 1 & 1L) != 0L) {
                ++this.mantissa;
            }
            if (this.mantissa < 0L) {
                this.mantissa = this.mantissa + 1L >>> 1;
                ++this.exponent;
            } else if (n2 == 0) {
                if (magicRounding && this.mantissa > 0L && this.mantissa <= 7L) {
                    l = -l;
                    if (this.exponent == 1073741884 || this.exponent == 1073741885 || this.exponent == 1073741886 && this.mantissa + l > 0L) {
                        long l2 = (1 << 1073741886 - this.exponent) - 1;
                        if ((this.mantissa & l2) != 0L || (l & l2) != 0L) {
                            this.mantissa = 0L;
                        }
                    } else {
                        this.mantissa = 0L;
                    }
                }
                this.normalize();
            }
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.sign = 0;
        }
    }

    public final void add(int n) {
        a.assign(n);
        this.add(a);
    }

    public final long add128(long l, Real real, long l2) {
        long l3;
        long l4;
        int n;
        byte by;
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L) {
            this.makeNan();
            return 0L;
        }
        if (this.exponent < 0 && this.mantissa == 0L || real.exponent < 0 && real.mantissa == 0L) {
            if (this.exponent < 0 && this.mantissa == 0L && real.exponent < 0 && real.mantissa == 0L && this.sign != real.sign) {
                this.makeNan();
            } else {
                this.makeInfinity(this.exponent < 0 && this.mantissa == 0L ? this.sign : real.sign);
            }
            return 0L;
        }
        if (this.exponent == 0 && this.mantissa == 0L || real.exponent == 0 && real.mantissa == 0L) {
            if (this.exponent == 0 && this.mantissa == 0L) {
                this.mantissa = real.mantissa;
                this.exponent = real.exponent;
                this.sign = real.sign;
                l = l2;
            }
            if (this.exponent == 0 && this.mantissa == 0L) {
                this.sign = 0;
            }
            return l;
        }
        if (this.exponent > real.exponent || this.exponent == real.exponent && this.mantissa > real.mantissa || this.exponent == real.exponent && this.mantissa == real.mantissa && l >>> 1 >= l2 >>> 1) {
            by = real.sign;
            n = real.exponent;
            l4 = real.mantissa;
            l3 = l2;
        } else {
            by = this.sign;
            n = this.exponent;
            l4 = this.mantissa;
            l3 = l;
            this.sign = real.sign;
            this.exponent = real.exponent;
            this.mantissa = real.mantissa;
            l = l2;
        }
        int n2 = this.exponent - n;
        if (n2 >= 127) {
            return l;
        }
        if (n2 >= 64) {
            l3 = l4 >>> n2 - 64;
            l4 = 0L;
        } else if (n2 > 0) {
            l3 = (l3 >>> n2) + (l4 << 64 - n2);
            l4 >>>= n2;
        }
        l >>>= 1;
        l3 >>>= 1;
        if (this.sign == by) {
            this.mantissa += (l += l3) >> 63 & 1L;
            this.mantissa += l4;
        } else {
            this.mantissa -= (l -= l3) >> 63 & 1L;
            this.mantissa -= l4;
            if (this.mantissa == 0L && l > 0L && l <= 31L) {
                l = 0L;
            }
        }
        l <<= 1;
        l = this.normalize128(l);
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.sign = 0;
        }
        return l;
    }

    public final void sub(Real real) {
        Real.a.mantissa = real.mantissa;
        Real.a.exponent = real.exponent;
        Real.a.sign = (byte)(real.sign ^ 1);
        this.add(a);
    }

    public final void sub(int n) {
        a.assign(n);
        this.sub(a);
    }

    public final void mul(Real real) {
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L) {
            this.makeNan();
            return;
        }
        this.sign = (byte)(this.sign ^ real.sign);
        if (this.exponent == 0 && this.mantissa == 0L || real.exponent == 0 && real.mantissa == 0L) {
            if (this.exponent < 0 && this.mantissa == 0L || real.exponent < 0 && real.mantissa == 0L) {
                this.makeNan();
                return;
            }
            this.makeZero(this.sign);
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L || real.exponent < 0 && real.mantissa == 0L) {
            this.makeInfinity(this.sign);
            return;
        }
        long l = this.mantissa & Integer.MAX_VALUE;
        long l2 = this.mantissa >>> 31;
        long l3 = real.mantissa & Integer.MAX_VALUE;
        long l4 = real.mantissa >>> 31;
        this.mantissa = l2 * l4;
        int n = this.mantissa < 0L ? 0 : 0x40000000;
        this.mantissa += l * l4 + l2 * l3 + (l * l3 >>> 31) + (long)n >>> 31;
        int n2 = real.exponent;
        this.exponent += n2 - 0x40000000;
        if (this.exponent < 0 && (this.exponent != -1 || n2 >= 0x40000000 || this.mantissa >= 0L)) {
            if (n2 < 0x40000000) {
                this.makeZero(this.sign);
                return;
            }
            this.makeInfinity(this.sign);
            return;
        }
        if (this.mantissa < 0L) {
            this.mantissa = this.mantissa + 1L >>> 1;
            ++this.exponent;
            if (this.exponent < 0) {
                this.makeInfinity(this.sign);
            }
        }
    }

    public final void mul(int n) {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return;
        }
        if (n < 0) {
            this.sign = (byte)(this.sign ^ 1);
            n = -n;
        }
        if (this.exponent == 0 && this.mantissa == 0L || n == 0) {
            if (this.exponent < 0 && this.mantissa == 0L) {
                this.makeNan();
                return;
            }
            this.makeZero(this.sign);
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            return;
        }
        int n2 = n;
        n2 |= n2 >> 1;
        n2 |= n2 >> 2;
        n2 |= n2 >> 4;
        n2 |= n2 >> 8;
        n2 |= n2 >> 16;
        n2 = a[n2 * 130329821 >>> 27];
        this.exponent += 31 - n2;
        n <<= n2;
        if (this.exponent < 0) {
            this.makeInfinity(this.sign);
            return;
        }
        long l = this.mantissa & Integer.MAX_VALUE;
        long l2 = this.mantissa >>> 31;
        long l3 = (long)n & 0xFFFFFFFFL;
        this.mantissa = l2 * l3;
        n = this.mantissa < 0L ? 0 : 0x40000000;
        this.mantissa += l * l3 + (long)n >>> 31;
        if (this.mantissa < 0L) {
            this.mantissa = this.mantissa + 1L >>> 1;
            ++this.exponent;
            if (this.exponent < 0) {
                this.makeInfinity(this.sign);
            }
        }
    }

    public final long mul128(long l, Real real, long l2) {
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L) {
            this.makeNan();
            return 0L;
        }
        this.sign = (byte)(this.sign ^ real.sign);
        if (this.exponent == 0 && this.mantissa == 0L || real.exponent == 0 && real.mantissa == 0L) {
            if (this.exponent < 0 && this.mantissa == 0L || real.exponent < 0 && real.mantissa == 0L) {
                this.makeNan();
            } else {
                this.makeZero(this.sign);
            }
            return 0L;
        }
        if (this.exponent < 0 && this.mantissa == 0L || real.exponent < 0 && real.mantissa == 0L) {
            this.makeInfinity(this.sign);
            return 0L;
        }
        int n = real.exponent;
        this.exponent += n - 0x40000000;
        if (this.exponent < 0) {
            if (n < 0x40000000) {
                this.makeZero(this.sign);
            } else {
                this.makeInfinity(this.sign);
            }
            return 0L;
        }
        long l3 = l & 0xFFFFFFFFL;
        long l4 = l >>> 32;
        long l5 = this.mantissa & 0xFFFFFFFFL;
        long l6 = this.mantissa >>> 32;
        long l7 = l2 & 0xFFFFFFFFL;
        long l8 = l2 >>> 32;
        long l9 = real.mantissa & 0xFFFFFFFFL;
        long l10 = real.mantissa >>> 32;
        l3 = (l6 * l7 >>> 2) + (l5 * l8 >>> 2) + (l4 * l9 >>> 2) + (l3 * l10 >>> 2) + 0x60000000L >>> 28;
        l7 = l5 * l9;
        l4 = ((l3 += ((l4 *= l10) << 2 & 0xFFFFFFFFL) + (l7 << 2 & 0xFFFFFFFFL) + ((l8 *= l6) << 2 & 0xFFFFFFFFL)) >>> 32) + (l4 >>> 30) + (l7 >>> 30) + (l8 >>> 30);
        l = ((l4 += ((l5 *= l10) << 2 & 0xFFFFFFFFL) + ((l9 *= l6) << 2 & 0xFFFFFFFFL)) << 32) + (l3 &= 0xFFFFFFFFL);
        this.mantissa = (l6 * l10 << 2) + (l4 >>> 32) + (l5 >>> 30) + (l9 >>> 30);
        l = this.normalize128(l);
        return l;
    }

    private void a() {
        if (this.exponent < 0 || this.mantissa == 0L) {
            return;
        }
        this.mantissa += this.mantissa + 2L >>> 2;
        this.exponent += 3;
        if (this.mantissa < 0L) {
            this.mantissa = this.mantissa + 1L >>> 1;
            ++this.exponent;
        }
        if (this.exponent < 0) {
            this.makeInfinity(this.sign);
        }
    }

    public final void sqr() {
        this.sign = 0;
        if (this.exponent < 0 || this.mantissa == 0L) {
            return;
        }
        int n = this.exponent;
        this.exponent += this.exponent - 0x40000000;
        if (this.exponent < 0) {
            if (n < 0x40000000) {
                this.makeZero(this.sign);
                return;
            }
            this.makeInfinity(this.sign);
            return;
        }
        long l = this.mantissa & Integer.MAX_VALUE;
        long l2 = this.mantissa >>> 31;
        this.mantissa = l2 * l2;
        n = this.mantissa < 0L ? 0 : 0x40000000;
        this.mantissa += (l * l2 << 1) + (l * l >>> 31) + (long)n >>> 31;
        if (this.mantissa < 0L) {
            this.mantissa = this.mantissa + 1L >>> 1;
            ++this.exponent;
            if (this.exponent < 0) {
                this.makeInfinity(this.sign);
            }
        }
    }

    private static long a(long l, long l2) {
        int n = (int)(0x400000000000L / ((l2 >>> 40) + 1L));
        int n2 = (int)(l >> 32) >>> 8;
        l <<= 20;
        n2 = (int)((long)n2 * (long)n >>> 26);
        l -= (long)n2 * l2;
        long l3 = n2;
        n2 = (int)(l >> 32) >>> 7;
        l <<= 21;
        n2 = (int)((long)n2 * (long)n >>> 26);
        l -= (long)n2 * l2;
        l3 = (l3 << 21) + (long)n2;
        n2 = (int)(l >> 32) >>> 7;
        l <<= 21;
        n2 = (int)((long)n2 * (long)n >>> 26);
        l3 = (l3 << 21) + (long)n2;
        if ((l -= (long)n2 * l2) < 0L || l >= l2) {
            ++l3;
            l -= l2;
        }
        if ((l <<= 1) < 0L || l >= l2) {
            ++l3;
        }
        return l3;
    }

    public final void div(Real real) {
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L) {
            this.makeNan();
            return;
        }
        this.sign = (byte)(this.sign ^ real.sign);
        if (this.exponent < 0 && this.mantissa == 0L) {
            if (real.exponent < 0 && real.mantissa == 0L) {
                this.makeNan();
            }
            return;
        }
        if (real.exponent < 0 && real.mantissa == 0L) {
            this.makeZero(this.sign);
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            if (real.exponent == 0 && real.mantissa == 0L) {
                this.makeNan();
            }
            return;
        }
        if (real.exponent == 0 && real.mantissa == 0L) {
            this.makeInfinity(this.sign);
            return;
        }
        this.exponent += 0x40000000 - real.exponent;
        if (this.mantissa < real.mantissa) {
            this.mantissa <<= 1;
            --this.exponent;
        }
        if (this.exponent < 0) {
            if (real.exponent >= 0x40000000) {
                this.makeZero(this.sign);
                return;
            }
            this.makeInfinity(this.sign);
            return;
        }
        if (real.mantissa == 0x4000000000000000L) {
            return;
        }
        this.mantissa = Real.a(this.mantissa, real.mantissa);
    }

    public final void div(int n) {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return;
        }
        if (n < 0) {
            this.sign = (byte)(this.sign ^ 1);
            n = -n;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            if (n == 0) {
                this.makeNan();
            }
            return;
        }
        if (n == 0) {
            this.makeInfinity(this.sign);
            return;
        }
        long l = (long)n & 0xFFFFFFFFL;
        long l2 = this.mantissa % l;
        this.mantissa /= l;
        n = 0;
        int n2 = (int)(this.mantissa >>> 32);
        if (n2 == 0) {
            n = 32;
            n2 = (int)this.mantissa;
        }
        n2 |= n2 >> 1;
        n2 |= n2 >> 2;
        n2 |= n2 >> 4;
        n2 |= n2 >> 8;
        n2 |= n2 >> 16;
        this.mantissa <<= (n += a[n2 * 130329821 >>> 27] - 1);
        l2 <<= n;
        this.exponent -= n;
        l2 = (l2 + l / 2L) / l;
        this.mantissa += l2;
        if (this.exponent < 0) {
            this.makeZero(this.sign);
        }
    }

    public final void rdiv(Real real) {
        Real.b.mantissa = real.mantissa;
        Real.b.exponent = real.exponent;
        Real.b.sign = real.sign;
        b.div(this);
        this.mantissa = Real.b.mantissa;
        this.exponent = Real.b.exponent;
        this.sign = Real.b.sign;
    }

    public final void rdiv(int n) {
        a.assign(n);
        this.rdiv(a);
    }

    public final void recip() {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            this.makeZero(this.sign);
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.makeInfinity(this.sign);
            return;
        }
        this.exponent = Integer.MIN_VALUE - this.exponent;
        if (this.mantissa == 0x4000000000000000L) {
            if (this.exponent < 0) {
                this.makeInfinity(this.sign);
            }
            return;
        }
        --this.exponent;
        this.mantissa = Real.a(Long.MIN_VALUE, this.mantissa);
    }

    public final long recip128(long l) {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return 0L;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            this.makeZero(this.sign);
            return 0L;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.makeInfinity(this.sign);
            return 0L;
        }
        byte by = this.sign;
        this.sign = 0;
        if (this.mantissa == 0x4000000000000000L && l == 0L) {
            this.exponent = Integer.MIN_VALUE - this.exponent;
            if (this.exponent < 0) {
                this.makeInfinity(by);
            }
            return 0L;
        }
        int n = 0x40000000 - this.exponent;
        this.exponent = 0x40000000;
        Real.b.mantissa = this.mantissa;
        Real.b.exponent = this.exponent;
        Real.b.sign = this.sign;
        b.neg();
        this.recip();
        Real.c.mantissa = this.mantissa;
        Real.c.exponent = this.exponent;
        Real.c.sign = this.sign;
        l = this.mul128(0L, b, l);
        l = this.add128(l, ONE, 0L);
        l = this.mul128(l, c, 0L);
        l = this.add128(l, c, 0L);
        this.scalbn(n);
        if (!this.isNan()) {
            this.sign = by;
        }
        return l;
    }

    public final void divf(Real real) {
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L) {
            this.makeNan();
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            if (real.exponent < 0 && real.mantissa == 0L) {
                this.makeNan();
            }
            return;
        }
        if (real.exponent < 0 && real.mantissa == 0L) {
            this.makeZero(this.sign);
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            if (real.exponent == 0 && real.mantissa == 0L) {
                this.makeNan();
            }
            return;
        }
        if (real.exponent == 0 && real.mantissa == 0L) {
            this.makeInfinity(this.sign);
            return;
        }
        Real.a.mantissa = real.mantissa;
        Real.a.exponent = real.exponent;
        Real.a.sign = real.sign;
        long l = a.recip128(0L);
        l = this.mul128(0L, a, l);
        if (Real.a.sign != 0 && (l < 0L || l > 31L) || Real.a.sign == 0 && l < 0L && l > -32L) {
            ++this.mantissa;
            this.normalize();
        }
        this.floor();
    }

    private void a(Real real, long l) {
        Real.a.mantissa = real.mantissa;
        Real.a.exponent = real.exponent;
        Real.a.sign = real.sign;
        long l2 = a.recip128(l);
        l2 = a.mul128(l2, this, 0L);
        if (Real.a.exponent > 1073741886) {
            this.makeZero(real.sign);
            return;
        }
        if (Real.a.sign != 0 && (l2 < 0L || l2 > 31L) || Real.a.sign == 0 && l2 < 0L && l2 > -32L) {
            ++Real.a.mantissa;
            a.normalize();
        }
        a.floor();
        a.neg();
        l2 = a.mul128(0L, real, l);
        l2 = this.add128(0L, a, l2);
        this.roundFrom128(l2);
    }

    public final void mod(Real real) {
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L) {
            this.makeNan();
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            this.makeNan();
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            if (real.exponent == 0 && real.mantissa == 0L) {
                this.makeNan();
                return;
            }
            this.sign = real.sign;
            return;
        }
        if (real.exponent < 0 && real.mantissa == 0L) {
            if (this.sign != real.sign) {
                this.makeInfinity(real.sign);
            }
            return;
        }
        if (real.exponent == 0 && real.mantissa == 0L) {
            this.makeZero(real.sign);
            return;
        }
        this.a(real, 0L);
    }

    public final void and(Real real) {
        long l;
        int n;
        byte by;
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L) {
            this.makeNan();
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L || real.exponent == 0 && real.mantissa == 0L) {
            this.makeZero();
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L || real.exponent < 0 && real.mantissa == 0L) {
            if ((this.exponent >= 0 || this.mantissa != 0L) && this.sign != 0) {
                this.mantissa = real.mantissa;
                this.exponent = real.exponent;
                this.sign = real.sign;
                return;
            }
            if ((real.exponent < 0 && real.mantissa == 0L || real.sign == 0) && (this.exponent >= 0 || this.mantissa != 0L || real.exponent >= 0 || real.mantissa != 0L || this.sign == 0 || real.sign == 0)) {
                this.makeZero();
            }
            return;
        }
        if (this.exponent >= real.exponent) {
            by = real.sign;
            n = real.exponent;
            l = real.mantissa;
        } else {
            by = this.sign;
            n = this.exponent;
            l = this.mantissa;
            this.sign = real.sign;
            this.exponent = real.exponent;
            this.mantissa = real.mantissa;
        }
        int n2 = this.exponent - n;
        if (n2 >= 64) {
            if (by == 0) {
                this.makeZero(this.sign);
            }
            return;
        }
        if (by != 0) {
            l = -l;
        }
        if (this.sign != 0) {
            this.mantissa = -this.mantissa;
        }
        this.mantissa &= l >> n2;
        this.sign = 0;
        if (this.mantissa < 0L) {
            this.mantissa = -this.mantissa;
            this.sign = 1;
        }
        this.normalize();
    }

    public final void or(Real real) {
        long l;
        int n;
        byte by;
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L) {
            this.makeNan();
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L || real.exponent == 0 && real.mantissa == 0L) {
            if (this.exponent == 0 && this.mantissa == 0L) {
                this.mantissa = real.mantissa;
                this.exponent = real.exponent;
                this.sign = real.sign;
            }
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L || real.exponent < 0 && real.mantissa == 0L) {
            if (this.exponent < 0 && this.mantissa == 0L || this.sign == 0) {
                if ((real.exponent >= 0 || real.mantissa != 0L) && real.sign != 0) {
                    this.mantissa = real.mantissa;
                    this.exponent = real.exponent;
                    this.sign = real.sign;
                    return;
                }
                this.makeInfinity(this.sign | real.sign);
            }
            return;
        }
        if (this.sign != 0 && this.exponent <= real.exponent || real.sign == 0 && this.exponent >= real.exponent) {
            by = real.sign;
            n = real.exponent;
            l = real.mantissa;
        } else {
            by = this.sign;
            n = this.exponent;
            l = this.mantissa;
            this.sign = real.sign;
            this.exponent = real.exponent;
            this.mantissa = real.mantissa;
        }
        int n2 = this.exponent - n;
        if (n2 >= 64 || n2 <= -64) {
            return;
        }
        if (by != 0) {
            l = -l;
        }
        if (this.sign != 0) {
            this.mantissa = -this.mantissa;
        }
        this.mantissa = n2 >= 0 ? (this.mantissa |= l >> n2) : (this.mantissa |= l << -n2);
        this.sign = 0;
        if (this.mantissa < 0L) {
            this.mantissa = -this.mantissa;
            this.sign = 1;
        }
        this.normalize();
    }

    public final void xor(Real real) {
        long l;
        int n;
        byte by;
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L) {
            this.makeNan();
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L || real.exponent == 0 && real.mantissa == 0L) {
            if (this.exponent == 0 && this.mantissa == 0L) {
                this.mantissa = real.mantissa;
                this.exponent = real.exponent;
                this.sign = real.sign;
            }
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L || real.exponent < 0 && real.mantissa == 0L) {
            this.makeInfinity(this.sign ^ real.sign);
            return;
        }
        if (this.exponent >= real.exponent) {
            by = real.sign;
            n = real.exponent;
            l = real.mantissa;
        } else {
            by = this.sign;
            n = this.exponent;
            l = this.mantissa;
            this.sign = real.sign;
            this.exponent = real.exponent;
            this.mantissa = real.mantissa;
        }
        int n2 = this.exponent - n;
        if (n2 >= 64) {
            return;
        }
        if (by != 0) {
            l = -l;
        }
        if (this.sign != 0) {
            this.mantissa = -this.mantissa;
        }
        this.mantissa ^= l >> n2;
        this.sign = 0;
        if (this.mantissa < 0L) {
            this.mantissa = -this.mantissa;
            this.sign = 1;
        }
        this.normalize();
    }

    public final void bic(Real real) {
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L) {
            this.makeNan();
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L || real.exponent == 0 && real.mantissa == 0L) {
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L || real.exponent < 0 && real.mantissa == 0L) {
            if (this.exponent >= 0 || this.mantissa != 0L) {
                if (this.sign != 0) {
                    if (real.sign != 0) {
                        this.makeInfinity(0);
                        return;
                    }
                    this.makeInfinity(1);
                    return;
                }
            } else if (real.sign != 0) {
                if (real.exponent < 0 && real.mantissa == 0L) {
                    this.makeInfinity(0);
                    return;
                }
                this.makeZero();
            }
            return;
        }
        int n = this.exponent - real.exponent;
        if (n >= 64 || n <= -64 && this.sign == 0) {
            return;
        }
        long l = real.mantissa;
        if (real.sign != 0) {
            l = -l;
        }
        if (this.sign != 0) {
            this.mantissa = -this.mantissa;
        }
        if (n < 0) {
            if (this.sign != 0) {
                this.mantissa = n <= -64 ? l ^ 0xFFFFFFFFFFFFFFFFL : this.mantissa >> -n & (l ^ 0xFFFFFFFFFFFFFFFFL);
                this.exponent = real.exponent;
            } else {
                this.mantissa &= l << -n ^ 0xFFFFFFFFFFFFFFFFL;
            }
        } else {
            this.mantissa &= l >> n ^ 0xFFFFFFFFFFFFFFFFL;
        }
        this.sign = 0;
        if (this.mantissa < 0L) {
            this.mantissa = -this.mantissa;
            this.sign = 1;
        }
        this.normalize();
    }

    private int a(int n) {
        a.assign(n);
        return this.a(a);
    }

    public final void sqrt() {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.sign = 0;
            return;
        }
        if (this.sign != 0) {
            this.makeNan();
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            return;
        }
        Real.b.mantissa = this.mantissa;
        Real.b.exponent = this.exponent;
        Real.b.sign = this.sign;
        int n = this.exponent - 0x3FFFFFFF;
        this.exponent = 0x3FFFFFFF;
        Real.c.mantissa = this.mantissa;
        Real.c.exponent = this.exponent;
        Real.c.sign = this.sign;
        Real.d.sign = 1;
        Real.d.exponent = 0x3FFFFFFD;
        Real.d.mantissa = 7541244123455418907L;
        this.mul(d);
        Real.d.sign = 0;
        Real.d.exponent = 0x3FFFFFFF;
        Real.d.mantissa = 8210591124990847720L;
        this.add(d);
        this.mul(c);
        Real.d.sign = 0;
        Real.d.exponent = 0x3FFFFFFE;
        Real.d.mantissa = 5784291442694842234L;
        this.add(d);
        if ((n & 1) != 0) {
            this.mul(SQRT2);
        }
        this.exponent += n >> 1;
        for (n = 0; n < 3; ++n) {
            Real.c.mantissa = Real.b.mantissa;
            Real.c.exponent = Real.b.exponent;
            Real.c.sign = Real.b.sign;
            c.div(this);
            this.add(c);
            this.scalbn(-1);
        }
    }

    public final void rsqrt() {
        this.sqrt();
        this.recip();
    }

    public final void cbrt() {
        if (this.exponent < 0 || this.mantissa == 0L) {
            return;
        }
        byte by = this.sign;
        this.sign = 0;
        Real.b.mantissa = this.mantissa;
        Real.b.exponent = this.exponent;
        Real.b.sign = this.sign;
        b.neg();
        this.mantissa = 5845672316326903808L - (this.mantissa >>> 2);
        int n = this.exponent == 0 ? 2 : (this.exponent - 1) % 3;
        this.exponent = 0x40000000 - (this.exponent - 0x40000000 - n) / 3;
        this.normalize();
        if (n > 0) {
            Real.c.sign = 0;
            Real.c.exponent = 0x3FFFFFFF;
            Real.c.mantissa = 7320595236998672907L;
            this.mul(c);
            if (n > 1) {
                this.mul(c);
            }
        }
        for (n = 0; n < 4; ++n) {
            Real.c.mantissa = this.mantissa;
            Real.c.exponent = this.exponent;
            Real.c.sign = this.sign;
            this.sqr();
            this.sqr();
            this.mul(b);
            c.scalbn(2);
            this.add(c);
            this.mul(THIRD);
        }
        this.recip();
        if (this.exponent >= 0 || this.mantissa == 0L) {
            this.sign = by;
        }
    }

    public final void nroot(Real real) {
        if (real.exponent < 0 && real.mantissa != 0L) {
            this.makeNan();
            return;
        }
        if (real.a(THREE) == 0) {
            this.cbrt();
            return;
        }
        if (real.a(TWO) == 0) {
            this.sqrt();
            return;
        }
        boolean bl = false;
        if (this.sign != 0 && real.isIntegral() && real.isOdd()) {
            bl = true;
            Real real2 = this;
            this.sign = 0;
        }
        Real.i.mantissa = real.mantissa;
        Real.i.exponent = real.exponent;
        Real.i.sign = real.sign;
        i.recip();
        this.pow(i);
        if (bl) {
            this.neg();
        }
    }

    public final void hypot(Real real) {
        Real.h.mantissa = real.mantissa;
        Real.h.exponent = real.exponent;
        Real.h.sign = real.sign;
        h.sqr();
        this.sqr();
        this.add(h);
        this.sqrt();
    }

    private void a(long l) {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            if (this.sign != 0) {
                this.makeZero(0);
            }
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.mantissa = Real.ONE.mantissa;
            this.exponent = Real.ONE.exponent;
            this.sign = Real.ONE.sign;
            return;
        }
        Real.e.mantissa = this.mantissa;
        Real.e.exponent = this.exponent;
        Real.e.sign = this.sign;
        e.add(HALF);
        e.floor();
        int n = e.toInteger();
        if (n > 0x40000000) {
            this.makeInfinity(this.sign);
            return;
        }
        if (n < -1073741824) {
            this.makeZero(this.sign);
            return;
        }
        e.neg();
        this.add128(l, e, 0L);
        Real.f.mantissa = this.mantissa;
        Real.f.exponent = this.exponent;
        Real.f.sign = this.sign;
        f.sqr();
        Real.e.sign = 0;
        Real.e.exponent = 0x40000005;
        Real.e.mantissa = 8735521019871854572L;
        e.mul(f);
        Real.g.sign = 0;
        Real.g.exponent = 0x4000000E;
        Real.g.mantissa = 8525024715132279315L;
        e.add(g);
        e.mul(f);
        Real.g.sign = 0;
        Real.g.exponent = 0x40000014;
        Real.g.mantissa = 9149627190283911008L;
        e.add(g);
        this.mul(e);
        e.assign(f);
        Real.g.sign = 0;
        Real.g.exponent = 0x4000000A;
        Real.g.mantissa = 7878091433835080621L;
        e.add(g);
        e.mul(f);
        Real.g.sign = 0;
        Real.g.exponent = 1073741842;
        Real.g.mantissa = 5765401886743753158L;
        e.add(g);
        e.mul(f);
        Real.g.sign = 0;
        Real.g.exponent = 1073741846;
        Real.g.mantissa = 6600060886702709183L;
        e.add(g);
        e.sub(this);
        this.div(e);
        this.scalbn(1);
        this.add(ONE);
        this.scalbn(n);
    }

    public final void exp() {
        Real.e.sign = 0;
        Real.e.exponent = 0x40000000;
        Real.e.mantissa = 6653256548922161245L;
        long l = this.mul128(0L, e, -2358760956788564156L);
        this.a(l);
    }

    public final void exp2() {
        this.a(0L);
    }

    public final void exp10() {
        Real.e.sign = 0;
        Real.e.exponent = 0x40000001;
        Real.e.mantissa = 7659844674706589055L;
        long l = this.mul128(0L, e, 2636289682573880742L);
        this.a(l);
    }

    private int a() {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return 0;
        }
        if (this.sign != 0) {
            this.makeNan();
            return 0;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.makeInfinity(1);
            return 0;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            return 0;
        }
        int n = this.exponent - 0x3FFFFFFF;
        this.exponent = 0x3FFFFFFF;
        if (this.a(SQRT1_2) < 0) {
            --n;
            ++this.exponent;
        }
        this.sub(ONE);
        Real.f.mantissa = this.mantissa;
        Real.f.exponent = this.exponent;
        Real.f.sign = this.sign;
        this.sign = 0;
        this.exponent = 0x3FFFFFF1;
        this.mantissa = 6841009112073316573L;
        this.mul(f);
        Real.g.sign = 0;
        Real.g.exponent = 0x3FFFFFFE;
        Real.g.mantissa = 9196458758038490344L;
        this.add(g);
        this.mul(f);
        Real.g.sign = 0;
        Real.g.exponent = 0x40000002;
        Real.g.mantissa = 7584762280918207649L;
        this.add(g);
        this.mul(f);
        Real.g.sign = 0;
        Real.g.exponent = 0x40000004;
        Real.g.mantissa = 8621523759488509294L;
        this.add(g);
        this.mul(f);
        Real.g.sign = 0;
        Real.g.exponent = 0x40000005;
        Real.g.mantissa = 8783772864241025570L;
        this.add(g);
        this.mul(f);
        Real.g.sign = 0;
        Real.g.exponent = 0x40000005;
        Real.g.mantissa = 8230845489426743510L;
        this.add(g);
        this.mul(f);
        Real.g.sign = 0;
        Real.g.exponent = 0x40000004;
        Real.g.mantissa = 5776008042987136607L;
        this.add(g);
        Real.e.mantissa = Real.f.mantissa;
        Real.e.exponent = Real.f.exponent;
        Real.e.sign = Real.f.sign;
        Real.g.sign = 0;
        Real.g.exponent = 0x40000003;
        Real.g.mantissa = 8683175902134721628L;
        e.add(g);
        e.mul(f);
        Real.g.sign = 0;
        Real.g.exponent = 0x40000006;
        Real.g.mantissa = 5984207794357820952L;
        e.add(g);
        e.mul(f);
        Real.g.sign = 0;
        Real.g.exponent = 0x40000007;
        Real.g.mantissa = 7989832432531363702L;
        e.add(g);
        e.mul(f);
        Real.g.sign = 0;
        Real.g.exponent = 0x40000008;
        Real.g.mantissa = 5568227561439401455L;
        e.add(g);
        e.mul(f);
        Real.g.sign = 0;
        Real.g.exponent = 0x40000007;
        Real.g.mantissa = 7797636379160189072L;
        e.add(g);
        e.mul(f);
        Real.g.sign = 0;
        Real.g.exponent = 0x40000005;
        Real.g.mantissa = 8664012064480704931L;
        e.add(g);
        this.div(e);
        Real.g.mantissa = Real.f.mantissa;
        Real.g.exponent = Real.f.exponent;
        Real.g.sign = Real.f.sign;
        g.sqr();
        this.mul(g);
        this.mul(f);
        g.scalbn(-1);
        this.sub(g);
        this.add(f);
        return n;
    }

    public final void ln() {
        int n = this.a();
        e.assign(n);
        e.mul(LN2);
        this.add(e);
    }

    public final void log2() {
        int n = this.a();
        this.mul(LOG2E);
        this.add(n);
    }

    public final void log10() {
        int n = this.a();
        e.assign(n);
        e.mul(LN2);
        this.add(e);
        this.mul(LOG10E);
    }

    public final int lowPow10() {
        if (this.exponent < 0 || this.mantissa == 0L) {
            return 0;
        }
        Real.i.mantissa = this.mantissa;
        Real.i.exponent = this.exponent;
        Real.i.sign = this.sign;
        int n = this.exponent - 0x40000000;
        n = n < 0 ? -((int)((long)(-n) * 1292913987L + 0xFFFFFFFFL >> 32)) : (int)((long)n * 1292913987L >> 32);
        this.mantissa = Real.TEN.mantissa;
        this.exponent = Real.TEN.exponent;
        this.sign = Real.TEN.sign;
        this.pow(n);
        if (this.exponent == 0 && this.mantissa == 0L) {
            Real.j.mantissa = Real.TEN.mantissa;
            Real.j.exponent = Real.TEN.exponent;
            Real.j.sign = Real.TEN.sign;
            j.pow(n + 1);
        } else {
            Real.j.mantissa = this.mantissa;
            Real.j.exponent = this.exponent;
            Real.j.sign = this.sign;
            j.a();
        }
        if (j.a(i) <= 0) {
            ++n;
            this.mantissa = Real.j.mantissa;
            this.exponent = Real.j.exponent;
            this.sign = Real.j.sign;
        }
        return n;
    }

    public final void pow(Real real) {
        if (real.exponent == 0 && real.mantissa == 0L) {
            this.mantissa = Real.ONE.mantissa;
            this.exponent = Real.ONE.exponent;
            this.sign = Real.ONE.sign;
            return;
        }
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L) {
            this.makeNan();
            return;
        }
        if (real.a(ONE) == 0) {
            return;
        }
        if (real.exponent < 0 && real.mantissa == 0L) {
            Real.h.mantissa = this.mantissa;
            Real.h.exponent = this.exponent;
            Real.h.sign = this.sign;
            Real real2 = h;
            h.sign = 0;
            int n = h.a(ONE);
            if (n > 0) {
                if (real.sign == 0) {
                    this.makeInfinity(0);
                    return;
                }
                this.makeZero();
                return;
            }
            if (n < 0) {
                if (real.sign != 0) {
                    this.makeInfinity(0);
                    return;
                }
                this.makeZero();
                return;
            }
            this.makeNan();
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            if (this.sign == 0) {
                if (real.sign == 0) {
                    this.makeZero();
                    return;
                }
                this.makeInfinity(0);
                return;
            }
            if (real.isIntegral() && real.isOdd()) {
                if (real.sign == 0) {
                    this.makeZero(1);
                    return;
                }
                this.makeInfinity(1);
                return;
            }
            if (real.sign == 0) {
                this.makeZero();
                return;
            }
            this.makeInfinity(0);
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            if (this.sign == 0) {
                if (real.sign == 0) {
                    this.makeInfinity(0);
                    return;
                }
                this.makeZero();
                return;
            }
            if (real.isIntegral()) {
                if (real.isOdd()) {
                    if (real.sign == 0) {
                        this.makeInfinity(1);
                        return;
                    }
                    this.makeZero(1);
                    return;
                }
                if (real.sign == 0) {
                    this.makeInfinity(0);
                    return;
                }
                this.makeZero();
                return;
            }
            this.makeNan();
            return;
        }
        if (real.isIntegral() && real.exponent <= 1073741854) {
            this.pow(real.toInteger());
            return;
        }
        byte by = 0;
        if (this.sign != 0) {
            if (real.isIntegral()) {
                if (real.isOdd()) {
                    by = 1;
                }
            } else {
                this.makeNan();
                return;
            }
            this.sign = 0;
        }
        Real.h.mantissa = real.mantissa;
        Real.h.exponent = real.exponent;
        Real.h.sign = real.sign;
        if (Real.h.exponent <= 1073741854) {
            Real.i.mantissa = Real.h.mantissa;
            Real.i.exponent = Real.h.exponent;
            Real.i.sign = Real.h.sign;
            i.floor();
            Real.j.mantissa = this.mantissa;
            Real.j.exponent = this.exponent;
            Real.j.sign = this.sign;
            j.pow(i.toInteger());
            h.sub(i);
        } else {
            Real.j.mantissa = Real.ONE.mantissa;
            Real.j.exponent = Real.ONE.exponent;
            Real.j.sign = Real.ONE.sign;
        }
        int n = this.a();
        Real.i.sign = 0;
        Real.i.exponent = 0x40000000;
        Real.i.mantissa = 6653256548922161245L;
        long l = this.mul128(0L, i, -2358760956788564156L);
        i.assign(n);
        l = this.add128(l, i, 0L);
        l = h.mul128(0L, this, l);
        h.a(l);
        this.mantissa = Real.h.mantissa;
        this.exponent = Real.h.exponent;
        this.sign = Real.h.sign;
        this.mul(j);
        if (this.exponent >= 0 || this.mantissa == 0L) {
            this.sign = by;
        }
    }

    public final void pow(int n) {
        boolean bl = false;
        if (n < 0) {
            n = -n;
            bl = true;
        }
        long l = 0L;
        long l2 = 0L;
        Real.e.mantissa = this.mantissa;
        Real.e.exponent = this.exponent;
        Real.e.sign = this.sign;
        this.mantissa = Real.ONE.mantissa;
        this.exponent = Real.ONE.exponent;
        this.sign = Real.ONE.sign;
        while (n != 0) {
            if ((n & 1) != 0) {
                l = this.mul128(l, e, l2);
            }
            l2 = e.mul128(l2, e, l2);
            n >>>= 1;
        }
        if (bl) {
            l = this.recip128(l);
        }
        this.roundFrom128(l);
    }

    private void b() {
        Real.h.mantissa = this.mantissa;
        Real.h.exponent = this.exponent;
        Real.h.sign = this.sign;
        Real.i.mantissa = this.mantissa;
        Real.i.exponent = this.exponent;
        Real.i.sign = this.sign;
        i.sqr();
        this.sign = 0;
        this.exponent = 0x3FFFFFD3;
        this.mantissa = 7687440180248885787L;
        this.mul(i);
        Real.j.sign = 1;
        Real.j.exponent = 1073741787;
        Real.j.mantissa = 7270156733278459803L;
        this.add(j);
        this.mul(i);
        Real.j.sign = 0;
        Real.j.exponent = 0x3FFFFFE3;
        Real.j.mantissa = 5168834004460186024L;
        this.add(j);
        this.mul(i);
        Real.j.sign = 1;
        Real.j.exponent = 1073741802;
        Real.j.mantissa = 5330360754940094102L;
        this.add(j);
        this.mul(i);
        Real.j.sign = 0;
        Real.j.exponent = 0x3FFFFFF0;
        Real.j.mantissa = 7495819814073739767L;
        this.add(j);
        this.mul(i);
        Real.j.sign = 1;
        Real.j.exponent = 0x3FFFFFF6;
        Real.j.mantissa = 6558842337318944179L;
        this.add(j);
        this.mul(i);
        Real.j.sign = 0;
        Real.j.exponent = 0x3FFFFFFB;
        Real.j.mantissa = 0x555555555555554DL;
        this.add(j);
        this.mul(i);
        this.sub(HALF);
        this.mul(i);
        this.add(ONE);
    }

    public final void sin() {
        if (this.exponent < 0 || this.mantissa == 0L) {
            if (this.exponent != 0 || this.mantissa != 0L) {
                this.makeNan();
            }
            return;
        }
        boolean bl = false;
        if (this.sign != 0) {
            Real real = this;
            this.sign = 0;
            bl = true;
        }
        if (this.a(PI2) > 0) {
            this.a(PI2, 7089564414062235241L);
        }
        if (this.a(PI) > 0) {
            this.sub(PI2);
            this.neg();
            boolean bl2 = bl = !bl;
        }
        if (this.a(PI_2) > 0) {
            this.sub(PI);
            this.neg();
        }
        if (this.a(PI_4) > 0) {
            this.sub(PI_2);
            this.neg();
            this.b();
        } else {
            Real real = this;
            Real.h.mantissa = real.mantissa;
            Real.h.exponent = real.exponent;
            Real.h.sign = real.sign;
            Real.i.mantissa = real.mantissa;
            Real.i.exponent = real.exponent;
            Real.i.sign = real.sign;
            i.sqr();
            real.sign = 1;
            real.exponent = 1073741783;
            real.mantissa = 7685553039149311763L;
            real.mul(i);
            Real.j.sign = 0;
            Real.j.exponent = 0x3FFFFFDF;
            Real.j.mantissa = 6361373033667703404L;
            real.add(j);
            real.mul(i);
            Real.j.sign = 1;
            Real.j.exponent = 1073741798;
            Real.j.mantissa = 7753250925411172568L;
            real.add(j);
            real.mul(i);
            Real.j.sign = 0;
            Real.j.exponent = 1073741805;
            Real.j.mantissa = 6662950943449080955L;
            real.add(j);
            real.mul(i);
            Real.j.sign = 1;
            Real.j.exponent = 0x3FFFFFF3;
            Real.j.mantissa = 7495819814073119370L;
            real.add(j);
            real.mul(i);
            Real.j.sign = 0;
            Real.j.exponent = 0x3FFFFFF9;
            Real.j.mantissa = 4919131752989207373L;
            real.add(j);
            real.mul(i);
            Real.j.sign = 1;
            Real.j.exponent = 0x3FFFFFFD;
            Real.j.mantissa = 0x555555555555554CL;
            real.add(j);
            real.mul(i);
            real.mul(h);
            real.add(h);
        }
        if (bl) {
            this.neg();
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            Real real = this;
            this.sign = 0;
        }
    }

    public final void cos() {
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.mantissa = Real.ONE.mantissa;
            this.exponent = Real.ONE.exponent;
            this.sign = Real.ONE.sign;
            return;
        }
        if (this.sign != 0) {
            Real real = this;
            this.sign = 0;
        }
        if (this.a(PI_4) < 0) {
            this.b();
            return;
        }
        this.add(PI_2);
        this.sin();
    }

    public final void tan() {
        Real.k.mantissa = this.mantissa;
        Real.k.exponent = this.exponent;
        Real.k.sign = this.sign;
        k.cos();
        this.sin();
        this.div(k);
    }

    public final void asin() {
        Real.h.mantissa = this.mantissa;
        Real.h.exponent = this.exponent;
        Real.h.sign = this.sign;
        this.sqr();
        this.neg();
        this.add(ONE);
        this.rsqrt();
        this.mul(h);
        this.atan();
    }

    public final void acos() {
        boolean bl = this.sign != 0;
        Real real = this;
        this.sign = 0;
        Real.h.mantissa = this.mantissa;
        Real.h.exponent = this.exponent;
        Real.h.sign = this.sign;
        this.sqr();
        this.neg();
        this.add(ONE);
        this.sqrt();
        this.div(h);
        this.atan();
        if (bl) {
            this.neg();
            this.add(PI);
        }
    }

    public final void atan() {
        if (this.exponent == 0 && this.mantissa == 0L || this.exponent < 0 && this.mantissa != 0L) {
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            byte by = this.sign;
            this.mantissa = Real.PI_2.mantissa;
            this.exponent = Real.PI_2.exponent;
            this.sign = Real.PI_2.sign;
            this.sign = by;
            return;
        }
        byte by = this.sign;
        this.sign = 0;
        boolean bl = false;
        boolean bl2 = false;
        Real.h.mantissa = Real.SQRT2.mantissa;
        Real.h.exponent = Real.SQRT2.exponent;
        Real.h.sign = Real.SQRT2.sign;
        h.add(ONE);
        if (this.a(h) > 0) {
            bl = true;
            this.recip();
            this.neg();
        } else {
            h.sub(TWO);
            if (this.a(h) > 0) {
                bl2 = true;
                Real.h.mantissa = this.mantissa;
                Real.h.exponent = this.exponent;
                Real.h.sign = this.sign;
                h.add(ONE);
                this.sub(ONE);
                this.div(h);
            }
        }
        Real.h.mantissa = this.mantissa;
        Real.h.exponent = this.exponent;
        Real.h.sign = this.sign;
        Real.i.mantissa = this.mantissa;
        Real.i.exponent = this.exponent;
        Real.i.sign = this.sign;
        i.sqr();
        this.mul(i);
        Real.j.sign = 1;
        Real.j.exponent = 0x3FFFFFFF;
        Real.j.mantissa = 8011773115982530407L;
        j.mul(i);
        Real.k.sign = 1;
        Real.k.exponent = 0x40000003;
        Real.k.mantissa = 8464466433134330867L;
        j.add(k);
        j.mul(i);
        Real.k.sign = 1;
        Real.k.exponent = 0x40000005;
        Real.k.mantissa = 9220041341143656951L;
        j.add(k);
        j.mul(i);
        Real.k.sign = 1;
        Real.k.exponent = 0x40000006;
        Real.k.mantissa = 7204949748616494315L;
        j.add(k);
        j.mul(i);
        Real.k.sign = 1;
        Real.k.exponent = 0x40000005;
        Real.k.mantissa = 7334615228943850338L;
        j.add(k);
        this.mul(j);
        Real.j.mantissa = Real.i.mantissa;
        Real.j.exponent = Real.i.exponent;
        Real.j.sign = Real.i.sign;
        Real.k.sign = 0;
        Real.k.exponent = 0x40000004;
        Real.k.mantissa = 6624077857899883114L;
        j.add(k);
        j.mul(i);
        Real.k.sign = 0;
        Real.k.exponent = 0x40000007;
        Real.k.mantissa = 5187821114451245916L;
        j.add(k);
        j.mul(i);
        Real.k.sign = 0;
        Real.k.exponent = 0x40000008;
        Real.k.mantissa = 6511138498204955093L;
        j.add(k);
        j.mul(i);
        Real.k.sign = 0;
        Real.k.exponent = 0x40000008;
        Real.k.mantissa = 7054000737974736352L;
        j.add(k);
        j.mul(i);
        Real.k.sign = 0;
        Real.k.exponent = 0x40000007;
        Real.k.mantissa = 5500961421707887758L;
        j.add(k);
        this.div(j);
        this.add(h);
        if (bl) {
            this.add(PI_2);
        }
        if (bl2) {
            this.add(PI_4);
        }
        if (by != 0) {
            this.neg();
        }
    }

    public final void atan2(Real real) {
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L || this.exponent < 0 && this.mantissa == 0L && real.exponent < 0 && real.mantissa == 0L) {
            this.makeNan();
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L && real.exponent == 0 && real.mantissa == 0L) {
            return;
        }
        byte by = this.sign;
        byte by2 = real.sign;
        this.sign = 0;
        real.sign = 0;
        this.div(real);
        this.atan();
        if (by2 != 0) {
            this.neg();
            this.add(PI);
        }
        this.sign = by;
    }

    public final void sinh() {
        Real.h.mantissa = this.mantissa;
        Real.h.exponent = this.exponent;
        Real.h.sign = this.sign;
        h.neg();
        h.exp();
        this.exp();
        this.sub(h);
        this.scalbn(-1);
    }

    public final void cosh() {
        Real.h.mantissa = this.mantissa;
        Real.h.exponent = this.exponent;
        Real.h.sign = this.sign;
        h.neg();
        h.exp();
        this.exp();
        this.add(h);
        this.scalbn(-1);
    }

    public final void tanh() {
        Real.h.mantissa = this.mantissa;
        Real.h.exponent = this.exponent;
        Real.h.sign = this.sign;
        h.neg();
        h.exp();
        this.exp();
        Real.i.mantissa = this.mantissa;
        Real.i.exponent = this.exponent;
        Real.i.sign = this.sign;
        i.add(h);
        this.sub(h);
        this.div(i);
    }

    public final void asinh() {
        if (this.exponent < 0 || this.mantissa == 0L) {
            return;
        }
        byte by = this.sign;
        this.sign = 0;
        Real.h.mantissa = this.mantissa;
        Real.h.exponent = this.exponent;
        Real.h.sign = this.sign;
        h.sqr();
        h.add(ONE);
        h.sqrt();
        this.add(h);
        this.ln();
        if (this.exponent >= 0 || this.mantissa == 0L) {
            this.sign = by;
        }
    }

    public final void acosh() {
        Real.h.mantissa = this.mantissa;
        Real.h.exponent = this.exponent;
        Real.h.sign = this.sign;
        h.sqr();
        h.sub(ONE);
        h.sqrt();
        this.add(h);
        this.ln();
    }

    public final void atanh() {
        Real.h.mantissa = this.mantissa;
        Real.h.exponent = this.exponent;
        Real.h.sign = this.sign;
        h.neg();
        h.add(ONE);
        this.add(ONE);
        this.div(h);
        this.ln();
        this.scalbn(-1);
    }

    public final void fact() {
        if (this.exponent < 0) {
            return;
        }
        if (!this.isIntegral() || this.a(ZERO) < 0 || this.a(200) > 0) {
            this.add(ONE);
            this.gamma();
            return;
        }
        Real.h.mantissa = this.mantissa;
        Real.h.exponent = this.exponent;
        Real.h.sign = this.sign;
        this.mantissa = Real.ONE.mantissa;
        this.exponent = Real.ONE.exponent;
        this.sign = Real.ONE.sign;
        while (h.a(ONE) > 0) {
            this.mul(h);
            h.sub(ONE);
        }
    }

    public final void gamma() {
        if (this.exponent < 0) {
            return;
        }
        boolean bl = this.sign != 0;
        Real real = this;
        this.sign = 0;
        Real.h.mantissa = this.mantissa;
        Real.h.exponent = this.exponent;
        Real.h.sign = this.sign;
        Real.i.mantissa = Real.ONE.mantissa;
        Real.i.exponent = Real.ONE.exponent;
        Real.i.sign = Real.ONE.sign;
        boolean bl2 = false;
        while (this.a(20) < 0) {
            bl2 = true;
            i.mul(this);
            this.add(ONE);
        }
        Real.j.mantissa = this.mantissa;
        Real.j.exponent = this.exponent;
        Real.j.sign = this.sign;
        Real.k.mantissa = this.mantissa;
        Real.k.exponent = this.exponent;
        Real.k.sign = this.sign;
        k.sqr();
        this.ln();
        Real.l.mantissa = Real.j.mantissa;
        Real.l.exponent = Real.j.exponent;
        Real.l.sign = Real.j.sign;
        l.sub(HALF);
        this.mul(l);
        this.sub(j);
        Real.l.sign = 0;
        Real.l.exponent = 0x3FFFFFFF;
        Real.l.mantissa = 8475711970748322458L;
        this.add(l);
        l.assign(12);
        l.mul(j);
        l.recip();
        this.add(l);
        j.mul(k);
        l.assign(360);
        l.mul(j);
        l.recip();
        this.sub(l);
        j.mul(k);
        l.assign(1260);
        l.mul(j);
        l.recip();
        this.add(l);
        j.mul(k);
        l.assign(1680);
        l.mul(j);
        l.recip();
        this.sub(l);
        j.mul(k);
        l.assign(1188);
        l.mul(j);
        l.recip();
        this.add(l);
        this.exp();
        if (bl2) {
            this.div(i);
        }
        if (bl) {
            Real.l.mantissa = Real.h.mantissa;
            Real.l.exponent = Real.h.exponent;
            Real.l.sign = Real.h.sign;
            this.mul(l);
            l.scalbn(-1);
            l.frac();
            l.mul(PI2);
            l.sin();
            this.mul(l);
            this.recip();
            this.mul(PI);
            this.neg();
        }
    }

    public final void erfc() {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.mantissa = Real.ONE.mantissa;
            this.exponent = Real.ONE.exponent;
            this.sign = Real.ONE.sign;
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L || this.toInteger() > 27281) {
            if (this.sign != 0) {
                this.mantissa = Real.TWO.mantissa;
                this.exponent = Real.TWO.exponent;
                this.sign = Real.TWO.sign;
                return;
            }
            this.makeZero(0);
            return;
        }
        byte by = this.sign;
        this.sign = 0;
        Real.h.sign = 0;
        Real.h.exponent = 0x40000002;
        Real.h.mantissa = 6271892985061247549L;
        if (this.lessThan(h)) {
            Real real = this;
            long l = 0L;
            Real.h.mantissa = real.mantissa;
            Real.h.exponent = real.exponent;
            Real.h.sign = real.sign;
            long l2 = 0L;
            Real.i.mantissa = real.mantissa;
            Real.i.exponent = real.exponent;
            Real.i.sign = real.sign;
            long l3 = i.mul128(0L, i, 0L);
            i.neg();
            Real.j.mantissa = Real.ONE.mantissa;
            Real.j.exponent = Real.ONE.exponent;
            Real.j.sign = Real.ONE.sign;
            long l4 = 0L;
            int n = 1;
            do {
                l2 = h.mul128(l2, i, l3);
                k.assign(n);
                l4 = j.mul128(l4, k, 0L);
                k.assign(n * 2 + 1);
                long l5 = k.mul128(0L, j, l4);
                l5 = k.recip128(l5);
                l5 = k.mul128(l5, h, l2);
                l = real.add128(l, k, l5);
                ++n;
            } while (real.exponent - Real.k.exponent < 128);
            Real.h.sign = 1;
            Real.h.exponent = 0x40000000;
            Real.h.mantissa = 5203730428379116614L;
            l = real.mul128(l, h, -5122205486241848926L);
            l = real.add128(l, ONE, 0L);
            real.roundFrom128(l);
        } else {
            Real real = this;
            Real.h.mantissa = real.mantissa;
            Real.h.exponent = real.exponent;
            Real.h.sign = real.sign;
            h.sqr();
            Real.i.sign = 0;
            Real.i.exponent = 0x40000000;
            Real.i.mantissa = 6645080718195083435L;
            i.mul(h);
            i.sub(HALF);
            int n = i.toInteger();
            if (n > 64) {
                n = 64;
            }
            h.scalbn(1);
            int n2 = h.toInteger() + 1;
            Real.h.mantissa = real.mantissa;
            Real.h.exponent = real.exponent;
            Real.h.sign = real.sign;
            real.recip();
            Real.i.mantissa = real.mantissa;
            Real.i.exponent = real.exponent;
            Real.i.sign = real.sign;
            Real.j.mantissa = real.mantissa;
            Real.j.exponent = real.exponent;
            Real.j.sign = real.sign;
            j.sqr();
            j.neg();
            j.scalbn(-1);
            real.mantissa = Real.ONE.mantissa;
            real.exponent = Real.ONE.exponent;
            real.sign = Real.ONE.sign;
            Real.k.mantissa = Real.ONE.mantissa;
            Real.k.exponent = Real.ONE.exponent;
            Real.k.sign = Real.ONE.sign;
            int n3 = 1;
            do {
                k.mul(n3 * 2 - 1);
                k.mul(j);
                real.add(k);
            } while (Real.k.exponent - 0x40000000 > -(n + 2) && ++n3 * 2 - 1 < n2);
            real.mul(i);
            h.sqr();
            h.neg();
            h.exp();
            real.mul(h);
            Real.h.sign = 0;
            Real.h.exponent = 0x3FFFFFFF;
            Real.h.mantissa = 5203730428379116615L;
            real.mul(h);
        }
        if (by != 0) {
            this.neg();
            this.add(TWO);
        }
    }

    public final void inverfc() {
        if (this.exponent < 0 && this.mantissa != 0L || this.sign != 0 || this.greaterThan(TWO)) {
            this.makeNan();
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.makeInfinity(0);
            return;
        }
        if (this.equalTo(TWO)) {
            this.makeInfinity(1);
            return;
        }
        int n = ONE.a(this);
        if (n == 0) {
            this.makeZero();
            return;
        }
        if (n < 0) {
            this.neg();
            this.add(TWO);
        }
        this.scalbn(-1);
        Real.h.mantissa = this.mantissa;
        Real.h.exponent = this.exponent;
        Real.h.sign = this.sign;
        h.ln();
        h.mul(-2);
        h.sqrt();
        Real.i.sign = 1;
        Real.i.exponent = 0x3FFFFFF1;
        Real.i.mantissa = 6855247258937034356L;
        i.mul(h);
        Real.j.sign = 1;
        Real.j.exponent = 0x3FFFFFFA;
        Real.j.mantissa = 6027841387605573141L;
        i.add(j);
        i.mul(h);
        Real.j.sign = 1;
        Real.j.exponent = 0x3FFFFFFE;
        Real.j.mantissa = 6313252218678351859L;
        i.add(j);
        i.mul(h);
        i.add(-1);
        i.mul(h);
        Real.j.sign = 1;
        Real.j.exponent = 0x3FFFFFFE;
        Real.j.mantissa = 5944139188529585484L;
        i.add(j);
        Real.j.sign = 0;
        Real.j.exponent = 0x3FFFFFF7;
        Real.j.mantissa = 9104888011498593917L;
        j.mul(h);
        Real.k.sign = 0;
        Real.k.exponent = 0x3FFFFFFC;
        Real.k.mantissa = 7639737715163766952L;
        j.add(k);
        j.mul(h);
        Real.k.sign = 0;
        Real.k.exponent = 0x3FFFFFFF;
        Real.k.mantissa = 4898564823463317188L;
        j.add(k);
        j.mul(h);
        Real.k.sign = 0;
        Real.k.exponent = 0x3FFFFFFF;
        Real.k.mantissa = 5428706798711650965L;
        j.add(k);
        j.mul(h);
        Real.k.sign = 0;
        Real.k.exponent = 0x3FFFFFFC;
        Real.k.mantissa = 7330622655237541986L;
        j.add(k);
        i.div(j);
        h.add(i);
        h.neg();
        Real.d.mantissa = Real.h.mantissa;
        Real.d.exponent = Real.h.exponent;
        Real.d.sign = Real.h.sign;
        Real.l.mantissa = Real.d.mantissa;
        Real.l.exponent = Real.d.exponent;
        Real.l.sign = Real.d.sign;
        l.mul(SQRT1_2);
        l.neg();
        l.erfc();
        l.scalbn(-1);
        l.sub(this);
        Real.j.mantissa = Real.d.mantissa;
        Real.j.exponent = Real.d.exponent;
        Real.j.sign = Real.d.sign;
        j.sqr();
        j.scalbn(-1);
        j.exp();
        l.mul(j);
        Real.j.sign = 0;
        Real.j.exponent = 0x40000001;
        Real.j.mantissa = 5779891283755275865L;
        l.mul(j);
        this.mantissa = Real.d.mantissa;
        this.exponent = Real.d.exponent;
        this.sign = Real.d.sign;
        this.mul(l);
        this.scalbn(-1);
        this.add(ONE);
        this.rdiv(l);
        this.neg();
        this.add(d);
        this.mul(SQRT1_2);
        if (n > 0) {
            this.neg();
        }
    }

    private static int a(int n, int n2) {
        if (n >= 0) {
            return n / n2;
        }
        return -((-n + n2 - 1) / n2);
    }

    private static int b(int n, int n2) {
        if (n >= 0) {
            return n % n2;
        }
        return n + (-n + n2 - 1) / n2 * n2;
    }

    private static boolean a(int n) {
        return n % 4 == 0 && (n % 100 != 0 || n % 400 == 0);
    }

    private static int a(int n, int n2, int n3) {
        return 365 + 365 * (n - 1) + Real.a(n - 1, 4) - Real.a(n - 1, 100) + Real.a(n - 1, 400) + ((n2 * 367 - 362) / 12 + (n2 <= 2 ? 0 : (Real.a(n) ? -1 : -2)) + n3);
    }

    public final void toDHMS() {
        if (this.exponent < 0 || this.mantissa == 0L) {
            return;
        }
        boolean bl = this.sign != 0;
        Real real = this;
        this.sign = 0;
        long l = this.toLong();
        this.frac();
        h.assign(60);
        this.mul(h);
        int n = this.toInteger();
        this.frac();
        this.mul(h);
        Real.i.mantissa = Real.ONE.mantissa;
        Real.i.exponent = Real.ONE.exponent;
        Real.i.sign = Real.ONE.sign;
        i.scalbn(-16);
        this.add(i);
        if (this.a(h) >= 0) {
            this.mantissa = Real.ZERO.mantissa;
            this.exponent = Real.ZERO.exponent;
            this.sign = Real.ZERO.sign;
            if (++n >= 60) {
                n -= 60;
                ++l;
            }
        } else {
            this.sub(i);
        }
        int n2 = (int)(l / 24L);
        l %= 24L;
        if (n2 >= 366) {
            int n3 = n2 - 366;
            int n4 = Real.a(n3, 146097);
            n3 = Real.b(n3, 146097);
            int n5 = Real.a(n3, 36524);
            n3 = Real.b(n3, 36524);
            int n6 = Real.a(n3, 1461);
            n3 = Real.b(n3, 1461);
            n3 = Real.a(n3, 365);
            n4 = n4 * 400 + n5 * 100 + (n6 << 2) + n3;
            if (n5 != 4 && n3 != 4) {
                ++n4;
            }
            n3 = n2 - Real.a(n4, 1, 1);
            n5 = n2 < Real.a(n4, 3, 1) ? 0 : (Real.a(n4) ? 1 : 2);
            n3 = Real.a((n3 + n5) * 12 + 373, 367);
            n2 = n2 - Real.a(n4, n3, 1) + 1;
            n2 = (n4 * 100 + n3) * 100 + n2;
        }
        this.add(n * 100);
        this.div(10000);
        h.assign((long)n2 * 100L + l);
        this.add(h);
        if (bl) {
            this.neg();
        }
    }

    public final void fromDHMS() {
        if (this.exponent < 0 || this.mantissa == 0L) {
            return;
        }
        boolean bl = this.sign != 0;
        Real real = this;
        this.sign = 0;
        long l = this.toLong();
        this.frac();
        h.assign(100);
        this.mul(h);
        int n = this.toInteger();
        this.frac();
        this.mul(h);
        Real.i.mantissa = Real.ONE.mantissa;
        Real.i.exponent = Real.ONE.exponent;
        Real.i.sign = Real.ONE.sign;
        i.scalbn(-10);
        this.add(i);
        if (this.a(h) >= 0) {
            this.mantissa = Real.ZERO.mantissa;
            this.exponent = Real.ZERO.exponent;
            this.sign = Real.ZERO.sign;
            if (++n >= 100) {
                n -= 100;
                ++l;
            }
        } else {
            this.sub(i);
        }
        int n2 = (int)(l / 100L);
        l %= 100L;
        if (n2 >= 10000) {
            int n3 = n2 / 100;
            if ((n2 %= 100) == 0) {
                n2 = 1;
            }
            int n4 = n3 / 100;
            if ((n3 %= 100) == 0) {
                n3 = 1;
            }
            n2 = Real.a(n4, n3, n2);
        }
        this.add(n * 60);
        this.div(3600);
        h.assign((long)n2 * 24L + l);
        this.add(h);
        if (bl) {
            this.neg();
        }
    }

    public final void time() {
        long l = System.currentTimeMillis();
        int n = (int)((l /= 1000L) % 60L);
        int n2 = (int)((l /= 60L) % 60L);
        int n3 = (int)((l /= 60L) % 24L);
        this.assign((n3 * 100 + n2) * 100 + n);
        this.div(10000);
    }

    public final void date() {
        long l = System.currentTimeMillis();
        l /= 86400000L;
        this.assign(l *= 24L);
        this.add(17268672);
        this.toDHMS();
    }

    private static void c() {
        randSeedA = randSeedA << 1 ^ (long)(randSeedA < 0L ? 27 : 0);
        randSeedB = randSeedB << 1 ^ (randSeedB < 0L ? -5764607523034234879L : 0L);
    }

    private static long a(int n) {
        long l = 0L;
        while (n-- > 0) {
            while (randSeedA >= 0L) {
                Real.c();
            }
            l = (l << 1) + (long)(randSeedB < 0L ? 1 : 0);
            Real.c();
        }
        return l;
    }

    public static void accumulateRandomness(long l) {
        randSeedA ^= l & 0x5555555555555555L;
        randSeedB ^= l & 0xAAAAAAAAAAAAAAAAL;
        Real.a(63);
    }

    public final void random() {
        this.sign = 0;
        this.exponent = 0x3FFFFFFF;
        while (Real.a(1) == 0L) {
            --this.exponent;
        }
        this.mantissa = 0x4000000000000000L + Real.a(62);
    }

    private static int a(char c2, int n, boolean bl) {
        int n2 = -1;
        if (c2 >= '0' && c2 <= '9') {
            n2 = c2 - 48;
        } else if (c2 >= 'A' && c2 <= 'F') {
            n2 = c2 - 65 + 10;
        }
        if (n2 >= n) {
            return -1;
        }
        if (bl) {
            n2 ^= n - 1;
        }
        return n2;
    }

    private void a(int n) {
        if (n == 2) {
            this.scalbn(1);
            return;
        }
        if (n == 8) {
            this.scalbn(3);
            return;
        }
        if (n == 16) {
            this.scalbn(4);
            return;
        }
        this.a();
    }

    private void a(byte[] byArray, int n, int n2) {
        byte by = 0;
        boolean bl = true;
        for (int i = n - 1; i >= 0; --i) {
            if (byArray[i] != 0) {
                bl = false;
            }
            int n3 = i;
            byArray[n3] = (byte)(byArray[n3] + by);
            by = 0;
            if (byArray[i] < n2) continue;
            int n4 = i;
            byArray[n4] = (byte)(byArray[n4] - n2);
            by = 1;
        }
        if (bl) {
            this.exponent = 0;
            return;
        }
        if (by != 0) {
            if (byArray[n - 1] >= n2 / 2) {
                int n5 = n - 2;
                byArray[n5] = (byte)(byArray[n5] + 1);
            }
            System.arraycopy(byArray, 0, byArray, 1, n - 1);
            byArray[0] = by;
            ++this.exponent;
            if (byArray[n - 1] >= n2) {
                this.a(byArray, n, n2);
            }
        }
        while (byArray[0] == 0) {
            System.arraycopy(byArray, 1, byArray, 0, n - 1);
            byArray[n - 1] = 0;
            --this.exponent;
        }
    }

    private int a(byte[] byArray, int n) {
        int n2;
        if (n == 10) {
            long l;
            Real.h.mantissa = this.mantissa;
            Real.h.exponent = this.exponent;
            Real.h.sign = this.sign;
            Real real = h;
            h.sign = 0;
            Real.i.mantissa = Real.h.mantissa;
            Real.i.exponent = Real.h.exponent;
            Real.i.sign = Real.h.sign;
            int n3 = this.exponent = h.lowPow10();
            int n4 = (n3 -= 18) <= 0 ? 1 : 0;
            if ((n3 = Math.abs(n3)) > 300000000) {
                Real.h.mantissa = Real.TEN.mantissa;
                Real.h.exponent = Real.TEN.exponent;
                Real.h.sign = Real.TEN.sign;
                h.pow(n3 / 2);
                if (n4 != 0) {
                    i.mul(h);
                } else {
                    i.div(h);
                }
                Real.h.mantissa = Real.TEN.mantissa;
                Real.h.exponent = Real.TEN.exponent;
                Real.h.sign = Real.TEN.sign;
                h.pow(n3 - n3 / 2);
            } else {
                Real.h.mantissa = Real.TEN.mantissa;
                Real.h.exponent = Real.TEN.exponent;
                Real.h.sign = Real.TEN.sign;
                h.pow(n3);
            }
            if (n4 != 0) {
                i.mul(h);
            } else {
                i.div(h);
            }
            if (Real.i.exponent > 1073741886) {
                --Real.i.exponent;
                i.round();
                l = i.toLong();
                if (l >= 5000000000000000000L) {
                    ++this.exponent;
                    byArray[18] = (byte)((l /= 5L) % 10L);
                    l /= 10L;
                } else {
                    byArray[18] = (byte)(l % 5L << 1);
                    l /= 5L;
                }
            } else {
                i.round();
                l = i.toLong();
                byArray[18] = (byte)(l % 10L);
                l /= 10L;
            }
            for (n4 = 17; n4 >= 0; --n4) {
                byArray[n4] = (byte)(l % 10L);
                l /= 10L;
            }
            byArray[19] = 0;
            return 19;
        }
        int n5 = 64;
        int n6 = n == 2 ? 1 : (n = n == 8 ? 3 : 4);
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.sign = 0;
        } else {
            if (this.sign != 0) {
                this.mantissa = -this.mantissa;
                if ((this.mantissa >> 62 & 3L) == 3L) {
                    this.mantissa <<= 1;
                    --this.exponent;
                    --n5;
                }
            }
            this.exponent -= 0x3FFFFFFF;
            n2 = n - 1 - Real.b(this.exponent, n);
            this.exponent = Real.a(this.exponent, n);
            if (n2 == n - 1) {
                this.mantissa <<= 1;
                --this.exponent;
                --n5;
            } else if (n2 > 0) {
                this.mantissa = this.mantissa + (1L << n2 - 1) >>> n2;
                if (this.sign != 0) {
                    this.mantissa |= Long.MIN_VALUE >> n2 - 1;
                }
            }
        }
        n2 = (n5 + n - 1) / n;
        for (int i = 0; i < n2; ++i) {
            byArray[i] = (byte)(this.mantissa >>> 64 - n);
            this.mantissa <<= n;
        }
        byArray[n2] = 0;
        return n2;
    }

    private static String a(StringBuffer stringBuffer, Real$NumberFormat real$NumberFormat) {
        block4: {
            block5: {
                block3: {
                    if (real$NumberFormat.align != 1) break block3;
                    while (stringBuffer.length() < real$NumberFormat.maxwidth) {
                        stringBuffer.append(' ');
                    }
                    break block4;
                }
                if (real$NumberFormat.align != 2) break block5;
                while (stringBuffer.length() < real$NumberFormat.maxwidth) {
                    stringBuffer.insert(0, ' ');
                }
                break block4;
            }
            if (real$NumberFormat.align != 3) break block4;
            while (stringBuffer.length() < real$NumberFormat.maxwidth) {
                stringBuffer.append(' ');
                if (stringBuffer.length() >= real$NumberFormat.maxwidth) continue;
                stringBuffer.insert(0, ' ');
            }
        }
        return stringBuffer.toString();
    }

    private String a(Real$NumberFormat real$NumberFormat) {
        char c2;
        Real real;
        byte[] byArray;
        int n;
        int n2;
        int n3;
        boolean bl;
        int n4;
        a.setLength(0);
        if (this.exponent < 0 && this.mantissa != 0L) {
            a.append("nan");
            return Real.a(a, real$NumberFormat);
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            a.append(this.sign != 0 ? "-inf" : "inf");
            return Real.a(a, real$NumberFormat);
        }
        switch (real$NumberFormat.base) {
            case 2: {
                n4 = 8;
                break;
            }
            case 8: {
                n4 = 1000;
                break;
            }
            case 16: {
                n4 = 4;
                break;
            }
            default: {
                n4 = 3;
            }
        }
        if (real$NumberFormat.thousand == '\u0000') {
            n4 = 1000;
        }
        Real.k.mantissa = this.mantissa;
        Real.k.exponent = this.exponent;
        Real.k.sign = this.sign;
        int n5 = k.a(b, real$NumberFormat.base);
        if (!(real$NumberFormat.base != 10 || this.exponent <= 1073741886 && this.isIntegral())) {
            n5 = 16;
        }
        int n6 = 0;
        block9: do {
            int n7 = real$NumberFormat.maxwidth - 1;
            int n8 = 0;
            if (real$NumberFormat.base != 10) {
                n8 = 1;
            } else if (Real.k.sign != 0) {
                --n7;
            }
            n3 = 0;
            switch (real$NumberFormat.fse) {
                case 2: {
                    n2 = real$NumberFormat.precision + 1;
                    n3 = 1;
                    break;
                }
                case 3: {
                    n6 = Real.b(Real.k.exponent, 3);
                    n2 = real$NumberFormat.precision + 1 + n6;
                    n3 = 1;
                    break;
                }
                default: {
                    n2 = 1000;
                    if (real$NumberFormat.fse == 1) {
                        n2 = real$NumberFormat.precision + 1;
                    }
                    if (Real.k.exponent + 1 > n7 - (Real.k.exponent + n8) / n4 - n8 + (real$NumberFormat.removePoint ? 1 : 0) || Real.k.exponent + 1 > n5 || -Real.k.exponent >= n7 || -Real.k.exponent >= n2) {
                        n3 = 1;
                        break;
                    }
                    n6 = Real.k.exponent;
                    n2 += Real.k.exponent;
                    if (Real.k.exponent > 0) {
                        n7 -= (Real.k.exponent + n8) / n4;
                    }
                    if (!real$NumberFormat.removePoint || Real.k.exponent != n7 - n8) break;
                    ++n7;
                }
            }
            if (n8 != 0 && n6 >= 0) {
                n7 -= n8;
            }
            b.setLength(0);
            if (n3 != 0) {
                b.append('e');
                b.append(Real.k.exponent - n6);
                n7 -= b.length();
            }
            if (n2 > n5) {
                n2 = n5;
            }
            if (n2 > n7) {
                n2 = n7;
            }
            if (n2 > n7 + n6) {
                n2 = n7 + n6;
            }
            if (n2 <= 0) {
                n2 = 1;
            }
            n = real$NumberFormat.base;
            n3 = n2;
            byArray = b;
            real = k;
            if (byArray[n3] < n / 2) {
                bl = false;
                continue;
            }
            --n3;
            while (n3 >= 0) {
                if (byArray[n3] < n - 1) {
                    bl = false;
                    continue block9;
                }
                --n3;
            }
            ++real.exponent;
            byArray[0] = 1;
            for (n3 = 1; n3 < byArray.length; ++n3) {
                byArray[n3] = 0;
            }
            bl = true;
        } while (bl);
        n = real$NumberFormat.base;
        n3 = n2;
        byArray = b;
        real = k;
        if (byArray[n3] >= n / 2) {
            int n9 = n3 - 1;
            byArray[n9] = (byte)(byArray[n9] + 1);
            real.a(byArray, n3, n);
        }
        if (Real.k.sign != 0 && real$NumberFormat.base == 10) {
            a.append('-');
        }
        int n10 = n6 < 0 ? 0 : n6;
        char c3 = c2 = real$NumberFormat.base == 10 || Real.k.sign == 0 ? (char)'0' : hexChar.charAt(real$NumberFormat.base - 1);
        if (n6 < 0) {
            a.append(c2);
            a.append(real$NumberFormat.point);
            while (n6 < -1) {
                a.append(c2);
                ++n6;
            }
        }
        for (n3 = 0; n3 < n2; ++n3) {
            a.append(hexChar.charAt(b[n3]));
            if (n6 > 0 && n6 % n4 == 0) {
                a.append(real$NumberFormat.thousand);
            }
            if (n6 == 0) {
                a.append(real$NumberFormat.point);
            }
            --n6;
        }
        if (real$NumberFormat.fse == 0) {
            while (a.charAt(a.length() - 1) == '0') {
                a.setLength(a.length() - 1);
            }
        }
        if (real$NumberFormat.removePoint && a.charAt(a.length() - 1) == real$NumberFormat.point) {
            a.setLength(a.length() - 1);
        }
        a.append((Object)b);
        if (real$NumberFormat.base != 10) {
            while (a.length() < real$NumberFormat.maxwidth) {
                if (++n10 > 0 && n10 % n4 == 0) {
                    a.insert(0, real$NumberFormat.thousand);
                }
                if (a.length() >= real$NumberFormat.maxwidth) continue;
                a.insert(0, c2);
            }
            if (a.charAt(0) == real$NumberFormat.thousand) {
                a.deleteCharAt(0);
            }
        }
        return Real.a(a, real$NumberFormat);
    }

    public final String toString() {
        Real.a.base = 10;
        return this.a(a);
    }

    public final String toString(int n) {
        Real.a.base = n;
        return this.a(a);
    }

    public final String toString(Real$NumberFormat real$NumberFormat) {
        return this.a(real$NumberFormat);
    }
}

