/*
 * Decompiled with CFR 0.152.
 */
package net.hsnav;

import java.util.Calendar;
import java.util.Date;
import net.hsnav.HotSpotNavigatorMIDlet;

public class Util {
    public static float MPS_to_KMH = 3.6f;
    public static float MPS_to_MPH = 2.23694f;
    public static float MPS_to_KNOTS = 1.943844f;
    public static float MPH_to_KMH = 1.609344f;
    public static float KMH_to_MPH = 0.621371f;
    public static float KNOTS_to_MPS = 0.514444f;
    public static float M_to_MI = 6.21371E-4f;
    public static float M_to_NM = 5.39937E-4f;
    public static float M_to_FT = 3.28084f;

    private Util() {
    }

    public static String formatDistance(float f2) {
        if (HotSpotNavigatorMIDlet.getInstance().getMeasurementUnits() == 0) {
            if (f2 < 10000.0f) {
                if (f2 < 1000.0f) {
                    return String.valueOf((int)f2) + " m";
                }
                int n = (int)f2 / 1000;
                int n2 = (int)(f2 % 1000.0f) / 100;
                return n + "." + n2 + " km";
            }
            return String.valueOf((int)f2 / 1000) + " km";
        }
        if (HotSpotNavigatorMIDlet.getInstance().getMeasurementUnits() == 1) {
            if (f2 < 16093.0f) {
                int n = (int)(f2 * M_to_MI);
                int n3 = (int)((f2 * M_to_MI - (float)n) * 10.0f);
                return n + "." + n3 + " mi";
            }
            return String.valueOf((int)(f2 * M_to_MI)) + " mi";
        }
        if (HotSpotNavigatorMIDlet.getInstance().getMeasurementUnits() == 2) {
            if (f2 < 18520.0f) {
                int n = (int)(f2 * M_to_NM);
                int n4 = (int)((f2 * M_to_NM - (float)n) * 10.0f);
                return n + "." + n4 + " nm";
            }
            return String.valueOf((int)(f2 * M_to_NM)) + " nm";
        }
        if (f2 < 10000.0f) {
            if (f2 < 1000.0f) {
                return String.valueOf((int)f2) + " m";
            }
            int n = (int)f2 / 1000;
            int n5 = (int)(f2 % 1000.0f) / 100;
            return n + "." + n5 + " km";
        }
        return String.valueOf((int)f2 / 1000) + " km";
    }

    public static String formatTimestamp(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(l));
        StringBuffer stringBuffer = new StringBuffer().append(calendar.get(1)).append('.');
        int n = calendar.get(2) + 1;
        stringBuffer.append(n < 10 ? "0" : "").append(n).append('.');
        n = calendar.get(5);
        stringBuffer.append(n < 10 ? "0" : "").append(n).append(' ');
        n = calendar.get(11);
        stringBuffer.append(n < 10 ? "0" : "").append(n).append(':');
        n = calendar.get(12);
        stringBuffer.append(n < 10 ? "0" : "").append(n).append(':');
        n = calendar.get(13);
        stringBuffer.append(n < 10 ? "0" : "").append(n);
        return stringBuffer.toString();
    }

    public static String formatShortTimestamp(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(l));
        StringBuffer stringBuffer = new StringBuffer().append(calendar.get(1)).append('.');
        int n = calendar.get(2) + 1;
        stringBuffer.append(n < 10 ? "0" : "").append(n).append('.');
        n = calendar.get(5);
        stringBuffer.append(n < 10 ? "0" : "").append(n).append(' ');
        n = calendar.get(11);
        stringBuffer.append(n < 10 ? "0" : "").append(n).append(':');
        n = calendar.get(12);
        stringBuffer.append(n < 10 ? "0" : "").append(n);
        return stringBuffer.toString();
    }

    public static String formatTimePeriod(long l) {
        int n = (int)(l / 3600000L);
        int n2 = (int)((l - (long)(n * 3600000)) / 60000L);
        return n + ":" + (n2 < 10 ? "0" + n2 : "" + n2);
    }

    public static String formatSpeed(float f2) {
        if (HotSpotNavigatorMIDlet.getInstance().getMeasurementUnits() == 0) {
            return (int)(f2 * MPS_to_KMH) + " km/h";
        }
        if (HotSpotNavigatorMIDlet.getInstance().getMeasurementUnits() == 1) {
            return (int)(f2 * MPS_to_MPH) + " mph";
        }
        if (HotSpotNavigatorMIDlet.getInstance().getMeasurementUnits() == 2) {
            return (int)(f2 * MPS_to_KNOTS) + " kn";
        }
        return (int)(f2 * MPS_to_KMH) + " km/h";
    }

    public static String formatAltitude(int n) {
        if (HotSpotNavigatorMIDlet.getInstance().getMeasurementUnits() == 1) {
            return (int)((float)n * M_to_FT) + " ft";
        }
        return n + " m";
    }

    public static String formatLatitude(double d2) {
        char c2 = d2 > 0.0 ? (char)'N' : 'S';
        double d3 = Math.abs(d2);
        int n = (int)d3;
        int n2 = (int)((d3 - (double)n) * 100000.0);
        String string = "";
        if (n2 < 10) {
            string = "0000";
        } else if (n2 < 100) {
            string = "000";
        } else if (n2 < 1000) {
            string = "00";
        } else if (n2 < 10000) {
            string = "0";
        }
        return c2 + " " + n + "." + string + n2;
    }

    public static String formatLongitude(double d2) {
        char c2 = d2 > 0.0 ? (char)'E' : 'W';
        double d3 = Math.abs(d2);
        int n = (int)d3;
        int n2 = (int)((d3 - (double)n) * 100000.0);
        String string = "";
        if (n2 < 10) {
            string = "0000";
        } else if (n2 < 100) {
            string = "000";
        } else if (n2 < 1000) {
            string = "00";
        } else if (n2 < 10000) {
            string = "0";
        }
        return c2 + " " + n + "." + string + n2;
    }
}

