/*
 * Decompiled with CFR 0.152.
 */
package net.hsnav;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import javax.microedition.location.Coordinates;
import javax.microedition.location.Landmark;
import javax.microedition.location.LandmarkException;
import javax.microedition.location.LandmarkStore;
import javax.microedition.location.QualifiedCoordinates;
import net.hsnav.HotSpotNavigatorMIDlet;
import net.hsnav.ImageManager;
import net.hsnav.e;
import net.hsnav.landmarks.LandmarkCategory;
import net.hsnav.landmarks.WiFiLandmark;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class WiFiLandmarkStorage {
    private LandmarkStore a;
    private LandmarkStore b;
    private Vector a;
    private int a;
    private HotSpotNavigatorMIDlet a = 0;

    public WiFiLandmarkStorage(HotSpotNavigatorMIDlet hotSpotNavigatorMIDlet) {
        try {
            this.a = hotSpotNavigatorMIDlet;
            this.a = new Vector();
            this.a = LandmarkStore.getInstance((String)"waypoints");
            if (this.a == null) {
                LandmarkStore.createLandmarkStore((String)"waypoints");
                this.a = LandmarkStore.getInstance((String)"waypoints");
            }
            this.b = LandmarkStore.getInstance(null);
            return;
        }
        catch (IOException iOException) {
            hotSpotNavigatorMIDlet.showError(iOException.toString());
            iOException.printStackTrace();
            return;
        }
        catch (LandmarkException landmarkException) {
            hotSpotNavigatorMIDlet.showError(landmarkException.toString());
            landmarkException.printStackTrace();
            return;
        }
    }

    public void loadAll() {
        try {
            this.a = 0;
            Vector vector = HotSpotNavigatorMIDlet.getInstance().getLandmarkCategories().getCategories();
            for (int i = 0; i < vector.size(); ++i) {
                Enumeration enumeration = this.a.getLandmarks(((LandmarkCategory)vector.elementAt(i)).getName(), null);
                while (enumeration != null && enumeration.hasMoreElements()) {
                    Object object = (Landmark)enumeration.nextElement();
                    object = new WiFiLandmark((Landmark)object);
                    this.a.addElement(object);
                }
            }
            this.a = this.a.size();
            System.out.println("loaded " + this.a + " landmarks");
            return;
        }
        catch (IOException iOException) {
            this.a.showError(iOException.toString());
            iOException.printStackTrace();
            return;
        }
    }

    public void clearStorage() {
        try {
            LandmarkStore.deleteLandmarkStore((String)"waypoints");
            this.a = 0;
            this.loadAll();
            return;
        }
        catch (IOException iOException) {
            this.a.showError(iOException.toString());
            iOException.printStackTrace();
            return;
        }
        catch (LandmarkException landmarkException) {
            this.a.showError(landmarkException.toString());
            landmarkException.printStackTrace();
            return;
        }
    }

    public Image[] getImages() {
        Image[] imageArray = new Image[this.a];
        for (int i = 0; i < this.a; ++i) {
            imageArray[i] = ((WiFiLandmark)this.a.elementAt(i)).getImage();
        }
        return imageArray;
    }

    public String[] getNames() {
        this.a = this.a.size();
        String[] stringArray = new String[this.a];
        for (int i = 0; i < this.a; ++i) {
            stringArray[i] = ((WiFiLandmark)this.a.elementAt(i)).getLandmark().getName();
        }
        return stringArray;
    }

    public static String metersToString(float f2) {
        String string = "";
        if (f2 < 1000.0f) {
            string = Integer.toString((int)f2) + " m";
        } else if (f2 >= 1000.0f) {
            string = Integer.toString((int)f2 / 1000) + " km";
        }
        return string;
    }

    public int getSize() {
        return this.a;
    }

    public void sortByDistance(QualifiedCoordinates qualifiedCoordinates) {
        float[] fArray = new float[this.a];
        for (int i = 0; i < this.a; ++i) {
            fArray[i] = qualifiedCoordinates.distance((Coordinates)((WiFiLandmark)this.a.elementAt(i)).getLandmark().getQualifiedCoordinates());
        }
        for (int i = 1; i < this.a; ++i) {
            int n;
            float f2 = fArray[i];
            WiFiLandmark wiFiLandmark = (WiFiLandmark)this.a.elementAt(i);
            for (n = i - 1; n >= 0 && fArray[n] > f2; --n) {
                fArray[n + 1] = fArray[n];
                this.a.setElementAt(this.a.elementAt(n), n + 1);
            }
            fArray[n + 1] = f2;
            this.a.setElementAt(wiFiLandmark, n + 1);
        }
    }

    public void addHotSpot(Landmark landmark) {
        try {
            WiFiLandmark wiFiLandmark = new WiFiLandmark(landmark);
            if (wiFiLandmark.isEncrypted()) {
                this.a.addLandmark(landmark, "Closed WiFi HotSpots");
                HotSpotNavigatorMIDlet.getInstance().getLandmarkProvider().recacheCategory("Closed WiFi HotSpots");
            } else {
                this.a.addLandmark(landmark, "Open WiFi HotSpots");
                HotSpotNavigatorMIDlet.getInstance().getLandmarkProvider().recacheCategory("Open WiFi HotSpots");
            }
            ++this.a;
            return;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
            return;
        }
    }

    public boolean addHotSpot(e e2) {
        boolean bl = false;
        try {
            if (e2.a() != null && !this.a(e2)) {
                Landmark landmark = new Landmark(e2.a(), e2.b(), e2.a(), null);
                if (e2.a()) {
                    this.a.addLandmark(landmark, "Closed WiFi HotSpots");
                } else {
                    this.a.addLandmark(landmark, "Open WiFi HotSpots");
                }
                bl = true;
                ++this.a;
            }
            return bl;
        }
        catch (IOException iOException) {
            try {
                this.a.showError(iOException.toString());
                iOException.printStackTrace();
                return bl;
            }
            catch (Throwable throwable) {
                return bl;
            }
        }
    }

    public boolean addNewHotSpot(e e2) {
        boolean bl = false;
        if (e2.a() != null && !this.a(e2)) {
            e2 = new Landmark(e2.a(), e2.b(), e2.a(), null);
            this.addHotSpot((Landmark)e2);
            bl = true;
        }
        return bl;
    }

    private boolean a(e e2) {
        boolean bl = false;
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            Landmark landmark = (Landmark)enumeration.nextElement();
            if (landmark.getQualifiedCoordinates() == null || !(e2.a().distance((Coordinates)landmark.getQualifiedCoordinates()) < 50.0f) || !e2.a().equals(landmark.getName())) continue;
            bl = true;
        }
        return bl;
    }

    public WiFiLandmark get(int n) {
        return (WiFiLandmark)this.a.elementAt(n);
    }

    public Enumeration getVisibleLandmarks(String string, double d2, double d3, double d4, double d5) {
        try {
            Enumeration enumeration = this.a.getLandmarks(string, d2, d3, d4, d5);
            if (enumeration == null) {
                enumeration = this.b.getLandmarks(string, d2, d3, d4, d5);
            }
            return enumeration;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
            return null;
        }
    }

    public WiFiLandmark getNearest(double d2, double d3) {
        QualifiedCoordinates qualifiedCoordinates = new QualifiedCoordinates(d2, d3, 0.0f, 0.0f, 0.0f);
        double d4 = Double.MAX_VALUE;
        int n = -1;
        for (int i = 0; i < this.a.size(); ++i) {
            if (!(d4 > (double)qualifiedCoordinates.distance((Coordinates)((WiFiLandmark)this.a.elementAt(i)).getLandmark().getQualifiedCoordinates()))) continue;
            n = i;
            d4 = qualifiedCoordinates.distance((Coordinates)((WiFiLandmark)this.a.elementAt(i)).getLandmark().getQualifiedCoordinates());
        }
        if (n == -1) {
            return null;
        }
        return this.get(n);
    }

    public void saveLandmark(Landmark landmark) {
        try {
            this.a.addLandmark(landmark, "Landmarks");
            HotSpotNavigatorMIDlet.getInstance().getLandmarkProvider().recacheCategory("Landmarks");
            return;
        }
        catch (IOException iOException) {
            this.a.showError("Error while saving landmark : " + iOException.getMessage());
            return;
        }
    }

    public void saveLandmark(String string, double d2, double d3, float f2) {
        this.saveLandmark(new Landmark(string, null, new QualifiedCoordinates(d2, d3, f2, Float.NaN, Float.NaN), null));
    }

    public static Image getLandmarkImage() {
        return ImageManager.getInstance().getImage("yellow");
    }

    public LandmarkStore getLandmarkDefaultStore() {
        return this.b;
    }

    public LandmarkStore getLandmarkStore() {
        return this.a;
    }

    public Enumeration getLandmarks(String string) {
        try {
            Enumeration enumeration = this.a.getLandmarks(string, null);
            if (enumeration == null) {
                enumeration = this.b.getLandmarks(string, null);
            }
            return enumeration;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
            return null;
        }
    }

    public Enumeration getUncategorisedLandmarks() {
        try {
            Vector<Landmark> vector = new Vector<Landmark>();
            Enumeration enumeration = this.b.getLandmarks();
            while (enumeration != null && enumeration.hasMoreElements()) {
                Landmark landmark = (Landmark)enumeration.nextElement();
                Enumeration enumeration2 = this.b.getCategories();
                boolean bl = false;
                while (enumeration2.hasMoreElements()) {
                    Object object = (String)enumeration2.nextElement();
                    object = this.b.getLandmarks((String)object, null);
                    while (object.hasMoreElements()) {
                        Landmark landmark2 = (Landmark)object.nextElement();
                        if (!landmark2.equals(landmark)) continue;
                        bl = true;
                    }
                }
                if (bl) continue;
                vector.addElement(landmark);
            }
            return vector.elements();
        }
        catch (IOException iOException) {
            HotSpotNavigatorMIDlet.getInstance().showAlert(iOException.toString());
            return null;
        }
    }

    public void removeLandmark(Landmark object) {
        try {
            this.a.deleteLandmark(object);
            HotSpotNavigatorMIDlet.getInstance().getLandmarkProvider().recacheVisibleCategories();
            return;
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
            return;
        }
        catch (LandmarkException landmarkException) {
            object = landmarkException;
            landmarkException.printStackTrace();
            return;
        }
    }

    public void addFonHotSpot(Landmark object) {
        try {
            this.a.addLandmark(object, "FON WiFi HotSpots");
            HotSpotNavigatorMIDlet.getInstance().getLandmarkProvider().recacheCategory("FON WiFi HotSpots");
            return;
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
            return;
        }
    }
}

