/*
 * Decompiled with CFR 0.152.
 */
package net.hsnav.tracks;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.location.QualifiedCoordinates;
import net.hsnav.OsmMercator;
import net.hsnav.Persistent;
import net.hsnav.Util;
import net.hsnav.tracks.GpsPoint;
import net.hsnav.tracks.MapViewState;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class GpsTrack
implements Persistent {
    private String a;
    private Vector a;
    private int a;
    private float a;
    private long a;
    private long b;
    private long c;
    private int b;
    private float b;
    private float c;
    private byte a = (byte)42;
    private String b = "";
    public Vector cacheX = new Vector();
    public Vector cacheY = new Vector();
    public Vector cacheI = new Vector();
    public int cacheZoom = -1;
    private int c = -1.0f;

    public void addPoint(GpsPoint gpsPoint) {
        if (!this.a.isEmpty()) {
            gpsPoint.setDistance(gpsPoint.distance((GpsPoint)this.a.lastElement()) + ((GpsPoint)this.a.lastElement()).getDistance());
        } else {
            gpsPoint.setDistance(0.0f);
        }
        this.a.addElement(gpsPoint);
        if (this.cacheZoom > 0) {
            this.cacheX.addElement(new Integer(OsmMercator.LonToX(gpsPoint.getLongitude(), this.cacheZoom)));
            this.cacheY.addElement(new Integer(OsmMercator.LatToY(gpsPoint.getLatitude(), this.cacheZoom)));
            this.cacheI.addElement(new Integer(this.a.size() - 1));
        }
    }

    public GpsPoint getPoint(int n) {
        return (GpsPoint)this.a.elementAt(n);
    }

    public void recacheIfNeccessary(int n) {
        int n2 = this.a.size();
        if (this.cacheZoom != n && n2 > 0) {
            this.cacheZoom = n;
            this.cacheX = new Vector(n2);
            this.cacheY = new Vector(n2);
            this.cacheI = new Vector(n2);
            for (int i = 0; i < n2; ++i) {
                GpsPoint gpsPoint = (GpsPoint)this.a.elementAt(i);
                int n3 = OsmMercator.LonToX(gpsPoint.getLongitude(), this.cacheZoom);
                n = OsmMercator.LatToY(gpsPoint.getLatitude(), this.cacheZoom);
                if (this.cacheX.isEmpty()) {
                    this.cacheX.addElement(new Integer(n3));
                    this.cacheY.addElement(new Integer(n));
                    this.cacheI.addElement(new Integer(i));
                    continue;
                }
                if (Math.abs(n3 - (Integer)this.cacheX.lastElement()) <= 6 && Math.abs(n - (Integer)this.cacheY.lastElement()) <= 6) continue;
                this.cacheX.addElement(new Integer(n3));
                this.cacheY.addElement(new Integer(n));
                this.cacheI.addElement(new Integer(i));
            }
        }
    }

    public QualifiedCoordinates center() {
        return ((GpsPoint)this.a.elementAt(this.a.size() / 2)).getQualifiedCoordinates();
    }

    public MapViewState viewState() {
        double d2 = -100.0;
        double d3 = 100.0;
        double d4 = -200.0;
        double d5 = 200.0;
        for (int i = 0; i < this.a.size(); ++i) {
            GpsPoint gpsPoint;
            GpsPoint gpsPoint2 = (GpsPoint)this.a.elementAt(i);
            if (gpsPoint.getLatitude() > d2) {
                d2 = gpsPoint2.getLatitude();
            }
            if (gpsPoint2.getLatitude() < d3) {
                d3 = gpsPoint2.getLatitude();
            }
            if (gpsPoint2.getLongitude() > d4) {
                d4 = gpsPoint2.getLongitude();
            }
            if (!(gpsPoint2.getLongitude() < d5)) continue;
            d5 = gpsPoint2.getLongitude();
        }
        return new MapViewState((d2 + d3) / 2.0, (d4 + d5) / 2.0, 1);
    }

    public GpsPoint getNearestPoint(double d2, double d3) {
        GpsPoint gpsPoint = null;
        double d4 = Double.MAX_VALUE;
        for (int i = 0; i < this.a.size(); ++i) {
            if (!((double)((GpsPoint)this.a.elementAt(i)).distance(d2, d3) < d4)) continue;
            gpsPoint = (GpsPoint)this.a.elementAt(i);
            d4 = ((GpsPoint)this.a.elementAt(i)).distance(d2, d3);
            this.c = i;
        }
        return gpsPoint;
    }

    public int getNearestPointIndex() {
        return this.c;
    }

    public GpsPoint getNearestPoint(int n, int n2, int n3) {
        n3 = Integer.MAX_VALUE;
        int n4 = 0;
        int n5 = this.cacheX.size();
        for (int i = 0; i < n5; ++i) {
            int n6 = n - (Integer)this.cacheX.elementAt(i);
            int n7 = n2 - (Integer)this.cacheY.elementAt(i);
            if (n3 <= (n6 = n6 * n6 + n7 * n7)) continue;
            n4 = i;
            n3 = n6;
        }
        this.c = (Integer)this.cacheI.elementAt(n4);
        return (GpsPoint)this.a.elementAt(this.c);
    }

    public void resetIterator() {
        this.a = 0;
    }

    public GpsPoint getNextPoint() {
        return (GpsPoint)this.a.elementAt(this.a++);
    }

    public boolean hasNext() {
        return this.a.size() > this.a;
    }

    public Enumeration getEnumeration() {
        return this.a.elements();
    }

    public int size() {
        return this.a.size();
    }

    public float distance() {
        int n = this.size();
        float f2 = 0.0f;
        for (int i = 1; i < n; ++i) {
            GpsPoint gpsPoint = (GpsPoint)this.a.elementAt(i - 1);
            double d2 = gpsPoint.getLatitude();
            double d3 = gpsPoint.getLongitude();
            f2 += ((GpsPoint)this.a.elementAt(i)).distance(d2, d3);
        }
        return f2;
    }

    public float distance(int n) {
        if (n <= 0) {
            return 0.0f;
        }
        float f2 = 0.0f;
        for (int i = 1; i < n; ++i) {
            GpsPoint gpsPoint = (GpsPoint)this.a.elementAt(i - 1);
            double d2 = gpsPoint.getLatitude();
            double d3 = gpsPoint.getLongitude();
            f2 += ((GpsPoint)this.a.elementAt(i)).distance(d2, d3);
        }
        return f2;
    }

    private float a() {
        float f2 = -1.0f;
        int n = this.a.size();
        for (int i = 0; i < n; ++i) {
            GpsPoint gpsPoint = (GpsPoint)this.a.elementAt(i);
            if (!(f2 < gpsPoint.getSpeed())) continue;
            f2 = gpsPoint.getSpeed();
        }
        return f2;
    }

    private float b() {
        this.a = this.a > -1.0f ? this.a : this.distance();
        this.a = this.a > -1L ? this.a : this.c - this.b;
        return this.a / (float)(this.a / 1000L) * Util.MPS_to_KNOTS;
    }

    public byte[] persist() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.b = ((GpsPoint)this.a.firstElement()).getTimestamp();
        this.c = ((GpsPoint)this.a.lastElement()).getTimestamp();
        this.a = this.c - this.b;
        this.a = this.distance();
        this.b = this.a();
        this.c = this.b();
        dataOutputStream.write(this.a);
        dataOutputStream.writeInt(this.a.size());
        dataOutputStream.writeLong(this.b);
        dataOutputStream.writeLong(this.c);
        dataOutputStream.writeLong(this.a);
        dataOutputStream.writeFloat(this.a);
        dataOutputStream.writeFloat(this.b);
        dataOutputStream.writeFloat(this.c);
        dataOutputStream.writeUTF(this.b);
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            GpsPoint gpsPoint = (GpsPoint)enumeration.nextElement();
            dataOutputStream.writeLong(gpsPoint.getTimestamp());
            dataOutputStream.writeDouble(gpsPoint.getLatitude());
            dataOutputStream.writeDouble(gpsPoint.getLongitude());
            dataOutputStream.writeFloat(gpsPoint.getAltitude());
            dataOutputStream.writeFloat(gpsPoint.getHorizontalAccuracy());
            dataOutputStream.writeFloat(gpsPoint.getVerticalAccuracy());
            dataOutputStream.writeFloat(gpsPoint.getCourse());
            dataOutputStream.writeFloat(gpsPoint.getSpeed());
        }
        dataOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    public void resurrect(byte[] object) {
        object = new ByteArrayInputStream((byte[])object);
        DataInputStream dataInputStream = new DataInputStream((InputStream)object);
        this.a = dataInputStream.readByte();
        if (this.a != 42) {
            System.out.println("convert started...");
            dataInputStream.reset();
            while (dataInputStream.available() > 0) {
                GpsPoint gpsPoint = new GpsPoint(dataInputStream.readLong(), dataInputStream.readDouble(), dataInputStream.readDouble(), dataInputStream.readFloat(), dataInputStream.readFloat(), dataInputStream.readFloat(), dataInputStream.readFloat(), dataInputStream.readFloat());
                this.addPoint(gpsPoint);
            }
            this.b = this.a.size();
            this.b = ((GpsPoint)this.a.firstElement()).getTimestamp();
            this.c = ((GpsPoint)this.a.lastElement()).getTimestamp();
            this.a = this.c - this.b;
            this.a = this.distance();
            this.b = this.a();
            this.c = this.b();
            dataInputStream.close();
            ((ByteArrayInputStream)object).close();
        } else {
            this.b = dataInputStream.readInt();
            this.b = dataInputStream.readLong();
            this.c = dataInputStream.readLong();
            this.a = dataInputStream.readLong();
            this.a = dataInputStream.readFloat();
            this.b = dataInputStream.readFloat();
            this.c = dataInputStream.readFloat();
            this.b = dataInputStream.readUTF();
            while (dataInputStream.available() > 0) {
                GpsPoint gpsPoint = new GpsPoint(dataInputStream.readLong(), dataInputStream.readDouble(), dataInputStream.readDouble(), dataInputStream.readFloat(), dataInputStream.readFloat(), dataInputStream.readFloat(), dataInputStream.readFloat(), dataInputStream.readFloat());
                this.addPoint(gpsPoint);
            }
        }
        dataInputStream.close();
    }

    public void resurrect40(byte[] object) {
        object = new ByteArrayInputStream((byte[])object);
        object = new DataInputStream((InputStream)object);
        this.a = ((DataInputStream)object).readByte();
        if (this.a != 42) {
            System.out.println("convert started for file");
            ((FilterInputStream)object).reset();
            while (((FilterInputStream)object).available() > 0) {
                GpsPoint gpsPoint = new GpsPoint(((DataInputStream)object).readLong(), ((DataInputStream)object).readDouble(), ((DataInputStream)object).readDouble(), ((DataInputStream)object).readFloat(), ((DataInputStream)object).readFloat(), ((DataInputStream)object).readFloat(), ((DataInputStream)object).readFloat(), ((DataInputStream)object).readFloat());
                this.addPoint(gpsPoint);
            }
            this.a = (byte)42;
            this.b = this.a.size();
            this.b = ((GpsPoint)this.a.firstElement()).getTimestamp();
            this.c = ((GpsPoint)this.a.lastElement()).getTimestamp();
            this.a = this.c - this.b;
            this.a = this.distance();
            this.b = this.a();
            this.c = this.b();
        }
    }

    public void loadFromFile(String string) {
        try {
            string = (FileConnection)Connector.open((String)(this.a + string), (int)1);
            InputStream inputStream = string.openInputStream();
            byte[] byArray = new byte[(int)string.fileSize()];
            inputStream.read(byArray);
            inputStream.close();
            string.close();
            this.resurrect(byArray);
            return;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
            return;
        }
    }

    public void saveToFile() {
        GpsPoint gpsPoint = (GpsPoint)this.a.firstElement();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(gpsPoint.getTimestamp()));
        int n = calendar.get(2) + 1;
        String string = n < 10 ? "0" : "";
        int n2 = calendar.get(5);
        String string2 = n2 < 10 ? "0" : "";
        String string3 = calendar.get(1) + "-" + string + n + "-" + string2 + n2 + "_" + calendar.get(11) + "-" + calendar.get(12) + ".bin";
        this.saveToFile(string3);
    }

    public void saveToFile(String string) {
        try {
            Object object = (FileConnection)Connector.open((String)this.a, (int)3);
            if (!object.exists()) {
                object.mkdir();
            }
            object.close();
            string = (FileConnection)Connector.open((String)(this.a + string), (int)3);
            if (!string.exists()) {
                string.create();
                object = string.openOutputStream();
                ((OutputStream)object).write(this.persist());
                ((OutputStream)object).close();
            }
            string.close();
            return;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
            return;
        }
    }

    public void loadFromFile40(String string) {
        try {
            string = (FileConnection)Connector.open((String)(this.a + string), (int)1);
            InputStream inputStream = string.openInputStream();
            byte[] byArray = new byte[(int)string.fileSize()];
            inputStream.read(byArray);
            inputStream.close();
            string.close();
            this.resurrect40(byArray);
            return;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
            return;
        }
    }

    public String getExtraInfo() {
        return this.b;
    }

    public float getAvgSpeed() {
        return this.c;
    }

    public long getEndTime() {
        return this.c;
    }

    public float getLength() {
        return this.a;
    }

    public float getMaxSpeed() {
        return this.b;
    }

    public int getPointsAmount() {
        return this.b;
    }

    public long getStartTime() {
        return this.b;
    }

    public long getTime() {
        return this.a;
    }
}

